/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.bpm.api.constant.ExtractType;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.model.process.task.BpmTask;
import com.artfess.bpm.persistence.dao.BpmTaskCandidateDao;
import com.artfess.bpm.persistence.manager.BpmTaskCandidateManager;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.bpm.persistence.model.DefaultBpmTaskCandidate;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmTaskCandidateManager")
public class BpmTaskCandidateManagerImpl
extends BaseManagerImpl<BpmTaskCandidateDao, DefaultBpmTaskCandidate>
implements BpmTaskCandidateManager {
    @Resource
    BpmTaskCandidateDao bpmTaskCandidateDao;
    @Resource
    IUserService userServiceImpl;
    @Resource
    BpmTaskManager bpmTaskManager;

    @Override
    @Transactional
    public void addCandidate(BpmTask task, List<BpmIdentity> list) {
        String taskId = task.getId();
        String instId = task.getProcInstId();
        for (BpmIdentity identity : list) {
            DefaultBpmTaskCandidate candidate;
            String type = identity.getType();
            if ("user".equals(type)) {
                candidate = new DefaultBpmTaskCandidate(taskId, "user", identity.getId(), instId);
                this.create((Model)candidate);
                continue;
            }
            if ("groupUser".equals(type)) {
                String[] aryId = identity.getId().split(",");
                for (String userId : aryId) {
                    DefaultBpmTaskCandidate candidate2 = new DefaultBpmTaskCandidate(taskId, "user", userId, instId);
                    this.create((Model)candidate2);
                }
                continue;
            }
            if (!"group".equals(type)) continue;
            if (ExtractType.EXACT_EXACT_USER.equals((Object)identity.getExtractType())) {
                List userList = this.userServiceImpl.getUserListByGroup(identity.getGroupType(), identity.getId());
                for (IUser user : userList) {
                    DefaultBpmTaskCandidate candidate3 = new DefaultBpmTaskCandidate(taskId, "user", user.getUserId(), instId);
                    this.create((Model)candidate3);
                }
                continue;
            }
            candidate = new DefaultBpmTaskCandidate(taskId, identity.getGroupType(), identity.getId(), instId);
            this.create((Model)candidate);
        }
    }

    @Override
    @Transactional
    public void removeByTaskId(String taskId) {
        this.bpmTaskCandidateDao.removeByTaskId(taskId);
    }

    @Override
    public List<DefaultBpmTaskCandidate> queryByTaskId(String taskId) {
        return this.bpmTaskCandidateDao.queryByTaskId(taskId);
    }

    @Override
    public DefaultBpmTaskCandidate getByTaskIdExeIdType(String taskId, String executorId, String type) {
        return this.bpmTaskCandidateDao.getByTaskIdExeIdType(taskId, executorId, type);
    }

    @Override
    @Transactional
    public void delByInstList(List<String> instList) {
        this.bpmTaskCandidateDao.delByInstList(instList);
    }

    @Override
    public List<DefaultBpmTaskCandidate> getByInstList(List<String> instList) {
        return this.bpmTaskCandidateDao.getByInstList(instList);
    }

    @Override
    @Transactional
    public void updateExecutor(Map<String, Object> params) {
        this.bpmTaskCandidateDao.updateExecutor(params);
    }

    @Override
    @Transactional
    public void addCandidate(String taskId, List<BpmIdentity> list) {
        BpmTask bpmTask = (BpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        this.addCandidate(bpmTask, list);
    }
}

