/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.util;

import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.bpm.api.constant.OpinionStatus;
import com.artfess.bpm.api.model.delegate.BpmDelegateExecution;
import com.artfess.bpm.api.model.delegate.BpmDelegateTask;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.model.identity.DefaultBpmIdentity;
import com.artfess.bpm.natapi.inst.NatProInstanceService;
import com.artfess.bpm.persistence.manager.BpmCheckOpinionManager;
import com.artfess.bpm.persistence.model.ActTask;
import com.artfess.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.bpm.util.BpmUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BpmCheckOpinionUtil {
    public static final List<String> effectNodeTransActions = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(OpinionStatus.AGREE.getKey());
            this.add(OpinionStatus.OPPOSE.getKey());
            this.add(OpinionStatus.SKIP.getKey());
            this.add(OpinionStatus.REJECT.getKey());
            this.add(OpinionStatus.DELIVERTO_AGREE.getKey());
            this.add(OpinionStatus.DELIVERTO_OPPOSE.getKey());
            this.add(OpinionStatus.BACK_TO_START.getKey());
            this.add(OpinionStatus.TRANS_FORMING.getKey());
            this.add(OpinionStatus.SIGN_PASSED.getKey());
        }
    };

    public static DefaultBpmCheckOpinion buildBpmCheckOpinion(BpmDelegateTask delegateTask, String procInstId) {
        DefaultBpmCheckOpinion bpmCheckOpinion = new DefaultBpmCheckOpinion();
        bpmCheckOpinion.setProcDefId(delegateTask.getBpmnDefId());
        String superInstId = (String)delegateTask.getSupperVariable("instanceId_");
        if (StringUtil.isEmpty((String)superInstId)) {
            superInstId = "0";
        }
        bpmCheckOpinion.setSupInstId(superInstId);
        bpmCheckOpinion.setProcInstId(procInstId);
        bpmCheckOpinion.setTaskId(delegateTask.getId());
        bpmCheckOpinion.setTaskKey(delegateTask.getTaskDefinitionKey());
        bpmCheckOpinion.setTaskName(delegateTask.getName());
        bpmCheckOpinion.setStatus(OpinionStatus.AWAITING_CHECK.getKey());
        bpmCheckOpinion.setCreateTime(delegateTask.getCreateTime());
        return bpmCheckOpinion;
    }

    public static String getIdentityIds(List<BpmIdentity> identityList) {
        if (BeanUtils.isEmpty(identityList)) {
            return "";
        }
        ArrayNode identityArray = JsonUtil.getMapper().createArrayNode();
        for (int i = 0; i < identityList.size(); ++i) {
            BpmIdentity identity = identityList.get(i);
            ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
            objectNode.put("id", identity.getId());
            objectNode.put("type", identity.getType());
            objectNode.put("groupType", identity.getGroupType());
            objectNode.put("name", identity.getName());
            identityArray.add((JsonNode)objectNode);
        }
        try {
            return JsonUtil.toJson((Object)identityArray);
        }
        catch (IOException e) {
            return "";
        }
    }

    public static String getIdentityNames(List<BpmIdentity> identityList) {
        if (BeanUtils.isEmpty(identityList)) {
            return "";
        }
        StringBuffer names = new StringBuffer();
        for (BpmIdentity bpmIdentity : identityList) {
            names.append(bpmIdentity.getName());
            names.append(",");
        }
        String result = names.toString();
        return result.substring(0, result.length() - 1);
    }

    public static DefaultBpmCheckOpinion buildBpmCheckOpinion(ActTask actTask, String superInstId, String procInstId) {
        IUser user = ContextUtil.getCurrentUser();
        String id = UniqueIdUtil.getSuid();
        ArrayList<BpmIdentity> identityList = new ArrayList<BpmIdentity>();
        DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
        bpmIdentity.setType("user");
        bpmIdentity.setId(user.getUserId());
        bpmIdentity.setName(user.getFullname());
        identityList.add(bpmIdentity);
        DefaultBpmCheckOpinion bpmCheckOpinion = new DefaultBpmCheckOpinion();
        bpmCheckOpinion.setId(id);
        bpmCheckOpinion.setProcDefId(actTask.getProcDefId());
        bpmCheckOpinion.setSupInstId(superInstId);
        bpmCheckOpinion.setProcInstId(procInstId);
        bpmCheckOpinion.setTaskId(actTask.getId());
        bpmCheckOpinion.setTaskKey(actTask.getTaskDefKey());
        bpmCheckOpinion.setTaskName(actTask.getName());
        bpmCheckOpinion.setStatus(OpinionStatus.AWAITING_CHECK.getKey());
        bpmCheckOpinion.setCreateTime(actTask.getCreateTime());
        bpmCheckOpinion.setQualfieds(BpmCheckOpinionUtil.getIdentityIds(identityList));
        bpmCheckOpinion.setQualfiedNames(user.getFullname());
        return bpmCheckOpinion;
    }

    public static DefaultBpmCheckOpinion buildBpmCheckOpinion(BpmDelegateExecution delegateExecution, String procInstId, Boolean isEndNote) {
        IUser user = ContextUtil.getCurrentUser();
        ArrayList<BpmIdentity> identityList = new ArrayList<BpmIdentity>();
        DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
        bpmIdentity.setType("user");
        bpmIdentity.setId(user.getUserId());
        bpmIdentity.setName(user.getFullname());
        identityList.add(bpmIdentity);
        DefaultBpmCheckOpinion bpmCheckOpinion = new DefaultBpmCheckOpinion();
        bpmCheckOpinion.setProcDefId(delegateExecution.getBpmnDefId());
        String superInstId = (String)delegateExecution.getSupperVariable("instanceId_");
        bpmCheckOpinion.setSupInstId(superInstId);
        bpmCheckOpinion.setProcInstId(procInstId);
        bpmCheckOpinion.setTaskId(null);
        bpmCheckOpinion.setTaskKey(delegateExecution.getNodeId());
        bpmCheckOpinion.setTaskName("\u53d1\u8d77\u8282\u70b9");
        bpmCheckOpinion.setIsRead(1);
        if (isEndNote.booleanValue()) {
            bpmCheckOpinion.setTaskKey(delegateExecution.getNodeId());
            bpmCheckOpinion.setTaskName(delegateExecution.getNodeName());
            bpmCheckOpinion.setStatus("end");
            bpmCheckOpinion.setOpinion("\u7ed3\u675f\u6d41\u7a0b");
        }
        bpmCheckOpinion.setCreateTime(LocalDateTime.now());
        bpmCheckOpinion.setCompleteTime(bpmCheckOpinion.getCreateTime());
        bpmCheckOpinion.setQualfieds(BpmCheckOpinionUtil.getIdentityIds(identityList));
        bpmCheckOpinion.setQualfiedNames(user.getFullname());
        bpmCheckOpinion.setAuditor(user.getUserId());
        bpmCheckOpinion.setAuditorName(user.getFullname());
        BpmUtil.setOpinionOrgInfo(user.getUserId(), bpmCheckOpinion);
        bpmCheckOpinion.setDurMs(0L);
        return bpmCheckOpinion;
    }

    public static void updateExtraPropCheckOpinion(DefaultBpmCheckOpinion bpmCheckOpinion, DefaultBpmTask bpmTask) {
        if (BeanUtils.isEmpty((Object)bpmCheckOpinion) || BeanUtils.isEmpty((Object)bpmTask)) {
            return;
        }
        boolean isUpdate = false;
        if (StringUtil.isNotEmpty((String)bpmTask.getProp1())) {
            isUpdate = true;
            bpmCheckOpinion.setProp1(bpmTask.getProp1());
        }
        if (StringUtil.isNotEmpty((String)bpmTask.getProp2())) {
            isUpdate = true;
            bpmCheckOpinion.setProp2(bpmTask.getProp2());
        }
        if (StringUtil.isNotEmpty((String)bpmTask.getProp3())) {
            isUpdate = true;
            bpmCheckOpinion.setProp3(bpmTask.getProp3());
        }
        if (StringUtil.isNotEmpty((String)bpmTask.getProp4())) {
            isUpdate = true;
            bpmCheckOpinion.setProp4(bpmTask.getProp4());
        }
        if (StringUtil.isNotEmpty((String)bpmTask.getProp5())) {
            isUpdate = true;
            bpmCheckOpinion.setProp5(bpmTask.getProp5());
        }
        if (StringUtil.isNotEmpty((String)bpmTask.getProp6())) {
            isUpdate = true;
            bpmCheckOpinion.setProp6(bpmTask.getProp6());
        }
        if (isUpdate) {
            BpmCheckOpinionManager bpmCheckOpinionManager = (BpmCheckOpinionManager)AppUtil.getBean(BpmCheckOpinionManager.class);
            bpmCheckOpinionManager.updateExtraProps(bpmCheckOpinion);
        }
    }

    public static void addCheckOpinion(DefaultBpmTask bpmTask, OpinionStatus opinionStatus, String userId, String opinion, boolean isCompleted) {
        String bpmnInstId = bpmTask.getBpmnInstId();
        NatProInstanceService natProInstanceService = (NatProInstanceService)AppUtil.getBean(NatProInstanceService.class);
        String superInstId = (String)natProInstanceService.getSuperVariable(bpmnInstId, "instanceId_");
        IUser user = BpmUtil.getUser(StringUtil.isEmpty((String)userId) ? bpmTask.getAssigneeId() : userId);
        ArrayList<BpmIdentity> identityList = new ArrayList<BpmIdentity>();
        DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
        bpmIdentity.setType("user");
        bpmIdentity.setId(user.getUserId());
        bpmIdentity.setName(user.getFullname());
        identityList.add(bpmIdentity);
        DefaultBpmCheckOpinion checkOpinion = new DefaultBpmCheckOpinion();
        checkOpinion.setId(UniqueIdUtil.getSuid());
        checkOpinion.setProcDefId(bpmTask.getBpmnDefId());
        checkOpinion.setSupInstId(superInstId);
        checkOpinion.setProcInstId(bpmTask.getProcInstId());
        checkOpinion.setTaskId(bpmTask.getTaskId());
        checkOpinion.setTaskKey(bpmTask.getNodeId());
        checkOpinion.setTaskName(bpmTask.getName());
        checkOpinion.setStatus(opinionStatus.getKey());
        checkOpinion.setCreateTime(LocalDateTime.now());
        checkOpinion.setQualfieds(BpmCheckOpinionUtil.getIdentityIds(identityList));
        checkOpinion.setQualfiedNames(user.getFullname());
        if (isCompleted) {
            checkOpinion.setAuditor(user.getUserId());
            checkOpinion.setAuditorName(user.getFullname());
            checkOpinion.setCompleteTime(LocalDateTime.now());
            checkOpinion.setDurMs(TimeUtil.getCurrentTimeMillis() - TimeUtil.getTimeMillis((LocalDateTime)bpmTask.getCreateTime()));
            checkOpinion.setOpinion(opinion);
        }
        BpmCheckOpinionManager bpmCheckOpinionManager = (BpmCheckOpinionManager)AppUtil.getBean(BpmCheckOpinionManager.class);
        bpmCheckOpinionManager.create((Model)checkOpinion);
    }

    public static void updateCheckRevoker(String completeTaskId) {
        BpmCheckOpinionUtil.updateCheckOpinionStatus(completeTaskId, OpinionStatus.REVOKER);
    }

    public static DefaultBpmCheckOpinion getCheckOpinionByTaskId(String completeTaskId) {
        BpmCheckOpinionManager bpmCheckOpinionManager = (BpmCheckOpinionManager)AppUtil.getBean(BpmCheckOpinionManager.class);
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("task_id_", (Object)completeTaskId, QueryOP.EQUAL);
        ArrayList<FieldSort> sorter1 = new ArrayList<FieldSort>();
        FieldSort sort1 = new FieldSort("COMPLETE_TIME_", Direction.DESC);
        sorter1.add(sort1);
        queryFilter.setSorter(sorter1);
        PageList query = bpmCheckOpinionManager.query(queryFilter);
        if (BeanUtils.isEmpty((Object)query.getRows())) {
            return null;
        }
        DefaultBpmCheckOpinion bpmCheckOpinion = null;
        HashMap<String, DefaultBpmCheckOpinion> opnionMap = new HashMap<String, DefaultBpmCheckOpinion>();
        for (DefaultBpmCheckOpinion opinion : query.getRows()) {
            opnionMap.put(opinion.getStatus(), opinion);
        }
        for (String status : effectNodeTransActions) {
            if (!opnionMap.containsKey(status)) continue;
            bpmCheckOpinion = (DefaultBpmCheckOpinion)opnionMap.get(status);
            break;
        }
        return bpmCheckOpinion;
    }

    public static void updateCheckOpinionStatus(String completeTaskId, OpinionStatus updStatus) {
        if (BeanUtils.isEmpty((Object)((Object)updStatus))) {
            updStatus = OpinionStatus.REVOKER;
        }
        BpmCheckOpinionManager bpmCheckOpinionManager = (BpmCheckOpinionManager)AppUtil.getBean(BpmCheckOpinionManager.class);
        DefaultBpmCheckOpinion bpmCheckOpinion = BpmCheckOpinionUtil.getCheckOpinionByTaskId(completeTaskId);
        if (BeanUtils.isNotEmpty((Object)bpmCheckOpinion)) {
            bpmCheckOpinion.setStatus(updStatus.getKey());
            if (OpinionStatus.AWAITING_CHECK.equals((Object)updStatus)) {
                bpmCheckOpinion.setCompleteTime(null);
                bpmCheckOpinion.setOpinion(null);
                bpmCheckOpinion.setFiles(null);
                bpmCheckOpinion.setAuditor(null);
                bpmCheckOpinion.setAuditorName(null);
                bpmCheckOpinion.setAgentLeaderId(null);
            }
            bpmCheckOpinionManager.update((Model)bpmCheckOpinion);
        }
    }
}

