/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.engine.inst;

import com.artfess.base.query.Direction;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.model.process.task.BpmTaskOpinion;
import com.artfess.bpm.api.service.BpmOpinionService;
import com.artfess.bpm.persistence.manager.BpmCheckOpinionManager;
import com.artfess.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.artfess.bpm.util.BpmCheckOpinionUtil;
import com.artfess.uc.api.impl.service.UserServiceImpl;
import com.artfess.uc.api.model.IUser;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DefaultBpmOpinionService
implements BpmOpinionService {
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;

    @Override
    public List<BpmTaskOpinion> getTaskOpinions(String procInstId) {
        List<DefaultBpmCheckOpinion> defaultBpmCheckOpinions = this.bpmCheckOpinionManager.getByInstId(procInstId);
        return defaultBpmCheckOpinions.stream().collect(Collectors.toList());
    }

    @Override
    public List<BpmTaskOpinion> getByInstNodeId(String instId, String nodeId) {
        return this.bpmCheckOpinionManager.getByInstNodeId(instId, nodeId).stream().collect(Collectors.toList());
    }

    @Override
    public Map<String, Set<String>> getHisAuditorByInstId(String instId, boolean transToAccount) {
        UserServiceImpl userServiceImpl;
        List userByIds;
        String topInstId = this.bpmCheckOpinionManager.getTopInstId(instId);
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("proc_inst_id_", (Object)StringUtil.join(this.bpmCheckOpinionManager.getListByInstId(topInstId)), QueryOP.IN);
        queryFilter.setDefaultSort("complete_time_", Direction.DESC);
        List opinionList = this.bpmCheckOpinionManager.queryNoPage(queryFilter);
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        if (BeanUtils.isEmpty((Object)opinionList)) {
            return map;
        }
        String preSortOutNodeId = "";
        HashSet<String> alreadySortOutNodeId = new HashSet<String>();
        HashSet<String> allAuditorIds = new HashSet<String>();
        for (DefaultBpmCheckOpinion opinion : opinionList) {
            String nodeId = opinion.getTaskKey();
            if (!BpmCheckOpinionUtil.effectNodeTransActions.contains(opinion.getStatus()) || StringUtil.isEmpty((String)nodeId) || alreadySortOutNodeId.contains(nodeId)) continue;
            Set<String> userIds = (Set)map.get(nodeId);
            if (BeanUtils.isEmpty((Object)userIds)) {
                userIds = new HashSet<String>();
            }
            userIds.add(opinion.getAuditor());
            allAuditorIds.add(opinion.getAuditor());
            map.put(nodeId, userIds);
            if (StringUtil.isNotEmpty((String)preSortOutNodeId) && !preSortOutNodeId.equals(nodeId)) {
                alreadySortOutNodeId.add(preSortOutNodeId);
            }
            preSortOutNodeId = nodeId;
        }
        if (BeanUtils.isNotEmpty(allAuditorIds) && transToAccount && BeanUtils.isNotEmpty((Object)(userByIds = (userServiceImpl = (UserServiceImpl)AppUtil.getBean(UserServiceImpl.class)).getUserByIds(StringUtil.join(allAuditorIds))))) {
            HashMap<String, String> userIdAccountMap = new HashMap<String, String>();
            for (IUser iUser : userByIds) {
                userIdAccountMap.put(iUser.getUserId(), iUser.getAccount());
            }
            for (Map.Entry entry : map.entrySet()) {
                Set ids = (Set)entry.getValue();
                HashSet accounts = new HashSet();
                for (String id : ids) {
                    accounts.add(userIdAccountMap.get(id));
                }
                entry.setValue(accounts);
            }
        }
        return map;
    }
}

