/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.plugin.execution.script.context;

import com.artfess.base.util.JsonUtil;
import com.artfess.bpm.api.constant.EventType;
import com.artfess.bpm.api.plugin.core.context.AbstractBpmExecutionPluginContext;
import com.artfess.bpm.api.plugin.core.def.BpmPluginDef;
import com.artfess.bpm.api.plugin.core.runtime.RunTimePlugin;
import com.artfess.bpm.plugin.execution.script.def.ScriptNodePluginDef;
import com.artfess.bpm.plugin.execution.script.plugin.ScriptNodePlugin;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jamesmurty.utils.XMLBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class ScriptNodePluginContext
extends AbstractBpmExecutionPluginContext {
    private static final long serialVersionUID = -5958682303600423597L;

    @Override
    public List<EventType> getEventTypes() {
        ArrayList<EventType> list = new ArrayList<EventType>();
        list.add(EventType.AUTO_TASK_EVENT);
        list.add(EventType.START_POST_EVENT);
        list.add(EventType.END_POST_EVENT);
        return list;
    }

    @Override
    public Class<? extends RunTimePlugin> getPluginClass() {
        return ScriptNodePlugin.class;
    }

    @Override
    public String getPluginXml() {
        ScriptNodePluginDef pluginDef = (ScriptNodePluginDef)this.getBpmPluginDef();
        try {
            XMLBuilder xmlBuilder = XMLBuilder.create((String)"scriptNode").a("xmlns", "http://www.jee-soft.cn/bpm/plugins/execution/scriptNode");
            xmlBuilder.cdata(pluginDef.getScript());
            return xmlBuilder.asString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public String getJson() throws IOException {
        ScriptNodePluginDef pluginDef = (ScriptNodePluginDef)this.getBpmPluginDef();
        ObjectNode config = (ObjectNode)JsonUtil.toJsonNode((Object)pluginDef);
        config.put("pluginType", this.getType());
        return JsonUtil.toJson((Object)config);
    }

    @Override
    protected BpmPluginDef parseJson(String pluginJson) throws IOException {
        ObjectNode jsonObject = (ObjectNode)JsonUtil.toJsonNode((String)pluginJson);
        ScriptNodePluginDef def = new ScriptNodePluginDef();
        String script = jsonObject.get("script").asText();
        def.setScript(script);
        return def;
    }

    @Override
    protected BpmPluginDef parseElement(Element element) {
        ScriptNodePluginDef def = new ScriptNodePluginDef();
        String script = element.getTextContent();
        def.setScript(script);
        return def;
    }

    @Override
    public String getTitle() {
        return "\u811a\u672c";
    }
}

