/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.util;

import com.artfess.base.context.BaseContext;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.event.AutoTestEvent;
import com.artfess.bpm.api.model.process.task.BpmTask;
import com.artfess.bpm.engine.task.service.DefaultBpmTaskService;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.model.AutoTestModel;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.uc.api.model.IUser;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.ApplicationEvent;

public class PublishAutoTestEventUtil {
    public static void publishAutoTestEvent(String instId) {
        DefaultBpmTaskService bpmTaskService = (DefaultBpmTaskService)AppUtil.getBean((String)"defaultBpmTaskService");
        BpmProcessInstanceManager bpmProcessInstanceManager = (BpmProcessInstanceManager)AppUtil.getBean((String)"bpmProcessInstanceManager");
        List<DefaultBpmProcessInstance> instances = bpmProcessInstanceManager.getByParentId(instId, true);
        if (BeanUtils.isEmpty(instances)) {
            return;
        }
        List<Object> tasks = new ArrayList();
        for (DefaultBpmProcessInstance defaultBpmProcessInstance : instances) {
            if (!BeanUtils.isEmpty((Object)defaultBpmProcessInstance) && BeanUtils.isNotEmpty(tasks = bpmTaskService.getTasksInstId(defaultBpmProcessInstance.getId()))) break;
        }
        if (BeanUtils.isNotEmpty(tasks)) {
            BpmTask bpmTask = (BpmTask)tasks.get(0);
            AutoTestModel autoTestModel = new AutoTestModel();
            autoTestModel.setTaskId(bpmTask.getTaskId());
            autoTestModel.setNodeId(bpmTask.getNodeId());
            autoTestModel.setNodeName(bpmTask.getName());
            autoTestModel.setSubject(bpmTask.getSubject());
            autoTestModel.setProcInstId(bpmTask.getProcInstId());
            autoTestModel.setSkipDebugger((Boolean)ContextThreadUtil.getCommuVar("skipDebugger", false));
            List<IUser> userList = bpmTaskService.getUsersByTaskId(bpmTask.getTaskId());
            autoTestModel.setUserList(userList);
            BaseContext baseContext = (BaseContext)AppUtil.getBean(BaseContext.class);
            autoTestModel.setTenantId(baseContext.getCurrentTenantId());
            AutoTestEvent event = new AutoTestEvent(autoTestModel);
            AppUtil.publishEvent((ApplicationEvent)event);
        }
    }
}

