/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.manager.impl;

import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.bpm.api.constant.OpinionStatus;
import com.artfess.bpm.api.constant.TaskType;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.persistence.dao.CopyToDao;
import com.artfess.bpm.persistence.manager.BpmCheckOpinionManager;
import com.artfess.bpm.persistence.manager.BpmCptoReceiverManager;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.bpm.persistence.manager.BpmTaskNoticeManager;
import com.artfess.bpm.persistence.manager.CopyToManager;
import com.artfess.bpm.persistence.manager.impl.BpmProcessInstanceManagerImpl;
import com.artfess.bpm.persistence.model.BpmCptoReceiver;
import com.artfess.bpm.persistence.model.BpmTaskNotice;
import com.artfess.bpm.persistence.model.CopyTo;
import com.artfess.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.util.MessageUtil;
import com.artfess.bpm.util.PortalDataUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="copyToManager")
public class CopyToManagerImpl
extends BaseManagerImpl<CopyToDao, CopyTo>
implements CopyToManager {
    @Resource
    BpmProcessInstanceManagerImpl bpmProcessInstanceManager;
    @Resource
    BpmCptoReceiverManager bpmCptoReceiverManager;
    @Resource
    IUserService userServiceImpl;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;

    @Override
    @Transactional
    public void delByInstList(List<String> instList) {
        ((CopyToDao)this.baseMapper).delByInstList(instList);
    }

    @Transactional
    public void create(CopyTo copyTo) {
        super.create((Model)copyTo);
        List<BpmCptoReceiver> receivers = copyTo.getReceivers();
        for (BpmCptoReceiver receiver : receivers) {
            this.bpmCptoReceiverManager.create((Model)receiver);
        }
    }

    @Override
    public List<CopyTo> getReceiverCopyTo(String userId, QueryFilter queryFilter) {
        if (BeanUtils.isEmpty((Object)queryFilter)) {
            queryFilter = QueryFilter.build().withDefaultPage();
        }
        queryFilter.withParam("userId", (Object)userId);
        return ((CopyToDao)this.baseMapper).getReceiverCopyTo((IPage<CopyTo>)this.convert2IPage(queryFilter.getPageBean()), queryFilter.getParams());
    }

    @Override
    public List<CopyTo> getMyCopyTo(String userId, QueryFilter filter) {
        if (BeanUtils.isEmpty((Object)filter)) {
            filter = QueryFilter.build().withDefaultPage();
        }
        filter.withParam("userId", (Object)userId);
        return ((CopyToDao)this.baseMapper).getMyCopyTo((IPage<CopyTo>)this.convert2IPage(filter.getPageBean()), filter.getParams());
    }

    @Transactional
    private void trans(String instanceId, String userId, String messageType, String opinion, String copyToType, String taskId, String files, String selectNodeId) throws Exception {
        BpmProcessInstance instance = (BpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instanceId));
        IUser user = this.userServiceImpl.getUserById(userId);
        IUser currentUser = this.userServiceImpl.getUserById(ContextUtil.getCurrentUserId());
        CopyTo copyTo = new CopyTo();
        if (copyToType.equals("0")) {
            copyTo.setType("copyto");
        } else {
            copyTo.setType("trans");
        }
        if (StringUtil.isNotEmpty((String)selectNodeId)) {
            copyTo.setNodeId(selectNodeId);
        } else {
            copyTo.setNodeId(ContextThreadUtil.getCommuVar("nodeId", "").toString());
        }
        copyTo.setOpinion(opinion);
        copyTo.setId(UniqueIdUtil.getUId().toString());
        copyTo.setBpmnInstId(instance.getBpmnInstId());
        copyTo.setInstId(instance.getId());
        copyTo.setSubject(instance.getSubject());
        copyTo.setStartor(currentUser.getFullname());
        copyTo.setStartorId(currentUser.getUserId());
        copyTo.setTypeId(instance.getTypeId());
        copyTo.setCreateTime(LocalDateTime.now());
        super.create((Model)copyTo);
        BpmCptoReceiver bpmCptoReceiver = new BpmCptoReceiver();
        bpmCptoReceiver.setId(UniqueIdUtil.getUId().toString());
        bpmCptoReceiver.setReceiverId(userId);
        bpmCptoReceiver.setReceiver(user.getFullname());
        bpmCptoReceiver.setCptoId(copyTo.getId());
        this.bpmCptoReceiverManager.create((Model)bpmCptoReceiver);
        BpmTaskNoticeManager noticeManager = (BpmTaskNoticeManager)AppUtil.getBean(BpmTaskNoticeManager.class);
        BpmTaskNotice taskNotice = new BpmTaskNotice("\u4f20\u9605\u4efb\u52a1", instance.getSubject(), instance.getId(), instance.getProcDefId(), instance.getProcDefName(), userId, user.getFullname(), TaskType.COPYTO.getKey(), ((DefaultBpmProcessInstance)instance).getSupportMobile(), currentUser.getFullname(), currentUser.getUserId(), 0, BeanUtils.isEmpty((Object)taskId) ? null : taskId, BeanUtils.isEmpty((Object)selectNodeId) ? null : selectNodeId);
        noticeManager.create((Model)taskNotice);
        ArrayList<IUser> userList = new ArrayList<IUser>();
        userList.add(user);
        Map<String, Object> vars = this.getVar(instance, opinion);
        MessageUtil.sendMsg(copyToType.equals("1") ? "bpmHandTo" : "copyTo", messageType, userList, vars);
    }

    @Override
    @Transactional
    public void transToMore(String instanceId, List<String> userIds, String messageType, String opinion, String copyToType, String taskId, String files, String selectNodeId) throws Exception {
        for (String userId : userIds) {
            this.trans(instanceId, userId, messageType, opinion, copyToType, taskId, files, selectNodeId);
        }
        if (copyToType.equals("0")) {
            UCFeignService ucFeignService = (UCFeignService)AppUtil.getBean(UCFeignService.class);
            ArrayNode users = ucFeignService.getUserByIds(StringUtil.join(userIds, (String)","));
            ArrayList<String> userNames = new ArrayList<String>();
            if (BeanUtils.isNotEmpty((Object)users)) {
                for (JsonNode user : users) {
                    ObjectNode userObj = (ObjectNode)user;
                    userNames.add(userObj.get("fullname").asText());
                }
            }
            DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instanceId));
            DefaultBpmCheckOpinion defaultBpmCheckOpinion = new DefaultBpmCheckOpinion();
            defaultBpmCheckOpinion.setId(UniqueIdUtil.getSuid());
            defaultBpmCheckOpinion.setProcDefId(instance.getProcDefId());
            defaultBpmCheckOpinion.setProcInstId(instanceId);
            defaultBpmCheckOpinion.setTaskId("");
            defaultBpmCheckOpinion.setTaskKey("");
            defaultBpmCheckOpinion.setTaskName("\u4f20\u9605\u4efb\u52a1");
            defaultBpmCheckOpinion.setStatus(OpinionStatus.COPYTO.getKey());
            defaultBpmCheckOpinion.setCreateTime(LocalDateTime.now());
            defaultBpmCheckOpinion.setOpinion(opinion);
            defaultBpmCheckOpinion.setQualfiedNames(StringUtil.join(userNames, (String)","));
            defaultBpmCheckOpinion.setCompleteTime(LocalDateTime.now());
            defaultBpmCheckOpinion.setDurMs(TimeUtil.getCurrentTimeMillis() - TimeUtil.getTimeMillis((LocalDateTime)defaultBpmCheckOpinion.getCreateTime()));
            defaultBpmCheckOpinion.setFiles(files);
            this.bpmCheckOpinionManager.create((Model)defaultBpmCheckOpinion);
        }
    }

    private Map<String, Object> getVar(BpmProcessInstance bpmProcessInstance, String opinion) {
        String baseUrl = PortalDataUtil.getPropertyByAlias("baseUrl");
        IUser user = ContextUtil.getCurrentUser();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("delegate", user.getFullname());
        map.put("taskSubject", bpmProcessInstance.getSubject());
        map.put("baseUrl", baseUrl);
        map.put("taskId", bpmProcessInstance.getId());
        map.put("cause", opinion);
        map.put("instSubject", bpmProcessInstance.getSubject());
        map.put("date", bpmProcessInstance.getCreateTime());
        map.put("creator", bpmProcessInstance.getCreator());
        map.put("bpmName", bpmProcessInstance.getProcDefName());
        return map;
    }
}

