/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.plugin.task.tasknotify.plugin;

import com.artfess.base.util.AppUtil;
import com.artfess.bpm.api.constant.EventType;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.model.process.task.BpmTask;
import com.artfess.bpm.api.plugin.core.def.BpmTaskPluginDef;
import com.artfess.bpm.api.plugin.core.session.BpmTaskPluginSession;
import com.artfess.bpm.api.service.BpmTaskService;
import com.artfess.bpm.plugin.core.runtime.AbstractBpmTaskPlugin;
import com.artfess.bpm.plugin.task.tasknotify.def.TaskNotifyPluginDef;
import com.artfess.bpm.plugin.task.tasknotify.def.model.NotifyItem;
import com.artfess.bpm.plugin.task.tasknotify.def.model.NotifyVo;
import com.artfess.bpm.plugin.task.tasknotify.helper.NotifyHelper;
import com.artfess.bpm.util.PortalDataUtil;
import java.util.Map;
import java.util.Set;

public class TaskNotifyPlugin
extends AbstractBpmTaskPlugin {
    private NotifyHelper notifyHelper = (NotifyHelper)AppUtil.getBean(NotifyHelper.class);

    @Override
    public Void execute(BpmTaskPluginSession pluginSession, BpmTaskPluginDef pluginDef) throws Exception {
        String baseUrl = PortalDataUtil.getPropertyByAlias("baseUrl");
        Map<String, Object> variables = pluginSession.getBpmDelegateTask().getVariables();
        variables.put("baseUrl", baseUrl);
        String procInstId = (String)variables.get("instanceId_");
        if (this.isSkip(procInstId, pluginSession.getBpmDelegateTask().getId())) {
            return null;
        }
        NotifyVo notifyVo = ((TaskNotifyPluginDef)pluginDef).getNotifyVos().get((Object)pluginSession.getEventType());
        if (notifyVo == null) {
            return null;
        }
        variables.put("nodeName", pluginSession.getBpmDelegateTask().getName());
        for (NotifyItem notifyItem : notifyVo.getNotifyItemList()) {
            if (notifyVo.getEventType().equals((Object)EventType.TASK_POST_CREATE_EVENT)) {
                this.notifyHelper.notify(notifyItem, "taskCreate", variables);
                continue;
            }
            if (!notifyVo.getEventType().equals((Object)EventType.TASK_COMPLETE_EVENT)) continue;
            this.notifyHelper.notify(notifyItem, "taskComplete", variables);
        }
        return null;
    }

    private boolean isSkip(String procInstId, String currentTaskId) throws Exception {
        boolean isSkip = false;
        Set<BpmTask> bpmTaskSet = ContextThreadUtil.getByInstId(procInstId);
        if (bpmTaskSet != null && bpmTaskSet.size() > 0) {
            BpmTask currentTask = null;
            for (BpmTask bpmTask : bpmTaskSet) {
                if (!bpmTask.getTaskId().equals(currentTaskId)) continue;
                currentTask = bpmTask;
                break;
            }
            BpmTaskService taskService = (BpmTaskService)AppUtil.getBean(BpmTaskService.class);
            taskService.setTaskSkip(currentTask);
        }
        return isSkip;
    }
}

