/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.engine.task.service;

import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.cmd.TaskFinishCmd;
import com.artfess.bpm.api.constant.ActionType;
import com.artfess.bpm.api.constant.MultiInstanceType;
import com.artfess.bpm.api.constant.NodeStatus;
import com.artfess.bpm.api.constant.OpinionStatus;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.event.StartNewFlowEvent;
import com.artfess.bpm.api.model.delegate.BpmDelegateExecution;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.plugin.core.execution.sign.SignActionHandler;
import com.artfess.bpm.api.plugin.core.execution.sign.SignResult;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.api.service.SignComplete;
import com.artfess.bpm.engine.execution.sign.handler.SignActionHandlerContainer;
import com.artfess.bpm.persistence.manager.BpmCheckOpinionManager;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.manager.BpmProStatusManager;
import com.artfess.bpm.persistence.manager.BpmSignDataManager;
import com.artfess.bpm.persistence.manager.BpmTaskCandidateManager;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.ApplicationEvent;
import org.springframework.transaction.annotation.Transactional;

public class SignCompleteImpl
implements SignComplete {
    @Resource
    SignActionHandlerContainer actionHandlerContainer;
    @Resource
    BpmProStatusManager bpmProStatusManager;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmSignDataManager bpmSignDataManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmTaskCandidateManager bpmTaskCandidateManager;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;

    @Override
    @Transactional
    public boolean isComplete(BpmDelegateExecution bpmDelegateExecution) throws Exception {
        String instId = (String)bpmDelegateExecution.getVariable("instanceId_");
        TaskFinishCmd taskFinishCmd = (TaskFinishCmd)ContextThreadUtil.getActionCmd();
        if (BeanUtils.isEmpty((Object)this.actionHandlerContainer)) {
            this.actionHandlerContainer = (SignActionHandlerContainer)AppUtil.getBean((String)"signActionHandlerContainer");
        }
        SignActionHandler handler = this.actionHandlerContainer.getSignActionHandler(taskFinishCmd.getActionType().getKey());
        SignResult result = handler.handByActionType(taskFinishCmd, bpmDelegateExecution);
        this.handComplete(result, instId, bpmDelegateExecution, taskFinishCmd.getActionType());
        return result.isComplete();
    }

    private void handComplete(SignResult result, String instId, BpmDelegateExecution bpmDelegateExecution, ActionType actionType) {
        String executeParentId;
        if (!result.isComplete()) {
            return;
        }
        String nodeId = bpmDelegateExecution.getNodeId();
        String nodeName = bpmDelegateExecution.getNodeName();
        TaskFinishCmd taskFinishCmd = (TaskFinishCmd)ContextThreadUtil.getActionCmd();
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)taskFinishCmd.getTransitVars("processInstance");
        String defId = instance.getProcDefId();
        try {
            BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean(BpmDefinitionAccessor.class);
            BpmNodeDef bpmNodeDef = bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
            StartNewFlowEvent event = new StartNewFlowEvent(bpmNodeDef);
            AppUtil.publishEvent((ApplicationEvent)event);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        NodeStatus signNodeStatus = null;
        signNodeStatus = result.getNodeStatus().getKey().equals(NodeStatus.AGREE.getKey()) ? NodeStatus.SIGN_PASS : (result.getNodeStatus().getKey().equals(NodeStatus.OPPOSE.getKey()) ? NodeStatus.SIGN_NO_PASS : this.getNodeStatus(taskFinishCmd));
        if (BeanUtils.isEmpty((Object)this.bpmProStatusManager)) {
            this.bpmProStatusManager = (BpmProStatusManager)AppUtil.getBean(BpmProStatusManager.class);
        }
        this.bpmProStatusManager.createOrUpd(instId, defId, nodeId, nodeName, signNodeStatus);
        boolean isParallel = !MultiInstanceType.SEQUENTIAL.equals((Object)bpmDelegateExecution.multiInstanceType());
        String string = executeParentId = isParallel ? bpmDelegateExecution.getParentExecution().getParentExecution().getId() : bpmDelegateExecution.getParentId();
        if (BeanUtils.isEmpty((Object)this.bpmSignDataManager)) {
            this.bpmSignDataManager = (BpmSignDataManager)AppUtil.getBean(BpmSignDataManager.class);
        }
        this.bpmSignDataManager.removeByNotActive(executeParentId, nodeId);
        this.bpmSignDataManager.updByNotActive(executeParentId, nodeId);
        this.updOpinion(executeParentId, nodeId, result.getOpinionStatus().getKey());
        if (ActionType.APPROVE.equals((Object)actionType)) {
            String resultVarName = "signResult_" + nodeId;
            bpmDelegateExecution.setVariable(resultVarName, result.getNodeStatus().getKey());
        }
        String varName = "signUsers_" + nodeId;
        if (MultiInstanceType.SEQUENTIAL.equals((Object)bpmDelegateExecution.multiInstanceType())) {
            bpmDelegateExecution.removeVariable(varName);
        }
    }

    private void updOpinion(String executeParentId, String nodeId, String status) {
        this.bpmTaskManager = (BpmTaskManager)AppUtil.getBean(BpmTaskManager.class);
        this.bpmCheckOpinionManager = (BpmCheckOpinionManager)AppUtil.getBean(BpmCheckOpinionManager.class);
        this.bpmTaskCandidateManager = (BpmTaskCandidateManager)AppUtil.getBean(BpmTaskCandidateManager.class);
        ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
        List<DefaultBpmCheckOpinion> byInstNodeId = this.bpmCheckOpinionManager.getByInstNodeId(actionCmd.getInstId(), nodeId);
        for (DefaultBpmCheckOpinion opinion : byInstNodeId) {
            if (!OpinionStatus.AWAITING_CHECK.getKey().equals(opinion.getStatus())) continue;
            opinion.setAuditor(ContextUtil.getCurrentUserId());
            opinion.setAuditorName(ContextUtil.getCurrentUser().getFullname());
            opinion.setStatus(status);
            if (OpinionStatus.RETRACTED.getKey().equals(status) && StringUtil.isEmpty((String)opinion.getOpinion())) {
                opinion.setOpinion(OpinionStatus.RETRACTED.getValue());
            }
            opinion.setCompleteTime(LocalDateTime.now());
            this.bpmCheckOpinionManager.update((Model)opinion);
        }
        List<DefaultBpmTask> bpmTasks = this.bpmTaskManager.getByExeIdAndNodeId(executeParentId, nodeId);
        for (DefaultBpmTask task : bpmTasks) {
            String taskId = task.getId();
            this.bpmTaskCandidateManager.removeByTaskId(taskId);
            this.bpmTaskManager.remove((Serializable)((Object)taskId));
        }
    }

    private NodeStatus getNodeStatus(TaskFinishCmd cmd) {
        NodeStatus nodeStatus = NodeStatus.AGREE;
        String action = cmd.getActionName();
        Object isDoneUnused = cmd.getTransitVars("IsDoneUnused");
        if (isDoneUnused != null) {
            nodeStatus = NodeStatus.RECOVER;
            return nodeStatus;
        }
        switch (cmd.getActionType()) {
            case APPROVE: {
                nodeStatus = NodeStatus.fromKey(cmd.getActionName());
                break;
            }
            case BACK_TO_START: {
                nodeStatus = NodeStatus.BACK_TO_START;
                break;
            }
            case BACK: {
                if ("toStart".equals(action) || "backToStart".equals(action)) {
                    nodeStatus = NodeStatus.BACK_TO_START;
                    break;
                }
                nodeStatus = NodeStatus.BACK;
                break;
            }
            case RECOVER: {
                nodeStatus = "toStart".equals(action) ? NodeStatus.RECOVER_TO_START : NodeStatus.RECOVER;
            }
        }
        return nodeStatus;
    }
}

