/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.engine.def.impl;

import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.bpm.api.constant.NodeType;
import com.artfess.bpm.api.exception.ProcessDefException;
import com.artfess.bpm.api.model.process.def.BpmDefinition;
import com.artfess.bpm.api.model.process.def.BpmProcessDef;
import com.artfess.bpm.api.model.process.def.BpmProcessDefExt;
import com.artfess.bpm.api.model.process.def.BpmVariableDef;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.api.service.BpmDefinitionService;
import com.artfess.bpm.engine.def.DefXmlTransForm;
import com.artfess.bpm.natapi.def.NatProDefinitionService;
import com.artfess.bpm.persistence.dao.BpmProcessInstanceDao;
import com.artfess.bpm.persistence.manager.BpmBusLinkManager;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.manager.BpmInstFormManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.bpm.persistence.manager.BpmTaskNoticeDoneManager;
import com.artfess.bpm.persistence.manager.BpmTaskNoticeManager;
import com.artfess.bpm.persistence.manager.BpmTaskTurnManager;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.artfess.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.persistence.model.query.BpmDefFieldSorts;
import com.artfess.bpm.persistence.model.query.BpmDefQueryFields;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class DefaultBpmDefinitionService
implements BpmDefinitionService {
    @Resource(name="proDefinitionServiceImpl")
    NatProDefinitionService natProDefinitionService;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    DefXmlTransForm defXmlTransForm;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmBusLinkManager bpmBusLinkManager;
    @Resource
    JdbcTemplate jdbcTemplate;
    @Resource
    BpmInstFormManager bpmInstFromManager;
    @Resource
    BpmTaskNoticeManager bpmTaskNoticeManager;
    @Resource
    BpmTaskNoticeDoneManager bpmTaskNoticeDoneManager;
    @Resource
    BpmTaskTurnManager bpmTaskTurnManager;
    @Resource
    BpmProcessInstanceDao bpmProcessInstanceDao;
    @Resource
    BpmTaskManager bpmTaskManager;

    @Override
    public boolean deploy(BpmDefinition bpmDefinition) throws Exception {
        return this.bpmDefinitionManager.deploy(bpmDefinition);
    }

    @Override
    public boolean saveDraft(BpmDefinition bpmDefinition) throws Exception {
        return this.bpmDefinitionManager.saveDraft(bpmDefinition);
    }

    @Override
    public BpmNodeDef getBpmNodeDef(String bpmnDefId, String nodeId) throws Exception {
        String defId = this.bpmDefinitionManager.getDefIdByBpmnDefId(bpmnDefId);
        BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        return bpmNodeDef;
    }

    @Override
    public BpmNodeDef getBpmNodeDefByDefIdNodeId(String procDefId, String nodeId) throws Exception {
        return this.bpmDefinitionAccessor.getBpmNodeDef(procDefId, nodeId);
    }

    @Override
    public BpmNodeDef getStartBpmNodeDef(String defId) throws Exception {
        List<BpmNodeDef> bpmNodeDefs = this.getAllBpmNodeDefs(defId);
        return bpmNodeDefs.size() > 0 ? bpmNodeDefs.get(0) : null;
    }

    @Override
    public List<BpmNodeDef> getAllBpmNodeDefs(String defId) throws Exception {
        return this.bpmDefinitionAccessor.getNodeDefs(defId);
    }

    @Override
    public List<BpmNodeDef> getEndNode(String defId) throws Exception {
        ArrayList<BpmNodeDef> endNodeDefs = new ArrayList<BpmNodeDef>();
        List<BpmNodeDef> bpmNodeDefs = this.getAllBpmNodeDefs(defId);
        for (BpmNodeDef bpmNodeDef : bpmNodeDefs) {
            if (bpmNodeDef.getOutcomeNodes().size() != 0) continue;
            endNodeDefs.add(bpmNodeDef);
        }
        return endNodeDefs;
    }

    @Override
    public boolean removeBpmDefinition(String defId) throws Exception {
        this.bpmDefinitionManager.removeCascade(defId);
        return true;
    }

    @Override
    public boolean disabledBpmDefinition(String defId) {
        DefaultBpmDefinition defaultBpmDefinition = this.bpmDefinitionManager.getById(defId);
        defaultBpmDefinition.setStatus("forbidden");
        this.bpmDefinitionManager.update((Model)defaultBpmDefinition);
        return true;
    }

    @Override
    public boolean enabledBpmDefinition(String defId) {
        DefaultBpmDefinition defaultBpmDefinition = this.bpmDefinitionManager.getById(defId);
        defaultBpmDefinition.setStatus("deploy");
        this.bpmDefinitionManager.update((Model)defaultBpmDefinition);
        this.bpmProcessInstanceManager.updForbiddenByDefKey(defaultBpmDefinition.getDefKey(), BpmProcessInstance.FORBIDDEN_NO);
        return true;
    }

    @Override
    public boolean updateBpmDefinition(BpmDefinition bpmDefinition) throws Exception {
        return this.bpmDefinitionManager.updateBpmDefinition(bpmDefinition);
    }

    @Override
    public List<BpmDefinition> getAllVersions(String defId) {
        DefaultBpmDefinition defaultBpmDefinition = this.bpmDefinitionManager.getById(defId);
        List<BpmDefinition> defaultBpmDefinitions = this.bpmDefinitionManager.queryByDefKey(defaultBpmDefinition.getDefKey());
        return defaultBpmDefinitions;
    }

    @Override
    public List<BpmDefinition> getAllHistoryVersions(String defId) {
        DefaultBpmDefinition defaultBpmDefinition = this.bpmDefinitionManager.getById(defId);
        List<DefaultBpmDefinition> defaultBpmDefinitions = this.bpmDefinitionManager.queryHistorys(defaultBpmDefinition.getDefKey());
        return this.convertBpmDefinitions(defaultBpmDefinitions);
    }

    @Override
    public List<BpmDefinition> getAll(QueryFilter queryFilter) {
        List defaultBpmDefinitions = this.bpmDefinitionManager.query(queryFilter).getRows();
        return this.convertBpmDefinitions(defaultBpmDefinitions);
    }

    @Override
    public boolean hasExternalSubprocess(String defId) throws Exception {
        List<BpmNodeDef> list = this.bpmDefinitionAccessor.getNodeDefs(defId);
        for (BpmNodeDef nodeDef : list) {
            if (!NodeType.CALLACTIVITY.equals((Object)nodeDef.getType())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDesignFile(String defId) {
        if (StringUtils.isEmpty((String)defId)) {
            return "";
        }
        DefaultBpmDefinition defaultBpmDefinition = this.bpmDefinitionManager.getById(defId);
        if (defaultBpmDefinition != null) {
            return defaultBpmDefinition.getDefXml();
        }
        return "";
    }

    @Override
    public String getBpmnFile(String defId) {
        if (StringUtils.isEmpty((String)defId)) {
            return "";
        }
        DefaultBpmDefinition defaultBpmDefinition = this.bpmDefinitionManager.getById(defId);
        if (defaultBpmDefinition != null) {
            return defaultBpmDefinition.getDefXml();
        }
        return "";
    }

    @Override
    public List<BpmDefinition> queryList(QueryFilter query) throws IOException {
        List defaultBpmDefinitions = this.bpmDefinitionManager.queryList(query).getRows();
        return defaultBpmDefinitions;
    }

    @Override
    public boolean isDefCodeExist(String defCode) {
        List<DefaultBpmDefinition> defaultBpmDefinitions = this.bpmDefinitionManager.queryByDefKey(defCode);
        return defaultBpmDefinitions.size() > 0;
    }

    @Override
    public boolean updateTreeType(String defId, String typeId) {
        DefaultBpmDefinition defaultBpmDefinition = this.bpmDefinitionManager.getById(defId);
        if (defaultBpmDefinition != null) {
            defaultBpmDefinition.setTypeId(typeId);
            this.bpmDefinitionManager.update((Model)defaultBpmDefinition);
            return true;
        }
        return false;
    }

    @Override
    public List<BpmDefinition> getProcessDefinitionByUserId(String userId) {
        BpmDefQueryFields bpmDefQueryFields = new BpmDefQueryFields();
        bpmDefQueryFields.addCreateBy(userId);
        BpmDefFieldSorts bpmDefFieldSorts = new BpmDefFieldSorts();
        bpmDefFieldSorts.addDefId();
        List<DefaultBpmDefinition> defaultBpmDefinitions = this.bpmDefinitionManager.query(bpmDefQueryFields, FieldRelation.AND, bpmDefFieldSorts);
        return this.convertBpmDefinitions(defaultBpmDefinitions);
    }

    @Override
    public List<BpmDefinition> getProcessDefinitionByUserId(String userId, QueryFilter queryFilter) {
        if (StringUtils.isEmpty((String)userId) || queryFilter == null) {
            return new ArrayList<BpmDefinition>();
        }
        queryFilter.addFilter("CREATE_BY_", (Object)userId, QueryOP.EQUAL, FieldRelation.AND);
        PageList pageList = this.bpmDefinitionManager.query(queryFilter);
        return this.convertBpmDefinitions(pageList.getRows());
    }

    @Override
    public BpmDefinition getBpmDefinitionByDefId(String defId) {
        DefaultBpmDefinition defaultBpmDefinition = this.bpmDefinitionManager.getById(defId);
        return defaultBpmDefinition;
    }

    @Override
    public BpmDefinition getBpmDefinitionByDefKey(String defKey, boolean needData) {
        DefaultBpmDefinition defaultBpmDefinition = this.bpmDefinitionManager.getMainByDefKey(defKey, needData);
        return defaultBpmDefinition;
    }

    private List<BpmDefinition> convertBpmDefinitions(List<DefaultBpmDefinition> defaultBpmDefinitions) {
        ArrayList<BpmDefinition> bpmDefinitions = new ArrayList<BpmDefinition>();
        for (DefaultBpmDefinition _defaultBpmDefinition : defaultBpmDefinitions) {
            bpmDefinitions.add(_defaultBpmDefinition);
        }
        return bpmDefinitions;
    }

    @Override
    public String getDefIdByBpmnDefId(String bpmnDefId) {
        return this.bpmDefinitionManager.getDefIdByBpmnDefId(bpmnDefId);
    }

    @Override
    public BpmProcessDef<BpmProcessDefExt> getBpmProcessDef(String bpmnDefId) throws Exception {
        String defId = this.bpmDefinitionManager.getDefIdByBpmnDefId(bpmnDefId);
        BpmProcessDef<BpmProcessDefExt> processDef = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        return processDef;
    }

    @Override
    public String getBpmnXmlByBpmnDefId(String bpmnDefId) {
        DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getByBpmnDefId(bpmnDefId);
        return this.natProDefinitionService.getDefXmlByDeployId(bpmDefinition.getBpmnDeployId());
    }

    @Override
    public String getBpmnXmlByDeployId(String deployId) {
        DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getByBpmnDeployId(deployId);
        return this.natProDefinitionService.getDefXmlByDeployId(bpmDefinition.getBpmnDeployId());
    }

    @Override
    public List<BpmVariableDef> getVariableDefs(String defId) throws Exception {
        BpmProcessDef<BpmProcessDefExt> bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        return ((DefaultBpmProcessDefExt)bpmProcessDef.getProcessDefExt()).getVariableList();
    }

    @Override
    public List<BpmVariableDef> getVariableDefs(String defId, String nodeId) throws Exception {
        BpmProcessDef<BpmProcessDefExt> bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        return ((DefaultBpmProcessDefExt)bpmProcessDef.getProcessDefExt()).getVariableList(nodeId);
    }

    @Override
    public void switchMainVersion(String defId) {
        this.bpmDefinitionManager.updMainVersion(defId);
    }

    @Override
    public boolean disabledBpmDefinitionInst(String defId) {
        DefaultBpmDefinition defaultBpmDefinition = this.bpmDefinitionManager.getById(defId);
        defaultBpmDefinition.setStatus("forbidden_instance");
        this.bpmDefinitionManager.update((Model)defaultBpmDefinition);
        String defKey = defaultBpmDefinition.getDefKey();
        this.bpmProcessInstanceManager.updForbiddenByDefKey(defKey, BpmProcessInstance.FORBIDDEN_YES);
        return false;
    }

    @Override
    public void cleanData(String defId) throws Exception {
        DefaultBpmDefinition defaultBpmDefinition = this.bpmDefinitionManager.getById(defId);
        if (!"test".equals(defaultBpmDefinition.getTestStatus())) {
            throw new ProcessDefException("\u975e\u6d4b\u8bd5\u72b6\u6001\u7684\u6d41\u7a0b\u4e0d\u80fd\u6e05\u9664\u6570\u636e");
        }
        List<DefaultBpmProcessInstance> instances = this.bpmProcessInstanceDao.getTestListByBpmnDefKey(defaultBpmDefinition.getDefKey());
        if (BeanUtils.isNotEmpty(instances)) {
            for (DefaultBpmProcessInstance entity : instances) {
                List<DefaultBpmProcessInstance> instancesSub = this.bpmProcessInstanceDao.getByParentId(entity.getId());
                if (!BeanUtils.isNotEmpty(instancesSub)) continue;
                ArrayList<String> listStr = new ArrayList<String>();
                for (DefaultBpmProcessInstance instance : instancesSub) {
                    String instId = instance.getId();
                    this.bpmProcessInstanceManager.remove((Serializable)((Object)instId));
                    this.bpmInstFromManager.removeDataByInstId(instId);
                    this.bpmTaskNoticeManager.delBpmTaskNoticeByInstId(instId);
                    this.bpmTaskNoticeDoneManager.delBpmTaskNoticeDoneByInstId(instId);
                    listStr.add(instId);
                }
                if (!BeanUtils.isNotEmpty(listStr)) continue;
                this.bpmTaskTurnManager.delByInstList(listStr);
                this.bpmTaskManager.delByInstList(listStr);
            }
        }
        List<DefaultBpmDefinition> listDefaultBpmDefinition = this.bpmDefinitionManager.queryByDefKey(defaultBpmDefinition.getDefKey());
        for (DefaultBpmDefinition entity : listDefaultBpmDefinition) {
            List<DefaultBpmProcessInstance> list = this.bpmProcessInstanceDao.getTestListByBpmnDefKey(entity.getDefKey());
            ArrayList<String> listStr = new ArrayList<String>();
            if (BeanUtils.isNotEmpty(list)) {
                for (DefaultBpmProcessInstance defaultBpmProcessInstance : list) {
                    String instId = defaultBpmProcessInstance.getId();
                    listStr.add(instId);
                    this.bpmTaskNoticeDoneManager.delBpmTaskNoticeDoneByInstId(instId);
                    this.bpmTaskNoticeManager.delBpmTaskNoticeByInstId(instId);
                    this.bpmInstFromManager.removeDataByInstId(instId);
                    this.bpmBusLinkManager.removeDataByInstId(instId);
                }
            }
            if (BeanUtils.isNotEmpty(listStr)) {
                this.bpmTaskTurnManager.delByInstList(listStr);
                this.bpmTaskManager.delByInstList(listStr);
            }
            this.bpmProcessInstanceManager.removeTestInstByDefKey(entity.getDefKey(), true);
        }
    }

    @Override
    public BpmDefinition getByBpmnDefId(String bpmnDefId) {
        return this.bpmDefinitionManager.getByBpmnDefId(bpmnDefId);
    }
}

