/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.workflow.runtime.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.groovy.GroovyScriptEngine;
import com.artfess.base.handler.MultiTenantHandler;
import com.artfess.base.handler.MultiTenantIgnoreResult;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.Base64;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.bpm.api.helper.identity.BpmIdentityExtractService;
import com.artfess.bpm.api.service.BoDataService;
import com.artfess.bpm.model.identity.DefaultBpmIdentity;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.artfess.bpm.util.BoDataUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.workflow.runtime.dao.BpmAutoStartConfDao;
import com.artfess.workflow.runtime.manager.BpmAutoStartConfManager;
import com.artfess.workflow.runtime.manager.IProcessManager;
import com.artfess.workflow.runtime.model.BpmAutoStartConf;
import com.artfess.workflow.runtime.params.StartFlowParamObject;
import com.artfess.workflow.runtime.params.StartResult;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="boAutoStartConfManager")
public class BpmAutoStartConfManagerImpl
extends BaseManagerImpl<BpmAutoStartConfDao, BpmAutoStartConf>
implements BpmAutoStartConfManager {
    @Resource
    BpmAutoStartConfDao boAutoStartConfDao;
    @Resource
    BpmIdentityExtractService bpmIdentityExtractService;
    @Resource
    BoDataService boDataService;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    IProcessManager iProcessService;
    @Resource
    GroovyScriptEngine groovyScriptEngine;
    @Resource
    BaseContext baseContext;

    @Override
    public BpmAutoStartConf getByDefKey(String defKey) {
        return (BpmAutoStartConf)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(BpmAutoStartConf::getDefKey, (Object)defKey)));
    }

    @Override
    public ObjectNode defAutoStart() throws Exception {
        List all = null;
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            all = super.getAll();
        }
        if (BeanUtils.isNotEmpty((Object)all)) {
            for (BpmAutoStartConf conf : all) {
                List bpmIdentities;
                List extractUser;
                String trigger = conf.getTrigger();
                String startUser = conf.getStartUser();
                if (StringUtil.isEmpty((String)startUser) || StringUtil.isEmpty((String)trigger) || !this.checkTrigger(trigger)) continue;
                this.baseContext.setTempTenantId(conf.getTenantId());
                List list = (List)JsonUtil.toBean((String)startUser, (TypeReference)new TypeReference<List<DefaultBpmIdentity>>(){});
                if (BeanUtils.isEmpty((Object)list) || BeanUtils.isEmpty((Object)(extractUser = this.bpmIdentityExtractService.extractUser(bpmIdentities = list.parallelStream().filter(predicate -> StringUtil.isNotEmpty((String)predicate.getId()) || StringUtil.isNotEmpty((String)predicate.getCode())).collect(Collectors.toList()))))) continue;
                DefaultBpmDefinition mainDef = this.bpmDefinitionManager.getMainByDefKey(conf.getDefKey(), false);
                List boDatas = this.boDataService.getDataByDefId(mainDef.getId());
                ObjectNode jsondata = BoDataUtil.hanlerData((String)mainDef.getId(), (List)boDatas, (boolean)true);
                ExecutorService executorService = Executors.newCachedThreadPool();
                for (IUser iUser : extractUser) {
                    executorService.execute(() -> {
                        try {
                            this.startByConf(iUser, conf, jsondata, mainDef);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                }
                this.baseContext.clearTempTenantId();
            }
        }
        return (ObjectNode)JsonUtil.toJsonNode((Object)new CommonResult("\u6267\u884c\u6210\u529f"));
    }

    private StartResult startByConf(IUser iUser, BpmAutoStartConf conf, ObjectNode jsondata, DefaultBpmDefinition mainDef) throws Exception {
        ContextUtil.setCurrentUser((IUser)iUser);
        this.baseContext.setTempTenantId(conf.getTenantId());
        StartFlowParamObject sObject = new StartFlowParamObject();
        sObject.setAccount(iUser.getAccount());
        sObject.setDefId(mainDef.getDefId());
        sObject.setFlowKey(mainDef.getDefKey());
        sObject.setExpression("\u914d\u7f6e\u81ea\u52a8\u53d1\u8d77");
        String formData = conf.getFormData();
        if (StringUtil.isNotEmpty((String)formData)) {
            ObjectNode dataConf = (ObjectNode)JsonUtil.toJsonNode((String)formData);
            HashMap<String, String> varMap = new HashMap<String, String>();
            varMap.put("startUser", iUser.getUserId());
            varMap.put("flowKey_", mainDef.getDefKey());
            Iterator iterator = jsondata.fields();
            while (iterator.hasNext()) {
                Map.Entry ent = (Map.Entry)iterator.next();
                String entKey = (String)ent.getKey();
                if (!(ent.getValue() instanceof ObjectNode)) continue;
                ObjectNode entity = (ObjectNode)ent.getValue();
                Iterator iterator2 = entity.fields();
                while (iterator2.hasNext()) {
                    Map.Entry filed = (Map.Entry)iterator2.next();
                    String filePath = entKey + "." + (String)filed.getKey();
                    if (!BeanUtils.isNotEmpty((Object)dataConf.get(filePath))) continue;
                    Object executeObject = this.groovyScriptEngine.executeObject(dataConf.get(filePath).asText(), varMap);
                    JsonUtil.putObjectToJson((ObjectNode)entity, (String)((String)filed.getKey()), (Object)executeObject);
                }
            }
        }
        sObject.setData(Base64.getBase64((String)JsonUtil.toJson((Object)jsondata)));
        CompletableFuture<StartResult> start = this.iProcessService.start(sObject);
        return start.get();
    }

    private boolean checkTrigger(String trigger) throws IOException {
        ObjectNode triggerObj = (ObjectNode)JsonUtil.toJsonNode((String)trigger);
        if (!triggerObj.hasNonNull("rdoTimeType")) {
            return false;
        }
        String triggerType = triggerObj.get("rdoTimeType").asText();
        String curDateStr = DateUtil.getCurrentTime((String)"HH:mm");
        String triggerDate = "";
        switch (triggerType) {
            case "1": {
                curDateStr = DateUtil.getCurrentTime((String)"yyyy-MM-dd HH:mm");
                triggerDate = JsonUtil.getString((JsonNode)triggerObj, (String)"sampleDate");
                if (StringUtil.isNotEmpty((String)triggerDate)) {
                    triggerDate = TimeUtil.getDateString((LocalDateTime)TimeUtil.convertString((String)triggerDate), (String)"yyyy-MM-dd HH:mm");
                }
                if (!curDateStr.equals(triggerDate)) break;
                return true;
            }
            case "2": {
                triggerDate = JsonUtil.getString((JsonNode)triggerObj, (String)"txtDay");
                if (!curDateStr.equals(triggerDate)) break;
                return true;
            }
            case "4": {
                triggerDate = JsonUtil.getString((JsonNode)triggerObj, (String)"txtWeek");
                String chkWeek = JsonUtil.getString((JsonNode)triggerObj, (String)"chkWeek");
                if (!curDateStr.equals(triggerDate) || chkWeek.indexOf(String.valueOf(LocalDateTime.now().getDayOfWeek().getValue())) <= -1) break;
                return true;
            }
            case "5": {
                triggerDate = triggerObj.get("txtMon").asText();
                String chkMons = JsonUtil.getString((JsonNode)triggerObj, (String)"chkMons");
                if (!curDateStr.equals(triggerDate) || chkMons.indexOf(String.valueOf(LocalDateTime.now().getDayOfMonth())) <= -1) break;
                return true;
            }
        }
        return false;
    }
}

