/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.workflow.runtime.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.bpm.persistence.manager.BpmReportActManager;
import com.artfess.bpm.persistence.manager.BpmReportListManager;
import com.artfess.bpm.persistence.model.BpmReportAct;
import com.artfess.bpm.persistence.model.BpmReportActVo;
import com.artfess.bpm.persistence.model.BpmReportList;
import com.artfess.bpm.persistence.model.vo.FlowOrgCountVo;
import com.artfess.bpm.persistence.model.vo.FlowUserCountVo;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/runtime/report/v1/"})
@Api(tags={"\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790"})
@ApiGroup(group={"group_bpm"})
public class ReportController
extends BaseController<BpmReportListManager, BpmReportList> {
    @Resource
    BpmReportListManager bpmReportListManager;
    @Resource
    BpmReportActManager bpmReportActManager;
    @Resource
    UCFeignService ucService;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u83b7\u53d6\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<BpmReportList> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<BpmReportList> queryFilter, @ApiParam(name="isPublic", value="\u53ea\u83b7\u53d6\u5df2\u53d1\u5e03\u7684", required=true) @RequestParam Optional<Boolean> isPublic) throws Exception {
        boolean is = isPublic.orElse(false);
        if (is) {
            queryFilter.addFilter("type", (Object)"1", QueryOP.EQUAL);
        }
        List sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("ID_", Direction.DESC));
        queryFilter.setSorter(sorter);
        return this.bpmReportListManager.query(queryFilter);
    }

    @RequestMapping(value={"getList"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u660e\u7ec6\u9875\u9762")
    @ResponseBody
    public BpmReportList getList(@ApiParam(name="id", value="\u6d41\u7a0b\u5206\u6790id", required=true) @RequestParam String id) throws Exception {
        if (StringUtil.isEmpty((String)id)) {
            return new BpmReportList();
        }
        BpmReportList bpmReportList = (BpmReportList)this.bpmReportListManager.get((Serializable)((Object)id));
        return bpmReportList;
    }

    @RequestMapping(value={"getAct"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u62a5\u8868\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u62a5\u8868\u660e\u7ec6\u9875\u9762")
    @ResponseBody
    public BpmReportAct getAct(@ApiParam(name="id", value="\u62a5\u8868id", required=true) @RequestParam String id) throws Exception {
        if (StringUtil.isEmpty((String)id)) {
            return new BpmReportAct();
        }
        BpmReportAct bpmReportAct = (BpmReportAct)this.bpmReportActManager.get((Serializable)((Object)id));
        return bpmReportAct;
    }

    @RequestMapping(value={"saveList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u4fe1\u606f")
    public CommonResult<String> saveList(@ApiParam(name="bpmReportList", value="\u8ba1\u5212\u540d\u79f0") @RequestBody BpmReportList bpmReportList) throws Exception {
        String resultMsg = null;
        String id = bpmReportList.getId();
        try {
            if (StringUtil.isEmpty((String)id)) {
                IUser user = ContextUtil.getCurrentUser();
                bpmReportList.setCreateBy(user.getUserId());
                bpmReportList.setCreateName(user.getFullname());
                ObjectNode org = this.ucService.getMainGroup(user.getUserId());
                if (BeanUtils.isNotEmpty((Object)org)) {
                    String orgId = org.get("id").asText();
                    String orgName = org.get("name").asText();
                    bpmReportList.setCreateOrgId(orgId);
                    bpmReportList.setOrgName(orgName);
                }
                bpmReportList.setId(UniqueIdUtil.getSuid());
                this.bpmReportListManager.create((Model)bpmReportList);
                resultMsg = "\u6dfb\u52a0\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u6210\u529f";
            } else {
                this.bpmReportListManager.update((Model)bpmReportList);
                resultMsg = "\u66f4\u65b0\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u6210\u529f";
            }
            return new CommonResult(true, resultMsg, (Object)bpmReportList.getId());
        }
        catch (Exception e) {
            resultMsg = "\u5bf9\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u64cd\u4f5c\u5931\u8d25";
            return new CommonResult(false, resultMsg);
        }
    }

    @RequestMapping(value={"saveAct"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u62a5\u8868\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u62a5\u8868\u4fe1\u606f")
    public CommonResult<String> saveAct(@ApiParam(name="bpmReportAct", value="\u8ba1\u5212\u540d\u79f0") @RequestBody BpmReportActVo bpmReportAct) throws Exception {
        return this.bpmReportActManager.saveAct(bpmReportAct);
    }

    @RequestMapping(value={"removeList"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u8bb0\u5f55")
    public CommonResult<String> removeList(@ApiParam(name="ids", value="\u8054\u7cfb\u4ebaids", required=true) @RequestParam String ids) throws Exception {
        try {
            String[] aryIds = StringUtil.getStringAryByStr((String)ids);
            this.bpmReportListManager.removeByIds(aryIds);
            return new CommonResult(true, "\u5220\u9664\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u6210\u529f", null);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u5931\u8d25", null);
        }
    }

    @RequestMapping(value={"removeAct"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u62a5\u8868\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u62a5\u8868\u8bb0\u5f55")
    public CommonResult<String> removeAct(@ApiParam(name="ids", value="\u8054\u7cfb\u4ebaids", required=true) @RequestParam String ids) throws Exception {
        try {
            String[] aryIds = StringUtil.getStringAryByStr((String)ids);
            this.bpmReportActManager.removeByIds(aryIds);
            return new CommonResult(true, "\u5220\u9664\u62a5\u8868\u6210\u529f", null);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u62a5\u8868\u5931\u8d25", null);
        }
    }

    @RequestMapping(value={"getEchartsData"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7edf\u8ba1\u56fe\u8868\u6570\u636e", httpMethod="GET", notes="\u62a5\u83b7\u53d6\u7edf\u8ba1\u56fe\u8868\u6570\u636e")
    public CommonResult<JsonNode> getEchartsData(@ApiParam(name="reportId", value="\u7edf\u8ba1\u56fe\u8868id", required=true) @RequestParam String reportId) throws Exception {
        return this.bpmReportActManager.getEchartsData(reportId);
    }

    @RequestMapping(value={"getSingleEchartsData"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7edf\u8ba1\u56fe\u8868\u6570\u636e", httpMethod="GET", notes="\u62a5\u83b7\u53d6\u7edf\u8ba1\u56fe\u8868\u6570\u636e")
    public CommonResult<JsonNode> getSingleEchartsData(@ApiParam(name="id", value="\u7edf\u8ba1\u56fe\u8868id", required=true) @RequestParam String id) throws Exception {
        return this.bpmReportActManager.getSingleEchartsData(id);
    }

    @RequestMapping(value={"publish"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d1\u5e03\u56fe\u8868\u8bbe\u8ba1", httpMethod="POST", notes="\u53d1\u5e03\u56fe\u8868\u8bbe\u8ba1")
    public CommonResult<String> publish(@ApiParam(name="id", value="\u56fe\u8868ID") @RequestParam String id) throws Exception {
        try {
            BpmReportList bpmReportList = (BpmReportList)this.bpmReportListManager.get((Serializable)((Object)id));
            if (!BeanUtils.isNotEmpty((Object)bpmReportList)) {
                return new CommonResult(true, "\u53d1\u5e03\u5931\u8d25\uff1aID\u4e3a\u3010" + id + "\u3011\u7684\u7edf\u8ba1\u5206\u6790\u4e0d\u5b58\u5728\uff01");
            }
            bpmReportList.setType("1");
            this.bpmReportListManager.update((Model)bpmReportList);
            return new CommonResult(true, "\u53d1\u5e03\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u53d1\u5e03\u5931\u8d25\uff1a" + e.getCause().toString());
        }
    }

    @RequestMapping(value={"listAll"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u5217\u8868\u6570\u636e", httpMethod="GET", notes="\u83b7\u53d6\u6240\u6709\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u5217\u8868\u6570\u636e")
    public PageList<BpmReportList> listAll() throws Exception {
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        queryFilter.addFilter("type", (Object)"1", QueryOP.EQUAL);
        return this.bpmReportListManager.query(queryFilter);
    }

    @RequestMapping(value={"flowOrgCountList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u6309\u90e8\u95e8\u7edf\u8ba1\u53d1\u8d77\u6570\u636e", httpMethod="POST", notes="\u6d41\u7a0b\u6309\u90e8\u95e8\u7edf\u8ba1\u53d1\u8d77\u6570\u636e")
    public PageList<FlowOrgCountVo> flowOrgCountList(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.bpmReportActManager.flowOrgCountList(queryFilter);
    }

    @RequestMapping(value={"flowOrgCountListExport"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u6309\u90e8\u95e8\u7edf\u8ba1\u53d1\u8d77\u6570\u636e", httpMethod="POST", notes="\u6d41\u7a0b\u6309\u90e8\u95e8\u7edf\u8ba1\u53d1\u8d77\u6570\u636e")
    public void flowOrgCountListExport(HttpServletResponse response, @ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        try {
            List list = this.bpmReportActManager.getFlowOrgSelectList(queryFilter);
            String tempName = "\u6d41\u7a0b\u6309\u90e8\u95e8\u7edf\u8ba1\u53d1\u8d77\u6570\u636e";
            LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
            exportMaps.put("procDefKey", "\u5de5\u5355key");
            exportMaps.put("procDefName", "\u5de5\u5355\u7c7b\u578b");
            exportMaps.put("instances", "\u5de5\u5355\u6570\u91cf");
            exportMaps.put("hourLong", "\u8fd0\u884c\u65f6\u957f\uff08\u5c0f\u65f6\uff09");
            exportMaps.put("incomplete", "\u672a\u5b8c\u6210\u5de5\u5355\u6570");
            HSSFWorkbook book = ExcelUtil.exportExcel((String)tempName, (int)24, exportMaps, (List)list);
            ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)tempName, (HttpServletResponse)response);
        }
        catch (Exception e) {
            throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @RequestMapping(value={"flowUserCountList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u6309\u4eba\u5458\u7edf\u8ba1\u53d1\u8d77\u6570\u636e", httpMethod="POST", notes="\u6d41\u7a0b\u6309\u4eba\u5458\u7edf\u8ba1\u53d1\u8d77\u6570\u636e")
    public PageList<FlowUserCountVo> flowUserCountList(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.bpmReportActManager.flowUserCountList(queryFilter);
    }

    @RequestMapping(value={"flowUserCountListExport"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u6309\u4eba\u5458\u7edf\u8ba1\u53d1\u8d77\u6570\u636e", httpMethod="POST", notes="\u6d41\u7a0b\u6309\u4eba\u5458\u7edf\u8ba1\u53d1\u8d77\u6570\u636e")
    public void flowUserCountListExport(HttpServletResponse response, @ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        try {
            List list = this.bpmReportActManager.getFlowUserSelectList(queryFilter);
            String tempName = "\u6d41\u7a0b\u6309\u4eba\u5458\u7edf\u8ba1\u53d1\u8d77\u6570\u636e";
            LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
            exportMaps.put("procDefKey", "\u5de5\u5355key");
            exportMaps.put("procDefName", "\u5de5\u5355\u7c7b\u578b");
            exportMaps.put("userId", "\u5904\u7406\u4ebaID");
            exportMaps.put("userName", "\u5904\u7406\u4eba");
            exportMaps.put("avgLong", "\u5e73\u5747\u65f6\u957f\uff08\u5c0f\u65f6\uff09");
            exportMaps.put("overtime", "\u903e\u671f\u5de5\u5355\u6570");
            exportMaps.put("closingRate", "\u95ed\u5355\u7387\uff08%\uff09");
            HSSFWorkbook book = ExcelUtil.exportExcel((String)tempName, (int)24, exportMaps, (List)list);
            ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)tempName, (HttpServletResponse)response);
        }
        catch (Exception e) {
            throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @RequestMapping(value={"exportXml"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6d41\u7a0b\u56fe\u8868xml", httpMethod="GET", notes="\u5bfc\u51fa\u6d41\u7a0b\u56fe\u8868xml")
    public void exportXml(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="ids", value="\u6d41\u7a0b\u56fe\u8868id", required=true) @RequestParam String ids) throws Exception {
        response.setContentType("APPLICATION/OCTET-STREAM");
        if (BeanUtils.isNotEmpty((Object)ids)) {
            String[] stringsIds = ids.split(",");
            List<String> list = Arrays.asList(stringsIds);
            String zipName = "ht_bpmReport_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmmss");
            Map strXml = ((BpmReportListManager)this.baseService).exportData(list);
            HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, (Map)strXml, (String)zipName);
        }
    }

    @RequestMapping(value={"import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u56fe\u8868\u5bfc\u5165", httpMethod="POST", notes="\u6d41\u7a0b\u56fe\u8868\u5bfc\u5165")
    public CommonResult<String> importData(MultipartHttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String msg;
            CommonResult message = new CommonResult("\u5bfc\u5165\u6210\u529f");
            ((BpmReportListManager)this.baseService).importData(request.getFile("file"));
            LinkedHashSet bpmReportsSaved = ThreadMsgUtil.getMapMsg2((String)"bpmReportsSaved");
            LinkedHashSet bpmReportsSkipped = ThreadMsgUtil.getMapMsg2((String)"bpmReportsSkipped");
            StringBuilder sb = new StringBuilder();
            if (BeanUtils.isNotEmpty((Object)bpmReportsSkipped)) {
                sb.append("<div style='font-weight:bold;'>\u4ee5\u4e0b\u6d41\u7a0b\u56fe\u8868\u5df2\u5b58\u5728\u6545\u8df3\u8fc7\uff1a</div>");
                msg = String.format("%s", String.join((CharSequence)"", bpmReportsSkipped));
                sb.append(msg);
            }
            if (StringUtil.isNotEmpty((String)(msg = sb.toString()))) {
                message.setMessage(msg);
            }
            return message;
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

