/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.workflow.runtime.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.base.util.time.TimeUtil;
import com.artfess.bpm.persistence.manager.BpmTaskDueTimeManager;
import com.artfess.bpm.persistence.model.BpmTaskDueTime;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/runtime/bpmTaskDueTime/v1/"})
@Api(tags={"\u4efb\u52a1\u671f\u9650\u7edf\u8ba1"})
@ApiGroup(group={"group_bpm"})
public class BpmTaskDueTimeController
extends BaseController<BpmTaskDueTimeManager, BpmTaskDueTime> {
    @Resource
    BpmTaskDueTimeManager bpmTaskDueTimeManager;
    @Resource
    SystemConfigFeignService systemConfigFeignService;

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4efb\u52a1\u671f\u9650\u7edf\u8ba1\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)", httpMethod="POST", notes="\u4efb\u52a1\u671f\u9650\u7edf\u8ba1\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)")
    public PageList<BpmTaskDueTime> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.bpmTaskDueTimeManager.query(queryFilter);
    }

    @RequestMapping(value={"get"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u671f\u9650\u7edf\u8ba1\u660e\u7ec6", httpMethod="GET", notes="\u83b7\u53d6\u4efb\u52a1\u671f\u9650\u7edf\u8ba1\u660e\u7ec6")
    public BpmTaskDueTime get(@ApiParam(name="id", value="\u4efb\u52a1\u671f\u9650\u7edf\u8ba1id", required=true) @RequestParam String id) throws Exception {
        return (BpmTaskDueTime)this.bpmTaskDueTimeManager.get((Serializable)((Object)id));
    }

    @RequestMapping(value={"getByTaskId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1id \u83b7\u53d6\u6700\u65b0\u7684\u5ef6\u671f\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636e\u4efb\u52a1id \u83b7\u53d6\u6700\u65b0\u7684\u5ef6\u671f\u4fe1\u606f")
    public BpmTaskDueTime getByTaskId(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        BpmTaskDueTime bpmTaskDueTime = this.bpmTaskDueTimeManager.getByTaskId(taskId);
        if (BeanUtils.isEmpty((Object)bpmTaskDueTime)) {
            return new BpmTaskDueTime();
        }
        int remainingTime = this.getRemainingTime(bpmTaskDueTime);
        bpmTaskDueTime.setRemainingTime(remainingTime);
        return bpmTaskDueTime;
    }

    @RequestMapping(value={"getExpirationDate"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u5230\u671f\u65f6\u95f4", httpMethod="GET", notes="\u6839\u636eid\u83b7\u53d6\u5230\u671f\u65f6\u95f4")
    public Object getExpirationDate(@ApiParam(name="id", value="\u4efb\u52a1id", required=true) @RequestParam String id, @ApiParam(name="addDueTime", value="\u4efb\u52a1id", required=true) @RequestParam Integer addDueTime) throws Exception {
        addDueTime = BeanUtils.isEmpty((Object)addDueTime) ? 0 : addDueTime;
        BpmTaskDueTime bpmTaskDueTime = (BpmTaskDueTime)this.bpmTaskDueTimeManager.get((Serializable)((Object)id));
        LocalDateTime expDate = this.getExpDate(bpmTaskDueTime, addDueTime);
        if (BeanUtils.isNotEmpty((Object)expDate)) {
            return TimeUtil.getTimeMillis((LocalDateTime)expDate);
        }
        return "0000-00-00 00:00:00";
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u4efb\u52a1\u671f\u9650\u7edf\u8ba1\u4fe1\u606f", httpMethod="POST", notes="\u6dfb\u52a0\u4efb\u52a1\u671f\u9650\u7edf\u8ba1\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="bpmTaskDueTime", value="\u4efb\u52a1\u671f\u9650\u7edf\u8ba1\u4fe1\u606f", required=true) @RequestBody BpmTaskDueTime bpmTaskDueTime) throws Exception {
        String resultMsg = null;
        boolean isTrue = true;
        try {
            String nowtime;
            String expireTime;
            BpmTaskDueTime oldBpmTaskDueTime;
            boolean isExpire = false;
            String id = bpmTaskDueTime.getId();
            if (StringUtil.isNotEmpty((String)id) && BeanUtils.isNotEmpty((Object)(oldBpmTaskDueTime = (BpmTaskDueTime)this.bpmTaskDueTimeManager.get((Serializable)((Object)id)))) && (isExpire = DateUtil.compare((String)(expireTime = DateFormatUtil.formaDatetTime((LocalDateTime)oldBpmTaskDueTime.getExpirationDate())), (String)(nowtime = DateFormatUtil.formaDatetTime((LocalDateTime)LocalDateTime.now()))))) {
                resultMsg = "\u5f53\u524d\u4efb\u52a1\u5df2\u8fc7\u671f\uff0c\u4e0d\u80fd\u518d\u8fdb\u884c\u5ef6\u671f\u64cd\u4f5c\uff01";
                isTrue = false;
            }
            if (!isExpire) {
                LocalDateTime expDate = this.getExpDate(bpmTaskDueTime, bpmTaskDueTime.getAddDueTime());
                bpmTaskDueTime.setDueTime(bpmTaskDueTime.getDueTime() + bpmTaskDueTime.getAddDueTime());
                bpmTaskDueTime.setExpirationDate(expDate);
                bpmTaskDueTime.setCreateTime(LocalDateTime.now());
                bpmTaskDueTime.setStatus(Short.valueOf((short)1));
                bpmTaskDueTime.setParentId(bpmTaskDueTime.getId());
                int remainingTime = this.getRemainingTime(bpmTaskDueTime);
                bpmTaskDueTime.setRemainingTime(remainingTime);
                this.bpmTaskDueTimeManager.updateAndSave(bpmTaskDueTime);
                resultMsg = "\u5ef6\u671f\u6210\u529f";
            }
        }
        catch (Exception e) {
            resultMsg = "\u5bf9\u4efb\u52a1\u671f\u9650\u7edf\u8ba1\u64cd\u4f5c\u5931\u8d25\uff1a" + e.getMessage();
            isTrue = false;
        }
        return new CommonResult(isTrue, resultMsg, (Object)"");
    }

    private int getRemainingTime(BpmTaskDueTime bpmTaskDueTime) throws Exception {
        int remainingTime = 0;
        if ("caltime".equals(bpmTaskDueTime.getDateType())) {
            remainingTime = TimeUtil.getSecondDiff((LocalDateTime)LocalDateTime.now(), (LocalDateTime)bpmTaskDueTime.getStartTime()) / 60;
        } else {
            ObjectNode params = JsonUtil.getMapper().createObjectNode();
            params.put("userId", bpmTaskDueTime.getUserId());
            params.put("startTime", DateFormatUtil.formaDatetTime((LocalDateTime)bpmTaskDueTime.getStartTime()));
            params.put("endTime", DateFormatUtil.formaDatetTime((LocalDateTime)LocalDateTime.now()));
            remainingTime = (int)(this.systemConfigFeignService.getWorkTimeByUser(params) / 60000L);
        }
        remainingTime = bpmTaskDueTime.getDueTime() - remainingTime;
        if (remainingTime <= 0) {
            remainingTime = 0;
        }
        return remainingTime;
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u4efb\u52a1\u671f\u9650\u7edf\u8ba1\u8bb0\u5f55", httpMethod="DELETE", notes="\u5220\u9664\u4efb\u52a1\u671f\u9650\u7edf\u8ba1\u8bb0\u5f55")
    public CommonResult<String> remove(@ApiParam(name="aryIds", value="\u4efb\u52a1\u671f\u9650\u7edf\u8ba1\u8bb0\u5f55ID\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u5206\u9694", required=true) @RequestParam String aryIds) throws Exception {
        String[] ids = null;
        if (!StringUtil.isEmpty((String)aryIds)) {
            ids = aryIds.split(",");
        }
        this.bpmTaskDueTimeManager.removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u50ac\u529e\u5386\u53f2\u6210\u529f", (Object)"");
    }

    private LocalDateTime getExpDate(BpmTaskDueTime bpmTaskDueTime, int addDueTime) throws Exception {
        LocalDateTime expDate = null;
        if ("caltime".equals(bpmTaskDueTime.getDateType())) {
            expDate = TimeUtil.getLocalDateTimeByMills((long)TimeUtil.getNextTime((int)1, (int)addDueTime, (long)TimeUtil.getTimeMillis((LocalDateTime)bpmTaskDueTime.getExpirationDate())));
        } else {
            ObjectNode params = JsonUtil.getMapper().createObjectNode();
            params.put("userId", bpmTaskDueTime.getUserId());
            if (BeanUtils.isNotEmpty((Object)bpmTaskDueTime.getExpirationDate())) {
                params.put("startTime", DateFormatUtil.formaDatetTime((LocalDateTime)bpmTaskDueTime.getExpirationDate()));
            }
            params.put("time", addDueTime);
            String expDateStr = this.systemConfigFeignService.getEndTimeByUser(params);
            expDate = DateFormatUtil.parse((String)expDateStr);
        }
        return expDate;
    }
}

