/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.workflow.bpmModel.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.constant.NodeType;
import com.artfess.bpm.api.model.process.def.BpmProcessDef;
import com.artfess.bpm.api.model.process.def.BpmVariableDef;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.UserTaskNodeDef;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.api.service.BpmDefinitionService;
import com.artfess.bpm.engine.def.impl.handler.VarDefBpmDefXmlHandler;
import com.artfess.bpm.model.var.DefaultBpmVariableDef;
import com.artfess.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.artfess.workflow.bpmModel.params.BpmVariableDefVo;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/flow/var/v1/"})
@Api(tags={"\u6d41\u7a0b\u53d8\u91cf"})
@ApiGroup(group={"group_bpm"})
public class DefVarController {
    @Resource
    VarDefBpmDefXmlHandler varDefBpmDefXmlHandler;
    @Resource
    BpmDefinitionService bpmDefinitionService;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;

    @RequestMapping(value={"listJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u53d8\u91cf\u5217\u8868\u6570\u636e", httpMethod="GET", notes="\u6d41\u7a0b\u53d8\u91cf\u5217\u8868\u6570\u636e")
    public List<BpmVariableDef> listJson(@ApiParam(name="defId", value="\u5e38\u7528\u8bedid") @RequestParam String defId, @ApiParam(name="nodeId", value="\u8282\u70b9id") @RequestParam String nodeId) throws Exception {
        List<Object> bpmVariableList = new ArrayList<BpmVariableDef>();
        if (StringUtil.isNotEmpty((String)nodeId) && StringUtil.isNotEmpty((String)defId)) {
            UserTaskNodeDef taskNodeDef = (UserTaskNodeDef)this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
            bpmVariableList = taskNodeDef.getVariableList();
        } else if (StringUtil.isNotEmpty((String)defId)) {
            bpmVariableList = this.getAllBpmVariableDef(defId);
        }
        return bpmVariableList;
    }

    private List<BpmVariableDef> getAllBpmVariableDef(String defId) throws Exception {
        ArrayList<BpmVariableDef> bpmVariableList = new ArrayList<BpmVariableDef>();
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        if (defExt.getVariableList() != null) {
            bpmVariableList.addAll(defExt.getVariableList());
        }
        List bpmNodeDefList = this.bpmDefinitionAccessor.getNodesByType(defId, NodeType.USERTASK);
        bpmNodeDefList.addAll(this.bpmDefinitionAccessor.getNodesByType(defId, NodeType.SIGNTASK));
        for (BpmNodeDef bpmNodeDef : bpmNodeDefList) {
            UserTaskNodeDef taskNodeDef = (UserTaskNodeDef)bpmNodeDef;
            List nodeVarList = taskNodeDef.getVariableList();
            if (nodeVarList == null) continue;
            bpmVariableList.addAll(nodeVarList);
        }
        return bpmVariableList;
    }

    @RequestMapping(value={"defVarEdit"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7f16\u8f91\u8282\u70b9\u53d8\u91cf", httpMethod="GET", notes="\u7f16\u8f91\u8282\u70b9\u53d8\u91cf")
    public Map<String, Object> defVarEdit(@ApiParam(name="defId", value="\u5e38\u7528\u8bedid") @RequestParam String defId, @ApiParam(name="varKey", value="\u53d8\u91cfkey") @RequestParam String varKey) throws Exception {
        List nodeDefList = this.bpmDefinitionAccessor.getNodeDefs(defId);
        List<BpmVariableDef> list = this.getAllBpmVariableDef(defId);
        BpmVariableDef bpmVariableDef = null;
        ArrayList<ObjectNode> nodeList = new ArrayList<ObjectNode>();
        for (BpmNodeDef bpmNodeDef : nodeDefList) {
            if (bpmNodeDef.getType() != NodeType.USERTASK) continue;
            ObjectNode node = JsonUtil.getMapper().createObjectNode();
            node.put("nodeId", bpmNodeDef.getNodeId());
            node.put("name", bpmNodeDef.getName());
            nodeList.add(node);
        }
        for (BpmVariableDef varDef : list) {
            if (!varKey.equals(varDef.getVarKey())) continue;
            bpmVariableDef = varDef;
        }
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put("bpmVariableDef", BeanUtils.isEmpty(bpmVariableDef) ? null : JsonUtil.toJsonNode((Object)bpmVariableDef));
        obj.put("nodeDefList", nodeList);
        return obj;
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u8282\u70b9\u53d8\u91cf", httpMethod="DELETE", notes="\u5220\u9664\u8282\u70b9\u53d8\u91cf")
    public CommonResult<String> remove(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String defId, @ApiParam(name="varKey", value="\u53d8\u91cfkey", required=true) @RequestParam String varKey) throws Exception {
        try {
            List<BpmVariableDef> list = this.getAllBpmVariableDef(defId);
            ArrayList<BpmVariableDef> bpmVariableDefs = new ArrayList<BpmVariableDef>();
            for (BpmVariableDef varDef : list) {
                if (varKey.equals(varDef.getVarKey())) continue;
                bpmVariableDefs.add(varDef);
            }
            this.varDefBpmDefXmlHandler.saveNodeXml(defId, null, bpmVariableDefs);
            return new CommonResult(true, "\u5220\u9664\u6210\u529f", (Object)"");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u5220\u9664\u5931\u8d25:" + e.getMessage(), (Object)"");
        }
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u8282\u70b9\u89c4\u5219", httpMethod="POST", notes="\u4fdd\u5b58\u8282\u70b9\u89c4\u5219")
    public CommonResult<String> save(@ApiParam(name="variableDefVo", value="\u4fdd\u5b58\u8282\u70b9\u89c4\u5219", required=true) @RequestBody BpmVariableDefVo variableDefVo) throws Exception {
        String defId = variableDefVo.getDefId();
        boolean isAdd = variableDefVo.getIsAdd();
        DefaultBpmVariableDef variableDef = variableDefVo.getVariableDef();
        String varKey = variableDef.getVarKey();
        try {
            List<BpmVariableDef> list = this.getAllBpmVariableDef(defId);
            ArrayList<Object> bpmVariableDefs = new ArrayList<Object>();
            for (BpmVariableDef varDef : list) {
                if (varKey.equals(varDef.getVarKey())) {
                    if (!isAdd) continue;
                    throw new Exception("\u53d8\u91cfKey\u5fc5\u987b\u552f\u4e00\uff01");
                }
                bpmVariableDefs.add(varDef);
            }
            bpmVariableDefs.add(variableDef);
            this.varDefBpmDefXmlHandler.saveNodeXml(defId, null, bpmVariableDefs);
            return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f\uff01", (Object)"");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u64cd\u4f5c\u5931\u8d25:" + e.getMessage(), (Object)"");
        }
    }
}

