/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.EncryptUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.uc.dao.ElectronicSealDao;
import com.artfess.uc.manager.ElectronicSealManager;
import com.artfess.uc.manager.PwdStrategyManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.ElectronicSeal;
import com.artfess.uc.model.PwdStrategy;
import com.artfess.uc.model.User;
import com.artfess.uc.params.seal.ImportSignatureObject;
import com.artfess.uc.params.seal.UserSignature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="electronicSealManager")
public class ElectronicSealManagerImpl
extends BaseManagerImpl<ElectronicSealDao, ElectronicSeal>
implements ElectronicSealManager {
    @Autowired
    UserManager userManager;
    @Autowired
    PwdStrategyManager pwdStrategyManager;

    @Override
    public void setIsUse(String id) {
        super.update((Wrapper)((UpdateWrapper)new UpdateWrapper().set((Object)"IS_USE_", (Object)1)).eq((Object)"ID_", (Object)id));
    }

    @Override
    @Transactional
    public CommonResult<String> importSignature(ImportSignatureObject signatureData) throws Exception {
        if (BeanUtils.isNotEmpty((Object)signatureData) && BeanUtils.isNotEmpty(signatureData.getSignatureList())) {
            List<UserSignature> list = signatureData.getSignatureList();
            ArrayList<String> accounts = new ArrayList<String>();
            HashMap<String, String> signatureMap = new HashMap<String, String>();
            PwdStrategy pwdStrategy = this.pwdStrategyManager.getDefault();
            for (UserSignature userSignature : list) {
                accounts.add(userSignature.getAccount());
                signatureMap.put(userSignature.getAccount(), userSignature.getFileId());
            }
            QueryFilter filter = QueryFilter.build();
            filter.withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
            filter.addFilter("ACCOUNT_", accounts, QueryOP.IN);
            filter.addFilter("IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
            PageList page = this.userManager.query(filter);
            List users = page.getRows();
            if (BeanUtils.isNotEmpty((Object)users) && users.size() > 0) {
                boolean isSuccess;
                ArrayList<ElectronicSeal> newSeals = new ArrayList<ElectronicSeal>();
                for (User user : users) {
                    ElectronicSeal seal = (ElectronicSeal)((Object)this.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ID_", (Object)user.getId())).eq((Object)"IS_USE_", (Object)0)));
                    if (BeanUtils.isNotEmpty((Object)((Object)seal)) && signatureData.isRepeatConver()) {
                        this.setIsUse(seal.getId());
                        newSeals.add(this.getNewSeal(user.getId(), (String)signatureMap.get(user.getAccount()), pwdStrategy.getInitPwd()));
                        continue;
                    }
                    if (!BeanUtils.isEmpty((Object)((Object)seal))) continue;
                    newSeals.add(this.getNewSeal(user.getId(), (String)signatureMap.get(user.getAccount()), pwdStrategy.getInitPwd()));
                }
                if (BeanUtils.isNotEmpty(newSeals) && !(isSuccess = this.saveBatch(newSeals))) {
                    throw new RuntimeException("\u7b7e\u7ae0\u6570\u636e\u6279\u91cf\u63d2\u5165\u5931\u8d25\uff01");
                }
            }
        }
        return new CommonResult(true, "\u5904\u7406\u6210\u529f\uff01");
    }

    private ElectronicSeal getNewSeal(String userId, String fileId, String pwd) throws Exception {
        ElectronicSeal newSeal = new ElectronicSeal();
        newSeal.setId(UniqueIdUtil.getSuid());
        newSeal.setIsUse(0);
        newSeal.setUserId(userId);
        newSeal.setFileId(fileId);
        newSeal.setPassword(EncryptUtil.encrypt((String)pwd));
        return newSeal;
    }
}

