/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.ws;

import com.artfess.base.exception.BaseException;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.User;
import com.artfess.uc.ws.WsFacadeUser;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class WebserviceUserHandler {
    @Resource
    UserManager userManager;
    @Resource
    PasswordEncoder passwordEncoder;

    public void sysUserOperate(WsFacadeUser wsFacadeUser) throws Exception {
        String operateType;
        switch (operateType = wsFacadeUser.getOperatetype()) {
            case "1": {
                this.addUser(wsFacadeUser);
                break;
            }
            case "3": {
                this.delUser(wsFacadeUser);
                break;
            }
            case "2": {
                this.updUser(wsFacadeUser);
                break;
            }
            case "4": {
                this.updUserAndTime(wsFacadeUser);
                break;
            }
            case "5": {
                this.addUserAndOrder(wsFacadeUser);
                break;
            }
            default: {
                throw new BaseException(String.format("\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b\uff1a %s", operateType));
            }
        }
    }

    private void addUser(WsFacadeUser wsFacadeUser) {
        User user = this.convert2User(wsFacadeUser);
        this.userManager.create((Model)user);
    }

    private void delUser(WsFacadeUser wsFacadeUser) throws Exception {
        String account = wsFacadeUser.getAccount();
        User oldUser = this.userManager.getByAccount(account);
        if (BeanUtils.isEmpty((Object)oldUser)) {
            throw new BaseException(String.format("\u8d26\u53f7\u4e3a\uff1a%s \u7684\u7528\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u88ab\u5220\u9664.", account));
        }
        this.userManager.remove((Serializable)((Object)oldUser.getId()));
    }

    private void updUser(WsFacadeUser wsFacadeUser) throws Exception {
        String account = wsFacadeUser.getAccount();
        User oldUser = this.userManager.getByAccount(account);
        if (BeanUtils.isEmpty((Object)oldUser)) {
            throw new BaseException(String.format("\u8d26\u53f7\u4e3a\uff1a%s \u7684\u7528\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u88ab\u5220\u9664.", account));
        }
        oldUser.setFullname(wsFacadeUser.getFullname());
        oldUser.setEmail(wsFacadeUser.getEmail());
        oldUser.setMobile(wsFacadeUser.getMobile());
        oldUser.setUpdateTime(LocalDateTime.now());
        oldUser.setStatus(1);
        this.userManager.update((Model)oldUser);
    }

    private void updUserAndTime(WsFacadeUser wsFacadeUser) {
        throw new BaseException("\u63a5\u53e3\u672a\u5b9e\u73b0");
    }

    private void addUserAndOrder(WsFacadeUser wsFacadeUser) {
        throw new BaseException("\u63a5\u53e3\u672a\u5b9e\u73b0");
    }

    private User convert2User(WsFacadeUser wsFacadeUser) {
        User user = new User();
        user.setId(UniqueIdUtil.getSuid());
        user.setPassword(this.passwordEncoder.encode((CharSequence)"123456"));
        user.setAccount(wsFacadeUser.getAccount());
        user.setEmail(wsFacadeUser.getEmail());
        user.setMobile(wsFacadeUser.getMobile());
        user.setFullname(wsFacadeUser.getFullname());
        user.setCreateTime(LocalDateTime.now());
        user.setUpdateTime(LocalDateTime.now());
        user.setFrom("webservice");
        user.setStatus(1);
        user.setHasSyncToWx(0);
        return user;
    }
}

