/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataAccess.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.dataAccess.dao.DataAccessControlDao;
import com.artfess.dataAccess.dao.DataAccessDefinedDao;
import com.artfess.dataAccess.manager.DataAccessControlManager;
import com.artfess.dataAccess.manager.DataAccessDefinedManager;
import com.artfess.dataAccess.model.DataAccessControl;
import com.artfess.dataAccess.model.DataAccessDefined;
import com.artfess.uc.dao.RoleDao;
import com.artfess.uc.model.Role;
import com.artfess.uc.model.User;
import com.artfess.uc.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class DataAccessDefinedManagerImpl
extends BaseManagerImpl<DataAccessDefinedDao, DataAccessDefined>
implements DataAccessDefinedManager {
    @Resource
    private DataAccessDefinedDao dao;
    @Resource
    private DataAccessControlDao dataAccessControlDao;
    @Resource
    private DataAccessControlManager manager;
    @Resource
    private RoleDao roleDao;

    @Override
    public List<DataAccessDefined> queryListDataAccessDefined(String interfaceId) {
        Assert.hasText((String)interfaceId, (String)"\u63a5\u53e3id\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"INTERFACE_ID_", (Object)interfaceId);
        List list = this.dao.selectList((Wrapper)queryWrapper);
        for (DataAccessDefined DataAccessDefined2 : list) {
            String[] split;
            String accessRangeId = DataAccessDefined2.getAccessRangeId();
            List<Object> rangNameList = new ArrayList();
            if (DataAccessDefined2.getAccessRangeType() == 5) {
                split = accessRangeId.split(",");
                rangNameList = this.dao.queryRangNameByOrg(Arrays.asList(split));
            } else if (DataAccessDefined2.getAccessRangeType() == 6) {
                split = accessRangeId.split(",");
                rangNameList = this.dao.queryRangNameByUser(Arrays.asList(split));
            }
            String strip = StringUtils.strip((String)((Object)rangNameList).toString(), (String)"[]");
            DataAccessDefined2.setRangeNameList(strip);
            List<DataAccessControl> listControl = this.manager.queryListDataAccessDefined(DataAccessDefined2.getId());
            if (listControl.size() > 0) {
                if (listControl.get(0).getAccessControlType() == 1) {
                    DataAccessDefined2.setType("\u6240\u6709\u4eba");
                    continue;
                }
                DataAccessDefined2.setType("\u5176\u4ed6");
                continue;
            }
            DataAccessDefined2.setType("");
        }
        return list;
    }

    @Override
    @Transactional
    public String saveDataAccessDefined(DataAccessDefined DataAccessDefined2) {
        Assert.notNull((Object)((Object)DataAccessDefined2), (String)"\u6743\u9650\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String msg = "";
        if (StringUtils.isNotBlank((CharSequence)DataAccessDefined2.getId())) {
            if (DataAccessDefined2.getAccessRangeType() == 5 || DataAccessDefined2.getAccessRangeType() != 6) {
                // empty if block
            }
            this.update((Model)DataAccessDefined2);
            msg = "\u66f4\u65b0\u6210\u529f";
        } else {
            this.create((Model)DataAccessDefined2);
            msg = "\u65b0\u589e\u6210\u529f";
        }
        return msg;
    }

    @Override
    @Transactional
    public void deleteDataAccessDefinedByIds(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u53c2\u6570ids\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        for (int i = 0; i < ids.size(); ++i) {
            this.dataAccessControlDao.deleteByAccessDefinedId(ids.get(i));
        }
        ((DataAccessDefinedDao)this.baseMapper).deleteBatchIds(ids);
    }

    @Override
    public DataAccessDefined loadDataAccessDefined(String id) {
        String[] split;
        Assert.hasText((String)id, (String)"\u6743\u9650id\u4e0d\u80fd\u4e3a\u7a7a");
        DataAccessDefined DataAccessDefined2 = (DataAccessDefined)((Object)((DataAccessDefinedDao)this.baseMapper).selectById((Serializable)((Object)id)));
        String accessRangeId = DataAccessDefined2.getAccessRangeId();
        List<Object> rangNameList = new ArrayList();
        if (DataAccessDefined2.getAccessRangeType() == 5) {
            split = accessRangeId.split(",");
            rangNameList = this.dao.queryRangNameByOrg(Arrays.asList(split));
        } else if (DataAccessDefined2.getAccessRangeType() == 6) {
            split = accessRangeId.split(",");
            rangNameList = this.dao.queryRangNameByUser(Arrays.asList(split));
        }
        String strip = StringUtils.strip((String)((Object)rangNameList).toString(), (String)"[]");
        DataAccessDefined2.setRangeNameList(strip);
        List<DataAccessControl> list = this.manager.queryListDataAccessDefined(DataAccessDefined2.getId());
        if (list.size() > 0) {
            if (list.get(0).getAccessControlType() == 1) {
                DataAccessDefined2.setType("\u6240\u6709\u4eba");
            } else {
                DataAccessDefined2.setType("\u5176\u4ed6");
            }
        } else {
            DataAccessDefined2.setType("");
        }
        return DataAccessDefined2;
    }

    @Override
    public List<Map<String, Object>> getDataAccessDefinedList(String alias) {
        ArrayList<String> list;
        User currentUser = ContextUtil.getCurrentUser();
        Set currentUserRolesAlias = AuthenticationUtil.getCurrentUserRolesAlias();
        QueryWrapper roleQueryWrapper = new QueryWrapper();
        roleQueryWrapper.in((Object)"CODE_", (Collection)currentUserRolesAlias);
        List roles = this.roleDao.selectList((Wrapper)roleQueryWrapper);
        String roleids = "";
        for (int i = 0; i < roles.size(); ++i) {
            roleids = i < roles.size() - 1 ? roleids + ((Role)roles.get(i)).getId() + "," : roleids + ((Role)roles.get(i)).getId();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("alias", alias);
        map.put("userId", currentUser.getUserId());
        map.put("userName", currentUser.getAccount());
        String currentUserOrgIds = AuthenticationUtil.getCurrentUserOrgIds();
        if (StringUtils.isNotBlank((CharSequence)currentUserOrgIds)) {
            List<String> orgList = Arrays.asList(currentUserOrgIds.split(","));
            map.put("orgIds", orgList);
        } else {
            list = new ArrayList<String>();
            list.add("-1");
            map.put("orgIds", list);
        }
        if (StringUtils.isNotBlank((CharSequence)roleids)) {
            List<String> roleidsList = Arrays.asList(roleids.split(","));
            map.put("roleIds", roleidsList);
        } else {
            list = new ArrayList();
            list.add("-1");
            map.put("roleIds", list);
        }
        List<Map<String, Object>> maps = this.dao.selectAccessDefinedList(map);
        return maps;
    }
}

