/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.util;

import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.manager.DemensionManager;
import com.artfess.uc.manager.OrgAuthManager;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.manager.RelAuthManager;
import com.artfess.uc.model.Demension;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.OrgAuth;
import com.artfess.uc.model.RelAuth;
import com.artfess.uc.model.User;
import com.artfess.uc.util.ContextUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AuthFilterUtil {
    public static void setDemAuthFilter(QueryFilter filter) {
        User user = ContextUtil.getCurrentUser();
        if (BeanUtils.isNotEmpty((Object)user) && !user.isAdmin()) {
            OrgAuthManager orgAuthService = (OrgAuthManager)AppUtil.getBean(OrgAuthManager.class);
            List<OrgAuth> auths = orgAuthService.getByUserId(user.getId());
            if (BeanUtils.isNotEmpty(auths)) {
                HashMap<String, String> typeIdMap = new HashMap<String, String>();
                for (OrgAuth orgAuth : auths) {
                    typeIdMap.put(orgAuth.getDemId(), orgAuth.getDemId());
                }
                String[] typeIds = new String[typeIdMap.size()];
                int i = 0;
                for (Map.Entry entry : typeIdMap.entrySet()) {
                    typeIds[i] = (String)entry.getKey();
                    ++i;
                }
                filter.addFilter("id", (Object)typeIds, QueryOP.IN, FieldRelation.AND);
            } else {
                filter.addFilter("id", (Object)"", QueryOP.EQUAL, FieldRelation.AND);
            }
        }
    }

    public static String getOrgAuthSql(String demId) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("");
        User user = ContextUtil.getCurrentUser();
        if (BeanUtils.isNotEmpty((Object)user) && !user.isAdmin() && StringUtil.isNotEmpty((String)demId)) {
            DemensionManager demensionService = (DemensionManager)AppUtil.getBean(DemensionManager.class);
            Demension dem = (Demension)demensionService.get((Serializable)((Object)demId));
            if (BeanUtils.isNotEmpty((Object)dem)) {
                OrgAuthManager orgAuthService = (OrgAuthManager)AppUtil.getBean(OrgAuthManager.class);
                List<OrgAuth> auths = orgAuthService.getOrgAuthListByDemAndUser(dem.getDemCode(), user.getAccount());
                sql.append(" AND ");
                if (BeanUtils.isNotEmpty(auths)) {
                    sql.append(" ( ");
                    boolean isFirst = true;
                    for (OrgAuth orgAuth : auths) {
                        sql.append(isFirst ? "" : " OR ");
                        sql.append(" PATH_ LIKE '" + orgAuth.getOrgPath() + "%' ");
                        isFirst = false;
                    }
                    sql.append(" ) ");
                } else {
                    sql.append(" ID_='0' ");
                }
            } else {
                sql.append(" AND ID_='0' ");
            }
        }
        return sql.toString();
    }

    public static String getOrgAuthParentId(String demId) throws Exception {
        DemensionManager demensionService;
        Demension dem;
        User user = ContextUtil.getCurrentUser();
        StringBuilder ids = new StringBuilder();
        if (BeanUtils.isNotEmpty((Object)user) && !user.isAdmin() && StringUtil.isNotEmpty((String)demId) && BeanUtils.isNotEmpty((Object)(dem = (Demension)(demensionService = (DemensionManager)AppUtil.getBean(DemensionManager.class)).get((Serializable)((Object)demId))))) {
            OrgAuthManager orgAuthService = (OrgAuthManager)AppUtil.getBean(OrgAuthManager.class);
            OrgManager orgService = (OrgManager)AppUtil.getBean(OrgManager.class);
            List<OrgAuth> auths = orgAuthService.getOrgAuthListByDemAndUser(dem.getDemCode(), user.getAccount());
            boolean isFirst = true;
            for (OrgAuth orgAuth : auths) {
                String orgId = orgAuth.getOrgId();
                Org org = (Org)orgService.get((Serializable)((Object)orgId));
                if (!BeanUtils.isNotEmpty((Object)org)) continue;
                ids.append(isFirst ? "" : ",");
                ids.append("'" + org.getParentId() + "'");
                isFirst = false;
            }
        }
        String parentId = StringUtil.isNotEmpty((String)ids.toString()) ? ids.toString() : "'0'";
        return " ( " + parentId + " ) ";
    }

    public static String getPostAuthSql() throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("");
        User user = ContextUtil.getCurrentUser();
        if (BeanUtils.isNotEmpty((Object)user) && !user.isAdmin()) {
            OrgAuthManager orgAuthService = (OrgAuthManager)AppUtil.getBean(OrgAuthManager.class);
            List<OrgAuth> auths = orgAuthService.getByUserId(user.getUserId());
            if (BeanUtils.isNotEmpty(auths)) {
                sql.append(" AND ORG_ID_ IN(select ORG_ID_ FROM UC_ORG_AUTH WHERE USER_ID_='" + user.getId() + "') ");
            } else {
                sql.append(" AND ID_='0' ");
            }
        }
        return sql.toString();
    }

    public static void setRelTypeAuthFilter(QueryFilter filter) {
        User user = ContextUtil.getCurrentUser();
        if (BeanUtils.isNotEmpty((Object)user) && !user.isAdmin()) {
            RelAuthManager relAuthService = (RelAuthManager)AppUtil.getBean(RelAuthManager.class);
            List<RelAuth> auths = relAuthService.getByUserId(user.getId());
            if (BeanUtils.isNotEmpty(auths)) {
                HashMap<String, String> typeIdMap = new HashMap<String, String>();
                for (RelAuth relAuth : auths) {
                    typeIdMap.put(relAuth.getTypeId(), relAuth.getTypeId());
                }
                String[] typeIds = new String[typeIdMap.size()];
                int i = 0;
                for (Map.Entry entry : typeIdMap.entrySet()) {
                    typeIds[i] = (String)entry.getKey();
                    ++i;
                }
                filter.addFilter("id", (Object)typeIds, QueryOP.IN, FieldRelation.AND);
            } else {
                filter.addFilter("id", (Object)"", QueryOP.EQUAL, FieldRelation.AND);
            }
        }
    }
}

