/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.manager.impl;

import com.artfess.base.handler.MultiTenantHandler;
import com.artfess.base.handler.MultiTenantIgnoreResult;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.uc.dao.TenantParamsDao;
import com.artfess.uc.manager.ParamsManager;
import com.artfess.uc.manager.TenantManageManager;
import com.artfess.uc.manager.TenantParamsManager;
import com.artfess.uc.model.Params;
import com.artfess.uc.model.TenantManage;
import com.artfess.uc.model.TenantParams;
import com.artfess.uc.params.params.ParamObject;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tenantParamsManager")
public class TenantParamsManagerImpl
extends BaseManagerImpl<TenantParamsDao, TenantParams>
implements TenantParamsManager {
    @Resource
    TenantManageManager tenantManageManager;
    @Resource
    ParamsManager paramsService;

    @Override
    public List<TenantParams> getByTenantId(String tenantId) {
        return ((TenantParamsDao)this.baseMapper).getByTenantId(tenantId);
    }

    @Override
    @Transactional
    public void deleteByTenantId(String tenantId) {
        ((TenantParamsDao)this.baseMapper).deleteByTenantId(tenantId);
    }

    @Override
    @Transactional
    public CommonResult<String> saveUserParams(String tenantId, List<ParamObject> params) {
        if (StringUtil.isEmpty((String)tenantId)) {
            return new CommonResult(false, "\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        try {
            StringBuilder pcodes = new StringBuilder();
            TenantManage tenant = (TenantManage)this.tenantManageManager.get((Serializable)((Object)tenantId));
            boolean isTrue = false;
            if (BeanUtils.isEmpty((Object)((Object)tenant))) {
                return new CommonResult(false, "\u4fdd\u5b58\u5931\u8d25\uff0c\u6ca1\u627e\u5230\u79df\u6237id\u4e3a\u3010" + tenantId + "\u3011\u7684\u79df\u6237\uff01");
            }
            ArrayList<ObjectNode> list = new ArrayList<ObjectNode>();
            if (BeanUtils.isNotEmpty(params)) {
                for (ParamObject paramObject : params) {
                    Params param = null;
                    try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
                        param = this.paramsService.getByAlias(paramObject.getAlias());
                    }
                    if (BeanUtils.isNotEmpty((Object)param) && "3".equals(param.getType())) {
                        list.add((ObjectNode)JsonUtil.toJsonNode((String)paramObject.toString()));
                        isTrue = true;
                        continue;
                    }
                    pcodes.append(paramObject.getAlias() + "\uff0c");
                }
            }
            if (BeanUtils.isNotEmpty(list)) {
                this.saveParams(tenantId, list);
                return new CommonResult(true, isTrue && StringUtil.isEmpty((String)pcodes.toString()) ? "\u4fdd\u5b58\u6210\u529f" : "\u90e8\u5206\u4fdd\u5b58\u6210\u529f\uff0c\u7528\u6237\u53c2\u6570\u7f16\u7801\uff1a" + pcodes + "\u4e0d\u5b58\u5728\uff01", (Object)"");
            }
            return new CommonResult(false, "\u672a\u4fdd\u5b58\u4efb\u4f55\u53c2\u6570\uff0c\u79df\u6237\u53c2\u6570\u7f16\u7801\uff1a" + pcodes + "\u4e0d\u5b58\u5728\uff01");
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg.indexOf("ORA-12899") > -1) {
                msg = "\u53c2\u6570\u503c\u8fc7\u957f";
            }
            return new CommonResult(false, "\u79df\u6237\u6269\u5c55\u53c2\u6570\u4fdd\u5b58\u5931\u8d25\uff1a" + msg);
        }
    }

    @Transactional
    private void saveParams(String tenantId, List<ObjectNode> lists) throws SQLException {
        for (ObjectNode ObjectNode2 : lists) {
            TenantParams params = ((TenantParamsDao)this.baseMapper).getByTenantIdAndCode(tenantId, ObjectNode2.get("alias").asText());
            if (BeanUtils.isNotEmpty((Object)((Object)params))) {
                if (ObjectNode2.hasNonNull("value") && !"null".equals(ObjectNode2.get("value").asText())) {
                    params.setValue(ObjectNode2.get("value").asText());
                } else {
                    params.setValue("");
                }
                this.update((Model)params);
                continue;
            }
            TenantParams tenantParams = new TenantParams();
            tenantParams.setCode(ObjectNode2.get("alias").asText());
            if (!"null".equals(ObjectNode2.get("value"))) {
                tenantParams.setValue(ObjectNode2.get("value").asText());
            }
            tenantParams.setTenantId(tenantId);
            tenantParams.setId(UniqueIdUtil.getSuid());
            this.create((Model)tenantParams);
        }
    }
}

