/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.portal.model.SysIndexTools;
import com.artfess.portal.persistence.manager.SysIndexToolsManager;
import com.artfess.sysConfig.persistence.manager.SysAuthUserManager;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/portal/sysIndexTools/sysIndexTools/v1/"})
@Api(tags={"\u95e8\u6237\u5de5\u5177"})
public class SysIndexToolsController
extends BaseController<SysIndexToolsManager, SysIndexTools> {
    @Resource
    SysIndexToolsManager sysIndexToolsManager;
    @Resource
    SysAuthUserManager bpmDefUserManager;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9996\u9875\u5de5\u5177\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u9996\u9875\u5de5\u5177\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<SysIndexTools> executeJob(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysIndexTools> queryFilter) throws Exception {
        return this.sysIndexToolsManager.query(queryFilter);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9996\u9875\u5de5\u5177\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u9996\u9875\u5de5\u5177\u660e\u7ec6\u9875\u9762")
    @ResponseBody
    public SysIndexTools getJson(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        if (StringUtil.isEmpty((String)id)) {
            return new SysIndexTools();
        }
        SysIndexTools sysIndexTools = (SysIndexTools)this.sysIndexToolsManager.get((Serializable)((Object)id));
        return sysIndexTools;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u9996\u9875\u5de5\u5177\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u9996\u9875\u5de5\u5177\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="sysIndexTools", value="\u9996\u9875\u5de5\u5177") @RequestBody SysIndexTools sysIndexTools) throws Exception {
        String resultMsg = null;
        String id = sysIndexTools.getId();
        try {
            if (StringUtil.isEmpty((String)id)) {
                sysIndexTools.setId(UniqueIdUtil.getSuid());
                this.sysIndexToolsManager.create((Model)sysIndexTools);
                resultMsg = "\u6dfb\u52a0\u9996\u9875\u5de5\u5177\u6210\u529f";
            } else {
                this.sysIndexToolsManager.update((Model)sysIndexTools);
                resultMsg = "\u66f4\u65b0\u9996\u9875\u5de5\u5177\u6210\u529f";
            }
            return new CommonResult(true, resultMsg);
        }
        catch (Exception e) {
            resultMsg = "\u5bf9\u9996\u9875\u5de5\u5177\u64cd\u4f5c\u5931\u8d25";
            return new CommonResult(false, resultMsg + e.getMessage());
        }
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u9996\u9875\u5de5\u5177\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u9996\u9875\u5de5\u5177\u8bb0\u5f55")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u4e3b\u952e", required=true) @RequestParam String ids) throws Exception {
        try {
            String[] aryIds = StringUtil.getStringAryByStr((String)ids);
            this.sysIndexToolsManager.removeByIds(aryIds);
            return new CommonResult(true, "\u5220\u9664\u9996\u9875\u5de5\u5177\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u9996\u9875\u5de5\u5177\u5931\u8d25");
        }
    }

    @RequestMapping(value={"getRights"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6388\u6743\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u6388\u6743\u4fe1\u606f")
    @ResponseBody
    public JsonNode getColumnRights(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        if (StringUtil.isEmpty((String)id)) {
            return null;
        }
        return this.bpmDefUserManager.getRights(id, "indexTools");
    }
}

