/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.util.jvm;

import com.artfess.portal.util.jvm.ApplicationMonitorMessage;
import com.artfess.portal.util.jvm.JVMGCUtils;
import com.artfess.portal.util.jvm.JVMInfoUtils;
import com.artfess.portal.util.jvm.JVMMemoryUtils;
import com.artfess.portal.util.jvm.JVMThreadUtils;
import org.springframework.stereotype.Component;

@Component
public class ApplicationMonitorTask {
    public ApplicationMonitorMessage doRun() {
        return this.createMessage();
    }

    private ApplicationMonitorMessage createMessage() {
        ApplicationMonitorMessage message = new ApplicationMonitorMessage();
        this.setJVMInfo(message);
        return message;
    }

    private void setJVMInfo(ApplicationMonitorMessage message) {
        JVMMemoryUtils.JVMMemoryUsage codeCacheGenPeakMemoryUsage;
        JVMMemoryUtils.JVMMemoryUsage codeCacheGenMemoryUsage;
        JVMMemoryUtils.JVMMemoryUsage permGenPeakMemoryUsage;
        JVMMemoryUtils.JVMMemoryUsage permGenMemoryUsage;
        JVMMemoryUtils.JVMMemoryUsage oldGenPeakMemoryUsage;
        JVMMemoryUtils.JVMMemoryUsage oldGenMemoryUsage;
        JVMMemoryUtils.JVMMemoryUsage survivorPeakMemoryUsage;
        JVMMemoryUtils.JVMMemoryUsage survivorMemoryUsage;
        JVMMemoryUtils.JVMMemoryUsage edenPeakMemoryUsage;
        JVMMemoryUtils.JVMMemoryUsage edenMemoryUsage;
        JVMMemoryUtils.JVMMemoryUsage nonHeapMemoryUsage;
        try {
            message.setPid(Integer.parseInt(JVMInfoUtils.getPID()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        message.setJavaVersion(JVMInfoUtils.getJavaVersion());
        message.setRunTime(JVMInfoUtils.getJVMUpTimeMs());
        message.setLoadedClassCount(JVMInfoUtils.getJVMLoadedClassCount());
        message.setUnloadedClassCount(JVMInfoUtils.getJVMUnLoadedClassCount());
        JVMMemoryUtils.JVMMemoryUsage heapMemoryUsage = JVMMemoryUtils.getHeapMemoryUsage();
        if (heapMemoryUsage != null) {
            message.setHeapTotal(heapMemoryUsage.getMax());
            message.setHeapUsed(heapMemoryUsage.getUsed());
            message.setHeapUsedPercent(heapMemoryUsage.getUsedPercent());
        }
        if ((nonHeapMemoryUsage = JVMMemoryUtils.getNonHeapMemoryUsage()) != null) {
            message.setNonHeapTotal(nonHeapMemoryUsage.getMax());
            message.setNonHeapUsed(nonHeapMemoryUsage.getUsed());
            message.setNonHeapUsedPercent(nonHeapMemoryUsage.getUsedPercent());
        }
        if ((edenMemoryUsage = JVMMemoryUtils.getEdenSpaceMemoryUsage()) != null) {
            message.setEdenTotal(edenMemoryUsage.getMax());
            message.setEdenUsed(edenMemoryUsage.getUsed());
            message.setEdenUsedPercent(edenMemoryUsage.getUsedPercent());
        }
        if ((edenPeakMemoryUsage = JVMMemoryUtils.getAndResetEdenSpaceMemoryPeakUsage()) != null) {
            message.setEdenPeakUsedPercent(edenPeakMemoryUsage.getUsedPercent());
        }
        if ((survivorMemoryUsage = JVMMemoryUtils.getSurvivorSpaceMemoryUsage()) != null) {
            message.setSurvivorTotal(survivorMemoryUsage.getMax());
            message.setSurvivorUsed(survivorMemoryUsage.getUsed());
            message.setSurvivorUsedPercent(survivorMemoryUsage.getUsedPercent());
        }
        if ((survivorPeakMemoryUsage = JVMMemoryUtils.getAndResetSurvivorSpaceMemoryPeakUsage()) != null) {
            message.setSurvivorPeakUsedPercent(survivorPeakMemoryUsage.getUsedPercent());
        }
        if ((oldGenMemoryUsage = JVMMemoryUtils.getOldGenMemoryUsage()) != null) {
            message.setOldTotal(oldGenMemoryUsage.getMax());
            message.setOldUsed(oldGenMemoryUsage.getUsed());
            message.setOldUsedPercent(oldGenMemoryUsage.getUsedPercent());
        }
        if ((oldGenPeakMemoryUsage = JVMMemoryUtils.getAndResetOldGenMemoryPeakUsage()) != null) {
            message.setOldPeakUsedPercent(oldGenPeakMemoryUsage.getUsedPercent());
        }
        if ((permGenMemoryUsage = JVMMemoryUtils.getPermGenMemoryUsage()) != null) {
            message.setPermTotal(permGenMemoryUsage.getMax());
            message.setPermUsed(permGenMemoryUsage.getUsed());
            message.setPermUsedPercent(permGenMemoryUsage.getUsedPercent());
        }
        if ((permGenPeakMemoryUsage = JVMMemoryUtils.getAndResetPermGenMemoryPeakUsage()) != null) {
            message.setPermPeakUsedPercent(permGenPeakMemoryUsage.getUsedPercent());
        }
        if ((codeCacheGenMemoryUsage = JVMMemoryUtils.getCodeCacheMemoryUsage()) != null) {
            message.setCodeCacheTotal(codeCacheGenMemoryUsage.getMax());
            message.setCodeCacheUsed(codeCacheGenMemoryUsage.getUsed());
            message.setCodeCacheUsedPercent(codeCacheGenMemoryUsage.getUsedPercent());
        }
        if ((codeCacheGenPeakMemoryUsage = JVMMemoryUtils.getAndResetCodeCacheMemoryPeakUsage()) != null) {
            message.setCodeCachePeakUsedPercent(codeCacheGenPeakMemoryUsage.getUsedPercent());
        }
        message.setYgcName(JVMGCUtils.getYoungGCName());
        message.setYgc(JVMGCUtils.getYoungGCCollectionCount());
        message.setYgcTime(JVMGCUtils.getYoungGCCollectionTime());
        message.setFgcName(JVMGCUtils.getFullGCName());
        message.setFgc(JVMGCUtils.getFullGCCollectionCount());
        message.setFgcTime(JVMGCUtils.getFullGCCollectionTime());
        message.setThreadCount(JVMThreadUtils.getThreadCount());
        message.setThreadPeakCount(JVMThreadUtils.getAndResetPeakThreadCount());
        message.setUserThreadCount(message.getThreadCount() - JVMThreadUtils.getDaemonThreadCount());
        message.setDeadLockedThreadCount(JVMThreadUtils.getDeadLockedThreadCount());
    }
}

