package com.artfess.sysConfig.persistence.model;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.artfess.base.entity.BaseModel;
import com.artfess.base.model.Tree;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 数据字典 entity对象
 * 
 * @company 阿特菲斯信息技术有限公司
 * @author miao
 * @email miao@jee-soft.cn
 * @date 2014-06-20 13:55:53
 */
@TableName("portal_sys_dic")
@ApiModel(description="数据字典 entity对象")
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class DataDict extends BaseModel<DataDict> implements Tree{
	
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(name="id", notes="主键")
	@TableId("id_")
	protected String id; 

	@ApiModelProperty(name="typeId", notes="类型id")
	@TableField("type_id_")
	protected String typeId;

	@ApiModelProperty(name="type", notes="类型（dic：项，val：值）")
	@TableField("type_")
	protected String type;


	@ApiModelProperty(name="dicId", notes="字典项ID")
	@TableField("dic_id_")
	protected String dicId;

	@ApiModelProperty(name="key", notes="字典项/值代码,当是字典项的时候，完全不能重复，当是字典值的时候在同一个字典项中不能重复")
	@TableField("key_")
	protected String key; 
	
	@ApiModelProperty(name="name", notes="字典值名称")
	@TableField("name_")
	protected String name; 
	
	@ApiModelProperty(name="parentId", notes="父ID")
	@TableField("parent_id_")
	protected String parentId; 
	
	@ApiModelProperty(name="sn", notes="序号")
	@TableField("sn_")
	protected Integer sn;

	@ApiModelProperty(name="fullId", notes="全路径ID")
	@TableField("full_id_")
	protected String fullId;

	@ApiModelProperty(name="fullCode", notes="全路径编码")
	@TableField("full_code_")
	protected String fullCode;

	@ApiModelProperty(name="fullName", notes="全路径名称")
	@TableField("full_name_")
	protected String fullName;

	@TableField(exist=false)
	protected String open;//为true时树父节点展开
	
	@ApiModelProperty(name="isParent", notes="是否父节点")
	@TableField(exist=false)
	protected String isParent;//是否有子节点数据

	@ApiModelProperty(name="key", notes="字典项/值代码,当是字典项的时候，完全不能重复，当是字典值的时候在同一个字典项中不能重复")
	@TableField(exist=false)
	protected String value;

	@ApiModelProperty(name="dicKey", notes="字典项编目")
	@TableField(exist=false)
	protected String dicKey;//为true时树父节点展开

	@ApiModelProperty(name="dicName", notes="字典项名称")
	@TableField(exist=false)
	protected String dicName;//为true时树父节点展开

	@TableField(exist=false)
	protected List<DataDict> children = new ArrayList<DataDict>();

	public String getIsParent() {
		return isParent;
	}

	public void setIsParent(String isParent) {
		this.isParent = isParent;
	}

	public String getOpen() {
		return open;
	}

	public void setOpen(String open) {
		this.open = open;
	}
	
	public void setId(String id) 
	{
		this.id = id;
	}

	public String getDicId() {
		return dicId;
	}

	public void setDicId(String dicId) {
		this.dicId = dicId;
	}

	/**
	 * 返回 主键
	 * @return
	 */
	public String getId() 
	{
		return this.id;
	}
	
	/**
	 * 设置序号
	 * @param sn 序号
	 */
	public void setSn(Integer sn) 
	{
		this.sn = sn;
	}
	
	/**
	 * 返回 序号
	 * @return
	 */
	public Integer getSn() 
	{
		return this.sn;
	}
	
	/**
	 * 设置类型id
	 * @param typeId 类型id
	 */
	public void setTypeId(String typeId) 
	{
		this.typeId = typeId;
	}
	
	/**
	 * 返回 类型ID
	 * @return
	 */
	public String getTypeId() 
	{
		return this.typeId;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	/**
	 * 设置字典值代码,在同一个字典中值不能重复
	 * @param key 字典值代码
	 */
	public void setKey(String key) 
	{
		this.key = key;
	}
	
	/**
	 * 返回 字典值代码,在同一个字典中值不能重复
	 * @return
	 */
	public String getKey() 
	{
		return this.key;
	}
	
	/**
	 * 设置 字典值名称
	 * @param name 字典值名称
	 */
	public void setName(String name) 
	{
		this.name = name;
	}
	
	/**
	 * 返回 字典值名称
	 * @return
	 */
	public String getName() 
	{
		return this.name;
	}
	/**
	 * 设置 父ID
	 * @param parentId 父ID
	 */
	public void setParentId(String parentId) 
	{
		this.parentId = parentId;
	}
	
	/**
	 * 返回 父ID
	 * @return
	 */
	public String getParentId() 
	{
		return this.parentId;
	}

	public String getDicKey() {
		return dicKey;
	}

	public void setDicKey(String dicKey) {
		this.dicKey = dicKey;
	}

	public String getDicName() {
		return dicName;
	}

	public void setDicName(String dicName) {
		this.dicName = dicName;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public String getFullId() {
		return fullId;
	}

	public void setFullId(String fullId) {
		this.fullId = fullId;
	}

	public String getFullCode() {
		return fullCode;
	}

	public void setFullCode(String fullCode) {
		this.fullCode = fullCode;
	}

	public String getFullName() {
		return fullName;
	}

	public void setFullName(String fullName) {
		this.fullName = fullName;
	}

	/**
	 * @see Object#toString()
	 */
	public String toString() 
	{
		return new ToStringBuilder(this)
		.append("id", this.id) 
		.append("typeId", this.typeId) 
		.append("key", this.key) 
		.append("name", this.name) 
		.append("parentId", this.parentId)
		.append("sn", this.sn)
		.toString();
	}
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public List getChildren() {
		return children;
	}

	@SuppressWarnings({ "unchecked", "rawtypes" })
	public void setChildren(List children){
		this.children = children;
	}
	
	public String getText() {
		return this.name;
	}
	
}