package com.artfess.portal.kh.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 考核结果详情
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-02-20
 */
@Data
@ApiModel(value="KhResultDetails对象", description="考核结果详情")
public class KhResultDetails extends BaseModel<KhResultDetails> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "结果ID")
    @TableField("result_id_")
    private String resultId;

    @ApiModelProperty(value = "指标科目ID")
    @TableField("subject_id_")
    private String subjectId;

    @ApiModelProperty(value = "指标性质【字典】（1：量化指标，2：非量化指标）")
    @TableField("nature_")
    private String nature;

    @ApiModelProperty(value = "指标名称")
    @TableField("name_")
    private String name;

    @ApiModelProperty(value = "指标编码")
    @TableField("code_")
    private String code;

    @ApiModelProperty(value = "指标定义(考核说明)")
    @TableField("contents_")
    private String contents;

    @ApiModelProperty(value = "计算方法（评分标准）")
    @TableField("mode_")
    private String mode;

    @ApiModelProperty(value = "目标值")
    @TableField("target_value_")
    private BigDecimal targetValue;

    @ApiModelProperty(value = "计量单位")
    @TableField("unit_")
    private String unit;

    @ApiModelProperty(value = "权重值（不大于1）")
    @TableField("weight_")
    private BigDecimal weight;

    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    @ApiModelProperty(value = "实际值")
    @TableField("actual_value_")
    private BigDecimal actualValue;

    @ApiModelProperty(value = "实际得分")
    @TableField("actual_score_")
    private BigDecimal actualScore;

    @ApiModelProperty(value = "考核备注")
    @TableField("memo_")
    private String memo;

}
