package com.artfess.portal.kh.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 考核对信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-02-20
 */
@ApiModel(value="KhPlanObject对象", description="考核对信息")
public class KhPlanObject extends BaseModel<KhPlanObject> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "计划ID")
    @TableField("plan_id_")
    private String planId;

    @ApiModelProperty(value = "考核对象类型【字典】（ogn：单位，dept：部门，user：人员，post：岗位，other：其它）")
    @TableField("obj_type_")
    private String objType;

    @ApiModelProperty(value = "考核对象ID")
    @TableField("obj_id_")
    private String objId;

    @ApiModelProperty(value = "考核对象名称")
    @TableField("obj_name_")
    private String objName;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPlanId() {
        return planId;
    }

    public void setPlanId(String planId) {
        this.planId = planId;
    }

    public String getObjType() {
        return objType;
    }

    public void setObjType(String objType) {
        this.objType = objType;
    }

    public String getObjId() {
        return objId;
    }

    public void setObjId(String objId) {
        this.objId = objId;
    }

    public String getObjName() {
        return objName;
    }

    public void setObjName(String objName) {
        this.objName = objName;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "KhPlanObject{" +
            "id=" + id +
            ", planId=" + planId +
            ", objType=" + objType +
            ", objId=" + objId +
            ", objName=" + objName +
        "}";
    }
}
