package com.artfess.application.controller;

import com.artfess.application.params.MessageAndConfigVo;
import com.artfess.application.service.TemplateService;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.jms.JmsProducer;
import com.artfess.base.jms.Notice;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.AppUtil;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * jms相关操作
 *
 * @author zhangxianwen
 * @company 广州宏天软件股份有限公司
 * @email zhangxw@jee-soft.cn
 * @date 2018年8月2日
 */
@RestController
@RequestMapping("/jms/v1")
@Api(tags = "队列消息发送")
@ApiGroup(group = {ApiGroupConsts.GROUP_APPLICATION})
public class JmsProducerController {
    @Resource
    TemplateService templateService;

    @RequestMapping(value = "sendNoticeToQueue", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "发送消息", httpMethod = "POST", notes = "发送消息")
    public CommonResult<String> sendNoticeToQueue(@ApiParam(name = "notice", value = "通知(通过模板来发送的消息)") @RequestBody Notice notice) throws Exception {
        templateService.sendNotice2Jms(notice);
        return new CommonResult<String>(true, "发送消息成功！");
    }

    @RequestMapping(value = "sendToQueue", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "发送消息到队列中", httpMethod = "POST", notes = "发送消息到队列中")
    public CommonResult<String> sendToQueue(@ApiParam(name = "notice", value = "通知(通过模板来发送的消息)") @RequestBody ObjectNode model) throws Exception {
        JmsProducer jmsProducer = AppUtil.getBean(JmsProducer.class);
        jmsProducer.sendToQueue(model);
        return new CommonResult<String>(true, "成功发送消息到队列！");
    }

    @RequestMapping(value = "sendToQueueByMessageConfig", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "通过消息配置发送消息", httpMethod = "POST", notes = "通过消息配置发送消息")
    public CommonResult<String> sendToQueueByMessageConfig(
            @ApiParam(name = "messageAndConfigVo", value = "消息配置发送消息VO") @RequestBody MessageAndConfigVo messageAndConfigVo) throws Exception {
       if (null != messageAndConfigVo){
           templateService.sendToQueueByMessageConfig(messageAndConfigVo.getNotice(), messageAndConfigVo.getMessageConfig());
       }
        return new CommonResult<String>(true, "成功发送消息到队列！");
    }
}
