package com.artfess.query.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.query.manager.BizQueryTagManager;
import com.artfess.query.model.BizQueryTag;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

/**
 * 搜索标签定义表（BIZ_QUERY_TAG） 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2025-02-17
 */
@Api(tags = "企查查--搜索标签定义表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_QUERY})
@RestController
@RequestMapping("/query/tag/v1/")
public class BizQueryTagController extends BaseController<BizQueryTagManager, BizQueryTag> {

    @ApiOperation("批量保存搜索标签定义表")
    @PostMapping("saveBatchTag")
    public CommonResult<String> saveBatchTag(@ApiParam(name = "model",value = "实体信息")
                                         @RequestBody
                                         @Validated({AddGroup.class}) List<BizQueryTag> tagList) throws Exception {
        boolean status = this.baseService.saveOrUpdateBatch(tagList);
        return status ? CommonResult.success(null,"批量搜索标签定义表成功") : new CommonResult<>(ResponseErrorEnums.FAIL_OPTION);
    }

    @ApiOperation("首页统计")
    @PostMapping("countByType")
    public CommonResult<String> countByType(@ApiParam(name = "type",value = "类型（1：个人，2：企业）") @RequestParam Integer type,@ApiParam(name = "itemType",value = "统计类型") @RequestParam(required = false) String itemType)  {
        List<Map<String,Object>> list= this.baseService.countByType(type,itemType);
        return CommonResult.success(list,"");
    }
}
