/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.datasource.DatabaseSwitchResult;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.SQLUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.form.model.QueryMetafield;
import com.artfess.form.model.QuerySqldef;
import com.artfess.form.persistence.manager.QueryMetafieldManager;
import com.artfess.form.persistence.manager.QuerySqldefManager;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@Api(tags={"\u81ea\u5b9a\u4e49SQL"})
@ApiGroup(group={"group_form"})
@RequestMapping(value={"/form/query/querySqldef"})
public class QuerySqldefController
extends BaseController<QuerySqldefManager, QuerySqldef> {
    @Resource
    QuerySqldefManager querySqldefManager;
    @Resource
    QueryMetafieldManager queryMetafieldManager;
    @Resource
    DatabaseContext databaseContext;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u81ea\u5b9a\u4e49SQL\u5b9a\u4e49\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u81ea\u5b9a\u4e49SQL\u5b9a\u4e49\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    @ResponseBody
    public PageList<QuerySqldef> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<QuerySqldef> queryFilter) throws Exception {
        List sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("ID_", Direction.DESC));
        queryFilter.setSorter(sorter);
        return this.querySqldefManager.query(queryFilter);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u81ea\u5b9a\u4e49SQL\u5b9a\u4e49\u660e\u7ec6", httpMethod="GET", notes="\u81ea\u5b9a\u4e49SQL\u5b9a\u4e49\u660e\u7ec6")
    public QuerySqldef getJson(@ApiParam(name="id", value="id") @RequestParam Optional<String> id, @ApiParam(name="alias", value="alias") @RequestParam Optional<String> alias) throws Exception {
        String id_ = id.orElse("");
        String alias_ = alias.orElse("");
        QuerySqldef querySqldef = null;
        if (StringUtil.isNotEmpty((String)id_)) {
            querySqldef = (QuerySqldef)this.querySqldefManager.get((Serializable)((Object)id_));
        } else if (StringUtil.isNotEmpty((String)alias_)) {
            querySqldef = this.querySqldefManager.getByAlias(alias_);
        }
        if (querySqldef != null) {
            querySqldef.setMetafields(this.queryMetafieldManager.getBySqlId(querySqldef.getId()));
        }
        return querySqldef;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u81ea\u5b9a\u4e49SQL\u5b9a\u4e49", httpMethod="POST", notes="\u4fdd\u5b58\u81ea\u5b9a\u4e49SQL\u5b9a\u4e49")
    public CommonResult<String> save(@ApiParam(name="queryView", value="\u4fdd\u5b58\u81ea\u5b9a\u4e49SQL\u5b9a\u4e49\u4fe1\u606f", required=true) @RequestBody QuerySqldef querySqldef) throws Exception {
        String id = querySqldef.getId();
        String resultMsg = "\u6dfb\u52a0\u81ea\u5b9a\u4e49SQL\u67e5\u8be2\u6210\u529f";
        if (!StringUtil.isEmpty((String)id)) {
            resultMsg = "\u66f4\u65b0\u81ea\u5b9a\u4e49SQL\u67e5\u8be2\u6210\u529f";
        }
        this.querySqldefManager.save((Object)querySqldef);
        return new CommonResult(true, resultMsg);
    }

    @RequestMapping(value={"refreshFields"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5237\u65b0\u5b57\u6bb5", httpMethod="GET", notes="\u5237\u65b0\u5b57\u6bb5")
    public List<QueryMetafield> refreshFields(@ApiParam(name="refreshFields", value="\u5237\u65b0\u5b57\u6bb5", required=true) @RequestParam String id) throws Exception {
        return this.querySqldefManager.refreshFields(id);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5220\u9664\u6570\u636e\u5217\u8868\u914d\u7f6e", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u5220\u9664\u6570\u636e\u5217\u8868\u914d\u7f6e")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u81ea\u5b9a\u4e49SQL\u5b9a\u4e49ID!\u591a\u4e2aID\u7528,\u5206\u5272", required=true) @RequestParam String ids) throws Exception {
        String[] aryIds = null;
        if (!StringUtil.isEmpty((String)ids)) {
            aryIds = ids.split(",");
        }
        this.querySqldefManager.removeByIds(aryIds);
        return new CommonResult(true, "\u5220\u9664\u6570\u636e\u5217\u8868\u914d\u7f6e\u6210\u529f");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"checkSql"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9a8c\u8bc1sql", httpMethod="POST", notes="\u9a8c\u8bc1sql")
    public CommonResult<String> checkSql(@ApiParam(name="sql", value="\u5f85\u9a8c\u8bc1\u7684sql") @RequestBody ObjectNode obj) throws Exception {
        CommonResult result = null;
        try (DatabaseSwitchResult dResult = this.databaseContext.setDataSource(obj.get("dsName").asText());){
            JdbcTemplate jdbcTemplate = null;
            jdbcTemplate = (JdbcTemplate)AppUtil.getBean(JdbcTemplate.class);
            String sql = obj.get("sql").asText();
            if (SQLUtil.containsSqlInjection((String)sql)) {
                CommonResult commonResult = result = new CommonResult(false, "sql\u8bed\u53e5\u542b\u6709\u975e\u6cd5\u6ce8\u5165\uff01");
                return commonResult;
            }
            Boolean flag = true;
            if (sql.split("from").length == 2) {
                HashMap<String, String> map = new HashMap<String, String>();
                try {
                    Select select = (Select)CCJSqlParserUtil.parse((String)sql);
                    SelectBody selectBody = select.getSelectBody();
                    PlainSelect plainSelect = (PlainSelect)selectBody;
                    Table table = (Table)plainSelect.getFromItem();
                    if (table.getAlias() != null) {
                        map.put(table.getAlias().getName(), table.getName());
                    }
                    for (Join join : plainSelect.getJoins()) {
                        Table table1 = (Table)join.getRightItem();
                        if (table1.getAlias() == null) continue;
                        map.put(table1.getAlias().getName(), table1.getName());
                    }
                    for (String key : map.keySet()) {
                        String value = (String)map.get(key);
                        if (value.equals(key)) continue;
                        flag = false;
                        break;
                    }
                    System.out.println(map);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (flag.booleanValue()) {
                jdbcTemplate.execute(sql);
                result = new CommonResult("\u9a8c\u8bc1\u901a\u8fc7");
                return result;
            }
            result = new CommonResult(false, "\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff0cSQL\u8bed\u53e5\u8868\u522b\u540d\u5fc5\u987b\u548c\u8868\u540d\u76f8\u540c");
            return result;
        }
        catch (Exception e) {
            return new CommonResult(false, "SQL\u9a8c\u8bc1\u5931\u8d25:" + e.getMessage());
        }
    }

    @RequestMapping(value={"export"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e", httpMethod="GET", notes="\u5bfc\u51fa\u6570\u636e")
    public void export(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="ids", value="ids", required=true) @RequestParam String ids) throws Exception {
        if (BeanUtils.isEmpty((Object)ids)) {
            return;
        }
        String[] idList = ids.split(",");
        String xml = this.querySqldefManager.export(idList);
        String fileName = "sqldef_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmm");
        HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, (String)xml, (String)"sqldef.xml", (String)fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165BO\u5bf9\u8c61", httpMethod="POST", notes="\u5bfc\u5165BO\u5bf9\u8c61")
    public CommonResult<String> importBo(MultipartHttpServletRequest request, HttpServletResponse response) throws Exception {
        CommonResult commonResult;
        block6: {
            File formDir;
            MultipartFile fileLoad = request.getFile("file");
            String unZipFilePath = null;
            try {
                String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
                FileUtil.createFolder((String)rootRealPath, (boolean)true);
                String name = fileLoad.getOriginalFilename();
                String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
                ZipUtil.unZipFile((MultipartFile)fileLoad, (String)rootRealPath);
                unZipFilePath = rootRealPath + File.separator + fileDir;
                this.querySqldefManager.importDef(unZipFilePath);
                commonResult = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
                if (!StringUtil.isNotEmpty((String)unZipFilePath) || !(formDir = new File(unZipFilePath)).exists()) break block6;
            }
            catch (Exception e) {
                CommonResult commonResult2 = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
                return commonResult2;
            }
            finally {
                File formDir2;
                if (StringUtil.isNotEmpty(unZipFilePath) && (formDir2 = new File(unZipFilePath)).exists()) {
                    FileUtil.deleteDir((File)formDir2);
                }
            }
            FileUtil.deleteDir((File)formDir);
        }
        return commonResult;
    }
}

