/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.persistence.manager.impl;

import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.datasource.DatabaseSwitchResult;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.handler.MultiTenantHandler;
import com.artfess.base.interceptor.ResultSetInterceptor;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JAXBUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.SQLUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.form.enums.FieldControlType;
import com.artfess.form.model.QueryMetafield;
import com.artfess.form.model.QuerySqldef;
import com.artfess.form.model.QuerySqldefXml;
import com.artfess.form.model.QuerySqldefXmlList;
import com.artfess.form.model.QueryView;
import com.artfess.form.persistence.dao.QuerySqldefDao;
import com.artfess.form.persistence.manager.QueryMetafieldManager;
import com.artfess.form.persistence.manager.QuerySqldefManager;
import com.artfess.form.persistence.manager.QueryViewManager;
import com.artfess.table.datasource.DataSourceUtil;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="querySqldefManager")
public class QuerySqldefManagerImpl
extends BaseManagerImpl<QuerySqldefDao, QuerySqldef>
implements QuerySqldefManager {
    @Resource
    QueryMetafieldManager queryMetafieldManager;
    @Resource
    QueryViewManager queryViewManager;
    @Resource
    SystemConfigFeignService systemConfigFeignService;
    @Resource
    DatabaseContext databaseContext;

    @Transactional
    public void remove(Serializable entityId) {
        QuerySqldef querySqldef = (QuerySqldef)this.get(entityId);
        this.queryMetafieldManager.removeBySqlId((String)((Object)entityId));
        this.queryViewManager.removeBySqlAlias(querySqldef.getAlias());
        super.remove(entityId);
    }

    @Transactional
    public void removeByIds(String ... ids) {
        for (String id : ids) {
            this.queryMetafieldManager.removeBySqlId(id);
            QuerySqldef querySqldef = (QuerySqldef)this.get((Serializable)((Object)id));
            if (!BeanUtils.isNotEmpty((Object)((Object)querySqldef)) || !BeanUtils.isNotEmpty((Object)querySqldef.getAlias())) continue;
            this.queryViewManager.removeBySqlAlias(querySqldef.getAlias());
        }
        super.removeByIds(ids);
    }

    @Override
    public ObjectNode checkSql(String dsName, String sql) {
        ObjectNode data = JsonUtil.getMapper().createObjectNode();
        JdbcTemplate jdbcTemplate = null;
        try {
            jdbcTemplate = (JdbcTemplate)AppUtil.getBean(JdbcTemplate.class);
            jdbcTemplate.execute(sql);
            data.put("result", true);
            data.put("message", "\u9a8c\u8bc1\u901a\u8fc7");
        }
        catch (Exception e) {
            data.put("result", false);
            data.put("message", e.getMessage());
        }
        throw new RuntimeException(data.toString());
    }

    @Transactional
    public boolean save(QuerySqldef querySqldef) {
        boolean result = false;
        this.checkBeforeSave(querySqldef);
        try (DatabaseSwitchResult dResult = this.databaseContext.setDataSource(querySqldef.getDsName());){
            this.checkSql(querySqldef.getSql());
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
        MultiTenantHandler.removeThreadLocalIgnore();
        QuerySqldef byAlias = this.getByAlias(querySqldef.getAlias());
        QuerySqldef sqldef = (QuerySqldef)this.get((Serializable)((Object)querySqldef.getId()));
        if (StringUtil.isEmpty((String)querySqldef.getId())) {
            if (byAlias != null) {
                throw new BaseException(querySqldef.getAlias() + "\u8be5\u522b\u540d\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\uff01");
            }
            querySqldef.setId(UniqueIdUtil.getSuid());
            result = super.save((Object)querySqldef);
            this.initMetafield(querySqldef);
        } else if (BeanUtils.isEmpty((Object)((Object)sqldef)) && StringUtil.isNotEmpty((String)querySqldef.getId())) {
            result = super.save((Object)querySqldef);
            this.initMetafield(querySqldef);
        } else {
            if (byAlias != null && !byAlias.getId().equals(querySqldef.getId())) {
                throw new BaseException(querySqldef.getAlias() + "\u8be5\u522b\u540d\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\uff01");
            }
            result = super.updateById((Object)querySqldef);
        }
        this.queryMetafieldManager.removeBySqlId(querySqldef.getId());
        List<QueryMetafield> metafields = querySqldef.getMetafields();
        for (int x = 0; x < metafields.size(); ++x) {
            QueryMetafield field = metafields.get(x);
            int sn = x + 1;
            field.setSn((short)sn);
            field.setId(UniqueIdUtil.getSuid());
            this.queryMetafieldManager.create((Model)field);
        }
        return result;
    }

    private void checkSql(String sql) {
        if (SQLUtil.containsSqlInjection((String)sql)) {
            throw new BaseException("SQL\u8bed\u53e5\u542b\u6709\u975e\u6cd5\u6ce8\u5165\uff01");
        }
        JdbcTemplate jdbcTemplate = null;
        jdbcTemplate = (JdbcTemplate)AppUtil.getBean(JdbcTemplate.class);
        try {
            jdbcTemplate.execute(sql);
        }
        catch (Exception e) {
            throw new BaseException("SQL\u9a8c\u8bc1\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
    }

    private void checkBeforeSave(QuerySqldef querySqldef) {
        if (!StringUtil.isEmpty((String)querySqldef.getId())) {
            return;
        }
        if (this.getByAlias(querySqldef.getAlias()) != null) {
            throw new RuntimeException("\u522b\u540d:" + querySqldef.getAlias() + ",\u5df2\u88ab\u4f7f\u7528");
        }
    }

    @Override
    public QuerySqldef getByAlias(String alias) {
        QueryFilter queryFilter = QueryFilter.build().withDefaultPage();
        queryFilter.addFilter("alias_", (Object)alias, QueryOP.EQUAL);
        PageList pageList = this.query(queryFilter);
        if (pageList != null && !pageList.getRows().isEmpty()) {
            return (QuerySqldef)((Object)pageList.getRows().get(0));
        }
        return null;
    }

    @Transactional
    private void initMetafield(QuerySqldef querySqldef) {
        JdbcTemplate jdbcTemplate = null;
        try {
            jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)querySqldef.getDsName());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
        String sql = querySqldef.getSql();
        Boolean isTwoTable = true;
        if (sql.split("from").length == 2 && sql.split("from")[1].indexOf(".") == -1) {
            isTwoTable = false;
        }
        String dbType = SQLUtil.getDbType();
        if (isTwoTable.booleanValue() && "oracle".equals(dbType)) {
            try {
                ResultSetInterceptor resultSetInterceptor = (ResultSetInterceptor)AppUtil.getBean(ResultSetInterceptor.class);
                List tableList = resultSetInterceptor.getTableNames(querySqldef.getSql());
                List<QueryMetafield> list = new ArrayList<QueryMetafield>();
                for (int i = 0; i < tableList.size(); ++i) {
                    String table = (String)tableList.get(i);
                    String sqlTwo = "select * from " + table;
                    list = this.getMetafield(jdbcTemplate, querySqldef, sqlTwo, list, isTwoTable, table);
                }
                querySqldef.setMetafields(list);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            ArrayList<QueryMetafield> queryMetafields = new ArrayList<QueryMetafield>();
            List<QueryMetafield> list = this.getMetafield(jdbcTemplate, querySqldef, querySqldef.getSql(), queryMetafields, isTwoTable, "");
            querySqldef.setMetafields(list);
        }
    }

    private List<QueryMetafield> getMetafield(JdbcTemplate jdbcTemplate, QuerySqldef querySqldef, String sql, List<QueryMetafield> list, Boolean isTwoTable, String table) {
        SqlRowSet srs = jdbcTemplate.queryForRowSet(sql);
        SqlRowSetMetaData srsmd = srs.getMetaData();
        String dbType = SQLUtil.getDbType();
        for (int i = 1; i < srsmd.getColumnCount() + 1; ++i) {
            String cn = "";
            String fn = "";
            if (!"oracle".equals(dbType)) {
                table = srsmd.getTableName(i);
            }
            if (!isTwoTable.booleanValue()) {
                cn = srsmd.getColumnName(i).toUpperCase();
                fn = srsmd.getColumnName(i).toUpperCase();
            } else if (StringUtil.isEmpty((String)table)) {
                cn = srsmd.getColumnName(i).toUpperCase();
                fn = srsmd.getColumnName(i).toUpperCase();
            } else if (StringUtil.isNotEmpty((String)table)) {
                cn = table + "." + srsmd.getColumnName(i).toUpperCase();
                fn = table + "_" + srsmd.getColumnName(i).toUpperCase();
            }
            String ctn = srsmd.getColumnTypeName(i);
            QueryMetafield field = new QueryMetafield();
            field.setSqlId(querySqldef.getId());
            field.setName(cn);
            field.setFieldName(fn);
            field.setFieldDesc(fn);
            field.setDataType(this.simplifyDataType(ctn));
            field.setIsShow((short)1);
            field.setIsSearch((short)0);
            field.setControlType(FieldControlType.ONETEXT.key);
            field.setIsVirtual((short)0);
            field.setSn((short)i);
            list.add(field);
        }
        return list;
    }

    private String simplifyDataType(String type) {
        type = type.toLowerCase();
        String number = this.systemConfigFeignService.getPropertyByAlias("datatype.number");
        String date = this.systemConfigFeignService.getPropertyByAlias("datatype.date");
        String text = this.systemConfigFeignService.getPropertyByAlias("datatype.text");
        String varchar = this.systemConfigFeignService.getPropertyByAlias("datatype.varchar");
        if (varchar.contains(type)) {
            return "varchar";
        }
        if (text.contains(type)) {
            return "clob";
        }
        if (date.contains(type)) {
            return "date";
        }
        if (number.contains(type)) {
            return "number";
        }
        return type;
    }

    @Override
    public String export(String[] idList) throws Exception {
        if (BeanUtils.isEmpty((Object)idList)) {
            return "";
        }
        QuerySqldefXmlList list = new QuerySqldefXmlList();
        for (String id : idList) {
            QuerySqldef def = (QuerySqldef)this.get((Serializable)((Object)id));
            List<QueryMetafield> metaFieldList = this.queryMetafieldManager.getBySqlId(id);
            List<QueryView> viewList = this.queryViewManager.getBySqlAlias(def.getAlias());
            QuerySqldefXml defXml = new QuerySqldefXml();
            defXml.setQuerySqldef(def);
            defXml.setMetafieldList(metaFieldList);
            defXml.setQueryViewList(viewList);
            list.addQuerySqlDef(defXml);
        }
        String xml = JAXBUtil.marshall((Object)list, QuerySqldefXmlList.class);
        return xml;
    }

    @Override
    @Transactional
    public void importDef(String path) {
        try {
            String xml = FileUtil.readFile((String)(path + File.separator + "sqldef.xml"));
            if (StringUtil.isEmpty((String)xml)) {
                return;
            }
            QuerySqldefXmlList list = (QuerySqldefXmlList)JAXBUtil.unmarshall((String)xml, QuerySqldefXmlList.class);
            List<QuerySqldefXml> sqlDefList = list.getQuerySqlDefList();
            for (QuerySqldefXml def : sqlDefList) {
                this.importDef(def);
            }
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
    }

    private void importDef(QuerySqldefXml def) {
        QuerySqldef sqlDef = def.getQuerySqldef();
        QuerySqldef tmp = this.getByAlias(sqlDef.getAlias());
        if (tmp != null) {
            ThreadMsgUtil.addMsg((String)("\u5b9a\u4e49\uff1a" + tmp.getName() + "\uff0c\u5df2\u5b58\u5728\u6545\u8df3\u8fc7"));
            return;
        }
        String sqlId = UniqueIdUtil.getSuid();
        sqlDef.setId(sqlId);
        try {
            List<QueryMetafield> metafields = def.getMetafieldList();
            sqlDef.setMetafields(metafields);
            this.save(sqlDef);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg != null && msg.contains("SQL\u9a8c\u8bc1\u5931\u8d25")) {
                throw new BaseException("SQL\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u4e0d\u652f\u6301\u5bfc\u5165\uff01");
            }
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
        List<QueryView> viewList = def.getQueryViewList();
        for (QueryView view : viewList) {
            view.setId(UniqueIdUtil.getSuid());
            this.queryViewManager.create((Model)view);
        }
        ThreadMsgUtil.addMsg((String)("\u5b9a\u4e49\uff1a" + sqlDef.getName() + "\uff0c\u6210\u529f\u5bfc\u5165!"));
    }

    @Override
    @Transactional
    public List<QueryMetafield> refreshFields(String id) {
        QuerySqldef querySqldef = (QuerySqldef)this.get((Serializable)((Object)id));
        List<QueryMetafield> oldMetafields = this.queryMetafieldManager.getBySqlId(id);
        this.initMetafield(querySqldef);
        List<QueryMetafield> newMetafields = querySqldef.getMetafields();
        ArrayList<QueryMetafield> returnMetafields = new ArrayList<QueryMetafield>();
        for (int x = 0; x < oldMetafields.size(); ++x) {
            for (int i = 0; i < newMetafields.size(); ++i) {
                if (!newMetafields.get(i).getName().equals(oldMetafields.get(x).getName())) continue;
                returnMetafields.add(oldMetafields.get(x));
                newMetafields.remove(i);
            }
        }
        returnMetafields.addAll(newMetafields);
        return returnMetafields;
    }
}

