/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.persistence.manager.impl;

import com.artfess.base.cache.annotation.CacheEvict;
import com.artfess.base.cache.annotation.CachePut;
import com.artfess.base.cache.annotation.Cacheable;
import com.artfess.base.cache.annotation.FirstCache;
import com.artfess.base.exception.BaseException;
import com.artfess.base.exception.SystemException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.WorkflowFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.template.impl.FreeMarkerEngine;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.Dom4jUtil;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JAXBUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.MapUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.bo.bodef.BoDefService;
import com.artfess.bo.model.BoAttribute;
import com.artfess.bo.model.BoBpmShipGroup;
import com.artfess.bo.model.BoData;
import com.artfess.bo.model.BoDef;
import com.artfess.bo.model.BoDefXml;
import com.artfess.bo.model.BoEnt;
import com.artfess.bo.persistence.manager.BoDefManager;
import com.artfess.bo.util.BoUtil;
import com.artfess.form.enums.FormType;
import com.artfess.form.model.Form;
import com.artfess.form.model.FormField;
import com.artfess.form.model.FormHistory;
import com.artfess.form.model.FormHistoryRecord;
import com.artfess.form.model.FormImportXml;
import com.artfess.form.model.FormMeta;
import com.artfess.form.model.FormPrintTemplate;
import com.artfess.form.model.FormRight;
import com.artfess.form.model.FormTemplate;
import com.artfess.form.model.FormXml;
import com.artfess.form.param.FormPreviewDataParam;
import com.artfess.form.param.GenerateExpandParam;
import com.artfess.form.persistence.dao.FormDao;
import com.artfess.form.persistence.manager.FormDataTemplateManager;
import com.artfess.form.persistence.manager.FormFieldManager;
import com.artfess.form.persistence.manager.FormHistoryManager;
import com.artfess.form.persistence.manager.FormHistoryRecordManager;
import com.artfess.form.persistence.manager.FormManager;
import com.artfess.form.persistence.manager.FormMetaManager;
import com.artfess.form.persistence.manager.FormPrintTemplateManager;
import com.artfess.form.persistence.manager.FormRightManager;
import com.artfess.form.persistence.manager.FormTemplateManager;
import com.artfess.form.service.FormService;
import com.artfess.form.util.FormUtil;
import com.artfess.form.util.FreeMakerUtil;
import com.artfess.form.util.GenerateExpandUtil;
import com.artfess.form.util.JsoupUtil;
import com.artfess.form.vo.BpmFormVo;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service(value="bpmFormManager")
public class FormManagerImpl
extends BaseManagerImpl<FormDao, Form>
implements FormManager {
    @Resource
    FormFieldManager formFieldManager;
    @Resource
    FormTemplateManager formTemplateManager;
    @Resource
    FormDataTemplateManager dataTemplateManager;
    @Resource
    FreeMarkerEngine freemarkEngine;
    @Resource
    BoDefService boDefService;
    @Resource
    FormMetaManager formMetaManager;
    @Resource
    FormHistoryManager formHistoryManager;
    @Resource
    SystemConfigFeignService systemConfigFeignService;
    @Resource
    BoDefManager boDefManager;
    @Resource
    FormHistoryRecordManager formHistoryRecordManager;
    @Resource
    BoDefManager bODefManager;
    @Resource
    FormService formService;
    @Resource
    FormRightManager bpmFormRightManager;
    @Resource
    FormPrintTemplateManager formPrintTemplateManager;
    @Resource
    WorkflowFeignService workflowFeignService;

    @Override
    public IPage<Form> getFormQueryList(QueryFilter<Form> queryFilter) throws Exception {
        return ((FormDao)this.baseMapper).getFormQueryList((IPage<Form>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<Form>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    public Form get(Serializable entityId) {
        Form bpmForm = (Form)super.get(entityId);
        String html = bpmForm.getFormHtml();
        String formHtml = I18nUtil.replaceTemp((String)html, (String)"\\#\\{([\\w]+[\\.\\w]*)\\}", (Locale)LocaleContextHolder.getLocale());
        bpmForm.setFormHtml(formHtml);
        return bpmForm;
    }

    @Override
    public String getHtml(String formId, String mainFieldTemplate, String subFieldListTemplate) throws Exception {
        String[] tableNameArray = mainFieldTemplate.split(",");
        String[] templateAliasArray = subFieldListTemplate.split(",");
        FormMeta bpmFormdef = (FormMeta)this.formMetaManager.get((Serializable)((Object)formId));
        String html = "";
        if (bpmFormdef != null) {
            JsonNode fieldList = bpmFormdef.getFieldList();
            for (int i = 0; i < tableNameArray.length; ++i) {
                String tableName = tableNameArray[i];
                JsonNode tableField = null;
                for (int j = 0; j < fieldList.size(); ++j) {
                    JsonNode table = fieldList.get(j);
                    if (!tableName.equals(table.get("name"))) continue;
                    tableField = table;
                    break;
                }
                FormTemplate template = this.formTemplateManager.getByTemplateAlias(templateAliasArray[i]);
                String macroTemplate = this.formTemplateManager.getByTemplateAlias(template.getMacrotemplateAlias()).getHtml();
                if (tableField == null || template == null) continue;
                boolean isSub = tableField.get("type").equals((Object)"sub");
                ArrayNode fieldLists = null;
                if (isSub) {
                    fieldLists = (ArrayNode)tableField.get("children");
                } else {
                    JsonNode expand = JsonUtil.toJsonNode((String)bpmFormdef.getExpand());
                    JsonNode separators = null;
                    if (BeanUtils.isNotEmpty((Object)expand)) {
                        separators = expand.get("separators");
                    }
                    this.getFieldList(fieldLists, tableField.get("children"), separators);
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("table", tableField);
                map.put("isSub", isSub);
                map.put("mainGroup", "\u57fa\u672c\u4fe1\u606f");
                map.put("formDesc", tableField.get("desc"));
                map.put("fieldList", fieldLists);
                map.put("ganged", bpmFormdef.getGanged());
                html = html + this.freemarkEngine.parseByTempName(macroTemplate + template.getHtml(), map);
            }
        }
        return html;
    }

    private void getFieldList(ArrayNode fieldLists, JsonNode fields, JsonNode separators) {
        if (BeanUtils.isNotEmpty((Object)fields)) {
            int i;
            ArrayNode basefields = JsonUtil.getMapper().createObjectNode().arrayNode();
            ObjectNode mainSep = JsonUtil.getMapper().createObjectNode();
            if (BeanUtils.isNotEmpty((Object)separators)) {
                for (i = 0; i < separators.size(); ++i) {
                    ObjectNode oj = (ObjectNode)separators.get(i);
                    oj.put("fields", (JsonNode)JsonUtil.getMapper().createObjectNode());
                    if (separators.get(i).get("key") == null) continue;
                    mainSep = (ObjectNode)separators.get(i);
                }
            }
            for (i = 0; i < fields.size(); ++i) {
                JsonNode obj = fields.get(i);
                String separator = obj.get("separator").asText();
                if (StringUtil.isZeroEmpty((String)separator)) {
                    basefields.arrayNode();
                    continue;
                }
                for (int m = 0; m < separators.size(); ++m) {
                    ArrayNode sepObj = (ArrayNode)separators.get(m);
                    if (!separator.equals(sepObj.get("key"))) continue;
                    ((ArrayNode)sepObj.get("fields")).add(obj);
                }
            }
            mainSep.set("fields", (JsonNode)basefields);
            fieldLists.add((JsonNode)mainSep);
            for (int m = 0; m < separators.size(); ++m) {
                ArrayNode sepObj = (ArrayNode)separators.get(m);
                if (!BeanUtils.isNotEmpty((Object)sepObj.get("fields")) || sepObj.get("key").equals((Object)"0")) continue;
                fieldLists.add((JsonNode)sepObj);
            }
        }
    }

    @Override
    public Form getMainByFormKey(String formKey) {
        return ((FormDao)this.baseMapper).getMainByFormKey(formKey);
    }

    @Override
    public List<Form> getByFormKey(String formKey) {
        return ((FormDao)this.baseMapper).getByFormKey(formKey);
    }

    @Override
    public List<Form> getPrintByFormKey(String formKey) {
        return ((FormDao)this.baseMapper).getPrintByFormKey(formKey);
    }

    @Override
    public List<Form> getByBoCodes(List<String> codes, String formType, QueryFilter<Form> filter) {
        List<Form> list = null;
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("codes", codes);
            map.put("formType", formType);
            map.put("formKey", filter.getParams().get("formKey"));
            map.put("name", filter.getParams().get("name"));
            list = ((FormDao)this.baseMapper).getByBoCodes(map);
        }
        catch (SystemException e) {
            e.printStackTrace();
            list = new ArrayList<Form>();
        }
        return list;
    }

    @Override
    public Integer getBpmFormCountsByFormKey(String formKey) {
        return ((FormDao)this.baseMapper).getBpmFormCountsByFormKey(formKey);
    }

    @Override
    @Transactional
    public void newVersion(String formId) throws Exception {
        Form bpmform = this.get((Serializable)((Object)formId));
        this.createNewVersionForm(bpmform);
    }

    private void createNewVersionForm(Form bpmform) {
        if (bpmform != null) {
            Integer rtn = ((FormDao)this.baseMapper).getMaxVersionByFormKey(bpmform.getFormKey());
            String newFormId = UniqueIdUtil.getSuid();
            Form newBpmForm = bpmform;
            newBpmForm.setId(newFormId);
            newBpmForm.setIsMain('N');
            newBpmForm.setStatus("draft");
            newBpmForm.setVersion(rtn + 1);
            this.create((Model)newBpmForm);
            this.publish(newFormId);
            this.setDefaultVersion(newFormId, newBpmForm.getFormKey());
        }
    }

    private void createNewDraftForm(Form bpmFormDraft) {
        if (bpmFormDraft != null) {
            Integer rtn = ((FormDao)this.baseMapper).getMaxVersionByFormKey(bpmFormDraft.getFormKey());
            String newFormId = UniqueIdUtil.getSuid();
            Form newBpmForm = bpmFormDraft;
            newBpmForm.setId(newFormId);
            newBpmForm.setIsMain('N');
            newBpmForm.setStatus("draft");
            newBpmForm.setVersion(rtn + 1);
            this.create((Model)newBpmForm);
            this.setDefaultVersion(newFormId, newBpmForm.getFormKey());
        }
    }

    @Override
    @Transactional
    public void setDefaultVersion(String formId, String formKey) {
        ((FormDao)this.baseMapper).updNotDefaultByFormKey(formKey);
        ((FormDao)this.baseMapper).updDefaultByFormId(formId);
        Form form = (Form)super.get((Serializable)((Object)formId));
        if (BeanUtils.isNotEmpty((Object)((Object)form))) {
            FormMeta byKey = this.formMetaManager.getByKey(formKey);
            byKey.setExpand(form.getExpand());
            this.formMetaManager.update((Model)byKey);
        }
        this.removeFromCache(formKey);
    }

    private void removeFromCache(String formKey) {
        FormManagerImpl bean = (FormManagerImpl)AppUtil.getBean(this.getClass());
        bean.delFromCache(formKey);
    }

    @CacheEvict(value={"bpm:form:bpmForm"}, key="#formKey")
    protected void delFromCache(String formKey) {
    }

    @Override
    @Transactional
    public void publish(String formId) {
        Form formDef = this.get((Serializable)((Object)formId));
        if (formDef != null) {
            formDef.setStatus("deploy");
            this.update(formDef);
        }
    }

    @Override
    public List<Form> getByDefId(String defId) {
        return ((FormDao)this.baseMapper).getByDefId(defId);
    }

    @Override
    @Transactional
    public CommonResult<String> importForms(ObjectNode obj, String typeId) throws Exception {
        return this.formService.importFormAndBo(obj, typeId);
    }

    @Override
    @Transactional
    public void importByFormXml(String xml, String typeId, List<BoDef> importBoDef, Map<String, String> nameMap) throws Exception {
        FormImportXml formImportXml = (FormImportXml)JAXBUtil.unmarshall((String)xml, FormImportXml.class);
        List<FormXml> formXmlList = formImportXml.getFormXmlList();
        Map<String, String> entIdMap = this.getEntIdMap(importBoDef, nameMap);
        for (FormXml formXml : formXmlList) {
            List<FormField> fields;
            ObjectNode boDefJson;
            ObjectNode sysType;
            HashSet<String> boCodesSet = new HashSet<String>();
            if (BeanUtils.isNotEmpty(formXml.getBoCodes())) {
                for (String boCode : formXml.getBoCodes()) {
                    boCodesSet.add(boCode);
                }
            }
            FormMeta formDef = formXml.getBpmFormDef();
            Form form = formXml.getBpmForm();
            if (StringUtil.isNotEmpty((String)typeId) && BeanUtils.isNotEmpty((Object)(sysType = this.systemConfigFeignService.getSysTypeById(typeId)))) {
                form.setTypeId(sysType.get("id").asText());
                form.setTypeName(sysType.get("name").asText());
            }
            FormMeta oldFormDef = this.formMetaManager.getByKey(formDef.getKey());
            HashMap<String, BoDef> boDefMap = new HashMap<String, BoDef>();
            ObjectNode expand = (ObjectNode)JsonUtil.toJsonNode((String)formDef.getExpand());
            ArrayNode boDefList = JsonUtil.getMapper().createArrayNode();
            for (BoDef boDef : importBoDef) {
                if (!boCodesSet.contains(boDef.getAlias())) continue;
                boDefMap.put(boDef.getAlias(), boDef);
                boDefJson = JsonUtil.getMapper().createObjectNode();
                boDefJson.put("id", boDef.getId());
                boDefJson.put("alias", boDef.getAlias());
                boDefJson.put("desc", boDef.getDescription());
                boDefList.add((JsonNode)boDefJson);
            }
            expand.set("boDefList", (JsonNode)boDefList);
            if (BeanUtils.isNotEmpty(importBoDef)) {
                this.updateEntId(importBoDef, expand);
            }
            formDef.setExpand(expand.toString());
            if (oldFormDef != null) {
                formDef.setId(oldFormDef.getId());
                this.formMetaManager.updateByImport(formDef, entIdMap);
                ThreadMsgUtil.addMapMsg2((String)"formDefsUpdated", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s [%s]</div>", formDef.getName() + "", formDef.getKey() + ""));
            } else {
                formDef.setId(UniqueIdUtil.getSuid());
                this.formMetaManager.createByImport(formDef, entIdMap);
                ThreadMsgUtil.addMapMsg2((String)"formDefsAdded", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s [%s]</div>", formDef.getName() + "", formDef.getKey() + ""));
            }
            this.formMetaManager.deleteBpmFormBo(formDef.getId());
            for (JsonNode obj : boDefList) {
                boDefJson = obj;
                this.formMetaManager.createBpmFormBo(UniqueIdUtil.getSuid(), boDefJson.get("id").asText() + "", formDef.getId());
            }
            Form oldForm = this.getMainByFormKey(form.getFormKey());
            form.setDefId(formDef.getId());
            form.setStatus("deploy");
            form.setExpand(formDef.getExpand());
            if (oldForm != null) {
                form.setId(oldForm.getId());
                if ("deploy".equals(oldForm.getStatus())) {
                    this.createNewVersionForm(form);
                    ThreadMsgUtil.addMapMsg2((String)"formsUpdatedReleased", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s [%s]</div>", form.getName() + "", form.getFormKey() + ""));
                } else if ("draft".equals(oldForm.getStatus())) {
                    this.createNewDraftForm(form);
                    ThreadMsgUtil.addMapMsg2((String)"formsUpdated", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s [%s]</div>", form.getName() + "", form.getFormKey() + ""));
                }
            } else {
                form.setId(UniqueIdUtil.getSuid());
                if (StringUtil.isEmpty((String)typeId)) {
                    ObjectNode sysType2 = this.systemConfigFeignService.getSysTypeById(formDef.getTypeId());
                    if (BeanUtils.isEmpty((Object)sysType2)) {
                        sysType2 = this.systemConfigFeignService.getSysTypeByType("FORM_TYPE", "default");
                    }
                    if (BeanUtils.isNotEmpty((Object)sysType2)) {
                        form.setTypeId(sysType2.get("id").asText());
                        form.setTypeName(sysType2.get("name").asText());
                    }
                }
                form.setVersion(1);
                form.setIsMain('Y');
                form.setUpdateTime(LocalDateTime.now());
                this.create((Model)form);
                ThreadMsgUtil.addMapMsg2((String)"formsAddedPublished", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s [%s]</div>", form.getName() + "", form.getFormKey() + ""));
            }
            if (!BeanUtils.isEmpty(fields = this.formFieldManager.getByFormId(formDef.getId()))) continue;
            this.formMetaManager.createFields(formDef, entIdMap);
        }
    }

    private Map<String, String> getEntIdMap(List<BoDef> importBoDef, Map<String, String> nameMap) {
        HashMap<String, String> entIdMap = new HashMap<String, String>();
        if (BeanUtils.isNotEmpty(importBoDef)) {
            for (BoDef def : importBoDef) {
                if (!BeanUtils.isNotEmpty((Object)def.getBoEnt())) continue;
                BoEnt ent = def.getBoEnt();
                if (BeanUtils.isNotEmpty((Object)ent.getBoAttrList())) {
                    if (BeanUtils.isNotEmpty(nameMap)) {
                        entIdMap.put(nameMap.get(ent.getName()), ent.getId());
                    } else {
                        entIdMap.put(ent.getName(), ((BoAttribute)ent.getBoAttrList().get(0)).getEntId());
                    }
                }
                if (!BeanUtils.isNotEmpty((Object)ent.getChildEntList())) continue;
                List subEnts = ent.getChildEntList();
                for (BoEnt subEnt : subEnts) {
                    if (BeanUtils.isNotEmpty((Object)subEnt.getBoAttrList())) {
                        if (BeanUtils.isNotEmpty(nameMap)) {
                            entIdMap.put(nameMap.get(subEnt.getName()), subEnt.getId());
                        } else {
                            entIdMap.put(subEnt.getName(), ((BoAttribute)subEnt.getBoAttrList().get(0)).getEntId());
                        }
                    }
                    if (!BeanUtils.isNotEmpty((Object)subEnt.getChildEntList())) continue;
                    List sunEnts = subEnt.getChildEntList();
                    for (BoEnt sunEnt : sunEnts) {
                        if (!BeanUtils.isNotEmpty((Object)sunEnt.getBoAttrList()) || !BeanUtils.isNotEmpty((Object)subEnt.getBoAttrList())) continue;
                        if (BeanUtils.isNotEmpty(nameMap)) {
                            entIdMap.put(nameMap.get(sunEnt.getName()), sunEnt.getId());
                            continue;
                        }
                        entIdMap.put(sunEnt.getName(), ((BoAttribute)sunEnt.getBoAttrList().get(0)).getEntId());
                    }
                }
            }
        }
        return entIdMap;
    }

    private void updateEntId(List<BoDef> importBoDef, ObjectNode expand) {
        HashMap<String, BoEnt> boEntMap = new HashMap<String, BoEnt>();
        for (BoDef boDef : importBoDef) {
            boEntMap.put(boDef.getAlias(), boDef.getBoEnt());
        }
        JsonNode list = expand.get("list");
        for (JsonNode jsonNode : list) {
            JsonNode jsonNode2 = jsonNode.get("boDefAlias");
            if (BeanUtils.isEmpty((Object)jsonNode2)) continue;
            String boDefAlias = jsonNode2.asText();
            ObjectNode objectNode = (ObjectNode)jsonNode;
            objectNode.put("entId", ((BoEnt)boEntMap.get(boDefAlias)).getId());
        }
    }

    @Override
    public Map<String, String> exportForms(List<String> idList, boolean containBo) {
        BoDefXml bodefXml = new BoDefXml();
        FormImportXml formImport = new FormImportXml();
        HashMap<String, String> map = new HashMap<String, String>();
        for (String formId : idList) {
            FormXml formXml = new FormXml();
            Form form = this.get((Serializable)((Object)formId));
            FormMeta formDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)form.getDefId()));
            List<String> boCodes = this.formMetaManager.getBOCodeByFormId(form.getDefId());
            formXml.setBpmForm(form);
            formXml.setBpmFormDef(formDef);
            formXml.setBoCodes(boCodes);
            if (containBo) {
                List<String> boIds = this.formMetaManager.getBODefIdByFormId(form.getDefId());
                for (String boId : boIds) {
                    BoDef bodef = this.boDefService.getByDefId(boId);
                    bodefXml.addBodef(bodef);
                }
            }
            formImport.addFormXml(formXml);
        }
        try {
            map.put("form.xml", JAXBUtil.marshall((Object)formImport, FormImportXml.class));
            if (containBo) {
                map.put("bo.xml", JAXBUtil.marshall((Object)bodefXml, BoDefXml.class));
            }
        }
        catch (JAXBException e) {
            throw new RuntimeException("\u5bfc\u51fa\u8868\u5355\u5931\u8d25" + e.getMessage(), e);
        }
        return map;
    }

    @Override
    public String genByField(String defId, String attrId, String formType) {
        FormMeta def = (FormMeta)this.formMetaManager.get((Serializable)((Object)defId));
        String html = "";
        if (def != null) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            if (def.getExpand() != null) {
                try {
                    JsonNode expand = JsonUtil.toJsonNode((String)def.getExpand());
                    JsonNode tables = expand.get("fields");
                    ObjectNode field = JsonUtil.getMapper().createObjectNode();
                    Boolean isSub = false;
                    for (JsonNode table : tables) {
                        JsonNode fields = table.get("children");
                        for (int i = 0; i < fields.size(); ++i) {
                            JsonNode f = fields.get(i);
                            if (!f.get("boAttrId").equals((Object)attrId)) continue;
                            field = f;
                            isSub = !table.get("type").equals((Object)"main");
                        }
                    }
                    map.put("isSub", isSub);
                    map.put("field", (Boolean)field);
                }
                catch (IOException e) {
                    throw new BaseException(e.getMessage(), (Throwable)e);
                }
            }
            String macroTemplate = this.formTemplateManager.getByTemplateAlias("mobile".equals(formType) ? "mobileFieldMacro" : "fieldControl").getHtml();
            String template = "<@input field=field isSub=isSub/>" + macroTemplate;
            try {
                html = this.freemarkEngine.parseByTempName(template, map);
            }
            catch (Exception e) {
                throw new BaseException(e.getMessage(), (Throwable)e);
            }
        }
        return html;
    }

    @Transactional
    public void update(Form bpmForm) {
        super.update((Model)bpmForm);
        this.removeFromCache(bpmForm.getFormKey());
    }

    @Transactional
    public void remove(Serializable id) {
        Form bpmForm = this.get(id);
        this.removeFromCache(bpmForm.getFormKey());
        super.remove(id);
    }

    @Override
    @Transactional
    public void remove(String[] aryIds) {
        for (String id : aryIds) {
            Form bpmForm = this.get((Serializable)((Object)id));
            if (!BeanUtils.isNotEmpty((Object)((Object)bpmForm))) continue;
            String formKey = bpmForm.getFormKey();
            if ("Y".equals(String.valueOf(bpmForm.getIsMain()))) {
                List<Form> list = ((FormDao)this.baseMapper).getByFormKey(formKey);
                for (Form bpmform : list) {
                    this.remove((Serializable)((Object)bpmform.getId()));
                }
                this.dataTemplateManager.removeByFormKey(formKey);
            } else {
                this.remove((Serializable)((Object)id));
            }
            String fromDefId = bpmForm.getDefId();
            this.formMetaManager.remove((Serializable)((Object)fromDefId));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("FORM_ID_", fromDefId);
            this.formFieldManager.removeByMap(map);
            this.formMetaManager.deleteBpmFormBo(fromDefId);
            this.removeFromCache(bpmForm.getFormKey());
        }
    }

    @Override
    @Transactional
    public CommonResult<String> saveFormJs(String formId, String divJs, String formHtml, String formExpand) {
        Form form = this.get((Serializable)((Object)formId));
        if (BeanUtils.isNotEmpty((Object)((Object)form))) {
            form.setDiyJs(divJs);
            form.setFormHtml(formHtml);
            this.update(form);
            FormHistoryRecord entity = new FormHistoryRecord();
            entity.setId(UniqueIdUtil.getSuid());
            entity.setFormId(formId);
            entity.setFormHtml(formHtml);
            entity.setFormExpand(formExpand);
            this.formHistoryRecordManager.create((Model)entity);
            this.removeFromCache(form.getFormKey());
            return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
        }
        return new CommonResult(false, "\u8bf7\u5148\u4fdd\u5b58\u8868\u5355\u5185\u5bb9\u518d\u6dfb\u52a0\u81ea\u5b9a\u4e49\u811a\u672c");
    }

    @Override
    @Transactional
    public CommonResult<String> updateFormHistoryRecord(String formId, String formHtml, String formExpand) {
        Form form = this.get((Serializable)((Object)formId));
        if (BeanUtils.isNotEmpty((Object)((Object)form))) {
            form.setFormHtml(formHtml);
            form.setExpand(formExpand);
            this.update(form);
            FormMeta formDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)form.getDefId()));
            formDef.setExpand(formExpand);
            this.formMetaManager.update((Model)formDef);
            this.removeFromCache(form.getFormKey());
            return new CommonResult(true, "\u6062\u590d\u6210\u529f");
        }
        return new CommonResult(false, "\u8bf7\u5148\u4fdd\u5b58\u8868\u5355\u5185\u5bb9");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional
    public void saveDesign(String formData) throws Exception {
        JsonNode bpmFormdefNode;
        Form form = new Form();
        FormMeta bpmFormdef = new FormMeta();
        JsonNode paramNode = JsonUtil.toJsonNode((String)formData);
        JsonNode formJson = paramNode.get("form");
        JsonNode expandJson = paramNode.get("expand");
        String expand = JsonUtil.toJson((Object)expandJson);
        String ganged = paramNode.get("ganged").asText();
        String opinion = paramNode.get("opinion").asText();
        String rev = paramNode.get("rev").asText();
        String formId = formJson.get("formId").asText();
        String newType = formJson.get("newType").asText();
        if (StringUtil.isNotEmpty((String)formId)) {
            form = this.get((Serializable)((Object)formId));
            bpmFormdef = (FormMeta)this.formMetaManager.get((Serializable)((Object)form.getDefId()));
            bpmFormdefNode = paramNode.get("formDef");
            bpmFormdef.setMacroAlias(bpmFormdefNode.get("macroAlias").asText());
            bpmFormdef.setMainAlias(bpmFormdefNode.get("mainAlias").asText());
            bpmFormdef.setSubEntity(bpmFormdefNode.get("subEntity").asText());
        } else {
            bpmFormdefNode = paramNode.get("formDef");
            bpmFormdef.setType(bpmFormdefNode.get("type").asText());
            bpmFormdef.setTypeId(bpmFormdefNode.get("typeId").asText());
            bpmFormdef.setName(bpmFormdefNode.get("name").asText());
            bpmFormdef.setKey(bpmFormdefNode.get("key").asText());
            bpmFormdef.setDesc(bpmFormdefNode.get("desc").asText());
            bpmFormdef.setMacroAlias(bpmFormdefNode.get("macroAlias").asText());
            bpmFormdef.setMainAlias(bpmFormdefNode.get("mainAlias").asText());
            bpmFormdef.setSubEntity(bpmFormdefNode.get("subEntity").asText());
            String formKey = bpmFormdef.getKey();
            if (this.formMetaManager.getByKey(formKey) != null) {
                throw new RuntimeException("\u8868\u5355\u5df2\u7ecf\u5b58\u5728\uff01key:" + formKey);
            }
            form.setName(formJson.get("name").asText());
            form.setFormKey(formJson.get("formKey").asText());
            form.setTypeId(bpmFormdef.getTypeId());
            form.setTypeName(bpmFormdef.getType());
            form.setFormType(formJson.get("formType").asText());
        }
        bpmFormdef.setGanged(ganged);
        bpmFormdef.setExpand(expand);
        if (BeanUtils.isNotEmpty((Object)bpmFormdef.getId())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", bpmFormdef.getId());
            map.put("rev", rev);
            FormMeta bpmFormDef1 = this.formMetaManager.getFormDefByRev(map);
            if (!BeanUtils.isNotEmpty((Object)((Object)bpmFormDef1))) throw new RuntimeException("\u6b64\u8868\u5355\u4e0d\u662f\u6700\u65b0\u7248\u672c\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u518d\u4fee\u6539");
            this.formMetaManager.update((Model)bpmFormdef);
        } else {
            bpmFormdef.setId(UniqueIdUtil.getSuid());
            this.formMetaManager.create((Model)bpmFormdef);
        }
        this.formMetaManager.updateOpinionConf(bpmFormdef.getId(), opinion);
        String formHtml = "";
        String formI18nName = expandJson.has("designFormName") ? expandJson.get("designFormName").asText() : form.getName();
        formHtml = FormType.MOBILE.value().equals(form.getFormType()) ? this.getMobileDesignHtml(expandJson, formI18nName, ganged) : this.getDesignHtml(expandJson, formI18nName, ganged, JsonUtil.toJsonNode((Object)((Object)bpmFormdef)));
        form.setFormHtml(formHtml);
        if (StringUtil.isEmpty((String)form.getId())) {
            form.setDefId(bpmFormdef.getId());
            List<Form> bpmForm = this.getByFormKey(form.getFormKey());
            if (BeanUtils.isNotEmpty(bpmForm)) {
                throw new RuntimeException("KEY\u3010" + form.getFormKey() + "\u3011\u5bf9\u5e94\u7684\u8868\u5355\u5df2\u5b58\u5728");
            }
            form.setId(UniqueIdUtil.getSuid());
            this.create((Model)form);
        } else if (newType.equals("new")) {
            Integer rtn = ((FormDao)this.baseMapper).getMaxVersionByFormKey(form.getFormKey());
            String newFormId = UniqueIdUtil.getSuid();
            Form newBpmForm = form;
            newBpmForm.setId(newFormId);
            newBpmForm.setIsMain('N');
            newBpmForm.setStatus("draft");
            newBpmForm.setVersion(rtn + 1);
            this.create((Model)newBpmForm);
            this.publish(newFormId);
            this.setDefaultVersion(newFormId, newBpmForm.getFormKey());
        } else {
            form.setName(formJson.get("name").asText());
            this.update(form);
        }
        FormHistory bpmFormDefHi = new FormHistory(form);
        this.formHistoryManager.create((Model)bpmFormDefHi);
    }

    private void updatePermissionm(String asText) throws IOException {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("FORM_KEY_", (Object)asText, QueryOP.EQUAL);
        List queryNoPage = this.bpmFormRightManager.queryNoPage(queryFilter);
        JsonNode Default = this.bpmFormRightManager.getDefaultByFormDefKey(asText, false);
        JsonNode instaPermissionm = this.bpmFormRightManager.getDefaultByFormDefKey(asText, false);
        for (FormRight formRight : queryNoPage) {
            String json;
            String permission = formRight.getPermission();
            JsonNode oldPermission = JsonUtil.toJsonNode((String)permission);
            JsonNode oldTable = oldPermission.get("table");
            JsonNode newPermission = null;
            newPermission = formRight.getPermissionType() == 1 ? JsonUtil.toJsonNode((String)JsonUtil.toJson((Object)Default)) : JsonUtil.toJsonNode((String)JsonUtil.toJson((Object)instaPermissionm));
            JsonNode newTable = newPermission.get("table");
            Iterator fieldNames = newTable.fieldNames();
            while (fieldNames.hasNext()) {
                ObjectNode newField;
                String FieldsKey;
                Iterator newFieldsKey;
                String key = (String)fieldNames.next();
                if (!BeanUtils.isNotEmpty((Object)oldTable.get(key))) continue;
                JsonNode oldFields = oldTable.get(key).get("fields");
                JsonNode newFields = newTable.get(key).get("fields");
                if (BeanUtils.isEmpty((Object)newFields)) continue;
                JsonNode oldRights = oldTable.get(key).get("rights");
                JsonNode newRights = newTable.get(key).get("rights");
                if (BeanUtils.isNotEmpty((Object)oldRights)) {
                    newFieldsKey = newRights.fieldNames();
                    while (newFieldsKey.hasNext()) {
                        FieldsKey = (String)newFieldsKey.next();
                        if (!BeanUtils.isNotEmpty((Object)oldRights.get(FieldsKey))) continue;
                        newField = (ObjectNode)newRights;
                        newField.set(FieldsKey, oldRights.get(FieldsKey));
                    }
                }
                newFieldsKey = newFields.fieldNames();
                while (newFieldsKey.hasNext()) {
                    FieldsKey = (String)newFieldsKey.next();
                    if (!BeanUtils.isNotEmpty((Object)oldFields.get(FieldsKey))) continue;
                    newField = (ObjectNode)newFields;
                    newField.set(FieldsKey, oldFields.get(FieldsKey));
                }
                Iterator fields = oldTable.fields();
                while (fields.hasNext()) {
                    Map.Entry node = (Map.Entry)fields.next();
                    JsonNode value = (JsonNode)node.getValue();
                    if (!BeanUtils.isNotEmpty((Object)value) || !value.isObject() || !BeanUtils.isNotEmpty((Object)value.get("ctrlType")) || !"dataView".equals(value.get("ctrlType").asText()) || !newTable.has((String)node.getKey())) continue;
                    ObjectNode newTableNode = (ObjectNode)newTable;
                    newTableNode.set((String)node.getKey(), value);
                }
            }
            if (oldPermission.has("subRowAuth")) {
                ObjectNode newPermissionObj = (ObjectNode)newPermission;
                newPermissionObj.put("subRowAuth", oldPermission.get("subRowAuth"));
            }
            if ((json = JsonUtil.toJson((Object)newPermission)).equals(formRight.getPermission())) continue;
            formRight.setPermission(json);
            this.bpmFormRightManager.update((Model)formRight);
        }
    }

    @Override
    @Transactional
    public void saveFormDef(BpmFormVo bpmFormVo) throws Exception {
        FormMeta bpmFormdef = bpmFormVo.getBpmFormDef();
        Form form = bpmFormVo.getBpmForm();
        form.setExpand(bpmFormdef.getExpand());
        if (StringUtil.isEmpty((String)bpmFormdef.getId())) {
            this.formMetaManager.create((Model)bpmFormdef);
            form.setDefId(bpmFormdef.getId());
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", bpmFormdef.getId());
            map.put("rev", bpmFormdef.getRev());
            FormMeta bpmFormDef1 = this.formMetaManager.getFormDefByRev(map);
            if (BeanUtils.isEmpty((Object)((Object)bpmFormDef1))) {
                throw new BaseException("\u6b64\u8868\u5355\u4e0d\u662f\u6700\u65b0\u7248\u672c\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u518d\u4fee\u6539");
            }
            this.formMetaManager.update((Model)bpmFormdef);
        }
        this.genFromHtml(bpmFormVo);
        Form oldBpmForm = null;
        if (StringUtil.isNotEmpty((String)form.getId())) {
            oldBpmForm = (Form)((Object)((FormDao)this.baseMapper).selectById((Serializable)((Object)form.getId())));
        }
        if (StringUtil.isEmpty((String)form.getId())) {
            form.setStatus("draft");
            form.setUpdateTime(DateUtil.getCurrentDate());
            this.create((Model)form);
        } else if ("newForm".equals(bpmFormVo.getNewForm())) {
            if ("draft".equals(form.getStatus())) {
                this.publish(form.getId());
            }
            Integer rtn = ((FormDao)this.baseMapper).getMaxVersionByFormKey(form.getFormKey());
            String newFormId = UniqueIdUtil.getSuid();
            this.setDefaultVersion(newFormId, form.getFormKey());
            Form newBpmForm = form;
            if (StringUtil.isNotEmpty((String)oldBpmForm.getDiyJs())) {
                newBpmForm.setDiyJs(oldBpmForm.getDiyJs());
            }
            newBpmForm.setId(newFormId);
            newBpmForm.setIsMain('Y');
            newBpmForm.setVersion(rtn + 1);
            newBpmForm.setUpdateTime(DateUtil.getCurrentDate());
            newBpmForm.setStatus("deploy");
            this.create((Model)newBpmForm);
        } else {
            if (BeanUtils.isNotEmpty((Object)((Object)oldBpmForm))) {
                form.setDiyJs(oldBpmForm.getDiyJs());
            }
            this.update(form);
        }
        if (BeanUtils.isNotEmpty((Object)((Object)oldBpmForm))) {
            FormHistoryRecord formHistoryRecord = new FormHistoryRecord(oldBpmForm);
            this.formHistoryRecordManager.create((Model)formHistoryRecord);
        }
        this.updatePermissionm(bpmFormVo.getBpmForm().getFormKey());
    }

    @Override
    @Transactional
    public void generateFrom(BpmFormVo bpmFormVo) throws Exception {
        this.genFromHtml(bpmFormVo);
        this.formMetaManager.update((Model)bpmFormVo.getBpmFormDef());
        this.update(bpmFormVo.getBpmForm());
        FormHistory bpmFormDefHi = new FormHistory(bpmFormVo.getBpmForm());
        this.formHistoryManager.create((Model)bpmFormDefHi);
    }

    private String genFromHtml(BpmFormVo bpmFormVo) throws Exception {
        FormMeta bpmFormDef = bpmFormVo.getBpmFormDef();
        String expand = bpmFormDef.getExpand();
        JsonNode expandJsonNode = JsonUtil.toJsonNode((String)expand);
        JsonNode field = expandJsonNode.get("list");
        ArrayList layoutList = new ArrayList();
        field.forEach(obj -> {
            try {
                layoutList.add(JsonUtil.toMap((String)JsonUtil.toJson((Object)obj)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        FreeMakerUtil freeMakerUtil = new FreeMakerUtil();
        HashMap<String, Object> mapObj = new HashMap<String, Object>();
        mapObj.put("layoutList", layoutList);
        mapObj.put("expandMap", JsonUtil.toMap((String)expand));
        mapObj.put("util", freeMakerUtil);
        if (BeanUtils.isNotEmpty((Object)bpmFormVo.getBpmForm().getFormSetting())) {
            mapObj.put("formSetting", JsonUtil.toJsonNode((String)bpmFormVo.getBpmForm().getFormSetting()));
        }
        FormTemplate fieldControl = this.formTemplateManager.getByTemplateAlias("fieldControl");
        List<FormTemplate> bpmFormTpls = this.formTemplateManager.getTemplateType("formDesign");
        StringBuffer formDesignFtl = new StringBuffer(fieldControl.getHtml());
        for (FormTemplate bpmFormTemplate : bpmFormTpls) {
            formDesignFtl.append(bpmFormTemplate.getHtml());
        }
        String html = this.freemarkEngine.parseByTemplate(formDesignFtl.toString(), mapObj);
        bpmFormVo.getBpmForm().setFormHtml(html);
        return html;
    }

    @Override
    @Transactional
    public void pcForm2MobileForm(String formId) throws Exception {
        Form bpmForm = this.get((Serializable)((Object)formId));
        FormMeta bpmFormDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)bpmForm.getDefId()));
        Form mainByFormKey = ((FormDao)this.baseMapper).getMainByFormKey(bpmForm.getFormKey() + "mobile");
        if (BeanUtils.isNotEmpty((Object)((Object)mainByFormKey))) {
            throw new BaseException(String.format("\u5df2\u7ecf\u751f\u6210\u8868\u5355key\u4e3a\u3010%s\u3011\u7684\u8868\u5355", mainByFormKey.getFormKey()));
        }
        BpmFormVo bpmFormVo = new BpmFormVo();
        bpmForm.setId("");
        bpmForm.setFormKey(bpmForm.getFormKey() + "mobile");
        bpmForm.setFormType("mobile");
        bpmFormDef.setId("");
        bpmFormDef.setKey(bpmFormDef.getKey() + "mobile");
        bpmFormDef.setExpand(this.transformationMobileExpand(bpmFormDef.getExpand()));
        bpmFormVo.setBpmForm(bpmForm);
        bpmFormVo.setBpmFormDef(bpmFormDef);
        this.saveFormDef(bpmFormVo);
    }

    @Override
    public Map<String, Object> getBindRelation(String defId, String formKey) throws Exception {
        List<Map<String, Object>> boEnt = ((FormDao)this.baseMapper).getBoEnt(defId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        List bpmData = this.boDefManager.getBpmDefinitionData(boEnt.get(0).get("alias_").toString());
        HashMap<String, BoBpmShipGroup> shipMap = new HashMap<String, BoBpmShipGroup>();
        for (Map bpmDatum : bpmData) {
            JsonNode pcForm;
            String curDefId = (String)bpmDatum.get("def_id_");
            Map definitionData = this.workflowFeignService.definitionData(curDefId);
            if (definitionData.size() <= 0) continue;
            if (definitionData.containsKey("pcForm")) {
                pcForm = JsonUtil.toJsonNode(definitionData.get("pcForm"));
                if (!pcForm.get("pcAlias").asText().equals(formKey)) continue;
                this.buildBoBpmShipGroup(definitionData, shipMap, curDefId);
                continue;
            }
            if (!definitionData.containsKey("mobileForm") || !(pcForm = JsonUtil.toJsonNode(definitionData.get("mobileForm"))).get("mobileAlias").asText().equals(formKey)) continue;
            this.buildBoBpmShipGroup(definitionData, shipMap, curDefId);
        }
        map.put("bpmData", shipMap.values());
        map.put("entData", boEnt);
        return map;
    }

    private void buildBoBpmShipGroup(Map<String, Object> definitionData, Map<String, BoBpmShipGroup> shipMap, String curDefId) {
        String defKey = MapUtil.getString(definitionData, (String)"defKey");
        String mainDefId = MapUtil.getString(definitionData, (String)"mainDefId");
        String flowName = MapUtil.getString(definitionData, (String)"defName");
        String version = MapUtil.getString(definitionData, (String)"version");
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)defKey), (String)"\u67e5\u8be2\u7ed1\u5b9a\u5173\u7cfb\u65f6\u83b7\u53d6\u4e0d\u5230defKey");
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)mainDefId), (String)"\u67e5\u8be2\u7ed1\u5b9a\u5173\u7cfb\u65f6\u83b7\u53d6\u4e0d\u5230\u6d41\u7a0b\u4e3b\u7248\u672c");
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)flowName), (String)"\u67e5\u8be2\u7ed1\u5b9a\u5173\u7cfb\u65f6\u83b7\u53d6\u4e0d\u5230\u6d41\u7a0b\u540d\u79f0");
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)version), (String)"\u67e5\u8be2\u7ed1\u5b9a\u5173\u7cfb\u65f6\u83b7\u53d6\u4e0d\u5230\u6d41\u7a0b\u7248\u672c\u53f7");
        BoBpmShipGroup shipGroup = null;
        if (!shipMap.containsKey(defKey)) {
            shipGroup = BoBpmShipGroup.build((String)defKey, (String)flowName);
            shipMap.put(defKey, shipGroup);
        }
        shipGroup = shipMap.get(defKey);
        shipGroup.addShip(curDefId, version, curDefId.equals(mainDefId));
    }

    @Override
    public Map<String, Object> getFormData(String pcAlias, String mobileAlias) throws Exception {
        List<Map<String, Object>> boEnt;
        QueryWrapper eq;
        QueryWrapper queryWrapper = new QueryWrapper();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtil.isNotEmpty((String)pcAlias)) {
            eq = (QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"form_key_", (Object)pcAlias)).eq((Object)"form_type_", (Object)"pc")).eq((Object)"is_main_", (Object)"Y");
            List pcForms = ((FormDao)this.baseMapper).selectList((Wrapper)eq);
            boEnt = ((FormDao)this.baseMapper).getBoEnt(((Form)((Object)pcForms.get(0))).getDefId());
            map.put("pcEnt", boEnt.get(0));
        }
        if (StringUtil.isNotEmpty((String)mobileAlias)) {
            eq = (QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"form_key_", (Object)mobileAlias)).eq((Object)"form_type_", (Object)"mobile")).eq((Object)"is_main_", (Object)"Y");
            List mobileForms = ((FormDao)this.baseMapper).selectList((Wrapper)eq);
            boEnt = ((FormDao)this.baseMapper).getBoEnt(((Form)((Object)mobileForms.get(0))).getDefId());
            map.put("mobileEnt", boEnt.get(0));
        }
        return map;
    }

    @Override
    public Map<String, Object> getPreviewDesignVueData(String formId) throws Exception {
        Form bpmForm = this.get((Serializable)((Object)formId));
        FormMeta formDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)bpmForm.getDefId()));
        JsonNode jsonNode = JsonUtil.toJsonNode((String)formDef.getExpand());
        String bos = "";
        if (BeanUtils.isNotEmpty((Object)jsonNode)) {
            bos = JsonUtil.toJson((Object)jsonNode.get("boDefList"));
        }
        ArrayList<String> boCode = new ArrayList<String>();
        ArrayNode bosArray = (ArrayNode)JsonUtil.toBean((String)bos, ArrayNode.class);
        for (int i = 0; i < bosArray.size(); ++i) {
            JsonNode obj = bosArray.get(i);
            BoDef boDef = (BoDef)this.bODefManager.get((Serializable)((Object)obj.get("id").asText()));
            if (!BeanUtils.isNotEmpty((Object)boDef)) continue;
            boCode.add(boDef.getAlias());
        }
        List<BoData> boJson = this.formService.getBoDataByBoKeys(boCode);
        ObjectNode object = BoUtil.hanlerData(boJson);
        JsonNode permissionConf = this.bpmFormRightManager.getByFormKey(bpmForm.getFormKey(), false);
        JsonNode permission = this.bpmFormRightManager.calcFormPermission(permissionConf);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("bpmForm", (Object)bpmForm);
        resultMap.put("permission", permission);
        resultMap.put("data", object);
        return resultMap;
    }

    @Override
    public Map<String, Object> getPreviewDesignData(FormPreviewDataParam param) throws Exception {
        ObjectNode expand = JsonUtil.getMapper().createObjectNode();
        String expandStr = "";
        Form bpmForm = new Form();
        String id = param.getId();
        String design = param.getDesign();
        ArrayNode bosArray = null;
        String formDefId = "";
        if (StringUtil.isNotEmpty((String)id) && StringUtil.isEmpty((String)design)) {
            FormMeta formDef;
            bpmForm = this.get((Serializable)((Object)id));
            if (BeanUtils.isNotEmpty((Object)((Object)bpmForm)) && BeanUtils.isNotEmpty((Object)((Object)(formDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)bpmForm.getDefId())))))) {
                formDefId = formDef.getId();
                expandStr = formDef.getExpand();
                expand = (ObjectNode)JsonUtil.toBean((String)expandStr, ObjectNode.class);
            }
        } else {
            ObjectNode designJson = (ObjectNode)JsonUtil.toBean((String)design, ObjectNode.class);
            expand = (ObjectNode)designJson.get("expand");
            expandStr = JsonUtil.toJson((Object)expand);
            String ganged = JsonUtil.toJson((Object)designJson.get("ganged"));
            String tableNames = "";
            String form = param.getForm();
            JsonNode formDefNode = designJson.get("formDef");
            if (StringUtil.isNotEmpty((String)form)) {
                ObjectNode formNode = (ObjectNode)JsonUtil.toJsonNode((String)form);
                tableNames = formNode.get("name").asText();
            }
            String formHtml = "";
            formHtml = FormType.MOBILE.value().equals(param.getFormType()) ? this.getMobileDesignHtml((JsonNode)expand, tableNames, ganged) : this.getDesignHtml((JsonNode)expand, tableNames, ganged, formDefNode);
            if (StringUtil.isNotEmpty((String)formHtml)) {
                bpmForm.setFormHtml(formHtml);
            }
        }
        bosArray = (ArrayNode)expand.get("boDefList");
        JsonNode permissionConf = this.bpmFormRightManager.getDefaultByDesign(formDefId, expandStr, false);
        JsonNode permission = this.bpmFormRightManager.calcFormPermission(permissionConf);
        ArrayList<String> boCode = new ArrayList<String>();
        for (int i = 0; i < bosArray.size(); ++i) {
            JsonNode obj = bosArray.get(i);
            BoDef boDef = (BoDef)this.bODefManager.get((Serializable)((Object)obj.get("id").asText()));
            if (!BeanUtils.isNotEmpty((Object)boDef)) continue;
            boCode.add(boDef.getAlias());
        }
        List<BoData> boJson = this.formService.getBoDataByBoKeys(boCode);
        ObjectNode object = BoUtil.hanlerData(boJson);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("bpmForm", (Object)bpmForm);
        resultMap.put("permission", permission);
        resultMap.put("data", object);
        return resultMap;
    }

    @Override
    public JsonNode getRightData(String id, String defId, String formType) throws Exception {
        Form bpmForm = new Form();
        if (StringUtil.isNotEmpty((String)id)) {
            bpmForm = this.get((Serializable)((Object)id));
            formType = bpmForm.getFormType();
        }
        if (StringUtil.isNotEmpty((String)bpmForm.getDefId())) {
            defId = bpmForm.getDefId();
        }
        FormMeta formDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)defId));
        JsonNode permissionConf = null;
        permissionConf = StringUtil.isNotEmpty((String)bpmForm.getFormKey()) ? this.bpmFormRightManager.getByFormKey(bpmForm.getFormKey(), false) : this.bpmFormRightManager.getDefaultByFormDefKey(formDef.getKey(), false);
        JsonNode permission = this.bpmFormRightManager.calcFormPermission(permissionConf);
        return permission;
    }

    @Override
    public Map getChooseDesignTemplate(String subject, String categoryId, String formDesc, Boolean isSimple) throws Exception {
        HashMap<String, Object> mv = new HashMap<String, Object>();
        String templatePath = FormUtil.getDesignTemplatePath();
        String xml = FileUtil.readFile((String)(templatePath + "designtemps.xml"));
        Document document = Dom4jUtil.loadXml((String)xml);
        Element root = document.getRootElement();
        List list = root.elements();
        String reStr = "[";
        for (Element element : list) {
            String alias = element.attributeValue("alias");
            String name = element.attributeValue("name");
            String templateDesc = element.attributeValue("templateDesc");
            if (!reStr.equals("[")) {
                reStr = reStr + ",";
            }
            reStr = reStr + "{name:'" + name + "',alias:'" + alias + "',templateDesc:'" + templateDesc + "'}";
        }
        reStr = reStr + "]";
        mv.put("subject", subject);
        mv.put("categoryId", categoryId);
        mv.put("formDesc", formDesc);
        mv.put("temps", reStr);
        mv.put("isSimple", isSimple);
        return mv;
    }

    @Override
    public void getGenByTemplate(String formId, String tableNames, String templateAlias, String formDefId, String formType, HttpServletResponse response) throws Exception {
        Form form = this.get((Serializable)((Object)formId));
        if (form != null) {
            formDefId = form.getDefId();
        }
        String html = this.getHtml(formDefId, tableNames, templateAlias);
        PrintWriter out = response.getWriter();
        html = JsoupUtil.prettyHtml(html);
        StringBuffer outHtml = new StringBuffer();
        String script = "<script type='text/javascript'>function validForm(scope){ return true;}</script>";
        outHtml.append(script);
        if (StringUtil.isNotEmpty((String)formType) && formType.equals(FormType.MOBILE.value())) {
            outHtml.append("<div style=\"height: 100%;overflow: auto;\">");
            outHtml.append(html);
            outHtml.append("</div>");
        } else {
            outHtml.append(html);
        }
        out.println(outHtml);
    }

    @Override
    public ObjectNode getFormDesign(String formId) throws Exception {
        Form form = null;
        FormMeta formDef = null;
        ObjectNode resultJson = JsonUtil.getMapper().createObjectNode();
        if (StringUtil.isNotEmpty((String)formId)) {
            ObjectNode designJson = JsonUtil.getMapper().createObjectNode();
            form = this.get((Serializable)((Object)formId));
            if (BeanUtils.isNotEmpty((Object)((Object)form)) && BeanUtils.isNotEmpty((Object)((Object)(formDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)form.getDefId())))))) {
                resultJson.put("ganged", formDef.getGanged());
                resultJson.put("opinion", formDef.getOpinionConf());
                resultJson.put("defId", formDef.getId());
                resultJson.put("desc", formDef.getDesc());
                resultJson.put("name", formDef.getName());
                resultJson.put("rev", formDef.getRev());
                JsonNode jsonNode = JsonUtil.toJsonNode((String)formDef.getExpand());
                if (BeanUtils.isNotEmpty((Object)jsonNode)) {
                    resultJson.put("bos", JsonUtil.toJson((Object)jsonNode.get("boDefList")));
                    resultJson.put("fields", JsonUtil.toJson((Object)jsonNode.get("fields")));
                    resultJson.put("flowField", jsonNode.has("flowField") ? jsonNode.get("flowField").asText() : "");
                    resultJson.put("includeFiles", jsonNode.has("includeFiles") ? jsonNode.get("includeFiles").asText() : "");
                    resultJson.put("designFormName", jsonNode.has("designFormName") ? jsonNode.get("designFormName").asText() : "");
                    if (jsonNode.has("treeCtrl")) {
                        resultJson.set("treeCtrl", jsonNode.get("treeCtrl"));
                    }
                }
                designJson.put("type", formDef.getType());
            }
            ObjectNode formJson = JsonUtil.getMapper().createObjectNode();
            designJson.set("form", (JsonNode)formJson);
            resultJson.put("formName", form.getName());
            resultJson.put("formKey", form.getFormKey());
            resultJson.put("formType", form.getFormType());
            resultJson.put("version", form.getVersion());
            resultJson.put("status", form.getStatus());
            resultJson.put("typeId", form.getTypeId());
            resultJson.put("typeName", form.getTypeName());
            resultJson.put("desc", form.getDesc());
            resultJson.put("macroAlias", formDef.getMacroAlias());
            resultJson.put("mainAlias", formDef.getMainAlias());
            resultJson.put("subEntity", formDef.getSubEntity());
            resultJson.put("isPrint", form.getIsPrint());
            resultJson.set("design", (JsonNode)designJson);
            resultJson.put("formSetting", form.getFormSetting());
        }
        return resultJson;
    }

    private String transformationMobileExpand(String expandStr) throws Exception {
        if (!StringUtil.isEmpty((String)expandStr)) {
            JsonNode expand = JsonUtil.toJsonNode((String)expandStr);
            ArrayNode table = (ArrayNode)expand.findValue("list");
            ArrayNode tempArray = JsonUtil.getMapper().createArrayNode();
            for (JsonNode tableNode : table) {
                ArrayNode fields;
                ArrayNode columns;
                if (tableNode.has("ctrlType") && "grid".equals(tableNode.get("ctrlType").asText())) {
                    columns = (ArrayNode)tableNode.findValue("columns");
                    for (JsonNode column : columns) {
                        if (!column.has("list")) continue;
                        fields = (ArrayNode)column.findValue("list");
                        for (JsonNode jsonNode : fields) {
                            tempArray.add(jsonNode);
                        }
                    }
                    continue;
                }
                if (tableNode.has("ctrlType") && ("accordion".equals(tableNode.get("ctrlType").asText()) || "tab".equals(tableNode.get("ctrlType").asText()))) {
                    columns = (ArrayNode)tableNode.findValue("columns");
                    for (JsonNode column : columns) {
                        if (!column.has("list")) continue;
                        fields = (ArrayNode)column.findValue("list");
                        for (JsonNode jsonNode : fields) {
                            if ("grid".equals(jsonNode.get("ctrlType").asText())) {
                                ArrayNode gridColumns = (ArrayNode)jsonNode.findValue("columns");
                                for (JsonNode gridColumn : gridColumns) {
                                    if (!column.has("list")) continue;
                                    ArrayNode gridFields = (ArrayNode)gridColumn.findValue("list");
                                    for (JsonNode gridjsonNode : gridFields) {
                                        tempArray.add(gridjsonNode);
                                    }
                                }
                                continue;
                            }
                            tempArray.add(jsonNode);
                        }
                    }
                    continue;
                }
                tempArray.add(tableNode);
            }
            ObjectNode objectNode = (ObjectNode)expand;
            objectNode.set("list", (JsonNode)tempArray);
            return JsonUtil.toJson((Object)objectNode);
        }
        return "";
    }

    @Override
    public String getDesignHtml(JsonNode expand, String tableNames, String ganged, JsonNode formDefNode) throws Exception {
        ArrayList<Map<String, Object>> jary = new ArrayList<Map<String, Object>>();
        ArrayNode fieldList = (ArrayNode)expand.get("fields");
        for (JsonNode jsonNode : fieldList) {
            if (!"main".equals(jsonNode.get("type").asText())) continue;
            ArrayNode arr = (ArrayNode)jsonNode.get("children");
            for (JsonNode fieldNode : arr) {
                jary.add(JsonUtil.toMap((String)fieldNode.toString()));
            }
        }
        boolean hasStepControl = false;
        Map stepAttr = new HashMap();
        Iterator jaryIt = jary.iterator();
        while (jaryIt.hasNext()) {
            Map map = (Map)jaryIt.next();
            if ("textFixed".equals(map.get("ctrlType"))) {
                String desc = map.get("desc").toString();
                desc = desc.replaceAll("\"", "'");
                map.remove("desc");
                map.put("desc", desc);
            }
            if (!"stepControl".equals(map.get("ctrlType"))) continue;
            hasStepControl = true;
            stepAttr = map;
            jaryIt.remove();
        }
        String mainAlias = "";
        String macroAlias = "";
        String subEntity = "";
        mainAlias = formDefNode.get("mainAlias").asText().equals("null") ? "dragColumn" : formDefNode.get("mainAlias").asText();
        macroAlias = formDefNode.get("macroAlias").asText().equals("null") ? "fieldControl" : formDefNode.get("macroAlias").asText();
        subEntity = formDefNode.get("subEntity").asText().equals("null") ? "subDragColumn" : formDefNode.get("subEntity").asText();
        FormTemplate mainTemplateObj = this.formTemplateManager.getByTemplateAlias(mainAlias);
        String mainTemplate = mainTemplateObj.getHtml();
        String subTemplate = this.formTemplateManager.getByTemplateAlias(subEntity).getHtml();
        String macroTemplate = this.formTemplateManager.getByTemplateAlias(macroAlias).getHtml();
        String divContainer = this.formTemplateManager.getByTemplateAlias("divContainer").getHtml();
        FreeMakerUtil freeMakerUtil = new FreeMakerUtil();
        for (int i = 0; i < jary.size(); ++i) {
            if (!"iframe".equals(((Map)jary.get(i)).get("ctrlType"))) continue;
            String iframeSrc = ((Map)jary.get(i)).get("iframeSrc").toString();
            String baseUrl = this.systemConfigFeignService.getPropertyByAlias("iframeUrl");
            if (iframeSrc.indexOf("iframeUrl") != 1) {
                iframeSrc = iframeSrc.replace("${iframeUrl}", baseUrl);
            }
            ((Map)jary.get(i)).put("iframeSrc", iframeSrc);
        }
        if (this.isContainsTabs(jary)) {
            List<Map<String, Object>> tabs = this.getTabsHtml(jary);
            ArrayList<Map<Object, Object>> newTabs = new ArrayList<Map<Object, Object>>();
            boolean _hasStepControl = hasStepControl;
            for (Map<String, Object> tab : tabs) {
                List fields = (List)tab.get("fields");
                if (this.isContainsCollapse(fields)) {
                    ArrayList<Map<String, Object>> collapse = new ArrayList<Map<String, Object>>();
                    HashMap<String, Object> mapObj = new HashMap<String, Object>();
                    mapObj.put("formDesc", tableNames);
                    mapObj.put("ganged", ganged);
                    mapObj.put("expand", expand);
                    mapObj.put("expandMap", JsonUtil.toMap((String)expand.toString()));
                    mapObj.put("util", freeMakerUtil);
                    mapObj.put("mainTemplate", mainTemplate);
                    mapObj.put("subTemplate", subTemplate);
                    mapObj.put("macroTemplate", macroTemplate);
                    mapObj.put("divContainer", divContainer);
                    List<Map<String, Object>> newCollapse = this.getFields(this.getCollapseHtml(fields), mapObj);
                    for (Map<String, Object> field : newCollapse) {
                        if (!field.containsKey("tabHtml")) {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            map.put("formDesc", tableNames);
                            map.put("fieldList", field.get("fields"));
                            map.put("ganged", ganged);
                            map.put("includeFiles", BeanUtils.isNotEmpty((Object)expand.get("includeFiles")) ? expand.get("includeFiles").asText() : "");
                            map.put("util", freeMakerUtil);
                            map.put("isTabs", true);
                            map.put("hasStepControl", _hasStepControl);
                            map.put("stepAttr", stepAttr);
                            this.handlerTrGroup(map);
                            field.put("isCollapse", field.containsKey("collapseField"));
                            String tabHtml = this.freemarkEngine.parseByTemplate(mainTemplate + macroTemplate + subTemplate + divContainer, map);
                            field.put("tabHtml", tabHtml);
                        }
                        collapse.add(field);
                    }
                    _hasStepControl = hasStepControl;
                    if (collapse.size() <= 0) continue;
                    String tabsTemplate = this.formTemplateManager.getByTemplateAlias("collapseColumn").getHtml();
                    HashMap<String, Object> tabMap = new HashMap<String, Object>();
                    tabMap.put("util", freeMakerUtil);
                    tabMap.put("tabs", collapse);
                    tabMap.put("formDesc", tableNames);
                    String html = this.freemarkEngine.parseByTemplate(tabsTemplate, tabMap);
                    HashMap<String, Object> table = new HashMap<String, Object>();
                    table.put("tabHtml", html);
                    Map tabField = (Map)tab.get("tabField");
                    table.put("tabField", tabField);
                    newTabs.add(table);
                    continue;
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("formDesc", tableNames);
                map.put("fieldList", tab.get("fields"));
                map.put("ganged", ganged);
                map.put("includeFiles", BeanUtils.isNotEmpty((Object)expand.get("includeFiles")) ? expand.get("includeFiles").asText() : "");
                map.put("util", freeMakerUtil);
                map.put("isTabs", true);
                map.put("hasStepControl", _hasStepControl);
                map.put("stepAttr", stepAttr);
                this.handlerTrGroup(map);
                tab.put("isCollapse", tab.containsKey("collapseField"));
                String tabHtml = this.freemarkEngine.parseByTemplate(mainTemplate + macroTemplate + subTemplate + divContainer, map);
                tab.put("tabHtml", tabHtml);
                newTabs.add(tab);
            }
            String tabsTemplate = this.formTemplateManager.getByTemplateAlias("tabsColumn").getHtml();
            HashMap<String, Object> tabMap = new HashMap<String, Object>();
            tabMap.put("formDesc", tableNames);
            tabMap.put("util", freeMakerUtil);
            tabMap.put("tabs", newTabs);
            String html = this.freemarkEngine.parseByTemplate(tabsTemplate, tabMap);
            return html;
        }
        if (this.isContainsCollapse(jary)) {
            List<Map<String, Object>> collapse = this.getCollapseHtml(jary);
            HashMap<String, Object> mapObj = new HashMap<String, Object>();
            mapObj.put("formDesc", tableNames);
            mapObj.put("ganged", ganged);
            mapObj.put("expand", expand);
            mapObj.put("expandMap", JsonUtil.toMap((String)expand.toString()));
            mapObj.put("util", freeMakerUtil);
            mapObj.put("mainTemplate", mainTemplate);
            mapObj.put("subTemplate", subTemplate);
            mapObj.put("macroTemplate", macroTemplate);
            List<Map<String, Object>> newCollapse = this.getFields(collapse, mapObj);
            String tabsTemplate = this.formTemplateManager.getByTemplateAlias("collapseColumn").getHtml();
            HashMap<String, Object> tabMap = new HashMap<String, Object>();
            tabMap.put("formDesc", tableNames);
            tabMap.put("util", freeMakerUtil);
            tabMap.put("tabs", newCollapse);
            String html = this.freemarkEngine.parseByTemplate(tabsTemplate, tabMap);
            return html;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("formDesc", tableNames);
        map.put("fieldList", jary);
        map.put("ganged", ganged);
        map.put("expand", expand);
        map.put("expandMap", JsonUtil.toMap((String)expand.toString()));
        map.put("includeFiles", BeanUtils.isNotEmpty((Object)expand.get("includeFiles")) ? expand.get("includeFiles").asText() : "");
        map.put("util", freeMakerUtil);
        map.put("isTabs", false);
        map.put("hasStepControl", hasStepControl);
        map.put("stepAttr", stepAttr);
        this.handlerTrGroup(map);
        String html = this.freemarkEngine.parseByTemplate(mainTemplate + macroTemplate + subTemplate + divContainer, map);
        return html;
    }

    private List<Map<String, Object>> getFields(List<Map<String, Object>> collapse, Map<String, Object> mapObj) throws Exception {
        ArrayList<Map<String, Object>> newCollapse = new ArrayList<Map<String, Object>>();
        String tableNames = (String)mapObj.get("formDesc");
        String ganged = (String)mapObj.get("ganged");
        JsonNode expand = (JsonNode)mapObj.get("expand");
        FreeMakerUtil freeMakerUtil = (FreeMakerUtil)mapObj.get("util");
        String mainTemplate = (String)mapObj.get("mainTemplate");
        String subTemplate = (String)mapObj.get("subTemplate");
        String divContainer = (String)mapObj.get("divContainer");
        String macroTemplate = (String)mapObj.get("macroTemplate");
        for (Map<String, Object> collaps : collapse) {
            Map tabFieldMap;
            String tabHtml;
            HashMap<String, Object> map;
            List newList = (List)collaps.get("fields");
            if ("collapseEnd".equals(((Map)newList.get(newList.size() - 1)).get("ctrlType"))) {
                newList.remove(newList.size() - 1);
                map = new HashMap();
                map.put("formDesc", tableNames);
                map.put("fieldList", newList);
                map.put("ganged", ganged);
                map.put("includeFiles", BeanUtils.isNotEmpty((Object)expand.get("includeFiles")) ? expand.get("includeFiles").asText() : "");
                map.put("util", freeMakerUtil);
                map.put("isTabs", true);
                this.handlerTrGroup(map);
                tabHtml = this.freemarkEngine.parseByTemplate(mainTemplate + macroTemplate + subTemplate + divContainer, map);
                collaps.put("tabHtml", tabHtml);
                collaps.put("isCollaps", true);
                if (collaps.containsKey("tabField")) {
                    Map tabFieldMap2 = (Map)collaps.get("tabField");
                    collaps.put("isShow", tabFieldMap2.get("isShow"));
                }
                newCollapse.add(collaps);
                continue;
            }
            if (!collaps.containsKey("tabField")) {
                map = new HashMap<String, Object>();
                map.put("formDesc", tableNames);
                map.put("fieldList", newList);
                map.put("ganged", ganged);
                map.put("includeFiles", BeanUtils.isNotEmpty((Object)expand.get("includeFiles")) ? expand.get("includeFiles").asText() : "");
                map.put("util", freeMakerUtil);
                map.put("isTabs", true);
                this.handlerTrGroup(map);
                tabHtml = this.freemarkEngine.parseByTemplate(mainTemplate + macroTemplate + subTemplate + divContainer, map);
                HashMap<String, Object> table = new HashMap<String, Object>();
                table.put("tabHtml", tabHtml);
                table.put("isCollaps", false);
                newCollapse.add(table);
                continue;
            }
            ArrayList collapsFields = new ArrayList();
            ArrayList tableFields = new ArrayList();
            boolean ref = false;
            for (int i = 0; i < newList.size(); ++i) {
                if (ref) {
                    tableFields.add(newList.get(i));
                } else if (!"collapseEnd".equals(((Map)newList.get(i)).get("ctrlType"))) {
                    collapsFields.add(newList.get(i));
                }
                if (!"collapseEnd".equals(((Map)newList.get(i)).get("ctrlType"))) continue;
                ref = true;
            }
            if (collapsFields.size() > 0) {
                HashMap<String, Object> c = new HashMap<String, Object>();
                HashMap<String, Object> map2 = new HashMap<String, Object>();
                map2.put("formDesc", tableNames);
                map2.put("fieldList", collapsFields);
                map2.put("ganged", ganged);
                map2.put("includeFiles", BeanUtils.isNotEmpty((Object)expand.get("includeFiles")) ? expand.get("includeFiles").asText() : "");
                map2.put("util", freeMakerUtil);
                map2.put("isTabs", true);
                this.handlerTrGroup(map2);
                String tabHtml2 = this.freemarkEngine.parseByTemplate(mainTemplate + macroTemplate + subTemplate, map2);
                if (collaps.containsKey("tabField")) {
                    tabFieldMap = (Map)collaps.get("tabField");
                    c.put("isShow", tabFieldMap.get("isShow"));
                }
                c.put("tabHtml", tabHtml2);
                c.put("isCollaps", true);
                c.put("tabField", collaps.get("tabField"));
                newCollapse.add(c);
            }
            if (tableFields.size() <= 0) continue;
            HashMap<String, Object> map3 = new HashMap<String, Object>();
            map3.put("formDesc", tableNames);
            map3.put("fieldList", tableFields);
            map3.put("ganged", ganged);
            map3.put("includeFiles", BeanUtils.isNotEmpty((Object)expand.get("includeFiles")) ? expand.get("includeFiles").asText() : "");
            map3.put("util", freeMakerUtil);
            map3.put("isTabs", true);
            this.handlerTrGroup(map3);
            String tabHtml3 = this.freemarkEngine.parseByTemplate(mainTemplate + macroTemplate + subTemplate, map3);
            HashMap table = new HashMap();
            if (collaps.containsKey("tabField")) {
                tabFieldMap = (Map)collaps.get("tabField");
                table.put("isShow", tabFieldMap.get("isShow"));
            }
            table.put("tabHtml", tabHtml3);
            table.put("isCollaps", false);
            newCollapse.add(table);
        }
        return newCollapse;
    }

    private List<Map<String, Object>> getTabsHtml(List<Map<String, Object>> fieldList) {
        ArrayList<Map<String, Object>> fields = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> tabs = new ArrayList<Map<String, Object>>();
        int index = 0;
        Map<Object, Object> tabField = new HashMap();
        for (Map<String, Object> field : fieldList) {
            if ("tabs".equals(field.get("ctrlType")) || "tabCheck".equals(field.get("ctrlType"))) {
                if (index > 0) {
                    HashMap<String, Cloneable> tab = new HashMap<String, Cloneable>();
                    tab.put("tabField", (Cloneable)((Object)tabField));
                    tab.put("fields", fields);
                    tabs.add(tab);
                    fields = new ArrayList();
                }
                if ("tabCheck".equals(field.get("ctrlType"))) {
                    field.put("nextCheck", field.containsKey("nextCheck") && (Boolean)field.get("nextCheck") == false ? "n" : "y");
                }
                tabField = field;
            } else {
                if (index == 0) {
                    tabField = new HashMap();
                    String uuid = UniqueIdUtil.getSuid();
                    tabField.put("name", "Tabs\u6807\u7b7e\u9875");
                    tabField.put("desc", "\u9ed8\u8ba4\u4fe1\u606f");
                    tabField.put("ctrlType", "tabs");
                    tabField.put("uuid", uuid);
                    tabField.put("widthClass", "col-md-12");
                }
                fields.add(field);
            }
            ++index;
        }
        if (BeanUtils.isNotEmpty(fields)) {
            HashMap<String, Cloneable> tab = new HashMap<String, Cloneable>();
            tab.put("tabField", (Cloneable)((Object)tabField));
            tab.put("fields", fields);
            tabs.add(tab);
        }
        return tabs;
    }

    private List<Map<String, Object>> getCollapseHtml(List<Map<String, Object>> fieldList) {
        ArrayList<Map<String, Object>> fields = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> collapses = new ArrayList<Map<String, Object>>();
        int index = 0;
        Map<Object, Object> tabField = new HashMap();
        for (Map<String, Object> field : fieldList) {
            if ("collapse".equals(field.get("ctrlType"))) {
                if (index > 0) {
                    HashMap<String, Object> tab = new HashMap<String, Object>();
                    if (tabField.size() > 0) {
                        tab.put("tabField", tabField);
                    }
                    tab.put("fields", fields);
                    tab.put("lableColor", field.get("isShow"));
                    collapses.add(tab);
                    fields = new ArrayList();
                }
                tabField = field;
            } else {
                fields.add(field);
            }
            ++index;
        }
        if (BeanUtils.isNotEmpty(fields)) {
            HashMap<String, Cloneable> tab = new HashMap<String, Cloneable>();
            if (tabField.size() > 0) {
                tab.put("tabField", (Cloneable)((Object)tabField));
            }
            tab.put("fields", fields);
            collapses.add(tab);
        }
        return collapses;
    }

    private boolean isContainsTabs(List<Map<String, Object>> fieldList) {
        if (BeanUtils.isNotEmpty(fieldList)) {
            for (Map<String, Object> map : fieldList) {
                if (!map.containsKey("ctrlType") || !"tabs".equals(map.get("ctrlType")) && !"tabCheck".equals(map.get("ctrlType"))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isContainsCollapse(List<Map<String, Object>> fieldList) {
        if (BeanUtils.isNotEmpty(fieldList)) {
            for (Map<String, Object> map : fieldList) {
                if (!map.containsKey("ctrlType") || !"collapse".equals(map.get("ctrlType"))) continue;
                return true;
            }
        }
        return false;
    }

    private void handlerTrGroup(Map<String, Object> map) {
        ArrayList trGroup = new ArrayList();
        List fieldList = (List)map.get("fieldList");
        Integer maxCount = 1;
        if (BeanUtils.isEmpty((Object)fieldList)) {
            map.put("maxCol", maxCount);
            map.put("trGroup", trGroup);
            return;
        }
        Float currentCol = Float.valueOf(0.0f);
        Integer count = 0;
        HashMap<String, Serializable> currentGroup = new HashMap<String, Serializable>();
        currentGroup.put("fields", new ArrayList());
        trGroup.add(currentGroup);
        for (Map field : fieldList) {
            String widthClass = MapUtil.getString((Map)field, (String)"widthClass");
            Float col = this.getColByWidthClass(widthClass);
            String ctrlType = MapUtil.getString((Map)field, (String)"ctrlType");
            if (BeanUtils.isNotEmpty(currentGroup.get("isSub")) && currentGroup.get("isSub").equals(true)) {
                currentCol = Float.valueOf(0.0f);
            }
            if (currentCol.floatValue() == 0.0f || currentCol.floatValue() + col.floatValue() <= 1.0f) {
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
                if (count > maxCount) {
                    maxCount = count;
                }
                currentCol = Float.valueOf(currentCol.floatValue() + col.floatValue());
                if (BeanUtils.isNotEmpty(currentGroup.get("isSub")) && currentGroup.get("isSub").equals(true)) {
                    currentGroup = new HashMap();
                    currentGroup.put("fields", new ArrayList());
                    trGroup.add(currentGroup);
                    ((List)currentGroup.get("fields")).add(field);
                } else {
                    ((List)currentGroup.get("fields")).add(field);
                }
                currentGroup.put("count", count);
            } else {
                currentGroup = new HashMap();
                currentCol = col;
                count = 1;
                ArrayList<Map> fs = new ArrayList<Map>();
                fs.add(field);
                currentGroup.put("fields", fs);
                currentGroup.put("count", count);
                trGroup.add(currentGroup);
            }
            if (!BeanUtils.isNotEmpty(field.get("children")) || "divContainer".equals(ctrlType)) continue;
            if ("sub".equals(ctrlType)) {
                currentGroup.put("isSub", Boolean.valueOf(true));
            }
            List childrenList = (List)field.get("children");
            ArrayList trGroupSup = new ArrayList();
            HashMap<String, Serializable> filedEntity = new HashMap<String, Serializable>();
            filedEntity.put("childrens", new ArrayList());
            trGroupSup.add(filedEntity);
            for (Map children : childrenList) {
                String widthClassSup = MapUtil.getString((Map)children, (String)"widthClass");
                Float colSup = this.getColByWidthClass(widthClassSup);
                if (colSup.floatValue() == 0.0f || currentCol.floatValue() + colSup.floatValue() <= 1.0f) {
                    Integer n = count;
                    Integer n3 = count = Integer.valueOf(count + 1);
                    if (count > maxCount) {
                        maxCount = count;
                    }
                    currentCol = Float.valueOf(currentCol.floatValue() + colSup.floatValue());
                    ((List)filedEntity.get("childrens")).add(children);
                    filedEntity.put("count", count);
                    continue;
                }
                filedEntity = new HashMap();
                currentCol = colSup;
                count = 1;
                ArrayList<Map> fs = new ArrayList<Map>();
                fs.add(children);
                filedEntity.put("childrens", fs);
                filedEntity.put("count", count);
                trGroupSup.add(filedEntity);
            }
            List list = (List)currentGroup.get("fields");
            for (Map obj : list) {
                obj.put("trGroupSup", trGroupSup);
            }
        }
        map.put("maxCol", maxCount);
        map.put("trGroup", trGroup);
    }

    private Float getColByWidthClass(String widthClass) {
        Assert.notNull((Object)widthClass, (String)"widthClass\u4e0d\u80fd\u4e3a\u7a7a");
        Float result = Float.valueOf(0.0f);
        switch (widthClass) {
            case "col-md-12": {
                result = Float.valueOf(1.0f);
                break;
            }
            case "col-md-6": {
                result = Float.valueOf(2.0f);
                break;
            }
            case "col-md-4": {
                result = Float.valueOf(3.0f);
                break;
            }
            case "col-md-3": {
                result = Float.valueOf(4.0f);
                break;
            }
            default: {
                throw new SystemException("widthClass\u7684\u503c\u4e0d\u5728\u5141\u8bb8\u7684\u8303\u56f4\u5185");
            }
        }
        return Float.valueOf(1.0f / result.floatValue());
    }

    @Override
    public String getMobileDesignHtml(JsonNode expand, String tableNames, String ganged) throws Exception {
        ArrayList<Map> jary = new ArrayList<Map>();
        ArrayNode fieldList = (ArrayNode)expand.get("fields");
        for (JsonNode jsonNode : fieldList) {
            if (!"main".equals(jsonNode.get("type").asText())) continue;
            ArrayNode arr = (ArrayNode)jsonNode.get("children");
            for (JsonNode fieldNode : arr) {
                jary.add(JsonUtil.toMap((String)fieldNode.toString()));
            }
        }
        FormTemplate mainTemplateObj = this.formTemplateManager.getByTemplateAlias("mobileMainTemplate");
        String mainTemplate = mainTemplateObj.getHtml();
        String subTemplate = this.formTemplateManager.getByTemplateAlias("blockSubTemplate").getHtml();
        String macroTemplate = this.formTemplateManager.getByTemplateAlias(mainTemplateObj.getMacrotemplateAlias()).getHtml();
        FreeMakerUtil freeMakerUtil = new FreeMakerUtil();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("formDesc", tableNames);
        map.put("fieldList", jary);
        map.put("ganged", ganged);
        map.put("includeFiles", BeanUtils.isNotEmpty((Object)expand.get("includeFiles")) ? expand.get("includeFiles").asText() : "");
        map.put("util", freeMakerUtil);
        String html = this.freemarkEngine.parseByTemplate(mainTemplate + macroTemplate + subTemplate, map);
        return html;
    }

    @Override
    public CommonResult<String> savePrintTemplate(Form form) throws Exception {
        IUser user = ContextUtil.getCurrentUser();
        IGroup org = ContextUtil.getCurrentGroup();
        Form newForm = this.get((Serializable)((Object)form.getId()));
        String printFormKey = newForm.getFormKey();
        String formKey = form.getFormKey();
        if (BeanUtils.isNotEmpty(this.getByFormKey(formKey))) {
            throw new RuntimeException("\u8868\u5355\u5df2\u7ecf\u5b58\u5728\uff0ckey:" + formKey);
        }
        FormMeta bpmFormDef = (FormMeta)this.formMetaManager.get((Serializable)((Object)newForm.getDefId()));
        String formNewDefId = UniqueIdUtil.getSuid();
        bpmFormDef.setId(formNewDefId);
        bpmFormDef.setKey(formKey);
        bpmFormDef.setName(form.getName());
        bpmFormDef.setTypeId(form.getTypeId());
        bpmFormDef.setType(form.getTypeName());
        bpmFormDef.setCreateBy(user.getUserId());
        if (BeanUtils.isNotEmpty((Object)org) && StringUtil.isNotEmpty((String)org.getGroupId())) {
            bpmFormDef.setCreateOrgId(org.getGroupId());
        }
        bpmFormDef.setRev(1);
        bpmFormDef.setUpdateBy(null);
        bpmFormDef.setUpdateTime(LocalDateTime.now());
        this.formMetaManager.create((Model)bpmFormDef);
        String newFormId = UniqueIdUtil.getSuid();
        newForm.setId(newFormId);
        newForm.setDefId(formNewDefId);
        newForm.setFormKey(formKey);
        newForm.setName(form.getName());
        newForm.setTypeId(form.getTypeId());
        newForm.setTypeName(form.getTypeName());
        newForm.setStatus("draft");
        newForm.setVersion(1);
        newForm.setCreateBy(user.getUserId());
        if (BeanUtils.isNotEmpty((Object)org) && StringUtil.isNotEmpty((String)org.getGroupId())) {
            newForm.setCreateOrgId(org.getGroupId());
        }
        newForm.setIsPrint("Y");
        newForm.setUpdateTime(LocalDateTime.now());
        newForm.setUpdateBy(null);
        this.create((Model)newForm);
        FormPrintTemplate formPrintTemplate = new FormPrintTemplate();
        String printType = "form";
        formPrintTemplate.setDefId(formNewDefId);
        formPrintTemplate.setFormId(newFormId);
        formPrintTemplate.setFormKey(printFormKey);
        formPrintTemplate.setFileName(form.getName());
        formPrintTemplate.setPrintType(printType);
        List<FormPrintTemplate> formPrintTemplates = this.formPrintTemplateManager.getPrintTemplates(printFormKey, printType);
        if (BeanUtils.isEmpty(formPrintTemplates)) {
            formPrintTemplate.setIsMain("Y");
        } else {
            formPrintTemplate.setIsMain("N");
        }
        this.formPrintTemplateManager.create((Model)formPrintTemplate);
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public void updatePermissionByKey(String formKey) throws Exception {
        this.updatePermissionm(formKey);
    }

    @Override
    @CachePut(value={"bpm:form:importFile"}, key="#fileId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.HOURS))
    public String putImportFileInCache(String fileId, String fileJson) {
        return fileJson;
    }

    @Override
    @Cacheable(value={"bpm:form:importFile"}, key="#fileId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.HOURS))
    public String getImportFileFromCache(String fileId) {
        return null;
    }

    @Override
    @CacheEvict(value={"bpm:form:importFile"}, key="#fileId")
    public void delImportFileFromCache(String fileId) {
    }

    @Override
    public void removeVersions(String[] aryIds) {
        super.removeByIds(aryIds);
    }

    @Override
    public CommonResult<String> generateExpand(GenerateExpandParam params) throws IOException {
        String boDefIds = params.getBoDefId();
        if (StringUtil.isEmpty((String)boDefIds)) {
            return new CommonResult(false, "BO\u5efa\u6a21id\u5fc5\u586b\uff01");
        }
        ArrayList<BoDef> defList = new ArrayList<BoDef>();
        String[] defIds = boDefIds.split(",");
        ArrayNode boDefListNode = JsonUtil.getMapper().createArrayNode();
        for (String defId : defIds) {
            BoDef bodef = this.boDefManager.getByDefId(defId);
            if (!BeanUtils.isNotEmpty((Object)bodef)) continue;
            defList.add(bodef);
            BoEnt mainEnt = bodef.getBoEnt();
            ObjectNode defNode = (ObjectNode)JsonUtil.toJsonNode((Object)bodef);
            ArrayNode entsNode = JsonUtil.getMapper().createArrayNode();
            List subEnts = mainEnt.getChildEntList();
            ObjectNode mainEntNode = this.getEntNode(mainEnt, 0, false, bodef, "");
            entsNode.add((JsonNode)mainEntNode);
            if (BeanUtils.isNotEmpty((Object)subEnts)) {
                for (BoEnt subEnt : subEnts) {
                    ObjectNode subEntNode = this.getEntNode(subEnt, 1, false, bodef, "");
                    List sunEnts = subEnt.getChildEntList();
                    if (BeanUtils.isNotEmpty((Object)sunEnts)) {
                        ArrayNode childrenNode = JsonUtil.getMapper().createArrayNode();
                        for (BoEnt sunEnt : sunEnts) {
                            childrenNode.add((JsonNode)this.getEntNode(sunEnt, 1, false, bodef, ""));
                        }
                        subEntNode.set("children", (JsonNode)childrenNode);
                    }
                    entsNode.add((JsonNode)subEntNode);
                }
            }
            defNode.set("ents", (JsonNode)entsNode);
            boDefListNode.add((JsonNode)defNode);
        }
        if (BeanUtils.isEmpty(defList)) {
            return new CommonResult(false, "\u83b7\u53d6BO\u5efa\u6a21\u5931\u8d25\uff01");
        }
        try {
            ObjectNode expandNode = JsonUtil.getMapper().createObjectNode();
            ObjectNode configNode = JsonUtil.getMapper().createObjectNode();
            configNode.put("labelWidth", 100);
            configNode.put("labelPosition", "right");
            configNode.put("size", "small");
            expandNode.set("list", (JsonNode)GenerateExpandUtil.getLayoutList(params, defList));
            expandNode.set("config", (JsonNode)configNode);
            expandNode.set("boDefList", (JsonNode)boDefListNode);
            return new CommonResult(true, "\u83b7\u53d6\u8868\u5355\u521d\u59cb\u5316\u6a21\u677f\u6210\u529f\uff01", (Object)JsonUtil.toJsonString((Object)expandNode));
        }
        catch (Exception e) {
            return new CommonResult(false, "\u83b7\u53d6\u8868\u5355\u521d\u59cb\u5316\u6a21\u677f\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private ObjectNode getEntNode(BoEnt ent, int index, boolean showDetail, BoDef boDef, String path) {
        ObjectNode entNode = JsonUtil.getMapper().createObjectNode();
        entNode.put("desc", ent.getDesc());
        entNode.put("index", index);
        entNode.put("name", ent.getName());
        entNode.put("packageId", "");
        entNode.put("show", ent.getShow());
        entNode.put("status", "");
        entNode.put("isCheck", true);
        entNode.put("comment", ent.getComment());
        entNode.put("description", ent.getDesc());
        entNode.put("fieldPrefix", BoEnt.FIELD_PREFIX);
        ArrayNode attributeList = JsonUtil.getMapper().createArrayNode();
        for (BoAttribute attribute : ent.getBoAttrList()) {
            if ("hide".equals(attribute.getStatus())) continue;
            ObjectNode attrNode = JsonUtil.getMapper().createObjectNode();
            attrNode = JsonUtil.getMapper().createObjectNode();
            attrNode.put("comment", attribute.getComment());
            attrNode.put("name", attribute.getName());
            attrNode.put("isRequired", String.valueOf(attribute.getIsRequired()));
            attrNode.put("dataType", attribute.getDataType());
            attrNode.put("format", attribute.getFormat());
            attrNode.put("intLen", attribute.getIntLen());
            attrNode.put("attrLength", attribute.getAttrLength());
            attrNode.put("decimalLen", attribute.getDecimalLen());
            attrNode.put("isNew", true);
            attrNode.put("defaultValue", attribute.getDefaultValue());
            attrNode.put("desc", attribute.getDesc());
            attrNode.put("index", attribute.getIndex());
            if (showDetail) {
                attrNode.put("boDefId", boDef.getId());
                attrNode.put("boDefAlias", boDef.getAlias());
                attrNode.put("boAttrId", attribute.getId());
                attrNode.put("entId", ent.getId());
                attrNode.put("tableName", ent.getName());
                attrNode.put("fieldPath", path + "." + attribute.getName());
            }
            attributeList.add((JsonNode)attrNode);
        }
        entNode.set("attributeList", (JsonNode)attributeList);
        return entNode;
    }

    @Override
    public CommonResult<String> generateBoTreeData(String boDefIds) throws IOException {
        if (StringUtil.isEmpty((String)boDefIds)) {
            return new CommonResult(false, "BO\u5efa\u6a21id\u5fc5\u586b\uff01");
        }
        ArrayList<BoDef> defList = new ArrayList<BoDef>();
        String[] defIds = boDefIds.split(",");
        ArrayNode boDefListNode = JsonUtil.getMapper().createArrayNode();
        for (String defId : defIds) {
            BoDef bodef = this.boDefManager.getByDefId(defId);
            if (!BeanUtils.isNotEmpty((Object)bodef)) continue;
            defList.add(bodef);
            BoEnt mainEnt = bodef.getBoEnt();
            ObjectNode defNode = (ObjectNode)JsonUtil.toJsonNode((Object)bodef);
            ArrayNode mainEntNodes = JsonUtil.getMapper().createArrayNode();
            List subEnts = mainEnt.getChildEntList();
            ObjectNode mainEntNode = this.getEntNode(mainEnt, 0, true, bodef, bodef.getAlias());
            if (BeanUtils.isNotEmpty((Object)subEnts)) {
                ArrayNode subEntNodes = JsonUtil.getMapper().createArrayNode();
                for (BoEnt subEnt : subEnts) {
                    ObjectNode subEntNode = this.getEntNode(subEnt, 1, true, bodef, "item");
                    List sunEnts = subEnt.getChildEntList();
                    if (BeanUtils.isNotEmpty((Object)sunEnts)) {
                        ArrayNode childrenNode = JsonUtil.getMapper().createArrayNode();
                        for (BoEnt sunEnt : sunEnts) {
                            String path = bodef.getAlias() + ".sub_" + subEnt.getName() + ".sub_" + sunEnt.getName();
                            childrenNode.add((JsonNode)this.getEntNode(sunEnt, 1, true, bodef, path));
                        }
                        subEntNode.set("children", (JsonNode)childrenNode);
                    }
                    subEntNodes.add((JsonNode)subEntNode);
                }
                mainEntNode.set("children", (JsonNode)subEntNodes);
            }
            mainEntNodes.add((JsonNode)mainEntNode);
            defNode.set("children", (JsonNode)mainEntNodes);
            boDefListNode.add((JsonNode)defNode);
        }
        if (BeanUtils.isEmpty(defList)) {
            return new CommonResult(false, "\u83b7\u53d6BO\u5efa\u6a21\u5931\u8d25\uff01");
        }
        return new CommonResult(true, "\u751f\u6210\u8868\u5355bo\u6811\u7ed3\u6784\u6570\u636e\u6210\u529f\uff01", (Object)JsonUtil.toJsonString((Object)boDefListNode));
    }
}

