/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.generator.impl;

import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.WebUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.bo.model.BoDef;
import com.artfess.bo.model.BoEnt;
import com.artfess.bo.persistence.manager.BoDefManager;
import com.artfess.form.generator.GeneratorModel;
import com.artfess.form.generator.GeneratorService;
import com.artfess.form.generator.impl.DynamicDataSourceConfig;
import com.artfess.form.manager.FormCodegenLogManager;
import com.artfess.form.model.FormCodegenLog;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.FileOutConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class MybatisPlusGeneratorService
implements GeneratorService {
    @Resource
    DatabaseContext databaseContext;
    @Resource
    BoDefManager boDefManager;
    @Resource
    FormCodegenLogManager formCodegenLogManager;

    private DataSourceConfig getDataSource(GeneratorModel generatorModel) throws SQLException {
        String type = generatorModel.getType();
        String dataSourceAlias = generatorModel.getDataSourceAlias();
        String[] tableName = generatorModel.getTableName();
        String formkey = generatorModel.getFormkey();
        if ("table".equals(type)) {
            Assert.isTrue((boolean)BeanUtils.isNotEmpty((Object)tableName), (String)"\u5fc5\u987b\u4f20\u5165\u7269\u7406\u8868\u540d");
        } else {
            Assert.isTrue((boolean)StringUtil.isNotEmpty((String)formkey), (String)"\u5fc5\u987b\u4f20\u5165\u8868\u5355Key");
            List boDefList = this.boDefManager.getByFormKey(formkey);
            Assert.isTrue((boolean)BeanUtils.isNotEmpty((Object)boDefList), (String)String.format("\u672a\u83b7\u53d6\u5230formkey:%s\u5bf9\u5e94\u7684\u4e1a\u52a1\u5bf9\u8c61", formkey));
            HashSet tableNameSet = new HashSet();
            HashSet boDataSourceAlias = new HashSet();
            boDefList.forEach(bd -> {
                BoDef boDef = this.boDefManager.getByAlias(bd.getAlias());
                BoEnt boEnt = boDef.getBoEnt();
                tableNameSet.add(boEnt.getTableName());
                if (boEnt.isExternal()) {
                    boDataSourceAlias.add(boEnt.getDsName());
                }
                List childEntList = boEnt.getChildEntList();
                childEntList.forEach(cbe -> tableNameSet.add(cbe.getTableName()));
            });
            Assert.isTrue((boDataSourceAlias.size() < 2 ? 1 : 0) != 0, (String)String.format("\u8868\u5355formkey\uff1a%s\u5bf9\u5e94\u7684\u4e1a\u52a1\u5bf9\u8c61\u5c5e\u4e8e\u4e0d\u540c\u7684\u6570\u636e\u6e90", formkey));
            if (boDataSourceAlias.size() == 1) {
                dataSourceAlias = (String)boDataSourceAlias.parallelStream().findFirst().get();
            }
            tableName = tableNameSet.toArray(new String[0]);
        }
        if (StringUtil.isEmpty((String)dataSourceAlias)) {
            dataSourceAlias = "LOCAL";
        }
        generatorModel.setDataSourceAlias(dataSourceAlias);
        generatorModel.setTableName(tableName);
        DataSource dataSourceByAlias = this.databaseContext.getDataSourceByAlias(dataSourceAlias);
        String dbTypeByAlias = this.databaseContext.getDbTypeByAlias(dataSourceAlias);
        DynamicDataSourceConfig dynamicDataSourceConfig = new DynamicDataSourceConfig(dbTypeByAlias, dataSourceByAlias);
        if (BeanUtils.isEmpty((Object)dynamicDataSourceConfig.getUsername())) {
            dynamicDataSourceConfig.setUsername(dataSourceByAlias.getConnection().getMetaData().getUserName());
        }
        return dynamicDataSourceConfig;
    }

    private GlobalConfig getGlobalConfig(String baseProjectPath, String authorName) {
        GlobalConfig globalConfig = new GlobalConfig().setOutputDir(String.format("%s%s", baseProjectPath, "/src/main/java".replace("/", File.separator))).setFileOverride(true).setActiveRecord(true).setEnableCache(false).setBaseResultMap(true).setBaseColumnList(true).setOpen(false).setAuthor(authorName).setSwagger2(true).setIdType(IdType.ASSIGN_ID).setMapperName("%sDao").setXmlName("%sMapper").setServiceName("%sManager").setServiceImplName("%sManagerImpl").setControllerName("%sController");
        return globalConfig;
    }

    private StrategyConfig getStrategyConfig(String ... tableNames) {
        return new StrategyConfig().setNaming(NamingStrategy.underline_to_camel).setInclude(tableNames).setRestControllerStyle(true).setSuperEntityClass("com.artfess.base.entity.BaseModel").setSuperServiceClass("com.artfess.base.manager.BaseManager").setSuperServiceImplClass("com.artfess.base.manager.impl.BaseManagerImpl").setSuperControllerClass("com.artfess.base.controller.BaseController");
    }

    private PackageConfig getPackageConfig(String basePackage, String moduleName) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)basePackage), (String)"\u57fa\u7840\u5305\u8def\u5f84(BasePackage)\u4e0d\u80fd\u4e3a\u7a7a");
        return new PackageConfig().setParent(basePackage).setModuleName(moduleName).setController("controller").setEntity("model").setMapper("dao").setService("manager").setServiceImpl("manager.impl").setXml("mapper");
    }

    private InjectionConfig getInjectionConfig(final String baseProjectPath, final GeneratorModel generatorModel) {
        InjectionConfig injectionConfig = new InjectionConfig(){

            public void initMap() {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("system", generatorModel.getSystem());
                String authorEmail = generatorModel.getAuthorEmail();
                String companyName = generatorModel.getCompanyName();
                if (StringUtil.isNotEmpty((String)authorEmail)) {
                    map.put("authorEmail", authorEmail);
                }
                if (StringUtil.isNotEmpty((String)companyName)) {
                    map.put("companyName", companyName);
                }
                this.setMap(map);
            }
        };
        ArrayList<FileOutConfig> fileOutList = new ArrayList<FileOutConfig>();
        fileOutList.add(new FileOutConfig("/template/mapper.xml.ftl"){

            public String outputFile(TableInfo tableInfo) {
                return baseProjectPath + "/src/main/resources/mapper/".replace("/", File.separator) + tableInfo.getEntityName() + "Mapper.xml";
            }
        });
        fileOutList.add(new FileOutConfig("/template/entityManager.vue.ftl"){

            public String outputFile(TableInfo tableInfo) {
                return baseProjectPath + "/web/src/views/".replace("/", File.separator) + tableInfo.getEntityName() + "Manager.vue";
            }
        });
        injectionConfig.setFileOutConfigList(fileOutList);
        return injectionConfig;
    }

    private TemplateConfig getTemplateConfig() {
        return new TemplateConfig().setXml(null).setController("template/controller.java").setEntity("template/entity.java").setMapper("template/mapper.java").setService("template/service.java").setServiceImpl("template/serviceImpl.java");
    }

    @Override
    @Transactional
    public String generator(GeneratorModel generatorModel) throws IOException, SQLException {
        AutoGenerator gen = new AutoGenerator();
        gen.setDataSource(this.getDataSource(generatorModel));
        String tmpdir = FileUtil.getIoTmpdir();
        String codeFolder = String.format("eipcode-%s", LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8")));
        String baseProjectPath = String.format("%s%s", tmpdir.endsWith(File.separator) ? tmpdir : tmpdir + File.separator, codeFolder);
        gen.setGlobalConfig(this.getGlobalConfig(baseProjectPath, generatorModel.getAuthorName()));
        gen.setStrategy(this.getStrategyConfig(generatorModel.getTableName()));
        gen.setPackageInfo(this.getPackageConfig(generatorModel.getBasePackage(), generatorModel.getModuleName()));
        gen.setCfg(this.getInjectionConfig(baseProjectPath, generatorModel));
        gen.setTemplateEngine((AbstractTemplateEngine)new FreemarkerTemplateEngine());
        gen.setTemplate(this.getTemplateConfig());
        gen.execute();
        this.saveCodegenLog(generatorModel);
        return codeFolder;
    }

    private void saveCodegenLog(GeneratorModel generatorModel) throws IOException {
        FormCodegenLog formCodegenLog = new FormCodegenLog();
        HttpServletRequest request = HttpUtil.getRequest();
        if (BeanUtils.isNotEmpty((Object)request)) {
            String ipAddr = WebUtil.getIpAddr((HttpServletRequest)request);
            formCodegenLog.setIp(ipAddr);
        }
        String type = generatorModel.getType();
        formCodegenLog.setType(type);
        if ("form".equals(type)) {
            formCodegenLog.setTableOrForm(generatorModel.getFormkey());
        } else if ("table".equals(type)) {
            formCodegenLog.setTableOrForm(StringUtil.join((String[])generatorModel.getTableName()));
        }
        String json = JsonUtil.toJson((Object)generatorModel);
        formCodegenLog.setOpeContent(json);
        this.formCodegenLogManager.create((Model)formCodegenLog);
    }

    @Override
    public void download(HttpServletResponse response, String codeFolder) throws IOException {
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)codeFolder), (String)"\u4e0b\u8f7d\u4ee3\u7801\u7684\u76ee\u5f55\u4e0d\u80fd\u4e3a\u7a7a");
        String tmpdir = FileUtil.getIoTmpdir();
        String baseProjectPath = String.format("%s%s", tmpdir.endsWith(File.separator) ? tmpdir : tmpdir + File.separator, codeFolder);
        ZipUtil.zip((String)baseProjectPath, (Boolean)true);
        HttpUtil.downLoadFile((HttpServletResponse)response, (String)(baseProjectPath + ".zip"), (String)(codeFolder + ".zip"));
        FileUtil.deleteFile((String)(baseProjectPath + ".zip"));
    }
}

