/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.persistence.manager.impl;

import com.artfess.base.groovy.GroovyScriptEngine;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.bo.bodef.BoDefService;
import com.artfess.bo.instance.BoDataHandler;
import com.artfess.bo.instance.BoInstanceFactory;
import com.artfess.bo.instance.DataTransform;
import com.artfess.bo.model.BoData;
import com.artfess.bo.model.BoDef;
import com.artfess.bo.model.BoEnt;
import com.artfess.bo.model.BoResult;
import com.artfess.form.model.Form;
import com.artfess.form.model.FormBusSet;
import com.artfess.form.model.FormMeta;
import com.artfess.form.persistence.dao.FormBusSetDao;
import com.artfess.form.persistence.manager.FormBusManager;
import com.artfess.form.persistence.manager.FormBusSetManager;
import com.artfess.form.persistence.manager.FormManager;
import com.artfess.form.persistence.manager.FormMetaManager;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="formBusManager")
public class FormBusManagerImpl
extends BaseManagerImpl<FormBusSetDao, FormBusSet>
implements FormBusManager {
    @Resource
    BoInstanceFactory boInstanceFactory;
    @Resource
    BoDefService boDefService;
    @Resource
    DataTransform dataTransform;
    @Resource
    FormBusSetManager formBusSetManager;
    @Resource
    FormManager bpmFormManager;
    @Resource
    FormMetaManager bpmFormdefManager;
    @Resource
    GroovyScriptEngine groovyScriptEngine;

    @Override
    public BoData getBoData(String boKey, String id) throws IOException {
        BoDataHandler boDataHandler = this.boInstanceFactory.getBySaveType("database");
        if (boDataHandler == null) {
            return null;
        }
        if (StringUtil.isNotEmpty((String)id)) {
            return boDataHandler.getById((Object)id, boKey);
        }
        return boDataHandler.getByBoDefAlias(boKey);
    }

    @Override
    @Transactional
    public void saveData(String formKey, String json) throws IOException {
        BoDataHandler boDataHandler = this.boInstanceFactory.getBySaveType("database");
        String boCode = this.getBoCodeByForm(formKey);
        BoDef boDef = this.boDefService.getByAlias(boCode);
        BoData curData = this.dataTransform.parse(json);
        if (boDef != null) {
            BoEnt boEnt = boDef.getBoEnt();
            curData.setBoEnt(boEnt);
            curData.setBoDef(boDef);
        }
        FormBusSet busSet = this.formBusSetManager.getByFormKey(formKey);
        HashMap<String, BoData> param = new HashMap<String, BoData>();
        param.put("boData", curData);
        if (busSet != null && StringUtil.isNotEmpty((String)busSet.getPreScript())) {
            this.groovyScriptEngine.execute(busSet.getPreScript(), param);
        }
        List listResult = boDataHandler.save("", "", curData);
        if (busSet != null && StringUtil.isNotEmpty((String)busSet.getAfterScript())) {
            this.groovyScriptEngine.execute(busSet.getAfterScript(), param);
        }
        if (BeanUtils.isNotEmpty((Object)listResult)) {
            if ("add".equals(((BoResult)listResult.get(0)).getAction())) {
                ThreadMsgUtil.addMsg((String)"\u6dfb\u52a0\u6210\u529f\uff01");
            } else {
                ThreadMsgUtil.addMsg((String)"\u7f16\u8f91\u6210\u529f\uff01");
            }
        }
    }

    @Override
    @Transactional
    public void removeByIds(String[] aryIds, String formKey) {
        BoDataHandler boDataHandler = this.boInstanceFactory.getBySaveType("database");
        String boCode = this.getBoCodeByForm(formKey);
        boDataHandler.removeBoData(boCode, aryIds);
    }

    private String getBoCodeByForm(String formKey) {
        Form form = this.bpmFormManager.getMainByFormKey(formKey);
        if (form == null) {
            return "";
        }
        FormMeta formDef = (FormMeta)this.bpmFormdefManager.get((Serializable)((Object)form.getDefId()));
        List<String> boCode = this.bpmFormdefManager.getBOCodeByFormId(formDef.getId());
        if (boCode.size() != 1) {
            throw new RuntimeException(formKey + "\u8868\u5355\u6240\u5bf9\u5e94\u7684BO\u6570\u636e\u4e0d\u652f\u6301\u4fee\u6539\u64cd\u4f5c\uff01");
        }
        return boCode.get(0);
    }

    @Override
    public JsonNode getList(String formKey, Map<String, Object> param) throws IOException {
        String boCode = this.getBoCodeByForm(formKey);
        BoDataHandler boDataHandler = this.boInstanceFactory.getBySaveType("database");
        List list = boDataHandler.getList(boCode, param);
        JsonNode jsonArray = JsonUtil.toJsonNode((Object)list);
        return jsonArray;
    }
}

