/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.datasource.DatabaseSwitchResult;
import com.artfess.base.exception.BaseException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.form.model.CustomChart;
import com.artfess.form.persistence.manager.CustomChartManager;
import com.artfess.table.datasource.DataSourceUtil;
import com.artfess.table.meta.impl.BaseTableMeta;
import com.artfess.table.model.Table;
import com.artfess.table.model.impl.DefaultColumn;
import com.artfess.table.model.impl.DefaultTable;
import com.artfess.table.util.MetaDataUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/form/customChart/v1"})
@Api(tags={"\u81ea\u5b9a\u4e49\u56fe\u8868"})
@ApiGroup(group={"group_form"})
public class CustomChartController
extends BaseController<CustomChartManager, CustomChart> {
    @Resource
    DatabaseContext databaseContext;

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u81ea\u5b9a\u4e49\u5bf9\u56fe\u8868\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u81ea\u5b9a\u4e49\u5bf9\u56fe\u8868\u5217\u8868")
    public PageList<CustomChart> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<CustomChart> queryFilter) throws Exception {
        List sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("CREATE_TIME_", Direction.DESC));
        queryFilter.setSorter(sorter);
        return super.query(queryFilter);
    }

    @GetMapping(value={"/get/{id}"})
    @ApiOperation(value="\u81ea\u5b9a\u4e49\u5bf9\u56fe\u8868\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u81ea\u5b9a\u4e49\u5bf9\u56fe\u8868\u6570\u636e\u8be6\u60c5")
    public CustomChart get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        return (CustomChart)super.getById(id);
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u81ea\u5b9a\u4e49\u5bf9\u56fe\u8868\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u81ea\u5b9a\u4e49\u5bf9\u56fe\u8868\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="customChart", value="\u81ea\u5b9a\u4e49\u5bf9\u56fe\u8868\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody CustomChart customChart) throws Exception {
        CustomChart chartByAlias = ((CustomChartManager)this.baseService).getChartByAlias(customChart.getAlias());
        String msg = "\u6dfb\u52a0\u81ea\u5b9a\u4e49\u5bf9\u56fe\u8868\u6210\u529f";
        if (StringUtil.isEmpty((String)customChart.getId())) {
            if (chartByAlias != null) {
                return new CommonResult(false, customChart.getAlias() + "\u8be5\u522b\u540d\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6539\uff01");
            }
            ((CustomChartManager)this.baseService).create((Model)customChart);
        } else {
            if (chartByAlias != null && !chartByAlias.getId().equals(customChart.getId())) {
                return new CommonResult(false, customChart.getAlias() + "\u8be5\u522b\u540d\u5df2\u5b58\u5728\uff0c\u8bf7\u66f4\u6539\uff01");
            }
            ((CustomChartManager)this.baseService).update((Model)customChart);
            msg = "\u66f4\u65b0\u81ea\u5b9a\u4e49\u5bf9\u56fe\u8868\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    @DeleteMapping(value={"remove/{id}"})
    @ApiOperation(value="\u5220\u9664\u81ea\u5b9a\u4e49\u5bf9\u56fe\u8868\u8bb0\u5f55", httpMethod="DELETE", notes="\u5220\u9664\u81ea\u5b9a\u4e49\u5bf9\u56fe\u8868\u8bb0\u5f55")
    public CommonResult<String> remove(@ApiParam(name="id", value="\u4e1a\u52a1\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        return super.deleteById(id);
    }

    @DeleteMapping(value={"/removes"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u5bf9\u56fe\u8868\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u5bf9\u56fe\u8868\u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        ((CustomChartManager)this.baseService).removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/getListData"})
    @ApiOperation(value="\u83b7\u53d6\u81ea\u5b9a\u4e49\u56fe\u8868\u6570\u636e", httpMethod="POST", notes="\u83b7\u53d6\u81ea\u5b9a\u4e49\u56fe\u8868\u6570\u636e")
    public Object getListData(@ApiParam(name="alias", value="\u56fe\u8868\u522b\u540d", required=true) @RequestParam String alias, @ApiParam(name="filter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<?> filter) throws Exception {
        CustomChart customDialog = (CustomChart)((CustomChartManager)this.baseService).get((Serializable)((Object)alias));
        Object result = null;
        try (DatabaseSwitchResult dResult = this.databaseContext.setDataSource(customDialog.getDsalias());){
            result = ((CustomChartManager)this.baseService).getListData(customDialog, filter, dResult.getDbType());
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"getTable"})
    @ApiOperation(value="\u83b7\u53d6\u8bbe\u7f6e\u5217\u6570\u636e", httpMethod="POST", notes="\u83b7\u53d6\u8bbe\u7f6e\u5217\u6570\u636e")
    public ObjectNode getTable(@ApiParam(name="param", value="\u8bbe\u7f6e\u5217\u53c2\u6570", required=true) @RequestBody ObjectNode object) throws Exception {
        String dsalias = object.get("dsalias").asText();
        String isTable = object.get("isTable").asText();
        ObjectNode result = JsonUtil.getMapper().createObjectNode();
        try (DatabaseSwitchResult dResult = this.databaseContext.setDataSource(dsalias);){
            Table table = null;
            if (isTable.equals("1")) {
                String objName = object.get("objName").asText();
                BaseTableMeta baseTableMeta = MetaDataUtil.getBaseTableMetaAfterSetDT((String)dResult.getDbType());
                table = baseTableMeta.getTableByName(objName);
            } else {
                String diySql = object.get("diySql").asText();
                table = this.initMetafield(dsalias, diySql);
            }
            result.set("table", JsonUtil.toJsonNode((Object)table));
            ObjectNode objectNode = result;
            return objectNode;
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
    }

    private Table initMetafield(String DsName, String sql) {
        ArrayList<DefaultColumn> list = new ArrayList<DefaultColumn>();
        DefaultTable table = new DefaultTable();
        JdbcTemplate jdbcTemplate = null;
        try {
            jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)DsName);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
        SqlRowSet srs = jdbcTemplate.queryForRowSet(sql);
        SqlRowSetMetaData srsmd = srs.getMetaData();
        for (int i = 1; i < srsmd.getColumnCount() + 1; ++i) {
            String cn = srsmd.getColumnName(i).toUpperCase();
            String ctn = srsmd.getColumnTypeName(i);
            DefaultColumn field = new DefaultColumn();
            field.setFieldName(cn);
            field.setComment(cn);
            field.setColumnType(this.simplifyDataType(ctn));
            list.add(field);
        }
        table.setColumnList(list);
        return table;
    }

    private String simplifyDataType(String type) {
        type = type.toLowerCase();
        String number = "int";
        String date = "date";
        String text = "text";
        String varchar = "varchar";
        if (varchar.contains(type)) {
            return "varchar";
        }
        if (text.contains(type)) {
            return "varchar";
        }
        if (date.contains(type)) {
            return "date";
        }
        if (number.contains(type)) {
            return "number";
        }
        return type;
    }

    @RequestMapping(value={"exportXml"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e\u56fe\u8868xml", httpMethod="GET", notes="\u5bfc\u51fa\u6570\u636e\u56fe\u8868xml")
    public void exportXml(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="ids", value="\u6570\u636e\u56fe\u8868id", required=true) @RequestParam String ids) throws Exception {
        response.setContentType("APPLICATION/OCTET-STREAM");
        if (BeanUtils.isNotEmpty((Object)ids)) {
            String[] stringsIds = ids.split(",");
            List<String> list = Arrays.asList(stringsIds);
            String zipName = "ht_customChart_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmmss");
            Map<String, String> strXml = ((CustomChartManager)this.baseService).exportData(list);
            HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, strXml, (String)zipName);
        }
    }

    @RequestMapping(value={"import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6570\u636e\u56fe\u8868\u5bfc\u5165", httpMethod="POST", notes="\u6570\u636e\u56fe\u8868\u5bfc\u5165")
    public CommonResult<String> importData(MultipartHttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String msg;
            CommonResult message = new CommonResult("\u5bfc\u5165\u6210\u529f");
            ((CustomChartManager)this.baseService).importData(request.getFile("file"));
            LinkedHashSet customChartsSaved = ThreadMsgUtil.getMapMsg2((String)"customChartsSaved");
            LinkedHashSet customChartsSkipped = ThreadMsgUtil.getMapMsg2((String)"customChartsSkipped");
            StringBuilder sb = new StringBuilder();
            if (BeanUtils.isNotEmpty((Object)customChartsSkipped)) {
                sb.append("<div style='font-weight:bold;'>\u4ee5\u4e0b\u6570\u636e\u56fe\u8868\u5df2\u5b58\u5728\u6545\u8df3\u8fc7\uff1a</div>");
                msg = String.format("%s", String.join((CharSequence)"", customChartsSkipped));
                sb.append(msg);
            }
            if (StringUtil.isNotEmpty((String)(msg = sb.toString()))) {
                message.setMessage(msg);
            }
            return message;
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @RequestMapping(value={"getById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7id\u83b7\u53d6\u81ea\u5b9a\u4e49\u56fe\u8868", httpMethod="GET", notes="\u901a\u8fc7id\u83b7\u53d6\u81ea\u5b9a\u4e49\u56fe\u8868")
    public CustomChart getCustomChartById(@ApiParam(name="id", value="\u81ea\u5b9a\u4e49\u89c6\u56feid", required=true) @RequestParam String id) throws Exception {
        return (CustomChart)((CustomChartManager)this.baseService).get((Serializable)((Object)id));
    }

    @RequestMapping(value={"getByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7alias\u83b7\u53d6\u81ea\u5b9a\u4e49\u56fe\u8868", httpMethod="GET", notes="\u901a\u8fc7alias\u83b7\u53d6\u81ea\u5b9a\u4e49\u56fe\u8868")
    public CustomChart getCustomChartByAlias(@ApiParam(name="alias", value="\u81ea\u5b9a\u4e49\u56fe\u8868\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"alias_", (Object)alias);
        return (CustomChart)((Object)((CustomChartManager)this.baseService).getOne((Wrapper)queryWrapper, false));
    }
}

