package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 问题类型枚举
 */
@Getter
public enum QuestionTypeEnum {
    /**
     * 单选
     */
    radio("1", "选择题"),

    dx("1", "单选题"),

    multi("2", "多选题"),

    judge("3", "判断题"),

    fillIn("4", "填空题"),

    shortAnswer("5", "简答题"),

    operation("6", "操作题"),

    lst("7", "论述题"),

    ;

    QuestionTypeEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;


    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        QuestionTypeEnum[] values = values();
        for (QuestionTypeEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        QuestionTypeEnum[] values = values();
        for (QuestionTypeEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }
}
