/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.cache.CacheManager;
import com.artfess.base.id.IdGenerator;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.PinyinUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.base.vo.DruidEncryptDTO;
import com.artfess.base.webSocket.PushService;
import com.baomidou.dynamic.datasource.toolkit.CryptoUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/base/tools/v1/"})
@Api(tags={"\u5de5\u5177\u63a5\u53e3"})
@ApiGroup(group={"group_bpm", "group_form", "group_system", "group_uc"})
public class ToolsController {
    @Value(value="${spring.profiles.version:''}")
    String platformVersion;
    @Autowired
    PushService pushService;
    @Resource
    IdGenerator idGenerator;

    @RequestMapping(value={"getPinyin"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u62fc\u97f3", httpMethod="GET", notes="\u83b7\u53d6\u62fc\u97f3")
    public CommonResult<String> getPinyin(@ApiParam(required=true, name="chinese", value="\u4e2d\u6587\u5185\u5bb9") @RequestParam String chinese, @ApiParam(name="type", value="\u7c7b\u578b\u662f1 \u5219\u4e3a\u5168\u62fc\uff0c\u5426\u5219\u4e3a\u9996\u5b57\u6bcd") @RequestParam Optional<Integer> type) throws AuthenticationException {
        Integer ptype = type.orElse(1);
        String pinying = "";
        pinying = ptype == 1 ? PinyinUtil.getPinyin(chinese) : PinyinUtil.getPinYinHeadChar(chinese);
        return new CommonResult<String>(true, "\u83b7\u53d6\u62fc\u97f3\u6210\u529f\uff01", pinying);
    }

    @RequestMapping(value={"getPlatformVersion"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5e73\u53f0\u7248\u672c", httpMethod="GET", notes="\u83b7\u53d6\u5e73\u53f0\u7248\u672c")
    public CommonResult<String> getPlatformVersion() {
        return new CommonResult<String>(true, "", this.platformVersion);
    }

    @RequestMapping(value={"encryptDbPassword"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u5e93\u5bc6\u7801\u52a0\u5bc6\u5b57\u7b26\u4e32", httpMethod="POST", notes="\u83b7\u53d6\u6570\u636e\u5e93\u5bc6\u7801\u52a0\u5bc6\u4fe1\u606f")
    public CommonResult<DruidEncryptDTO> encryptDbPassword(@ApiParam(required=true, name="password", value="\u5f85\u52a0\u5bc6\u5bc6\u7801") @RequestBody Map<String, String> map) throws Exception {
        String[] arr = CryptoUtils.genKeyPair((int)512);
        DruidEncryptDTO druidEncryptDTO = new DruidEncryptDTO();
        druidEncryptDTO.setPassword(CryptoUtils.encrypt((String)arr[0], (String)map.get("password")));
        druidEncryptDTO.setPublicKey(arr[1]);
        return new CommonResult<DruidEncryptDTO>(true, "\u83b7\u53d6\u62fc\u97f3\u6210\u529f\uff01", druidEncryptDTO);
    }

    @RequestMapping(value={"clearCacheByKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7f13\u5b58key\u6e05\u9664\u7f13\u5b58", httpMethod="GET", notes="\u6839\u636e\u7f13\u5b58key\u6e05\u9664\u7f13\u5b58")
    public CommonResult<String> clearCacheByKey(@ApiParam(required=true, name="key", value="\u7f13\u5b58key") @RequestParam String key) throws AuthenticationException {
        CacheManager manager = AppUtil.getBean(CacheManager.class);
        manager.clearCascadeByKey(key);
        return new CommonResult<String>(true, "\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"getCurrentDate"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u670d\u52a1\u5668\u7684\u65f6\u95f4", httpMethod="GET", notes="\u83b7\u53d6\u5f53\u524d\u670d\u52a1\u5668\u7684\u65f6\u95f4")
    public CommonResult<String> getCurrentDate(@ApiParam(required=true, name="valFormat", value="\u65e5\u671f\u683c\u5f0f") @RequestParam String valFormat) throws AuthenticationException {
        String date = DateUtil.getCurrentTime(valFormat);
        return new CommonResult<String>(true, "\u83b7\u53d6\u6210\u529f", date);
    }

    @PostMapping(value={"/webSocket/sendAll"})
    @ApiOperation(value="websocket\u7fa4\u53d1\u6d88\u606f")
    public CommonResult<String> sendAll(@RequestBody ObjectNode jsonObject) throws Exception {
        String message = jsonObject.get("message").asText();
        ObjectNode obj = JsonUtil.getMapper().createObjectNode();
        obj.put("cmd", "topic");
        obj.put("msgId", this.idGenerator.nextId());
        obj.put("msgTxt", message);
        this.pushService.pushMsgToAll(obj.toString());
        return new CommonResult<String>("\u7fa4\u53d1\uff01");
    }

    @PostMapping(value={"/webSocket/sendUser"})
    @ApiOperation(value="websocket\u5355\u53d1\u6d88\u606f")
    public CommonResult<String> sendUser(@RequestBody ObjectNode jsonObject) throws Exception {
        String userId = JsonUtil.getString((JsonNode)jsonObject, "userId");
        String message = JsonUtil.getString((JsonNode)jsonObject, "message");
        ObjectNode obj = JsonUtil.getMapper().createObjectNode();
        obj.put("cmd", "user");
        obj.put("userId", userId);
        obj.put("msgId", this.idGenerator.nextId());
        obj.put("msgTxt", message);
        this.pushService.pushMsgToAccount(userId, obj.toString());
        return new CommonResult<String>("\u5355\u53d1\uff01");
    }
}

