/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.jwt;

import com.artfess.base.cache.annotation.CacheEvict;
import com.artfess.base.cache.annotation.CachePut;
import com.artfess.base.cache.annotation.Cacheable;
import com.artfess.base.cache.annotation.FirstCache;
import com.artfess.base.cache.annotation.SecondaryCache;
import com.artfess.base.conf.JwtConfig;
import com.artfess.base.context.BaseContext;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Clock;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.impl.DefaultClock;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Resource;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class JwtTokenHandler
implements Serializable {
    @Resource
    JwtConfig jwtConfig;
    static final String CLAIM_KEY_USERNAME = "sub";
    static final String CLAIM_KEY_CREATED = "iat";
    private static final long serialVersionUID = -3301605591108950415L;
    private Clock clock = DefaultClock.INSTANCE;

    public String getUsernameFromToken(String token) {
        return this.getClaimFromToken(token, Claims::getSubject);
    }

    public Date getIssuedAtDateFromToken(String token) {
        return this.getClaimFromToken(token, Claims::getIssuedAt);
    }

    public Date getExpirationDateFromToken(String token) {
        return this.getClaimFromToken(token, Claims::getExpiration);
    }

    public <T> T getClaimFromToken(String token, Function<Claims, T> claimsResolver) {
        Claims claims = this.getAllClaimsFromToken(token);
        return claimsResolver.apply(claims);
    }

    private Claims getAllClaimsFromToken(String token) {
        return (Claims)Jwts.parser().setSigningKey(this.jwtConfig.getSecret()).parseClaimsJws(token).getBody();
    }

    public Boolean isTokenExpired(String token) {
        Date expiration = this.getExpirationDateFromToken(token);
        return expiration.before(this.clock.now());
    }

    private Boolean isCreatedBeforeLastPasswordReset(Date created, Date lastPasswordReset) {
        return lastPasswordReset != null && created.before(lastPasswordReset);
    }

    private Boolean ignoreTokenExpiration(String token) {
        return false;
    }

    public String generateToken(String userAccount) {
        IUserService userService = AppUtil.getBean(IUserService.class);
        IUser userByAccount = userService.getUserByAccount(userAccount);
        Assert.notNull((Object)userByAccount, (String)String.format("\u6839\u636e\u6240\u4f20\u8d26\u53f7\u3010%s\u3011\u672a\u67e5\u8be2\u5230\u7528\u6237", userAccount));
        return this.generateToken((UserDetails)userByAccount);
    }

    public String generateToken(UserDetails userDetails) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        String tenantId = "";
        String userId = "";
        if (userDetails instanceof IUser) {
            IUser iUser = (IUser)userDetails;
            tenantId = iUser.getTenantId();
            userId = iUser.getUserId();
        }
        claims.put("tenantId", tenantId);
        claims.put("userId", userId);
        return this.doGenerateToken(claims, userDetails.getUsername());
    }

    private String doGenerateToken(Map<String, Object> claims, String subject) {
        Date createdDate = this.clock.now();
        Date expirationDate = this.calculateExpirationDate(createdDate);
        return Jwts.builder().setClaims(claims).setSubject(subject).setIssuedAt(createdDate).setExpiration(expirationDate).signWith(SignatureAlgorithm.HS512, this.jwtConfig.getSecret()).compact();
    }

    public Boolean canTokenBeRefreshed(String token, Date lastPasswordReset) {
        Date created = this.getIssuedAtDateFromToken(token);
        return this.isCreatedBeforeLastPasswordReset(created, lastPasswordReset) == false && (this.isTokenExpired(token) == false || this.ignoreTokenExpiration(token) != false);
    }

    public String refreshToken(String token) {
        Date createdDate = this.clock.now();
        Date expirationDate = this.calculateExpirationDate(createdDate);
        Claims claims = this.getAllClaimsFromToken(token);
        claims.setIssuedAt(createdDate);
        claims.setExpiration(expirationDate);
        return Jwts.builder().setClaims(claims).signWith(SignatureAlgorithm.HS512, this.jwtConfig.getSecret()).compact();
    }

    public Boolean validateToken(String token, UserDetails userDetails) {
        String username = this.getUsernameFromToken(token);
        Date created = this.getIssuedAtDateFromToken(token);
        return username.equals(userDetails.getUsername()) && this.isTokenExpired(token) == false;
    }

    private Date calculateExpirationDate(Date createdDate) {
        return new Date(createdDate.getTime() + (long)(this.jwtConfig.getExpiration() * 1000));
    }

    public String getTenantIdFromToken(String authToken) {
        Claims allClaimsFromToken = this.getAllClaimsFromToken(authToken);
        String tenantId = (String)allClaimsFromToken.get("tenantId", String.class);
        return tenantId;
    }

    public String getUserIdFromToken(String authToken) {
        Claims allClaimsFromToken = this.getAllClaimsFromToken(authToken);
        String userId = (String)allClaimsFromToken.get("userId", String.class);
        return userId;
    }

    public String generateFeignToken() {
        BaseContext baseContext = AppUtil.getBean(BaseContext.class);
        HashMap<String, Object> claims = new HashMap<String, Object>();
        String currentUserId = baseContext.getCurrentUserId();
        String currentUserAccout = baseContext.getCurrentUserAccout();
        if ("-1".equals(currentUserAccout) || StringUtil.isEmpty(currentUserAccout)) {
            currentUserAccout = "admin";
        }
        String tenantId = baseContext.getCurrentTenantId();
        claims.put("userId", currentUserId);
        claims.put("tenantId", tenantId);
        return this.doGenerateFeignToken(claims, currentUserAccout);
    }

    private String doGenerateFeignToken(Map<String, Object> claims, String subject) {
        Date createdDate = this.clock.now();
        Date expirationDate = this.calculateFeignExpirationDate(createdDate);
        return Jwts.builder().setClaims(claims).setSubject(subject).setIssuedAt(createdDate).setExpiration(expirationDate).signWith(SignatureAlgorithm.HS512, this.jwtConfig.getSecret()).compact();
    }

    public Boolean validateFeignToken(String token) {
        String username = this.getUsernameFromToken(token);
        BaseContext baseContext = AppUtil.getBean(BaseContext.class);
        Date created = this.getIssuedAtDateFromToken(token);
        return username.equals(baseContext.getCurrentUserAccout()) && this.isTokenExpired(token) == false;
    }

    private Date calculateFeignExpirationDate(Date createdDate) {
        return new Date(createdDate.getTime() + (long)(this.jwtConfig.getExpiration() * 1000));
    }

    @Cacheable(value={"bpm:uc:userToken"}, key="#userAgent+'_'+#tenantId+'_'+#account", ignoreException=false, firstCache=@FirstCache(expireTime=1800, expireTimeExp="#expireTime", timeUnit=TimeUnit.SECONDS), secondaryCache=@SecondaryCache(expireTime=1800, expireTimeExp="#expireTime", preloadTime=360, forceRefresh=true, timeUnit=TimeUnit.SECONDS))
    public String getTokenFromCache(String userAgent, String tenantId, String account, int expireTime) {
        return null;
    }

    @CachePut(value={"bpm:uc:userToken"}, key="#userAgent+'_'+#tenantId+'_'+#account", ignoreException=false, firstCache=@FirstCache(expireTime=1800, expireTimeExp="#expireTime", timeUnit=TimeUnit.SECONDS), secondaryCache=@SecondaryCache(expireTime=1800, expireTimeExp="#expireTime", preloadTime=360, forceRefresh=true, timeUnit=TimeUnit.SECONDS))
    public String putTokenInCache(String userAgent, String tenantId, String account, int expireTime, String token) {
        return token;
    }

    @CacheEvict(value={"bpm:uc:userToken"}, key="#userAgent+'_'+#tenantId+'_'+#account", ignoreException=false)
    public void removeFromCache(String userAgent, String tenantId, String account) {
    }

    @CachePut(value={"bpm:uc:userToken"}, key="#userAgent+'_'+#tenantId+'_'+#account+'_'+#ip", ignoreException=false, firstCache=@FirstCache(expireTime=1800, expireTimeExp="#expireTime", timeUnit=TimeUnit.SECONDS), secondaryCache=@SecondaryCache(expireTime=1800, expireTimeExp="#expireTime", preloadTime=360, forceRefresh=true, timeUnit=TimeUnit.SECONDS))
    public String putTokenInCache(String userAgent, String tenantId, String account, String ip, int expireTime, String token) {
        return token;
    }

    @CacheEvict(value={"bpm:uc:userToken"}, key="#userAgent+'_'+#tenantId+'_'+#account+'_'+#ip", ignoreException=false)
    public void removeFromCache(String userAgent, String tenantId, String account, String ip) {
    }
}

