/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.security;

import com.artfess.base.cache.annotation.CachePut;
import com.artfess.base.jwt.JwtTokenHandler;
import com.artfess.base.security.MethodAuthService;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.ContextThread;
import com.artfess.base.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpMethod;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.stereotype.Service;

@Service
public class HtInvocationSecurityMetadataSourceService
implements FilterInvocationSecurityMetadataSource,
ContextThread {
    private static ThreadLocal<HashMap<String, Collection<ConfigAttribute>>> mapThreadLocal = new ThreadLocal();
    @Resource
    private MethodAuthService methodAuthService;
    @Resource
    JwtTokenHandler jwtTokenHandler;

    public void loadResourceDefine() {
        HashMap<String, Collection<ConfigAttribute>> map = HtInvocationSecurityMetadataSourceService.getMapThreadLocal();
        List<HashMap<String, String>> methodAuth = this.methodAuthService.getMethodAuth();
        if (BeanUtils.isEmpty(methodAuth)) {
            return;
        }
        for (HashMap<String, String> mapAuth : methodAuth) {
            Collection<Object> array = new ArrayList<SecurityConfig>();
            String roleAlias = mapAuth.get("roleAlias");
            String key = mapAuth.get("methodRequestUrl");
            if (StringUtil.isEmpty(roleAlias) || StringUtil.isEmpty(key)) continue;
            SecurityConfig cfg = new SecurityConfig(roleAlias);
            if (map.containsKey(key)) {
                array = map.get(key);
            }
            array.add(cfg);
            map.put(key, array);
        }
    }

    @CachePut(value={"bpm:sys:dataPermission"}, key="#key")
    protected String putDataPermissionInCache(String key, String data) {
        return data;
    }

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (AuthenticationUtil.isAnonymous(authentication)) {
            return null;
        }
        HttpServletRequest request = ((FilterInvocation)object).getHttpRequest();
        String requestHeader = request.getHeader("Proxy-Authorization");
        if (StringUtil.isNotEmpty(requestHeader) && requestHeader.startsWith("Bearer ") && this.jwtTokenHandler.validateFeignToken(requestHeader.substring(7)).booleanValue()) {
            return null;
        }
        if (object instanceof FilterInvocation) {
            FilterInvocation filterInvocation = (FilterInvocation)object;
            String method = filterInvocation.getRequest().getMethod();
            String resUrl = filterInvocation.getRequestUrl();
            if (HttpMethod.OPTIONS.matches(method)) {
                return null;
            }
        }
        this.loadResourceDefine();
        HashMap<String, Collection<ConfigAttribute>> map = HtInvocationSecurityMetadataSourceService.getMapThreadLocal();
        for (String resUrl : map.keySet()) {
            AntPathRequestMatcher matcher = new AntPathRequestMatcher(resUrl);
            if (!matcher.matches(request)) continue;
            return map.get(resUrl);
        }
        return null;
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return Collections.emptyList();
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }

    private static HashMap<String, Collection<ConfigAttribute>> getMapThreadLocal() {
        HashMap<String, Collection<Object>> hashMap = mapThreadLocal.get();
        if (BeanUtils.isEmpty(hashMap)) {
            hashMap = new HashMap();
            mapThreadLocal.set(hashMap);
        }
        return hashMap;
    }

    public static void clearMapThreadLocal() {
        HashMap<String, Collection<ConfigAttribute>> hashMap = mapThreadLocal.get();
        if (hashMap != null) {
            hashMap.clear();
        }
    }

    @Override
    public void cleanAll() {
        HtInvocationSecurityMetadataSourceService.clearMapThreadLocal();
    }
}

