/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.datasource;

import com.artfess.base.datasource.impl.DefaultDatabaseContext;
import com.artfess.base.handler.MultiTenantHandler;
import com.artfess.base.interceptor.MasterSlaveAutoRoutingPlugin;
import com.artfess.base.util.AppUtil;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import org.springframework.jdbc.core.JdbcTemplate;

public class DatabaseSwitchResult
implements AutoCloseable {
    private String previewDsAlias;
    private String currentDsAlias;
    private String dbType;

    public DatabaseSwitchResult(String previewDsAlias, String currentDsAlias, String dbType) {
        this.setPreviewDsAlias(previewDsAlias);
        this.setCurrentDsAlias(currentDsAlias);
        this.setDbType(dbType);
    }

    @Override
    public void close() throws Exception {
        if ("LOCAL".equals(this.previewDsAlias) && "LOCAL".equals(this.currentDsAlias)) {
            return;
        }
        DynamicDataSourceContextHolder.clear();
        DefaultDatabaseContext context = AppUtil.getBean(DefaultDatabaseContext.class);
        context.clear();
        JdbcTemplate jdbcTemplate = AppUtil.getBean(JdbcTemplate.class);
        jdbcTemplate.setDataSource(context.getDataSource());
        MasterSlaveAutoRoutingPlugin.removeInExternalDatasource();
        MultiTenantHandler.removeThreadLocalIgnore();
    }

    public String getPreviewDsAlias() {
        return this.previewDsAlias;
    }

    public void setPreviewDsAlias(String previewDsAlias) {
        this.previewDsAlias = previewDsAlias;
    }

    public String getCurrentDsAlias() {
        return this.currentDsAlias;
    }

    public void setCurrentDsAlias(String currentDsAlias) {
        this.currentDsAlias = currentDsAlias;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }
}

