/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.application.jms;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.ExceptionUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.sysConfig.service.SysLoginLogsBatchService;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.annotation.Resource;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"jms.enable"}, matchIfMissing=true)
public class JmsSysLoginLogConsumer {
    private static final Logger logger = LoggerFactory.getLogger(JmsSysLoginLogConsumer.class);
    @Resource
    SysLoginLogsBatchService sysLoginLogsBatchService;

    @JmsListener(destination="sysLoginQueue", containerFactory="jmsListenerContainerQueue")
    public void receiveQueue(Object model) {
        logger.debug("[JMS]: queue message is :" + model.getClass().getName() + "---" + model);
        this.handlerSysLog(model);
    }

    private void handlerSysLog(Object source) {
        if (BeanUtils.isEmpty((Object)source) || !(source instanceof TextMessage)) {
            return;
        }
        TextMessage textMsg = (TextMessage)source;
        try {
            ObjectNode objectNode;
            String type;
            String text = textMsg.getText();
            JsonNode jsonNode = JsonUtil.toJsonNode((String)text);
            if (BeanUtils.isNotEmpty((Object)jsonNode) && jsonNode.isObject() && "sysLog".equals(type = JsonUtil.getString((JsonNode)(objectNode = (ObjectNode)jsonNode), (String)"type"))) {
                this.sysLoginLogsBatchService.reader(objectNode);
                logger.debug("\u767b\u5f55\u65e5\u5fd7: " + JsonUtil.toJsonString((Object)objectNode));
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtil.getExceptionMessage((Throwable)e));
        }
    }
}

