/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.application.job;

import com.artfess.base.util.AppUtil;
import com.artfess.job.model.BaseJob;
import com.artfess.sysConfig.persistence.manager.SysErrorLogsManager;
import com.artfess.sysConfig.persistence.manager.SysLoginLogsManager;
import com.artfess.sysConfig.persistence.manager.SysLogsManager;
import com.artfess.sysConfig.persistence.manager.SysLogsSettingsManager;
import com.artfess.sysConfig.persistence.model.SysLogsSettings;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.quartz.JobExecutionContext;

public class SysLogsJob
extends BaseJob {
    public void executeJob(JobExecutionContext context) throws Exception {
        SysLogsManager sysLogsManager = (SysLogsManager)AppUtil.getBean(SysLogsManager.class);
        SysLoginLogsManager sysLoginLogsManager = (SysLoginLogsManager)AppUtil.getBean(SysLoginLogsManager.class);
        SysErrorLogsManager sysErrorLogsManager = (SysErrorLogsManager)AppUtil.getBean(SysErrorLogsManager.class);
        SysLogsSettingsManager sysLogsSettingsManager = (SysLogsSettingsManager)AppUtil.getBean(SysLogsSettingsManager.class);
        List allList = sysLogsSettingsManager.list();
        if (null != allList && allList.size() > 0) {
            ArrayList optLogsParams = new ArrayList();
            ArrayList errorLogsParams = new ArrayList();
            ArrayList loginLogsParams = new ArrayList();
            for (SysLogsSettings settings : allList) {
                HashMap<String, Object> map;
                if (null == settings || !"1".equals(settings.getStatus())) continue;
                if (settings.getLogType() == 3) {
                    map = new HashMap<String, Object>();
                    map.put("executionTime", LocalDateTime.now().minusDays(settings.getSaveDays().intValue()));
                    map.put("moduleType", settings.getModuleType());
                    optLogsParams.add(map);
                }
                if (settings.getLogType() == 1) {
                    map = new HashMap();
                    map.put("executionTime", LocalDateTime.now().minusDays(settings.getSaveDays().intValue()));
                    loginLogsParams.add(map);
                }
                if (settings.getLogType() != 2) continue;
                map = new HashMap();
                map.put("executionTime", LocalDateTime.now().minusDays(settings.getSaveDays().intValue()));
                errorLogsParams.add(map);
            }
            if (optLogsParams.size() > 0) {
                sysLogsManager.removeByEexcutionTime(optLogsParams);
            }
            if (loginLogsParams.size() > 0) {
                sysLoginLogsManager.removeByEexcutionTime(loginLogsParams);
            }
            if (errorLogsParams.size() > 0) {
                sysErrorLogsManager.removeByEexcutionTime(errorLogsParams);
            }
        }
    }
}

