/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bo.instance.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.bo.exception.BoBaseException;
import com.artfess.bo.instance.DataTransform;
import com.artfess.bo.instance.impl.AbstractBoDataHandler;
import com.artfess.bo.model.BoData;
import com.artfess.bo.model.BoDef;
import com.artfess.bo.model.BoEnt;
import com.artfess.bo.model.BoInst;
import com.artfess.bo.model.BoResult;
import com.artfess.bo.persistence.dao.BoInstDao;
import com.artfess.bo.persistence.manager.BoDefManager;
import com.artfess.bo.util.BoUtil;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BoInstHandler
extends AbstractBoDataHandler {
    @Resource
    BoInstDao boInstDao;
    @Resource
    DataTransform dataTransform;
    @Resource
    BoDefManager boDefManager;

    private void setId(BoData curData, boolean isAdd) {
        if (isAdd) {
            curData.set("uuid_", UUID.randomUUID().toString());
        } else if (!curData.containKey("uuid_")) {
            curData.set("uuid_", UUID.randomUUID().toString());
        }
    }

    @Override
    public List<BoResult> save(String id, String defId, BoData curData) throws IOException {
        List<BoData> list;
        curData.removeByKey("initData");
        boolean isAdd = StringUtil.isEmpty((String)id);
        this.setId(curData, isAdd);
        Map<String, List<BoData>> map = curData.getSubMap();
        for (Map.Entry<String, List<BoData>> ent : map.entrySet()) {
            list = ent.getValue();
            for (BoData bo : list) {
                this.setId(bo, isAdd);
            }
        }
        String json = this.dataTransform.getByData(curData, false);
        BoInst inst = null;
        if (isAdd) {
            String pk = UniqueIdUtil.getSuid();
            inst = new BoInst();
            inst.setId(pk);
            inst.setDefId(defId);
            inst.setInstData(json);
            inst.setCreateTime(LocalDateTime.now());
            this.boInstDao.insert((Object)inst);
        } else {
            inst = (BoInst)((Object)this.boInstDao.selectById((Serializable)((Object)id)));
            inst.setInstData(json);
            this.boInstDao.updateById((Object)inst);
        }
        list = new ArrayList<BoData>();
        BoResult result = new BoResult();
        String action = isAdd ? "add" : "upd";
        result.setAction(action);
        result.setPk(inst.getId());
        result.setBoEnt(curData.getBoEnt());
        list.add((BoData)((Object)result));
        if (curData.getBoDef() == null) {
            BoDef boDef = this.boDefManager.getByDefId(defId);
            curData.setBoDef(boDef);
        }
        this.setBoDefAlias(list, curData.getBoDef().getAlias());
        return list;
    }

    @Override
    public BoData getById(Object id, String bodefCode) throws IOException {
        BoDef boDef = this.boDefManager.getByAlias(bodefCode);
        BoEnt boEnt = boDef.getBoEnt();
        BoInst inst = (BoInst)((Object)this.boInstDao.selectById((Serializable)((Object)((String)id))));
        String json = inst.getInstData();
        JsonNode jsonObj = JsonUtil.toJsonNode((String)json);
        BoData data = BoUtil.transJSON(jsonObj);
        data.setBoDef(boDef);
        data.setBoEnt(boEnt);
        this.setInitData(data, boEnt);
        return data;
    }

    private void setInitData(BoData data, BoEnt boEnt) {
        List<BoEnt> list = boEnt.getChildEntList();
        if (BeanUtils.isEmpty(list)) {
            return;
        }
        for (BoEnt ent : list) {
            data.addInitDataMap(ent.getName(), ent.getInitData());
            this.setInitData(data, ent);
        }
    }

    @Override
    public BoData getResById(Object id, String bodefCode) throws IOException {
        return this.getById(id, bodefCode);
    }

    @Override
    public String saveType() {
        return "boObject";
    }

    @Override
    public void removeBoData(String boCode, String[] aryIds) {
        throw new BoBaseException("\u4fdd\u5b58\u5728\u901a\u7528\u5b9e\u4f8b\u8868\u4e2d\u7684bo\u6570\u636e\u4e0d\u652f\u6301\u901a\u8fc7ID\u5220\u9664\u6570\u636e.");
    }

    @Override
    public List<Map<String, Object>> getList(String boCode, Map<String, Object> param) {
        throw new BoBaseException("\u4fdd\u5b58\u5728\u901a\u7528\u5b9e\u4f8b\u8868\u4e2d\u7684bo\u6570\u636e\u4e0d\u652f\u6301\u53c2\u6570\u67e5\u8be2.");
    }

    @Override
    public PageList<Map<String, Object>> getList(String boCode, QueryFilter queryFilter) {
        throw new BoBaseException("\u4fdd\u5b58\u5728\u901a\u7528\u5b9e\u4f8b\u8868\u4e2d\u7684bo\u6570\u636e\u4e0d\u652f\u6301\u53c2\u6570\u53ca\u5206\u9875\u67e5\u8be2.");
    }
}

