/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.util;

import com.artfess.base.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;

public class MySQLUtils {
    public static void initChangeSource(JdbcTemplate template, String user, String pwd, String dbName) {
        MySQLUtils.createDataUser(template, user, pwd);
        MySQLUtils.createDataBase(template, dbName);
        MySQLUtils.createGrant(template, "select,insert,update,create,trigger", dbName, user);
    }

    public static void createDataUser(JdbcTemplate template, String user, String pwd) {
        String sql = "create user " + user + "@'%' IDENTIFIED WITH mysql_native_password BY '" + pwd + "'";
        template.execute(sql);
    }

    public static void dropDataUser(JdbcTemplate template, String user) {
        String sql = "drop user " + user + "@'%'";
        template.execute(sql);
    }

    public static void updateDateUser(JdbcTemplate template, String user, String pwd) {
        String sql = "set password for '" + user + "'@'%' = '" + pwd + "'";
        template.execute(sql);
    }

    public static void createDataBase(JdbcTemplate template, String dbName) {
        String sql = "create database " + dbName;
        template.execute(sql);
    }

    public static void createGrant(JdbcTemplate template, String grant, String dbName, String user) {
        if (StringUtil.isEmpty((String)grant)) {
            grant = "all";
        }
        String sql = "grant " + grant + " on " + dbName + ".* to " + user;
        template.execute(sql);
    }

    public static void createGrant(JdbcTemplate template, String grant, String dbName, String tableName, String user) {
        if (StringUtil.isEmpty((String)grant)) {
            grant = "all";
        }
        String sql = "grant " + grant + " on " + dbName + "." + tableName + " to " + user;
        template.execute(sql);
    }

    public static void revokeGrant(JdbcTemplate template, String grant, String dbName, String tableName, String user) {
        if (StringUtil.isEmpty((String)grant)) {
            grant = "all";
        }
        String sql = "revoke " + grant + " on " + dbName + "." + tableName + " from " + user;
        template.execute(sql);
    }

    public static void removeBaseUser(JdbcTemplate template, String dbName, String user) {
        String sql = "drop database " + dbName;
        template.execute(sql);
        String sqlUser = "drop user " + user;
        template.execute(sqlUser);
    }

    public static Map<String, String> createTiger(JdbcTemplate template, String tableName, String companyName, String sysName, String sysCode, String name, String code) {
        HashMap<String, String> map = new HashMap<String, String>();
        String insertTigerSql = MySQLUtils.initTriggerSql(tableName, companyName, sysName, sysCode, name, code, "INSERT", "1");
        template.execute("drop trigger if exists " + tableName + "_INSERT_tiger");
        template.execute(insertTigerSql);
        map.put("insert", insertTigerSql);
        String insertUpdateSql = MySQLUtils.initTriggerSql(tableName, companyName, sysName, sysCode, name, code, "UPDATE", "2");
        template.execute("drop trigger if exists " + tableName + "_UPDATE_tiger");
        template.execute(insertUpdateSql);
        map.put("update", insertUpdateSql);
        String insertDelSql = MySQLUtils.initTriggerSql(tableName, companyName, sysName, sysCode, name, code, "DELETE", "3");
        template.execute("drop trigger if exists " + tableName + "_DELETE_tiger");
        template.execute(insertDelSql);
        map.put("delete", insertDelSql);
        return map;
    }

    public static String initTriggerSql(String tableName, String companyName, String sysName, String sysCode, String name, String code, String type, String typeIndex) {
        String triggerSql = "CREATE TRIGGER " + tableName + "_" + type + "_tiger \n" + "    AFTER " + type + "  ON " + tableName + " FOR EACH ROW  \n" + "         BEGIN  \n" + "        insert into BIZ_CLUSTER_COLLECT_DATA(id_,COMPANY_NAME_,SYS_NAME_,SYS_CODE_,NAME_,CODE_,TABLE_NAME_,SRC_ID_,DATA_TYPE_,CREATE_TIME_) " + "           values(uuid(),'" + companyName + "','" + sysName + "','" + sysCode + "','" + name + "','" + code + "','" + tableName + "',new.id_," + typeIndex + ",now());\n" + "        insert into BIZ_CLUSTER_TEMP_DATA(id_,COMPANY_NAME_,SYS_NAME_,SYS_CODE_,NAME_,CODE_,TABLE_NAME_,SRC_ID_,DATA_TYPE_,CREATE_TIME_) " + "           values(uuid(),'" + companyName + "','" + sysName + "','" + sysCode + "','" + name + "','" + code + "','" + tableName + "',new.id_," + typeIndex + ",now());\n" + "        END";
        if ("DELETE".equals(type)) {
            triggerSql = "CREATE TRIGGER " + tableName + "_" + type + "_tiger \n" + "    AFTER " + type + "  ON " + tableName + " FOR EACH ROW  \n" + "         BEGIN  \n" + "        insert into BIZ_CLUSTER_COLLECT_DATA(id_,COMPANY_NAME_,SYS_NAME_,SYS_CODE_,NAME_,CODE_,TABLE_NAME_,SRC_ID_,DATA_TYPE_,CREATE_TIME_) " + "           values(uuid(),'" + companyName + "','" + sysName + "','" + sysCode + "','" + name + "','" + code + "','" + tableName + "',old.id_," + typeIndex + ",now());\n" + "        insert into BIZ_CLUSTER_TEMP_DATA(id_,COMPANY_NAME_,SYS_NAME_,SYS_CODE_,NAME_,CODE_,TABLE_NAME_,SRC_ID_,DATA_TYPE_,CREATE_TIME_) " + "           values(uuid(),'" + companyName + "','" + sysName + "','" + sysCode + "','" + name + "','" + code + "','" + tableName + "',old.id_," + typeIndex + ",now());\n" + "        END";
        }
        return triggerSql;
    }

    public static void createCollectTable(JdbcTemplate template) {
        String tempTable = "create table BIZ_CLUSTER_TEMP_DATA\n(\n   ID_                  VARCHAR(64) not null,\n   COMPANY_NAME_        VARCHAR(120) not null default '' comment '\u5355\u4f4d\u540d\u79f0',\n   SYS_NAME_            VARCHAR(120) comment '\u7cfb\u7edf\u540d\u79f0',\n   SYS_CODE_            VARCHAR(120) comment '\u7cfb\u7edf\u7f16\u7801',\n   NAME_                varchar(64) default null comment '\u6570\u636e\u8d44\u6e90\u9879\u540d\u79f0',\n   CODE_                varchar(64) comment '\u6570\u636e\u8d44\u6e90\u9879\u7f16\u7801',\n   TABLE_NAME_          VARCHAR(64) comment '\u6570\u636e\u8868\u540d',\n   SRC_ID_              VARCHAR(64) default '' comment '\u6570\u636e\u8868ID',\n   DATA_TYPE_           int default NULL comment '\u6570\u636e\u64cd\u4f5c\u6807\u8bb0\uff081\uff1a\u65b0\u589e\uff0c2\uff1a\u4fee\u6539\uff0c3\uff1a\u5220\u9664\uff09',\n   CREATE_TIME_         datetime default null comment '\u6570\u636e\u64cd\u4f5c\u65f6\u95f4',\n   primary key (ID_)\n)";
        template.execute(tempTable);
        String collectTable = "create table BIZ_CLUSTER_COLLECT_DATA\n(\n   ID_                  VARCHAR(64) not null,\n   COMPANY_NAME_        VARCHAR(120) not null default '' comment '\u5355\u4f4d\u540d\u79f0',\n   SYS_NAME_            VARCHAR(120) comment '\u7cfb\u7edf\u540d\u79f0',\n   SYS_CODE_            VARCHAR(120) comment '\u7cfb\u7edf\u7f16\u7801',\n   NAME_                varchar(64) default NULL comment '\u6570\u636e\u8d44\u6e90\u9879\u540d\u79f0',\n   CODE_                varchar(64) comment '\u6570\u636e\u8d44\u6e90\u9879\u7f16\u7801',\n   TABLE_NAME_          VARCHAR(64) comment '\u6570\u636e\u8868\u540d',\n   SRC_ID_              VARCHAR(64) default NULL comment '\u6570\u636e\u8868ID',\n   DATA_TYPE_           int default NULL comment '\u6570\u636e\u64cd\u4f5c\u6807\u8bb0\uff081\uff1a\u65b0\u589e\uff0c2\uff1a\u4fee\u6539\uff0c3\uff1a\u5220\u9664\uff09',\n   CREATE_TIME_         datetime default null comment '\u6570\u636e\u64cd\u4f5c\u65f6\u95f4',\n   primary key (ID_)\n)";
        template.execute(collectTable);
    }
}

