/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataShare.manager.impl;

import com.alibaba.fastjson.JSONArray;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.dataShare.dataApi.vo.RespParamVo;
import com.artfess.dataShare.dataShare.dao.BizShareApiDao;
import com.artfess.dataShare.dataShare.manager.BizShareApiManager;
import com.artfess.dataShare.dataShare.manager.BizShareTableManager;
import com.artfess.dataShare.dataShare.model.BizShareApi;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class BizShareApiManagerImpl
extends BaseManagerImpl<BizShareApiDao, BizShareApi>
implements BizShareApiManager {
    @Resource
    private RestTemplate restTemplate;
    @Resource
    private BizShareTableManager tableManager;
    @Value(value="${dataShare-api.url.shareApi.register}")
    private String SHAREAPI_REGISTER_URL;
    @Value(value="${dataShare-api.url.shareApi.checkSqlValidity}")
    private String SHAREAPI_CHECKSQLVALIDITY_URL;
    @Value(value="${dataShare-api.url.shareApi.unregister}")
    private String SHAREAPI_UNREGISTER_URL;
    @Value(value="${dataShare-api.url.shareApi.updateServiceApi}")
    private String SHAREAPI_UPDATESERVICEAPI_URL;
    @Value(value="${dataShare-api.url.shareApi.query}")
    private String SHAREAPI_QUERY_URL;
    @Value(value="${dataShare-api.url.shareApi.getInfo}")
    private String SHAREAPI_GETINFO_URL;
    @Value(value="${dataShare-api.url.shareApi.checkApi}")
    private String SHAREAPI_CHECKAPI_URL;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean register(BizShareApi shareApi) {
        shareApi.setApiUrl("/shareApi" + shareApi.getApiUrl());
        shareApi.setIsDele("0");
        shareApi.setStatus("0");
        boolean status = this.registerToDB(shareApi);
        return status;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean publish(String id) {
        BizShareApi shareApi = (BizShareApi)this.get((Serializable)((Object)id));
        int count = 0;
        if (BeanUtils.isNotEmpty((Object)((Object)shareApi))) {
            shareApi.setStatus("1");
            count = ((BizShareApiDao)this.baseMapper).updateById((Object)shareApi);
        }
        CommonResult commonResult = new CommonResult(ResponseErrorEnums.FAIL_OPTION);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)shareApi, (MultiValueMap)headers);
        commonResult = (CommonResult)this.restTemplate.postForObject(this.SHAREAPI_REGISTER_URL, (Object)request, CommonResult.class, new Object[0]);
        return commonResult.getState();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean soldOut(String id) {
        boolean status = false;
        BizShareApi shareApi = (BizShareApi)this.get((Serializable)((Object)id));
        shareApi.setStatus("0");
        int count = 0;
        if (BeanUtils.isNotEmpty((Object)((Object)shareApi))) {
            count = ((BizShareApiDao)this.baseMapper).updateById((Object)shareApi);
        }
        CommonResult commonResult = new CommonResult(ResponseErrorEnums.FAIL_OPTION);
        if (count > 0) {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            HttpEntity request = new HttpEntity((Object)shareApi, (MultiValueMap)headers);
            commonResult = (CommonResult)this.restTemplate.postForObject(this.SHAREAPI_UNREGISTER_URL, (Object)request, CommonResult.class, new Object[0]);
        }
        if (!commonResult.getState().booleanValue()) {
            status = false;
            throw new ApplicationException(commonResult.getMessage());
        }
        status = commonResult.getState();
        return status;
    }

    @Override
    public boolean checkApiValidity(BizShareApi shareApi) {
        return this.checkApiInDB(shareApi) && this.checkApiInSpring(shareApi);
    }

    private boolean checkApiInSpring(BizShareApi shareApi) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)shareApi, (MultiValueMap)headers);
        CommonResult commonResult = (CommonResult)this.restTemplate.postForObject(this.SHAREAPI_CHECKAPI_URL, (Object)request, CommonResult.class, new Object[0]);
        return commonResult.getState();
    }

    public boolean checkApiInDB(BizShareApi serviceApi) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BizShareApi::getApiUrl, (Object)serviceApi.getApiUrl());
        queryWrapper.eq(BizShareApi::getApiMode, (Object)serviceApi.getApiMode());
        return this.count((Wrapper)queryWrapper) == 0;
    }

    @Override
    public boolean checkSqlValidity(BizShareApi shareApi) throws SQLException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)shareApi, (MultiValueMap)headers);
        CommonResult commonResult = (CommonResult)this.restTemplate.postForObject(this.SHAREAPI_CHECKSQLVALIDITY_URL, (Object)request, CommonResult.class, new Object[0]);
        return commonResult.getState();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean unregister(String id) {
        BizShareApi shareApi = (BizShareApi)this.get((Serializable)((Object)id));
        boolean status = this.unregisterFromDB(shareApi.getId());
        CommonResult commonResult = new CommonResult(ResponseErrorEnums.FAIL_OPTION);
        if (status) {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            HttpEntity request = new HttpEntity((Object)shareApi, (MultiValueMap)headers);
            commonResult = (CommonResult)this.restTemplate.postForObject(this.SHAREAPI_UNREGISTER_URL, (Object)request, CommonResult.class, new Object[0]);
        }
        if (!commonResult.getState().booleanValue()) {
            status = false;
            throw new ApplicationException();
        }
        status = commonResult.getState();
        return status;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateServiceApi(BizShareApi shareApi) {
        CommonResult commonResult = new CommonResult(ResponseErrorEnums.FAIL_OPTION);
        BizShareApi oldShareApi = (BizShareApi)this.get((Serializable)((Object)shareApi.getId()));
        if (!(oldShareApi.getApiMode().name().equals(shareApi.getApiMode().name()) && oldShareApi.getApiUrl().equals(shareApi.getApiUrl()) || this.checkApiValidity(shareApi))) {
            throw new ApplicationException("\u63a5\u53e3\u5df2\u88ab\u6ce8\u518c\uff01");
        }
        if (!this.checkApiCode(shareApi)) {
            throw new ApplicationException("\u63a5\u53e3\u7f16\u7801\u91cd\u590d\uff01");
        }
        int count = ((BizShareApiDao)this.baseMapper).updateById((Object)shareApi);
        return count > 0;
    }

    @Override
    public PageList<BizShareApi> queryApi(QueryFilter<BizShareApi> queryFilter) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity(queryFilter, (MultiValueMap)headers);
        PageList pageList = (PageList)this.restTemplate.postForObject(this.SHAREAPI_QUERY_URL, (Object)request, PageList.class, new Object[0]);
        return pageList;
    }

    @Override
    public BizShareApi getInfo(String id) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("id", id);
        BizShareApi shareApi = (BizShareApi)((Object)this.restTemplate.getForObject(this.SHAREAPI_GETINFO_URL, BizShareApi.class, param));
        return shareApi;
    }

    @Override
    public BizShareApi viewApiDocument(String id) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("id", id);
        BizShareApi shareApi = (BizShareApi)((Object)this.restTemplate.getForObject(this.SHAREAPI_GETINFO_URL, BizShareApi.class, param));
        String responseExample = shareApi.getResponseExample();
        if (StringUtil.isNotEmpty((String)responseExample)) {
            JSONArray jsonArray = JSONArray.parseArray((String)responseExample);
            Integer size = jsonArray.size();
            RespParamVo respParamVo = new RespParamVo();
            respParamVo.setResultCode("200");
            respParamVo.setMessage("\u6210\u529f");
            respParamVo.setTotalCount(size.toString());
            respParamVo.setCount(size.toString());
            respParamVo.setRows(jsonArray.toJavaList(Object.class));
            shareApi.setRespParamVo(respParamVo);
        }
        return shareApi;
    }

    @Override
    public List<BizShareApi> queryByTableId(String tableId) {
        List list = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizShareApi::getIsDele, (Object)"0")).eq(BizShareApi::getTableId, (Object)tableId));
        return list;
    }

    @Override
    public PageList<BizShareApi> queryPageByCatalog(QueryFilter<BizShareApi> queryFilter, String catalogId, String consumerId) {
        IPage<BizShareApi> iPage = ((BizShareApiDao)this.baseMapper).queryPageByCatalog((IPage<BizShareApi>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizShareApi>)this.convert2Wrapper(queryFilter, this.currentModelClass()), catalogId, consumerId);
        return new PageList(iPage);
    }

    @Override
    public boolean checkApiCode(BizShareApi shareApi) {
        int count;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BizShareApi::getApiCode, (Object)shareApi.getApiCode());
        queryWrapper.and(w -> w.eq(BizShareApi::getApiCode, (Object)shareApi.getApiCode()));
        if (BeanUtils.isNotEmpty((Object)shareApi.getId())) {
            queryWrapper.ne(BizShareApi::getId, (Object)shareApi.getId());
        }
        return (count = this.count((Wrapper)queryWrapper)) <= 0;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean unregisterFromDB(String id) {
        return this.removeById((Serializable)((Object)id));
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean registerToDB(BizShareApi shareApi) {
        if (!this.checkApiValidity(shareApi)) {
            throw new ApplicationException("\u63a5\u53e3\u5df2\u88ab\u6ce8\u518c\uff01");
        }
        if (!this.checkApiCode(shareApi)) {
            throw new ApplicationException("\u63a5\u53e3\u7f16\u7801\u91cd\u590d\uff01");
        }
        return this.save((Object)shareApi);
    }
}

