/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataShare.manager.impl;

import cn.hutool.crypto.digest.DigestUtil;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.dataShare.dataShare.dao.BizShareConsumerDao;
import com.artfess.dataShare.dataShare.dto.ConsumerAuthDto;
import com.artfess.dataShare.dataShare.manager.BizShareAuthManager;
import com.artfess.dataShare.dataShare.manager.BizShareConsumerManager;
import com.artfess.dataShare.dataShare.model.BizShareAuth;
import com.artfess.dataShare.dataShare.model.BizShareConsumer;
import com.artfess.dataShare.util.MySQLUtils;
import com.artfess.redis.util.RedisUtil;
import com.artfess.sysConfig.persistence.manager.SysDataSourceManager;
import com.artfess.sysConfig.persistence.model.SysDataSource;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class BizShareConsumerManagerImpl
extends BaseManagerImpl<BizShareConsumerDao, BizShareConsumer>
implements BizShareConsumerManager {
    private static final String GETTOKEN_URL = "http://26.180.246.242:9157/biz/dataShare/shareConsumer/v1/getToken";
    @Resource
    private RestTemplate restTemplate;
    @Resource
    private SysDataSourceManager dataSourceManager;
    @Resource
    private BizShareAuthManager authManager;
    @Resource
    private RedisUtil redisUtil;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean registerShareConsumer(BizShareConsumer shareConsumer) throws Exception {
        String account = ContextUtil.getCurrentUserAccount();
        if (StringUtils.isEmpty((Object)shareConsumer.getCode())) {
            throw new ApplicationException("\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)shareConsumer.getName())) {
            throw new ApplicationException("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)shareConsumer.getAppName())) {
            throw new ApplicationException("\u7cfb\u7edf\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        int count = this.sameCountShareConsumer(shareConsumer.getCode(), null);
        if (count > 0) {
            throw new ApplicationException("\u9700\u6c42\u65b9\u3010" + shareConsumer.getName() + "\u3011\u5df2\u6709\u76f8\u540c\u7684\u7f16\u7801\u3010" + shareConsumer.getCode() + "\u3011!");
        }
        int result = this.chackConsumer(account);
        shareConsumer.setIsDele("0");
        if ("1".equals(shareConsumer.getIsOpenApi())) {
            shareConsumer.setAccessKey(shareConsumer.getCode());
            String password = shareConsumer.getCode() + BizShareConsumerManagerImpl.randomCode(6) + System.currentTimeMillis();
            shareConsumer.setSecretKey(password);
        }
        if ("1".equals(shareConsumer.getIsOpenDb())) {
            JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)shareConsumer.getDbAlias());
            MySQLUtils.createDataUser(jdbcTemplate, shareConsumer.getDatabaseUser(), shareConsumer.getDatabasePwd());
        }
        shareConsumer.setLoginUser(ContextUtil.getCurrentUserAccount());
        return this.save((Object)shareConsumer);
    }

    private int chackConsumer(String account) {
        return this.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BizShareConsumer::getIsDele, (Object)0)).eq(BizShareConsumer::getLoginUser, (Object)account));
    }

    @Override
    public String getToken(String accessKey, String hashSecretKey) {
        if (StringUtils.isEmpty((Object)accessKey)) {
            throw new ApplicationException("keyID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)accessKey)) {
            throw new ApplicationException("\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BizShareConsumer shareConsumer = this.getByAccessKey(accessKey);
        if (shareConsumer == null) {
            throw new ApplicationException("keyID\u3010" + accessKey + "\u3011\u9519\u8bef\uff01");
        }
        String hashed = this.hashMd5(shareConsumer.getSecretKey());
        if (!hashSecretKey.equals(hashed)) {
            throw new ApplicationException("\u5bc6\u94a5\u5339\u914d\u9519\u8bef!");
        }
        String token = null;
        token = (String)this.redisUtil.get("api:token:" + accessKey);
        if (!StringUtils.isEmpty((Object)token)) {
            return token;
        }
        try {
            String jsonConsumer = JsonUtil.toJson((Object)((Object)shareConsumer));
            token = shareConsumer.getSecretKey() + System.currentTimeMillis() + new Random().nextInt(1000);
            token = new String(DigestUtil.md5((String)token)).replace("/", "*");
            this.redisUtil.set("api:consumer:" + token, (Object)jsonConsumer, 86400L);
            this.redisUtil.set("api:token:" + accessKey, (Object)token, 86400L);
        }
        catch (Exception e) {
            throw new ApplicationException((Throwable)e);
        }
        return token;
    }

    private String hashMd5(String str) {
        return DigestUtils.md5DigestAsHex((byte[])str.getBytes());
    }

    private BizShareConsumer getByAccessKey(String accessKey) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BizShareConsumer::getAccessKey, (Object)accessKey);
        return (BizShareConsumer)((Object)((BizShareConsumerDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(BizShareConsumer consumer) throws Exception {
        if ("1".equals(consumer.getIsOpenApi())) {
            consumer.setAccessKey(consumer.getCode());
            String password = consumer.getCode() + BizShareConsumerManagerImpl.randomCode(6) + System.currentTimeMillis();
            consumer.setSecretKey(password);
        } else {
            consumer.setSecretKey(null);
            consumer.setAccessKey(null);
        }
        if ("1".equals(consumer.getIsOpenDb())) {
            JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)consumer.getDbAlias());
            if (this.checkDataUserIsExist(consumer.getDbAlias(), consumer.getDatabaseUser())) {
                MySQLUtils.createDataUser(jdbcTemplate, consumer.getDatabaseUser(), consumer.getDatabasePwd());
            } else {
                MySQLUtils.updateDateUser(jdbcTemplate, consumer.getDatabaseUser(), consumer.getDatabasePwd());
            }
        } else {
            consumer.setDbAlias(null);
            consumer.setDatabaseUrl(null);
            consumer.setDatabaseType(null);
            consumer.setDatabaseUrl(null);
            consumer.setDatabasePwd(null);
        }
        return this.updateById((Object)consumer);
    }

    @Override
    public boolean checkDataUserIsExist(String dbAlias, String user) throws Exception {
        String sql = "SELECT COUNT(*) FROM mysql.user WHERE user = ?";
        JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)dbAlias);
        Integer count = (Integer)jdbcTemplate.queryForObject(sql, new Object[]{user}, Integer.class);
        return count <= 0;
    }

    @Override
    public BizShareConsumer getInfoById(String id) {
        BizShareConsumer consumer = (BizShareConsumer)this.get((Serializable)((Object)id));
        SysDataSource dataSource = (SysDataSource)this.dataSourceManager.getOne((Wrapper)new LambdaQueryWrapper().eq(SysDataSource::getAlias, (Object)consumer.getDbAlias()));
        if (BeanUtils.isNotEmpty((Object)dataSource)) {
            consumer.setDatabaseId(dataSource.getId());
        }
        return consumer;
    }

    @Override
    public PageList<BizShareConsumer> queryUnAuthByTable(QueryFilter<BizShareConsumer> queryFilter, String tableId) {
        IPage<BizShareConsumer> iPage = ((BizShareConsumerDao)this.baseMapper).queryUnAuthByTable((IPage<BizShareConsumer>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizShareConsumer>)this.convert2Wrapper(queryFilter, this.currentModelClass()), tableId);
        return new PageList(iPage);
    }

    @Override
    public PageList<BizShareConsumer> queryUnAuthByApi(QueryFilter<BizShareConsumer> queryFilter, String tableId, String resourceId) {
        IPage<BizShareConsumer> iPage = ((BizShareConsumerDao)this.baseMapper).queryUnAuthByApi((IPage<BizShareConsumer>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizShareConsumer>)this.convert2Wrapper(queryFilter, this.currentModelClass()), tableId, resourceId);
        return new PageList(iPage);
    }

    @Override
    public PageList<BizShareConsumer> queryUnAuthByFiles(QueryFilter<BizShareConsumer> queryFilter, String tableId, String resourceId) {
        IPage<BizShareConsumer> iPage = ((BizShareConsumerDao)this.baseMapper).queryUnAuthByFiles((IPage<BizShareConsumer>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizShareConsumer>)this.convert2Wrapper(queryFilter, this.currentModelClass()), tableId, resourceId);
        return new PageList(iPage);
    }

    @Override
    public PageList<ConsumerAuthDto> queryAuthByTable(QueryFilter<BizShareConsumer> queryFilter, String tableId) {
        IPage<BizShareAuth> iPage = ((BizShareConsumerDao)this.baseMapper).queryTableAuth((IPage<BizShareConsumer>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizShareConsumer>)this.convert2Wrapper(queryFilter, this.currentModelClass()), tableId);
        PageList pageList = new PageList(iPage);
        ArrayList<ConsumerAuthDto> resultList = new ArrayList<ConsumerAuthDto>();
        List rows = pageList.getRows();
        for (BizShareAuth auth : rows) {
            ConsumerAuthDto consumerAuthDto = new ConsumerAuthDto();
            BizShareConsumer consumer = (BizShareConsumer)this.get((Serializable)((Object)auth.getMemberId()));
            consumerAuthDto.setAuthId(auth.getId());
            consumerAuthDto.setAuthId(auth.getId());
            consumerAuthDto.setConsumerName(consumer.getName());
            consumerAuthDto.setConsumerCode(consumer.getCode());
            resultList.add(consumerAuthDto);
        }
        PageList result = new PageList();
        result.setPage(pageList.getPage());
        result.setPageSize(pageList.getPageSize());
        result.setTotal(pageList.getTotal());
        result.setRows(resultList);
        return result;
    }

    @Override
    public PageList<ConsumerAuthDto> queryAuthByApi(QueryFilter<BizShareConsumer> queryFilter, String tableId, String resourceId) {
        IPage<BizShareAuth> iPage = ((BizShareConsumerDao)this.baseMapper).queryAuthByApi((IPage<BizShareConsumer>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizShareConsumer>)this.convert2Wrapper(queryFilter, this.currentModelClass()), tableId, resourceId);
        PageList pageList = new PageList(iPage);
        ArrayList<ConsumerAuthDto> resultList = new ArrayList<ConsumerAuthDto>();
        List rows = pageList.getRows();
        for (BizShareAuth auth : rows) {
            ConsumerAuthDto consumerAuthDto = new ConsumerAuthDto();
            BizShareConsumer consumer = (BizShareConsumer)this.get((Serializable)((Object)auth.getMemberId()));
            consumerAuthDto.setAuthId(auth.getId());
            consumerAuthDto.setAuthId(auth.getId());
            consumerAuthDto.setConsumerName(consumer.getName());
            consumerAuthDto.setConsumerCode(consumer.getCode());
            resultList.add(consumerAuthDto);
        }
        PageList result = new PageList();
        result.setPage(pageList.getPage());
        result.setPageSize(pageList.getPageSize());
        result.setTotal(pageList.getTotal());
        result.setRows(resultList);
        return result;
    }

    @Override
    public PageList<ConsumerAuthDto> queryAuthByFiles(QueryFilter<BizShareConsumer> queryFilter, String tableId, String resourceId) {
        IPage<BizShareAuth> iPage = ((BizShareConsumerDao)this.baseMapper).queryAuthByFiles((IPage<BizShareConsumer>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizShareConsumer>)this.convert2Wrapper(queryFilter, this.currentModelClass()), tableId, resourceId);
        PageList pageList = new PageList(iPage);
        ArrayList<ConsumerAuthDto> resultList = new ArrayList<ConsumerAuthDto>();
        List rows = pageList.getRows();
        for (BizShareAuth auth : rows) {
            ConsumerAuthDto consumerAuthDto = new ConsumerAuthDto();
            BizShareConsumer consumer = (BizShareConsumer)this.get((Serializable)((Object)auth.getMemberId()));
            consumerAuthDto.setAuthId(auth.getId());
            consumerAuthDto.setAuthId(auth.getId());
            consumerAuthDto.setConsumerName(consumer.getName());
            consumerAuthDto.setConsumerCode(consumer.getCode());
            resultList.add(consumerAuthDto);
        }
        PageList result = new PageList();
        result.setPage(pageList.getPage());
        result.setPageSize(pageList.getPageSize());
        result.setTotal(pageList.getTotal());
        result.setRows(resultList);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean removeConsumer(String id) {
        BizShareConsumer consumer = (BizShareConsumer)this.get((Serializable)((Object)id));
        try {
            if (!this.checkDataUserIsExist(consumer.getDbAlias(), consumer.getDatabaseUser())) {
                JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)consumer.getDbAlias());
                MySQLUtils.dropDataUser(jdbcTemplate, consumer.getDatabaseUser());
            }
        }
        catch (Exception e) {
            throw new ApplicationException("\u6570\u636e\u5e93\u5220\u9664\u5f02\u5e38");
        }
        return this.removeById((Serializable)((Object)id));
    }

    public static String randomCode(int place) {
        String base = "qwertyuioplkjhgfdsazxcvbnmQAZWSXEDCRFVTGBYHNUJMIKLOP0123456789";
        StringBuffer sb = new StringBuffer();
        Random rd = new Random();
        for (int i = 0; i < place; ++i) {
            sb.append(base.charAt(rd.nextInt(base.length())));
        }
        return sb.toString();
    }

    private int sameCountShareConsumer(String code, String id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BizShareConsumer::getCode, (Object)code);
        queryWrapper.ne(!StringUtils.isEmpty((Object)id), BizShareConsumer::getId, (Object)id);
        return ((BizShareConsumerDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
    }
}

