/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataShare.interceptor;

import com.artfess.dataShare.dataShare.manager.BizShareConsumerManager;
import com.artfess.dataShare.dataShare.manager.BizShareFileLogManager;
import com.artfess.dataShare.dataShare.manager.BizShareFilesManager;
import com.artfess.dataShare.dataShare.manager.BizShareTableManager;
import com.artfess.dataShare.dataShare.model.BizShareConsumer;
import com.artfess.dataShare.dataShare.model.BizShareFileLog;
import com.artfess.dataShare.dataShare.model.BizShareFiles;
import com.artfess.dataShare.dataShare.model.BizShareTable;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class DownloadFileInterceptor
extends HandlerInterceptorAdapter {
    private ThreadLocal<Long> startTime = new ThreadLocal();
    @Resource
    private BizShareFileLogManager fileLogManager;
    @Resource
    private BizShareFilesManager filesManager;
    @Resource
    private BizShareTableManager tableManager;
    @Resource
    private BizShareConsumerManager consumerManager;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.startTime.set(System.currentTimeMillis());
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        Map parameterMap = request.getParameterMap();
        String[] values = (String[])parameterMap.get("id");
        String fileId = values[0];
        BizShareFiles file = (BizShareFiles)this.filesManager.get((Serializable)((Object)fileId));
        BizShareTable table = (BizShareTable)this.tableManager.get((Serializable)((Object)file.getTableId()));
        BizShareConsumer consumer = (BizShareConsumer)((Object)this.consumerManager.getOne((Wrapper)new LambdaQueryWrapper().eq(BizShareConsumer::getLoginUser, (Object)ContextUtil.getCurrentUserAccount())));
        BizShareFileLog fileLog = new BizShareFileLog();
        fileLog.setMemberId(consumer.getId());
        fileLog.setMemberCode(consumer.getCode());
        fileLog.setMemberName(consumer.getName());
        fileLog.setAppName(consumer.getAppName());
        fileLog.setTableId(table.getId());
        fileLog.setResourceCode(table.getCode());
        fileLog.setResourceName(table.getName());
        fileLog.setFileId(file.getId());
        fileLog.setFileName(file.getFileName());
        fileLog.setFilePath(file.getFilePath());
        fileLog.setRequestIp(this.getClientIpAddress(request));
        Instant instant = Instant.ofEpochMilli(this.startTime.get());
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        fileLog.setRequestTime(localDateTime);
        this.fileLogManager.save((Object)fileLog);
    }

    private String getClientIpAddress(HttpServletRequest request) {
        String ipAddress = request.getHeader("X-Forwarded-For");
        if (ipAddress == null || ipAddress.isEmpty() || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.isEmpty() || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.isEmpty() || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getRemoteAddr();
        }
        return ipAddress;
    }
}

