/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataApi.manager.impl;

import com.alibaba.fastjson.JSONArray;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.dataShare.dataApi.dao.BizServiceApiDao;
import com.artfess.dataShare.dataApi.manager.BizServiceApiManager;
import com.artfess.dataShare.dataApi.model.BizServiceApi;
import com.artfess.dataShare.dataApi.vo.RespParamVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class BizServiceApiManagerImpl
extends BaseManagerImpl<BizServiceApiDao, BizServiceApi>
implements BizServiceApiManager {
    private static final Logger log = LoggerFactory.getLogger(BizServiceApiManagerImpl.class);
    @Resource
    private RestTemplate restTemplate;
    @Value(value="${dataShare-api.url.serviceApi.register}")
    private String API_REGISTER_URL;
    @Value(value="${dataShare-api.url.serviceApi.checkSqlValidity}")
    private String API_CHECKSQLVALIDITY_URL;
    @Value(value="${dataShare-api.url.serviceApi.unregister}")
    private String API_UNREGISTER_URL;
    @Value(value="${dataShare-api.url.serviceApi.updateServiceApi}")
    private String API_UPDATESERVICEAPI_URL;
    @Value(value="${dataShare-api.url.serviceApi.query}")
    private String API_QUERY_URL;
    @Value(value="${dataShare-api.url.serviceApi.getInfo}")
    private String API_GETINFO_URL;
    @Value(value="${dataShare-api.url.serviceApi.checkApi}")
    private String API_CHECKAPI_URL;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean register(BizServiceApi serviceApi) {
        serviceApi.setApiUrl("/api" + serviceApi.getApiUrl());
        serviceApi.setStatus("0");
        serviceApi.setIsDele("0");
        boolean status = this.registerToDB(serviceApi);
        return status;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean publish(String id) {
        BizServiceApi serviceApi = (BizServiceApi)this.get((Serializable)((Object)id));
        int count = 0;
        if (BeanUtils.isNotEmpty((Object)((Object)serviceApi))) {
            serviceApi.setStatus("1");
            count = ((BizServiceApiDao)this.baseMapper).updateById((Object)serviceApi);
        }
        CommonResult commonResult = new CommonResult(ResponseErrorEnums.FAIL_OPTION);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)serviceApi, (MultiValueMap)headers);
        commonResult = (CommonResult)this.restTemplate.postForObject(this.API_REGISTER_URL, (Object)request, CommonResult.class, new Object[0]);
        return commonResult.getState();
    }

    @Override
    public boolean checkApiValidity(BizServiceApi serviceApi) {
        return this.checkApiInDB(serviceApi) && this.checkApiInSpring(serviceApi);
    }

    private boolean checkApiInSpring(BizServiceApi serviceApi) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)serviceApi, (MultiValueMap)headers);
        CommonResult commonResult = (CommonResult)this.restTemplate.postForObject(this.API_CHECKAPI_URL, (Object)request, CommonResult.class, new Object[0]);
        return commonResult.getState();
    }

    public boolean checkApiInDB(BizServiceApi serviceApi) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BizServiceApi::getApiUrl, (Object)serviceApi.getApiUrl());
        queryWrapper.eq(BizServiceApi::getApiMode, (Object)serviceApi.getApiMode());
        return this.count((Wrapper)queryWrapper) == 0;
    }

    @Override
    public boolean checkSqlValidity(BizServiceApi serviceApi) throws SQLException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity((Object)serviceApi, (MultiValueMap)headers);
        CommonResult commonResult = (CommonResult)this.restTemplate.postForObject(this.API_CHECKSQLVALIDITY_URL, (Object)request, CommonResult.class, new Object[0]);
        return commonResult.getState();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean unregister(String id) {
        BizServiceApi serviceApi = (BizServiceApi)this.get((Serializable)((Object)id));
        boolean status = this.unregisterFromDB(serviceApi.getId());
        CommonResult commonResult = new CommonResult(ResponseErrorEnums.FAIL_OPTION);
        if (status) {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            HttpEntity request = new HttpEntity((Object)serviceApi, (MultiValueMap)headers);
            commonResult = (CommonResult)this.restTemplate.postForObject(this.API_UNREGISTER_URL, (Object)request, CommonResult.class, new Object[0]);
        }
        if (!commonResult.getState().booleanValue()) {
            status = false;
            throw new ApplicationException(commonResult.getMessage());
        }
        status = commonResult.getState();
        return status;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean soldOut(String id) {
        boolean status = false;
        BizServiceApi serviceApi = (BizServiceApi)this.get((Serializable)((Object)id));
        serviceApi.setStatus("0");
        int count = 0;
        if (BeanUtils.isNotEmpty((Object)((Object)serviceApi))) {
            count = ((BizServiceApiDao)this.baseMapper).updateById((Object)serviceApi);
        }
        CommonResult commonResult = new CommonResult(ResponseErrorEnums.FAIL_OPTION);
        if (count > 0) {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            HttpEntity request = new HttpEntity((Object)serviceApi, (MultiValueMap)headers);
            commonResult = (CommonResult)this.restTemplate.postForObject(this.API_UNREGISTER_URL, (Object)request, CommonResult.class, new Object[0]);
        }
        if (!commonResult.getState().booleanValue()) {
            status = false;
            throw new ApplicationException(commonResult.getMessage());
        }
        status = commonResult.getState();
        return status;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateServiceApi(BizServiceApi serviceApi) {
        BizServiceApi oldServiceApi = (BizServiceApi)this.get((Serializable)((Object)serviceApi.getId()));
        if (!(oldServiceApi.getApiMode().name().equals(serviceApi.getApiMode().name()) && oldServiceApi.getApiUrl().equals(serviceApi.getApiUrl()) || this.checkApiValidity(serviceApi))) {
            throw new ApplicationException("\u63a5\u53e3\u5df2\u88ab\u6ce8\u518c\uff01");
        }
        int count = ((BizServiceApiDao)this.baseMapper).updateById((Object)serviceApi);
        return count > 0;
    }

    @Override
    public PageList<BizServiceApi> queryApi(QueryFilter<BizServiceApi> queryFilter) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity request = new HttpEntity(queryFilter, (MultiValueMap)headers);
        PageList pageList = (PageList)this.restTemplate.postForObject(this.API_QUERY_URL, (Object)request, PageList.class, new Object[0]);
        return pageList;
    }

    @Override
    public BizServiceApi getInfo(String id) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("id", id);
        BizServiceApi serviceApi = (BizServiceApi)((Object)this.restTemplate.getForObject(this.API_GETINFO_URL, BizServiceApi.class, param));
        return serviceApi;
    }

    @Override
    public BizServiceApi viewApiDocument(String id) throws IOException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("id", id);
        BizServiceApi serviceApi = (BizServiceApi)((Object)this.restTemplate.getForObject(this.API_GETINFO_URL, BizServiceApi.class, param));
        String responseExample = serviceApi.getResponseExample();
        if (StringUtil.isNotEmpty((String)responseExample)) {
            JSONArray jsonArray = JSONArray.parseArray((String)responseExample);
            Integer size = jsonArray.size();
            RespParamVo respParamVo = new RespParamVo();
            respParamVo.setResultCode("200");
            respParamVo.setMessage("\u6210\u529f");
            respParamVo.setTotalCount(size.toString());
            respParamVo.setCount(size.toString());
            respParamVo.setRows(jsonArray.toJavaList(Object.class));
            serviceApi.setRespParamVo(respParamVo);
        }
        return serviceApi;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean unregisterFromDB(String id) {
        return this.removeById((Serializable)((Object)id));
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean registerToDB(BizServiceApi serviceApi) {
        if (!this.checkApiValidity(serviceApi)) {
            throw new ApplicationException("\u63a5\u53e3\u5df2\u88ab\u6ce8\u518c\uff01");
        }
        return this.save((Object)serviceApi);
    }
}

