/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataShare.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.dataShare.dataApi.model.BizServiceApi;
import com.artfess.dataShare.dataShare.manager.BizShareApiManager;
import com.artfess.dataShare.dataShare.model.BizShareApi;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.sql.SQLException;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/biz/dataShare/shareApi/v1/"})
@Api(tags={"\u6570\u636e\u8d44\u6e90--\u63a5\u53e3\u5171\u4eab\u4fe1\u606f"})
@ApiGroup(group={"group_biz_dataShare"})
public class BizShareApiController
extends BaseController<BizShareApiManager, BizShareApi> {
    @ApiOperation(value="\u6ce8\u518c\u63a5\u53e3\u914d\u7f6e")
    @PostMapping(value={"register"})
    public CommonResult<String> register(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) BizShareApi shareApi) throws Exception {
        boolean status = ((BizShareApiManager)this.baseService).register(shareApi);
        return status ? CommonResult.success(null, (String)"\u6ce8\u518c\u63a5\u53e3\u914d\u7f6e\u6210\u529f") : new CommonResult(ResponseErrorEnums.FAIL_OPTION);
    }

    @ApiOperation(value="\u53d1\u5e03\u63a5\u53e3")
    @PutMapping(value={"publish"})
    public CommonResult<String> publish(@RequestParam String id) {
        boolean status = ((BizShareApiManager)this.baseService).publish(id);
        return status ? CommonResult.success(null, (String)"\u53d1\u5e03\u6210\u529f") : new CommonResult(ResponseErrorEnums.FAIL_OPTION);
    }

    @ApiOperation(value="\u4e0b\u67b6\u63a5\u53e3")
    @PutMapping(value={"soldOut"})
    public CommonResult<String> soldOut(@RequestParam String id) {
        boolean status = ((BizShareApiManager)this.baseService).soldOut(id);
        return status ? CommonResult.success(null, (String)"\u4e0b\u67b6\u6210\u529f") : new CommonResult(ResponseErrorEnums.FAIL_OPTION);
    }

    @ApiOperation(value="\u9a8c\u8bc1SQL\u8bed\u53e5\u7684\u53ef\u7528\u6027")
    @PostMapping(value={"checkSqlValidity"})
    public CommonResult<String> checkSqlValidity(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) BizShareApi shareApi) throws SQLException {
        boolean status = ((BizShareApiManager)this.baseService).checkSqlValidity(shareApi);
        return status ? CommonResult.success(null, (String)"sql\u9a8c\u8bc1\u6210\u529f") : new CommonResult(ResponseErrorEnums.FAIL_OPTION);
    }

    @ApiOperation(value="\u9a8c\u8bc1\u91cd\u590d\u63a5\u53e3")
    @PostMapping(value={"checkApiValidity"})
    public CommonResult<String> checkApiValidity(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={AddGroup.class}) BizShareApi shareApi) throws SQLException {
        boolean status = ((BizShareApiManager)this.baseService).checkApiValidity(shareApi);
        return status ? CommonResult.success(null, (String)"sql\u9a8c\u8bc1\u6210\u529f") : new CommonResult(ResponseErrorEnums.FAIL_OPTION);
    }

    @ApiOperation(value="\u5220\u9664\u63a5\u53e3\u914d\u7f6e")
    @DeleteMapping(value={"unregister"})
    public CommonResult<String> unregister(@RequestParam(value="id") String id) {
        boolean status = ((BizShareApiManager)this.baseService).unregister(id);
        return status ? CommonResult.success(null, (String)"\u5220\u9664\u63a5\u53e3\u914d\u7f6e\u6210\u529f") : new CommonResult(ResponseErrorEnums.FAIL_OPTION);
    }

    @ApiOperation(value="\u4fee\u6539\u63a5\u53e3\u914d\u7f6e")
    @PutMapping(value={"updateServiceApi"})
    public CommonResult<String> updateServiceApi(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody @Validated(value={UpdateGroup.class}) BizShareApi shareApi) {
        boolean status = ((BizShareApiManager)this.baseService).updateServiceApi(shareApi);
        return status ? CommonResult.success(null, (String)"\u4fee\u6539\u63a5\u53e3\u914d\u7f6e\u6210\u529f") : new CommonResult(ResponseErrorEnums.FAIL_OPTION);
    }

    @ApiOperation(value="\u67e5\u8be2\u63a5\u53e3\u914d\u7f6e")
    @PostMapping(value={"/queryApi"})
    public PageList<BizShareApi> queryApi(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizShareApi> queryFilter) {
        return ((BizShareApiManager)this.baseService).queryApi(queryFilter);
    }

    @ApiOperation(value="\u67e5\u770b\u63a5\u53e3\u8be6\u60c5")
    @GetMapping(value={"getInfo/{id}"})
    public CommonResult<BizServiceApi> getInfo(@PathVariable(value="id") String id) {
        BizShareApi shareApi = ((BizShareApiManager)this.baseService).getInfo(id);
        return CommonResult.success((Object)((Object)shareApi), (String)"\u83b7\u53d6\u6210\u529f");
    }

    @ApiOperation(value="\u6d4f\u89c8\u63a5\u53e3\u6587\u6863")
    @GetMapping(value={"viewApiDocument/{id}"})
    public CommonResult<BizServiceApi> viewApiDocument(@PathVariable(value="id") String id) throws IOException {
        BizShareApi shareApi = ((BizShareApiManager)this.baseService).viewApiDocument(id);
        return CommonResult.success((Object)((Object)shareApi), (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"queryPageByCatalog"})
    @ApiOperation(value="\u6388\u6743\u67e5\u8be2-\u901a\u8fc7\u76ee\u5f55\u5206\u9875\u67e5\u8be2\u63a5\u53e3")
    public PageList<BizShareApi> queryPageByCatalog(@RequestBody QueryFilter<BizShareApi> queryFilter, @RequestParam(value="catalogId") String catalogId, @RequestParam(value="consumerId") String consumerId) {
        PageList<BizShareApi> pageList = ((BizShareApiManager)this.baseService).queryPageByCatalog(queryFilter, catalogId, consumerId);
        return pageList;
    }
}

