/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.scheduler.manager.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.entity.AutoOrgFillModel;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.id.IdGenerator;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.dataShare.dataResource.app.dao.BizAppCatalogsTableDao;
import com.artfess.dataShare.dataResource.app.model.BizAppCatalogsTable;
import com.artfess.dataShare.dataResource.dw.dao.BizDwTableDao;
import com.artfess.dataShare.dataResource.dw.model.BizDwdCatalogsTable;
import com.artfess.dataShare.dataResource.ods.dao.BizOdsTableDao;
import com.artfess.dataShare.dataShare.dao.BizShareTableDao;
import com.artfess.dataShare.dataShare.model.BizShareTable;
import com.artfess.dataShare.scheduler.dao.BizSchedulerJobDao;
import com.artfess.dataShare.scheduler.manager.BizSchedulerEtlTaskManager;
import com.artfess.dataShare.scheduler.manager.BizSchedulerJobLogManager;
import com.artfess.dataShare.scheduler.manager.BizSchedulerJobManager;
import com.artfess.dataShare.scheduler.manager.BizSchedulerJobTableManager;
import com.artfess.dataShare.scheduler.manager.BizSchedulerKettleTaskManager;
import com.artfess.dataShare.scheduler.manager.BizSchedulerOdsTaskManager;
import com.artfess.dataShare.scheduler.manager.BizSchedulerShellTaskManager;
import com.artfess.dataShare.scheduler.model.BizSchedulerEtlTask;
import com.artfess.dataShare.scheduler.model.BizSchedulerJob;
import com.artfess.dataShare.scheduler.model.BizSchedulerJobTable;
import com.artfess.dataShare.scheduler.model.BizSchedulerKettleTask;
import com.artfess.dataShare.scheduler.model.BizSchedulerOdsTask;
import com.artfess.dataShare.scheduler.model.BizSchedulerShellTask;
import com.artfess.file.config.HwObsSetting;
import com.artfess.file.config.MinioSetting;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.util.HuaweiyunOssUtil;
import com.artfess.file.util.MinioUtil;
import com.artfess.sysConfig.util.SysPropertyUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.StringJoiner;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BizSchedulerJobManagerImpl
extends BaseManagerImpl<BizSchedulerJobDao, BizSchedulerJob>
implements BizSchedulerJobManager {
    @Autowired
    BizSchedulerJobTableManager jobTableManager;
    @Autowired
    BizSchedulerJobLogManager jobLogManager;
    @Autowired
    BizSchedulerKettleTaskManager kettleTaskManager;
    @Autowired
    BizSchedulerShellTaskManager shellTaskManager;
    @Autowired
    BizSchedulerEtlTaskManager etlTaskManager;
    @Autowired
    BizSchedulerOdsTaskManager odsTaskManager;
    @Resource
    BizOdsTableDao odsTableDao;
    @Resource
    BizDwTableDao dwdTableDao;
    @Resource
    BizAppCatalogsTableDao appTableDao;
    @Resource
    BizShareTableDao shareTableDao;
    @Resource
    IdGenerator idGenerator;
    @Value(value="${dataShare-scheduler.base}")
    private String SCHEDULER_BASE;

    @Override
    public PageList<BizSchedulerJob> sliceQuery(QueryFilter<BizSchedulerJob> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        List list = queryFilter.getQuerys();
        String jobTaskType = "";
        String jobTaskMode = "";
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (QueryField field : list) {
                if (field.getProperty().equals("jobTaskType")) {
                    jobTaskType = field.getValue().toString();
                }
                if (!field.getProperty().equals("jobTaskMode")) continue;
                jobTaskMode = field.getValue().toString();
            }
        }
        queryFilter.addFilter("j.IS_DELE_", (Object)"1", QueryOP.NOT_EQUAL);
        IPage<BizSchedulerJob> result = null;
        result = jobTaskType.equals("1") && !jobTaskMode.equals("5") ? ((BizSchedulerJobDao)this.baseMapper).queryCollectPage((IPage<BizSchedulerJob>)this.convert2IPage(pageBean), (Wrapper<BizSchedulerJob>)this.convert2Wrapper(queryFilter, this.currentModelClass())) : (jobTaskType.equals("2") ? ((BizSchedulerJobDao)this.baseMapper).querySharePage((IPage<BizSchedulerJob>)this.convert2IPage(pageBean), (Wrapper<BizSchedulerJob>)this.convert2Wrapper(queryFilter, this.currentModelClass())) : (jobTaskType.equals("3") ? ((BizSchedulerJobDao)this.baseMapper).queryDwdPage((IPage<BizSchedulerJob>)this.convert2IPage(pageBean), (Wrapper<BizSchedulerJob>)this.convert2Wrapper(queryFilter, this.currentModelClass())) : (jobTaskType.equals("4") ? ((BizSchedulerJobDao)this.baseMapper).queryAppPage((IPage<BizSchedulerJob>)this.convert2IPage(pageBean), (Wrapper<BizSchedulerJob>)this.convert2Wrapper(queryFilter, this.currentModelClass())) : ((BizSchedulerJobDao)this.baseMapper).queryPage((IPage<BizSchedulerJob>)this.convert2IPage(pageBean), (Wrapper<BizSchedulerJob>)this.convert2Wrapper(queryFilter, this.currentModelClass())))));
        return new PageList(result);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertSchedulerJob(BizSchedulerJob schedulerJob, MultipartFile[] multipartFiles) {
        String className;
        if (this.checkSameName(schedulerJob.getJobName(), schedulerJob.getId())) {
            throw new RequiredException("\u6dfb\u52a0\u5931\u8d25\uff0c\u8be5\u4f5c\u4e1a\u3010" + schedulerJob.getJobName() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
        }
        if (schedulerJob.getJobType() == null) {
            throw new RequiredException("\u6dfb\u52a0\u5931\u8d25\uff0c\u8be5\u4f5c\u4e1a\u3010" + schedulerJob.getJobName() + "\u3011\u8bf7\u9009\u62e9\u662f\u5b9a\u65f6\u4efb\u52a1\u8fd8\u662f\u975e\u5b9a\u65f6\u4efb\u52a1\uff01");
        }
        if (schedulerJob.getJobType() == 1 && StringUtil.isEmpty((String)schedulerJob.getJobCron())) {
            throw new RequiredException("\u6dfb\u52a0\u5931\u8d25\uff0c\u8be5\u5b9a\u65f6\u4f5c\u4e1a\u3010" + schedulerJob.getJobName() + "\u3011\u8bf7\u586b\u5199\u5b9a\u65f6\u8ba1\u5212\uff01");
        }
        String jobId = this.idGenerator.getSuid();
        schedulerJob.setId(jobId);
        if (schedulerJob.getJobTaskMode() == 1 && StringUtil.isEmpty((String)schedulerJob.getJobClass())) {
            throw new RequiredException("\u6dfb\u52a0\u5931\u8d25\uff0c\u8bf7\u6dfb\u52a0\u6267\u884c\u7c7b\u7684\u7c7b\u8def\u5f84\uff01");
        }
        schedulerJob.setIsDele("0");
        schedulerJob.setJobStatus("NONE");
        BizSchedulerKettleTask kettleTask = null;
        BizSchedulerShellTask shellTask = null;
        BizSchedulerEtlTask etlTask = null;
        BizSchedulerOdsTask odsTask = null;
        if (schedulerJob.getJobTaskMode() == 2) {
            className = "com.artfess.scheduler.job.KettleJob";
            schedulerJob.setJobClass(className);
            if (multipartFiles == null || multipartFiles.length < 2) {
                throw new RequiredException("\u6dfb\u52a0\u5931\u8d25\uff0c\u8bf7\u6dfb\u52a0kettle\u7684\u6267\u884c\u6587\u4ef6\uff01");
            }
            kettleTask = schedulerJob.getSchedulerKettle();
            if (kettleTask == null) {
                kettleTask = new BizSchedulerKettleTask();
            }
            kettleTask.setJobId(jobId);
            kettleTask.setJobName(schedulerJob.getJobName());
        } else if (schedulerJob.getJobTaskMode() == 3) {
            if ((multipartFiles == null || multipartFiles.length != 1) && StringUtil.isEmpty((String)schedulerJob.getSchedulerShell().getCommand())) {
                throw new RequiredException("\u6dfb\u52a0\u5931\u8d25\uff0c\u8bf7\u6dfb\u52a0Shell\u547d\u4ee4\u811a\u672c\u6587\u4ef6\u6216\u8005\u547d\u4ee4\uff01");
            }
            className = "com.artfess.scheduler.job.ShellJob";
            schedulerJob.setJobClass(className);
            shellTask = schedulerJob.getSchedulerShell();
            if (shellTask == null) {
                shellTask = new BizSchedulerShellTask();
            }
            shellTask.setJobId(jobId);
            shellTask.setJobName(schedulerJob.getJobName());
        } else if (schedulerJob.getJobTaskMode() == 4) {
            className = "com.artfess.scheduler.job.EtlJob";
            schedulerJob.setJobClass(className);
            etlTask = schedulerJob.getSchedulerEtl();
            if (etlTask == null) {
                etlTask = new BizSchedulerEtlTask();
            }
            etlTask.setJobId(jobId);
            etlTask.setJobName(schedulerJob.getJobName());
        } else if (schedulerJob.getJobTaskMode() == 5) {
            className = "com.artfess.scheduler.job.OdsJob";
            schedulerJob.setJobClass(className);
            odsTask = schedulerJob.getSchedulerOds();
            if (odsTask == null) {
                odsTask = new BizSchedulerOdsTask();
            }
            odsTask.setJobId(jobId);
            odsTask.setJobName(schedulerJob.getJobName());
        }
        String uploadType = SysPropertyUtil.getByAlias((String)"file.saveType", (String)DefaultFile.SAVE_TYPE_HUAWEIYUN_OBS);
        StringJoiner ktrName = new StringJoiner(";");
        StringJoiner ktrPath = new StringJoiner(";");
        for (MultipartFile multipartFile : multipartFiles) {
            if (StringUtil.isEmpty((String)uploadType)) {
                throw new RequiredException("\u6dfb\u52a0\u5931\u8d25\uff0c\u8be5\u5b9a\u65f6\u4f5c\u4e1a\u3010" + schedulerJob.getJobName() + "\u3011\u8bf7\u9009\u62e9\u4e0a\u4f20\u65b9\u5f0f\uff01");
            }
            String fileExt = FileUtil.getFileExt((String)multipartFile.getOriginalFilename());
            if (schedulerJob.getJobTaskMode() == 2 && !fileExt.toLowerCase().endsWith("ktr") && !fileExt.toLowerCase().endsWith("kjb")) {
                throw new ApplicationException("\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u540e\u5c1d\u8bd5\uff01");
            }
            if (schedulerJob.getJobTaskMode() == 3 && !fileExt.toLowerCase().endsWith("sh") && !fileExt.toLowerCase().endsWith("bat")) {
                throw new ApplicationException("\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u540e\u5c1d\u8bd5\uff01");
            }
            String bizPath = "";
            if (schedulerJob.getJobTaskMode() == 2) {
                bizPath = "kettle/" + schedulerJob.getJobName();
            }
            if (schedulerJob.getJobTaskMode() == 3) {
                bizPath = "shell/" + schedulerJob.getJobName();
            }
            try {
                String backUrl = "";
                if (uploadType.equals("minio")) {
                    MinioSetting minioSettings = (MinioSetting)AppUtil.getBean(MinioSetting.class);
                    minioSettings.getMinioClient();
                    backUrl = MinioUtil.upload((MultipartFile)multipartFile, (String)bizPath, (String)multipartFile.getOriginalFilename(), (String)"datashare");
                } else if (uploadType.equals("huaweiyunObs")) {
                    HwObsSetting hwObsSetting = (HwObsSetting)AppUtil.getBean(HwObsSetting.class);
                    hwObsSetting.initObs();
                    backUrl = HuaweiyunOssUtil.uploadFile((MultipartFile)multipartFile, (String)(bizPath + "/" + multipartFile.getOriginalFilename()));
                }
                if (StringUtil.isNotBlank((CharSequence)backUrl)) {
                    if (schedulerJob.getJobTaskMode() == 2) {
                        if (fileExt.toLowerCase().endsWith("ktr")) {
                            ktrName.add(multipartFile.getOriginalFilename());
                            ktrPath.add(backUrl);
                            kettleTask.setKtrName(ktrName.toString());
                            kettleTask.setKtrPath(ktrPath.toString());
                        }
                        if (fileExt.toLowerCase().endsWith("kjb")) {
                            kettleTask.setKjbName(multipartFile.getOriginalFilename());
                            kettleTask.setKjbPath(backUrl);
                        }
                    }
                    if (schedulerJob.getJobTaskMode() == 3 && (fileExt.toLowerCase().endsWith("sh") || fileExt.toLowerCase().endsWith("bat"))) {
                        shellTask.setShellName(multipartFile.getOriginalFilename());
                        shellTask.setShellPath(backUrl);
                    }
                    continue;
                }
                throw new ApplicationException("\u811a\u672c\u4e0a\u4f20\u5931\u8d25\uff01");
            }
            catch (Exception e) {
                this.log.error("\u4e0a\u4f20\u6587\u4ef6\u4fdd\u5b58\u9519\u8bef:", (Throwable)e);
                throw new ApplicationException((Throwable)e);
            }
        }
        boolean flag = this.save((Object)schedulerJob);
        if (StringUtil.isNotEmpty((String)schedulerJob.getTableId()) && flag) {
            BizSchedulerJobTable jobTable = new BizSchedulerJobTable();
            jobTable.setJobId(jobId);
            jobTable.setTableId(schedulerJob.getTableId());
            this.jobTableManager.create((Model)jobTable);
        }
        if (flag && schedulerJob.getJobTaskMode() == 2) {
            this.kettleTaskManager.save((Object)kettleTask);
        }
        if (flag && schedulerJob.getJobTaskMode() == 3) {
            this.shellTaskManager.save((Object)shellTask);
        }
        if (flag && schedulerJob.getJobTaskMode() == 4) {
            this.etlTaskManager.save((Object)etlTask);
        }
        if (flag && schedulerJob.getJobTaskMode() == 5) {
            this.odsTaskManager.save((Object)odsTask);
        }
        return flag;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateSchedulerJob(BizSchedulerJob schedulerJob, MultipartFile[] multipartFiles) {
        if (BeanUtils.isNotEmpty((Object)((Object)schedulerJob))) {
            boolean flag;
            BizSchedulerOdsTask odsTask;
            BizSchedulerEtlTask etlTask;
            BizSchedulerShellTask shellTask;
            BizSchedulerJob oldModelTask = (BizSchedulerJob)((Object)((BizSchedulerJobDao)this.baseMapper).selectById((Serializable)((Object)schedulerJob.getId())));
            if (oldModelTask.getJobType() == 1 && oldModelTask.getJobStatus().equals("NORMAL")) {
                throw new RequiredException("\u4fee\u6539\u6570\u636e\u62bd\u53d6\u4efb\u52a1\u5931\u8d25\uff0c\u4efb\u52a1\u6b63\u5728\u8fd0\u884c\uff0c\u8bf7\u5148\u505c\u6b62\uff01");
            }
            if (this.checkSameName(schedulerJob.getJobName(), schedulerJob.getId())) {
                throw new RequiredException("\u4fee\u6539\u5931\u8d25\uff0c\u8be5\u4f5c\u4e1a\u3010" + schedulerJob.getJobName() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            BizSchedulerKettleTask kettleTask = schedulerJob.getSchedulerKettle();
            if (kettleTask != null) {
                kettleTask.setJobId(schedulerJob.getId());
                kettleTask.setJobName(schedulerJob.getJobName());
            }
            if ((shellTask = schedulerJob.getSchedulerShell()) != null) {
                shellTask.setJobId(schedulerJob.getId());
                shellTask.setJobName(schedulerJob.getJobName());
            }
            if ((etlTask = schedulerJob.getSchedulerEtl()) != null) {
                etlTask.setJobId(schedulerJob.getId());
                etlTask.setJobName(schedulerJob.getJobName());
            }
            if ((odsTask = schedulerJob.getSchedulerOds()) != null) {
                odsTask.setJobId(schedulerJob.getId());
                odsTask.setJobName(schedulerJob.getJobName());
            }
            String uploadType = SysPropertyUtil.getByAlias((String)"file.saveType", (String)DefaultFile.SAVE_TYPE_HUAWEIYUN_OBS);
            if (schedulerJob.getJobTaskMode() == 2 && kettleTask != null && multipartFiles != null && multipartFiles.length > 0) {
                MultipartFile[] ktrName = new StringJoiner(";");
                if (StringUtil.isNotEmpty((String)kettleTask.getKtrName())) {
                    ktrName.add(kettleTask.getKtrName());
                }
                StringJoiner ktrPath = new StringJoiner(";");
                if (StringUtil.isNotEmpty((String)kettleTask.getKtrPath())) {
                    ktrPath.add(kettleTask.getKtrPath());
                }
                for (MultipartFile multipartFile : multipartFiles) {
                    if (StringUtil.isEmpty((String)uploadType)) {
                        throw new RequiredException("\u6dfb\u52a0\u5931\u8d25\uff0c\u8be5\u5b9a\u65f6\u4f5c\u4e1a\u3010" + schedulerJob.getJobName() + "\u3011\u8bf7\u9009\u62e9\u4e0a\u4f20\u65b9\u5f0f\uff01");
                    }
                    String fileExt = FileUtil.getFileExt((String)multipartFile.getOriginalFilename());
                    if (schedulerJob.getJobTaskMode() == 2 && !fileExt.toLowerCase().endsWith("ktr") && !fileExt.toLowerCase().endsWith("kjb")) {
                        throw new ApplicationException("\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u540e\u5c1d\u8bd5\uff01");
                    }
                    String bizPath = "kettle/" + schedulerJob.getJobName();
                    try {
                        String backUrl = "";
                        if (uploadType.equals("minio")) {
                            MinioSetting minioSettings = (MinioSetting)AppUtil.getBean(MinioSetting.class);
                            minioSettings.getMinioClient();
                            backUrl = MinioUtil.upload((MultipartFile)multipartFile, (String)bizPath, (String)multipartFile.getOriginalFilename(), (String)"datashare");
                        } else if (uploadType.equals("huaweiyunObs")) {
                            HwObsSetting hwObsSetting = (HwObsSetting)AppUtil.getBean(HwObsSetting.class);
                            hwObsSetting.initObs();
                            backUrl = HuaweiyunOssUtil.uploadFile((MultipartFile)multipartFile, (String)(bizPath + "/" + multipartFile.getOriginalFilename()));
                        }
                        if (StringUtil.isNotBlank((CharSequence)backUrl)) {
                            if (fileExt.toLowerCase().endsWith("ktr")) {
                                ktrName.add(multipartFile.getOriginalFilename());
                                ktrPath.add(backUrl);
                                kettleTask.setKtrName(ktrName.toString());
                                kettleTask.setKtrPath(ktrPath.toString());
                            }
                            if (fileExt.toLowerCase().endsWith("kjb")) {
                                kettleTask.setKjbName(multipartFile.getOriginalFilename());
                                kettleTask.setKjbPath(backUrl);
                            }
                            continue;
                        }
                        throw new ApplicationException("\u811a\u672c\u4e0a\u4f20\u5931\u8d25\uff01");
                    }
                    catch (Exception e) {
                        this.log.error("\u4e0a\u4f20\u6587\u4ef6\u4fdd\u5b58\u9519\u8bef:", (Throwable)e);
                        throw new ApplicationException((Throwable)e);
                    }
                }
            }
            if (schedulerJob.getJobTaskMode() == 3 && shellTask != null && multipartFiles != null && multipartFiles.length > 0) {
                for (MultipartFile multipartFile : multipartFiles) {
                    if (StringUtil.isEmpty((String)uploadType)) {
                        throw new RequiredException("\u6dfb\u52a0\u5931\u8d25\uff0c\u8be5\u5b9a\u65f6\u4f5c\u4e1a\u3010" + schedulerJob.getJobName() + "\u3011\u8bf7\u9009\u62e9\u4e0a\u4f20\u65b9\u5f0f\uff01");
                    }
                    String fileExt = FileUtil.getFileExt((String)multipartFile.getOriginalFilename());
                    if (schedulerJob.getJobTaskMode() == 3 && !fileExt.toLowerCase().endsWith("sh") && !fileExt.toLowerCase().endsWith("bat")) {
                        throw new ApplicationException("\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u540e\u5c1d\u8bd5\uff01");
                    }
                    String bizPath = "shell/" + schedulerJob.getJobName();
                    try {
                        String backUrl = "";
                        if (uploadType.equals("minio")) {
                            MinioSetting minioSettings = (MinioSetting)AppUtil.getBean(MinioSetting.class);
                            minioSettings.getMinioClient();
                            backUrl = MinioUtil.upload((MultipartFile)multipartFile, (String)bizPath, (String)multipartFile.getOriginalFilename(), (String)"datashare");
                        } else if (uploadType.equals("huaweiyunObs")) {
                            HwObsSetting hwObsSetting = (HwObsSetting)AppUtil.getBean(HwObsSetting.class);
                            hwObsSetting.initObs();
                            backUrl = HuaweiyunOssUtil.uploadFile((MultipartFile)multipartFile, (String)(bizPath + "/" + multipartFile.getOriginalFilename()));
                        }
                        if (StringUtil.isNotBlank((CharSequence)backUrl)) {
                            if (fileExt.toLowerCase().endsWith("sh") || fileExt.toLowerCase().endsWith("bat")) {
                                shellTask.setShellName(multipartFile.getOriginalFilename());
                                shellTask.setShellPath(backUrl);
                            }
                            continue;
                        }
                        throw new ApplicationException("\u811a\u672c\u4e0a\u4f20\u5931\u8d25\uff01");
                    }
                    catch (Exception e) {
                        this.log.error("\u4e0a\u4f20\u6587\u4ef6\u4fdd\u5b58\u9519\u8bef:", (Throwable)e);
                        throw new ApplicationException((Throwable)e);
                    }
                }
            }
            if (schedulerJob.getJobTaskMode() == 2 && kettleTask != null) {
                this.kettleTaskManager.updateById((Object)kettleTask);
            }
            if (schedulerJob.getJobTaskMode() == 3 && shellTask != null) {
                this.shellTaskManager.updateById((Object)shellTask);
            }
            if (schedulerJob.getJobTaskMode() == 4 && etlTask != null) {
                this.etlTaskManager.updateById((Object)etlTask);
            }
            if (schedulerJob.getJobTaskMode() == 5 && odsTask != null) {
                this.odsTaskManager.updateById((Object)odsTask);
            }
            if (StringUtil.isNotEmpty((String)schedulerJob.gettId()) && StringUtil.isNotEmpty((String)schedulerJob.getTableId())) {
                UpdateWrapper updateWrapper = new UpdateWrapper();
                updateWrapper.eq((Object)"ID_", (Object)schedulerJob.gettId());
                updateWrapper.set((Object)"JOB_ID_", (Object)schedulerJob.getId());
                updateWrapper.set((Object)"TABLE_ID_", (Object)schedulerJob.getTableId());
                this.jobTableManager.update((Wrapper)updateWrapper);
            }
            if (flag = this.delJob(schedulerJob.getId())) {
                flag = this.updateById((Object)schedulerJob);
            }
            return flag;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteSchedulerJobById(String id) {
        boolean result;
        if (StringUtil.isEmpty((String)id)) {
            throw new RequiredException("\u5220\u9664\u4f5c\u4e1a\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u4efb\u52a1\uff01");
        }
        BizSchedulerJob oldSchedulerJob = (BizSchedulerJob)((Object)((BizSchedulerJobDao)this.baseMapper).selectById((Serializable)((Object)id)));
        if (oldSchedulerJob.getJobType() == 1 && oldSchedulerJob.getJobStatus().equals("NORMAL")) {
            throw new RequiredException("\u5220\u9664\u6570\u636e\u62bd\u53d6\u4efb\u52a1\u5931\u8d25\uff0c\u4efb\u52a1\u6b63\u5728\u8fd0\u884c\uff0c\u8bf7\u5148\u505c\u6b62\uff01");
        }
        boolean flag = this.delJob(id);
        if (flag && (result = this.removeById((Serializable)((Object)id)))) {
            if (oldSchedulerJob.getJobTaskMode() == 2) {
                QueryWrapper delKettleWrapper = new QueryWrapper();
                delKettleWrapper.eq((Object)"JOB_ID_", (Object)id);
                this.kettleTaskManager.getBaseMapper().delete((Wrapper)delKettleWrapper);
            }
            if (oldSchedulerJob.getJobTaskMode() == 3) {
                QueryWrapper delShellWrapper = new QueryWrapper();
                delShellWrapper.eq((Object)"JOB_ID_", (Object)id);
                this.shellTaskManager.getBaseMapper().delete((Wrapper)delShellWrapper);
            }
            if (oldSchedulerJob.getJobTaskMode() == 4) {
                QueryWrapper delEtlWrapper = new QueryWrapper();
                delEtlWrapper.eq((Object)"JOB_ID_", (Object)id);
                this.etlTaskManager.getBaseMapper().delete((Wrapper)delEtlWrapper);
            }
            if (oldSchedulerJob.getJobTaskMode() == 5) {
                QueryWrapper delOdsWrapper = new QueryWrapper();
                delOdsWrapper.eq((Object)"JOB_ID_", (Object)id);
                this.odsTaskManager.getBaseMapper().delete((Wrapper)delOdsWrapper);
            }
            QueryWrapper delWrapper = new QueryWrapper();
            delWrapper.eq((Object)"JOB_ID_", (Object)id);
            this.jobTableManager.getBaseMapper().delete((Wrapper)delWrapper);
            QueryWrapper delLogWrapper = new QueryWrapper();
            delLogWrapper.eq((Object)"JOB_ID_", (Object)id);
            this.jobLogManager.getBaseMapper().delete((Wrapper)delLogWrapper);
        }
        return flag;
    }

    @Override
    public BizSchedulerJob getSchedulerJobById(String id) {
        Assert.hasText((String)id, (String)"\u4f5c\u4e1a\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        BizSchedulerJob schedulerJob = (BizSchedulerJob)((Object)((BizSchedulerJobDao)this.baseMapper).selectById((Serializable)((Object)id)));
        if (schedulerJob != null) {
            List<AutoOrgFillModel> list;
            if (schedulerJob.getJobTaskType() == 1) {
                list = this.odsTableDao.queryByJob(schedulerJob.getId());
                if (!CollectionUtils.isEmpty(list)) {
                    schedulerJob.setDataResourcesName(list.get(0).getName());
                }
            } else if (schedulerJob.getJobTaskType() == 2) {
                list = this.shareTableDao.queryByJob(schedulerJob.getId());
                if (!CollectionUtils.isEmpty(list)) {
                    schedulerJob.setDataResourcesName(((BizShareTable)list.get(0)).getName());
                }
            } else if (schedulerJob.getJobTaskType() == 3) {
                list = this.dwdTableDao.queryByJob(schedulerJob.getId());
                if (!CollectionUtils.isEmpty(list)) {
                    schedulerJob.setDataResourcesName(((BizDwdCatalogsTable)list.get(0)).getName());
                }
            } else if (schedulerJob.getJobTaskType() == 4 && !CollectionUtils.isEmpty(list = this.appTableDao.queryByJob(schedulerJob.getId()))) {
                schedulerJob.setDataResourcesName(((BizAppCatalogsTable)list.get(0)).getName());
            }
            if (schedulerJob.getJobTaskMode() == 2) {
                QueryWrapper queryKettleWrapper = new QueryWrapper();
                queryKettleWrapper.eq((Object)"JOB_ID_", (Object)id);
                List kettleTaskList = this.kettleTaskManager.getBaseMapper().selectList((Wrapper)queryKettleWrapper);
                if (!CollectionUtils.isEmpty((Collection)kettleTaskList)) {
                    BizSchedulerKettleTask kettleTask = (BizSchedulerKettleTask)((Object)kettleTaskList.get(0));
                    schedulerJob.setSchedulerKettle(kettleTask);
                }
            }
            if (schedulerJob.getJobTaskMode() == 3) {
                QueryWrapper queryShellWrapper = new QueryWrapper();
                queryShellWrapper.eq((Object)"JOB_ID_", (Object)id);
                List shellTaskList = this.shellTaskManager.getBaseMapper().selectList((Wrapper)queryShellWrapper);
                if (!CollectionUtils.isEmpty((Collection)shellTaskList)) {
                    BizSchedulerShellTask shellTask = (BizSchedulerShellTask)((Object)shellTaskList.get(0));
                    schedulerJob.setSchedulerShell(shellTask);
                }
            }
            if (schedulerJob.getJobTaskMode() == 4) {
                QueryWrapper queryEtlWrapper = new QueryWrapper();
                queryEtlWrapper.eq((Object)"JOB_ID_", (Object)id);
                List etlTaskList = this.etlTaskManager.getBaseMapper().selectList((Wrapper)queryEtlWrapper);
                if (!CollectionUtils.isEmpty((Collection)etlTaskList)) {
                    BizSchedulerEtlTask etlTask = (BizSchedulerEtlTask)((Object)etlTaskList.get(0));
                    schedulerJob.setSchedulerEtl(etlTask);
                }
            }
            if (schedulerJob.getJobTaskMode() == 5) {
                QueryWrapper queryOdsWrapper = new QueryWrapper();
                queryOdsWrapper.eq((Object)"JOB_ID_", (Object)id);
                List odsTaskList = this.odsTaskManager.getBaseMapper().selectList((Wrapper)queryOdsWrapper);
                if (!CollectionUtils.isEmpty((Collection)odsTaskList)) {
                    BizSchedulerOdsTask odsTask = (BizSchedulerOdsTask)((Object)odsTaskList.get(0));
                    schedulerJob.setSchedulerOds(odsTask);
                }
            }
            QueryWrapper queryJobTableWrapper = new QueryWrapper();
            queryJobTableWrapper.eq((Object)"JOB_ID_", (Object)id);
            List jobTableList = this.jobTableManager.getBaseMapper().selectList((Wrapper)queryJobTableWrapper);
            if (!CollectionUtils.isEmpty((Collection)jobTableList)) {
                BizSchedulerJobTable jobTable = (BizSchedulerJobTable)((Object)jobTableList.get(0));
                schedulerJob.setTableId(jobTable.getTableId());
                schedulerJob.settId(jobTable.getId());
            }
        }
        return schedulerJob;
    }

    @Override
    public boolean startUpJob(String jobId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("id", jobId);
        String result = HttpUtil.post((String)(this.SCHEDULER_BASE + "/dataJob/biz/scheduler/schedulerJob/v1/startUpJob"), paramMap);
        if (StringUtil.isNotEmpty((String)result)) {
            JSONObject jsonResp = JSONObject.parseObject((String)result);
            if (jsonResp.getBoolean("state").booleanValue()) {
                return true;
            }
            String msg = jsonResp.getString("message");
            throw new RuntimeException("\u8bf7\u6c42\u5931\u8d25:<br>" + msg);
        }
        return false;
    }

    @Override
    public boolean stopJob(String jobId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("id", jobId);
        String result = HttpUtil.post((String)(this.SCHEDULER_BASE + "/dataJob/biz/scheduler/schedulerJob/v1/stopJob"), paramMap);
        if (StringUtil.isNotEmpty((String)result)) {
            JSONObject jsonResp = JSONObject.parseObject((String)result);
            if (jsonResp.getBoolean("state").booleanValue()) {
                return true;
            }
            String msg = jsonResp.getString("message");
            throw new RuntimeException("\u8bf7\u6c42\u5931\u8d25:<br>" + msg);
        }
        return false;
    }

    @Override
    public boolean delJob(String jobId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("id", jobId);
        String result = HttpUtil.post((String)(this.SCHEDULER_BASE + "/dataJob/biz/scheduler/schedulerJob/v1/delJob"), paramMap);
        if (StringUtil.isNotEmpty((String)result)) {
            JSONObject jsonResp = JSONObject.parseObject((String)result);
            if (jsonResp.getBoolean("state").booleanValue()) {
                return true;
            }
            String msg = jsonResp.getString("message");
            throw new RuntimeException("\u8bf7\u6c42\u5931\u8d25:<br>" + msg);
        }
        return false;
    }

    @Override
    public boolean executeJob(String jobId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("id", jobId);
        String result = HttpUtil.post((String)(this.SCHEDULER_BASE + "/dataJob/biz/scheduler/schedulerJob/v1/executeJob"), paramMap);
        if (StringUtil.isNotEmpty((String)result)) {
            JSONObject jsonResp = JSONObject.parseObject((String)result);
            if (jsonResp.getBoolean("state").booleanValue()) {
                return true;
            }
            String msg = jsonResp.getString("message");
            throw new RuntimeException("\u8bf7\u6c42\u5931\u8d25:<br>" + msg);
        }
        return false;
    }

    @Override
    public boolean validClass(String className) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("className", className);
        String result = HttpUtil.post((String)(this.SCHEDULER_BASE + "/dataJob/biz/scheduler/schedulerJob/v1/validClass"), paramMap);
        if (StringUtil.isNotEmpty((String)result)) {
            JSONObject jsonResp = JSONObject.parseObject((String)result);
            if (jsonResp.getBoolean("state").booleanValue()) {
                return true;
            }
            String msg = jsonResp.getString("message");
            throw new RuntimeException("\u8bf7\u6c42\u5931\u8d25:<br>" + msg);
        }
        return false;
    }

    private boolean checkSameName(String jobName, String id) {
        Assert.hasText((String)jobName, (String)"\u4f5c\u4e1a\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"JOB_NAME_", (Object)jobName);
        queryWrapper.ne(StringUtil.isNotEmpty((String)id), (Object)"ID_", (Object)id);
        int num = ((BizSchedulerJobDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
        return num != 0;
    }
}

