/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.activiti.ext.listener;

import com.artfess.activiti.ext.listener.AbstractTaskListener;
import com.artfess.base.util.AppUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.cmd.TaskFinishCmd;
import com.artfess.bpm.api.constant.ActionType;
import com.artfess.bpm.api.constant.EventType;
import com.artfess.bpm.api.constant.ScriptType;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.event.NotifyTaskModel;
import com.artfess.bpm.api.event.TaskCompleteEvent;
import com.artfess.bpm.api.event.TaskNotifyEvent;
import com.artfess.bpm.api.helper.identity.BpmIdentityExtractService;
import com.artfess.bpm.api.model.delegate.BpmDelegateTask;
import com.artfess.bpm.api.service.BpmIdentityService;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.context.ApplicationEvent;

public class TaskCompleteListener
extends AbstractTaskListener {
    private static final long serialVersionUID = 6844821899585103714L;
    @Resource
    BpmIdentityService bpmIdentityService;
    @Resource
    BpmIdentityExtractService bpmIdentityExtractService;

    @Override
    public EventType getBeforeTriggerEventType() {
        return EventType.TASK_COMPLETE_EVENT;
    }

    @Override
    public EventType getAfterTriggerEventType() {
        return EventType.TASK_POST_COMPLETE_EVENT;
    }

    @Override
    public void beforePluginExecute(BpmDelegateTask delegateTask) {
        ActionType actionType = ActionType.APPROVE;
        String instId = (String)delegateTask.getVariable("instanceId_");
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        TaskFinishCmd finishCmd = (TaskFinishCmd)cmd;
        if (ActionType.RECOVER.equals((Object)finishCmd.getActionType())) {
            String subject = (String)delegateTask.getVariable("subject_");
            Map vars = delegateTask.getVariables();
            List idlist = this.bpmIdentityService.queryByTask(delegateTask.getId());
            List userList = this.bpmIdentityExtractService.extractUser(idlist);
            NotifyTaskModel model = NotifyTaskModel.getNotifyModel((String)delegateTask.getId(), (String)delegateTask.getProcessInstanceId(), (String)instId, (String)subject, (String)delegateTask.getTaskDefinitionKey(), (String)delegateTask.getName(), (String)delegateTask.getBpmnDefId(), (Map)vars, (List)userList, (ActionType)actionType, (String)finishCmd.getActionName(), (String)finishCmd.getApprovalOpinion());
            TaskNotifyEvent ev = new TaskNotifyEvent(model);
            AppUtil.publishEvent((ApplicationEvent)ev);
        }
    }

    @Override
    public void triggerExecute(BpmDelegateTask task) {
        TaskCompleteEvent ev = new TaskCompleteEvent((Object)task);
        AppUtil.publishEvent((ApplicationEvent)ev);
    }

    @Override
    public void afterPluginExecute(BpmDelegateTask delegateTask) {
    }

    @Override
    protected ScriptType getScriptType() {
        return ScriptType.COMPLETE;
    }
}

