/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.delegate.event.impl;

import org.activiti.engine.delegate.event.ActivitiEntityEvent;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventDispatcher;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventSupport;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.repository.ProcessDefinition;

public class ActivitiEventDispatcherImpl
implements ActivitiEventDispatcher {
    protected ActivitiEventSupport eventSupport = new ActivitiEventSupport();
    protected boolean enabled = true;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void addEventListener(ActivitiEventListener listenerToAdd) {
        this.eventSupport.addEventListener(listenerToAdd);
    }

    public void addEventListener(ActivitiEventListener listenerToAdd, ActivitiEventType ... types) {
        this.eventSupport.addEventListener(listenerToAdd, types);
    }

    public void removeEventListener(ActivitiEventListener listenerToRemove) {
        this.eventSupport.removeEventListener(listenerToRemove);
    }

    public void dispatchEvent(ActivitiEvent event) {
        if (this.enabled) {
            this.eventSupport.dispatchEvent(event);
        }
        if (Context.isExecutionContextActive()) {
            ProcessDefinitionEntity definition = Context.getExecutionContext().getProcessDefinition();
            if (definition != null) {
                definition.getEventSupport().dispatchEvent(event);
            }
        } else {
            ProcessDefinitionEntity processDefinition;
            CommandContext commandContext = Context.getCommandContext();
            if (commandContext != null && (processDefinition = this.extractProcessDefinitionEntityFromEvent(event)) != null) {
                processDefinition.getEventSupport().dispatchEvent(event);
            }
        }
    }

    protected ProcessDefinitionEntity extractProcessDefinitionEntityFromEvent(ActivitiEvent event) {
        Object entity;
        ProcessDefinitionEntity result = null;
        if (event.getProcessDefinitionId() != null && (result = (ProcessDefinitionEntity)((Object)Context.getProcessEngineConfiguration().getDeploymentManager().getProcessDefinitionCache().get(event.getProcessDefinitionId()))) != null) {
            result = Context.getProcessEngineConfiguration().getDeploymentManager().resolveProcessDefinition(result);
        }
        if (result == null && event instanceof ActivitiEntityEvent && (entity = ((ActivitiEntityEvent)event).getEntity()) instanceof ProcessDefinition) {
            result = (ProcessDefinitionEntity)((Object)entity);
        }
        return result;
    }
}

