/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.activiti.inst.service.impl;

import com.artfess.activiti.def.graph.ilog.activiti.BPMNEdge;
import com.artfess.activiti.def.graph.ilog.activiti.BPMNShap;
import com.artfess.activiti.def.graph.ilog.activiti.ProcessDiagramGenerator;
import com.artfess.base.exception.BaseException;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.cmd.BaseActionCmd;
import com.artfess.bpm.api.cmd.ProcessInstCmd;
import com.artfess.bpm.api.constant.AopType;
import com.artfess.bpm.api.constant.NodeType;
import com.artfess.bpm.api.constant.OpinionStatus;
import com.artfess.bpm.api.constant.ProcessInstanceStatus;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.event.BpmStartEvent;
import com.artfess.bpm.api.event.BpmStartModel;
import com.artfess.bpm.api.model.process.def.BpmDefinition;
import com.artfess.bpm.api.model.process.def.BpmProcessDef;
import com.artfess.bpm.api.model.process.def.BpmVariableDef;
import com.artfess.bpm.api.model.process.inst.BpmInstanceTrack;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.model.process.inst.BpmTrackPoint;
import com.artfess.bpm.api.model.process.inst.BpmTrackSize;
import com.artfess.bpm.api.model.process.inst.TrackNode;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.UserTaskNodeDef;
import com.artfess.bpm.api.model.process.task.BpmTask;
import com.artfess.bpm.api.plugin.core.factory.BpmPluginSessionFactory;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.api.service.BpmDefinitionService;
import com.artfess.bpm.api.service.BpmInstService;
import com.artfess.bpm.engine.inst.DefaultProcessInstCmd;
import com.artfess.bpm.exception.StartFlowException;
import com.artfess.bpm.model.var.DefaultBpmVariableDef;
import com.artfess.bpm.natapi.inst.NatProInstanceService;
import com.artfess.bpm.persistence.manager.BpmCheckOpinionManager;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.manager.BpmExeStackManager;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.manager.BpmTaskManager;
import com.artfess.bpm.persistence.manager.impl.BpmTaskTurnManagerImpl;
import com.artfess.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.artfess.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.persistence.model.DefaultBpmTask;
import com.artfess.bpm.persistence.model.DefaultBpmTaskTurn;
import com.artfess.bpm.util.BpmUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserGroupService;
import com.artfess.uc.api.service.IUserService;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.seata.spring.annotation.GlobalTransactional;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;

@Service
public class DefaultProcessInstanceService
implements BpmInstService {
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmTaskTurnManagerImpl bpmTaskTurnManager;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmDefinitionService bpmDefinitionService;
    @Resource
    NatProInstanceService natProInstanceService;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmPluginSessionFactory bpmPluginSessionFactory;
    @Resource
    IUserService userServiceImpl;
    @Resource
    IUserGroupService defaultUserGroupService;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    BpmExeStackManager bpmExeStackManager;

    @GlobalTransactional
    public BpmProcessInstance startProcessInst(ProcessInstCmd processInstCmd) throws Exception {
        DefaultBpmProcessInstance instance = this.getProcessInst(processInstCmd, false);
        BaseActionCmd baseActionCmd = (BaseActionCmd)processInstCmd;
        boolean isAdd = StringUtil.isEmpty((String)baseActionCmd.getInstId());
        baseActionCmd.setInstId(instance.getId());
        baseActionCmd.addTransitVars("processInstance", (Object)instance);
        baseActionCmd.addVariable("subject_", instance.getSubject());
        ContextThreadUtil.setActionCmd((ActionCmd)baseActionCmd);
        BpmStartModel startModel = new BpmStartModel((BpmProcessInstance)instance, (ActionCmd)baseActionCmd, AopType.PREVIOUS);
        BpmStartEvent startEvent = new BpmStartEvent(startModel);
        AppUtil.publishEvent((ApplicationEvent)startEvent);
        String destination = baseActionCmd.getDestination();
        boolean isSkipFirstNode = BpmUtil.getSkipFirstNode((String)instance.getProcDefId());
        String bpmnInstId = "";
        boolean isDestEmpty = StringUtil.isEmpty((String)destination);
        if (isSkipFirstNode && !isDestEmpty) {
            Map variables = baseActionCmd.getVariables();
            variables.put("start_destiontion", true);
            bpmnInstId = this.natProInstanceService.startProcessInstance(instance.getBpmnDefId(), instance.getBizKey(), variables, new String[]{destination});
        } else if (isDestEmpty || isSkipFirstNode) {
            bpmnInstId = this.natProInstanceService.startProcessInstance(instance.getBpmnDefId(), instance.getBizKey(), baseActionCmd.getVariables());
        } else if (!isSkipFirstNode && !isDestEmpty) {
            bpmnInstId = this.natProInstanceService.startProcessInstance(instance.getBpmnDefId(), instance.getBizKey(), baseActionCmd.getVariables(), new String[]{destination});
        }
        instance.setBpmnInstId(bpmnInstId);
        BpmStartModel startModelAfter = new BpmStartModel((BpmProcessInstance)instance, (ActionCmd)baseActionCmd, AopType.POST);
        BpmStartEvent startEventAfter = new BpmStartEvent(startModelAfter);
        AppUtil.publishEvent((ApplicationEvent)startEventAfter);
        if (isAdd) {
            IGroup org = ContextUtil.getCurrentGroup();
            if (BeanUtils.isNotEmpty((Object)org)) {
                String orgPath = org.getPath();
                instance.setCreateOrgPath(orgPath);
                instance.setCreateOrgId(org.getGroupId());
            }
            this.bpmProcessInstanceManager.create((Model)instance);
        } else {
            this.bpmProcessInstanceManager.update((Model)instance);
        }
        this.updSubject(instance, processInstCmd);
        if ("pk".equals(ContextThreadUtil.getActionCmd().getDataMode())) {
            instance.setBizKey(ContextThreadUtil.getActionCmd().getBusinessKey());
            instance.setSysCode(ContextThreadUtil.getActionCmd().getSysCode());
            this.bpmProcessInstanceManager.update((Model)instance);
        }
        this.handlerSkipTask(instance);
        return instance;
    }

    private void updSubject(DefaultBpmProcessInstance instance, ProcessInstCmd processInstCmd) throws Exception {
        processInstCmd.setVariables(this.getActVars(instance.getProcDefId(), ""));
        List listTasks = this.bpmTaskManager.getByInstId(instance.getId());
        for (DefaultBpmTask defaultBpmTask : listTasks) {
            if (!BeanUtils.isNotEmpty((Object)instance.getSubject())) {
                throw new BaseException("\u6d41\u7a0b\u6807\u9898\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u6807\u9898\u8bbe\u7f6e");
            }
            defaultBpmTask.setSubject(instance.getSubject());
            this.bpmTaskManager.update((Model)defaultBpmTask);
            DefaultBpmTaskTurn bpmTaskTurn = (DefaultBpmTaskTurn)this.bpmTaskTurnManager.getByTaskId(defaultBpmTask.getTaskId());
            if (bpmTaskTurn == null) continue;
            bpmTaskTurn.setTaskSubject(instance.getSubject());
            this.bpmTaskTurnManager.update((Model)bpmTaskTurn);
        }
    }

    private void handlerSkipTask(DefaultBpmProcessInstance instance) throws Exception {
        String instId = instance.getId();
        Set set = ContextThreadUtil.getByInstId((String)instId);
        ContextThreadUtil.clearTaskByInstId((String)instId);
        if (BeanUtils.isEmpty((Object)set)) {
            return;
        }
        for (BpmTask task : set) {
            BpmUtil.setTaskSkip((BpmTask)task);
            if (!task.getSkipResult().isSkipTask()) continue;
            BpmUtil.finishTask((BpmTask)task);
        }
    }

    private DefaultBpmProcessInstance getProcessInst(ProcessInstCmd cmd, boolean isDraft) throws Exception {
        DefaultProcessInstCmd processInstCmd = (DefaultProcessInstCmd)cmd;
        String instId = processInstCmd.getInstId();
        DefaultBpmProcessInstance instance = null;
        DefaultBpmDefinition bpmDefinition = this.getDefByCmd((ProcessInstCmd)processInstCmd);
        BpmProcessDef processDef = this.bpmDefinitionAccessor.getBpmProcessDef(bpmDefinition.getDefId());
        if (StringUtil.isNotEmpty((String)instId)) {
            instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
        }
        if (instance == null) {
            instance = new DefaultBpmProcessInstance();
            if (StringUtil.isEmpty((String)instId)) {
                instance.setId(UniqueIdUtil.getSuid());
            } else {
                processInstCmd.setInstId(null);
                instance.setId(instId);
            }
            instance.setProcDefId(bpmDefinition.getDefId());
            instance.setTypeId(bpmDefinition.getTypeId());
            instance.setProcDefKey(bpmDefinition.getDefKey());
            instance.setBpmnDefId(bpmDefinition.getBpmnDefId());
            instance.setProcDefName(bpmDefinition.getName());
            instance.setSupportMobile(cmd.getSupportMobile());
            if ("pk".equals(cmd.getDataMode())) {
                instance.setBizKey(processInstCmd.getBusinessKey());
                instance.setSysCode(processInstCmd.getSysCode());
            }
            instance.setParentInstId("0");
            if (bpmDefinition.getTestStatus().equals("run")) {
                instance.setIsFormmal("Y");
            } else if (bpmDefinition.getTestStatus().equals("test")) {
                instance.setIsFormmal("N");
            }
        }
        if (!"true".equals(ThreadMsgUtil.getMapMsg((String)"inst_end_revoke"))) {
            String subject = this.bpmProcessInstanceManager.getSubject(processDef, (ProcessInstCmd)processInstCmd, instance);
            instance.setSubject(subject);
        }
        IUser startUser = ContextUtil.getCurrentUser();
        if (BeanUtils.isNotEmpty((Object)cmd.getTransitVars("startUser"))) {
            startUser = (IUser)cmd.getTransitVars("startUser");
        }
        if (!"true".equals(ThreadMsgUtil.getMapMsg((String)"inst_end_revoke")) || StringUtil.isEmpty((String)instance.getCreateBy())) {
            instance.setCreateBy(startUser.getUserId());
            instance.setCreator(startUser.getFullname());
            instance.setCreateTime(LocalDateTime.now());
        }
        instance.setStatus(isDraft ? ProcessInstanceStatus.STATUS_DRAFT.getKey() : ProcessInstanceStatus.STATUS_RUNNING.getKey());
        if (StringUtil.isNotEmpty((String)cmd.getUrgentState())) {
            instance.setUrgentState(cmd.getUrgentState());
        }
        processInstCmd.setProcDefId(instance.getProcDefId());
        processInstCmd.setFlowKey(instance.getProcDefKey());
        if ("pk".equals(cmd.getDataMode())) {
            processInstCmd.addVariable("businessKey_", instance.getBizKey());
        }
        if (BeanUtils.isNotEmpty((Object)processInstCmd.getTransitVars("start_org_id"))) {
            instance.setCreateOrgId((String)processInstCmd.getTransitVars("start_org_id"));
        }
        processInstCmd.addVariable("subject_", instance.getSubject());
        processInstCmd.addVariable("instanceId_", instance.getId());
        processInstCmd.addVariable("processDefId_", instance.getProcDefId());
        processInstCmd.addVariable("flowKey_", instance.getProcDefKey());
        processInstCmd.addVariable("startUser", startUser.getUserId());
        return instance;
    }

    private DefaultBpmDefinition getDefByCmd(ProcessInstCmd processInstCmd) {
        DefaultBpmDefinition bpmDefinition = null;
        if (StringUtils.isEmpty((String)processInstCmd.getProcDefId()) && StringUtils.isEmpty((String)processInstCmd.getFlowKey()) && StringUtils.isEmpty((String)processInstCmd.getBpmnDefId())) {
            throw new StartFlowException("\u6ca1\u6709\u4f20\u5165\u6d41\u7a0b\u5b9a\u4e49ID,\u8bf7\u4f20\u5165ProcDefId,FlowKey,BpmnDefId\u4e2d\u7684\u4efb\u4f55\u4e00\u4e2a");
        }
        if (StringUtils.isNotEmpty((String)processInstCmd.getProcDefId())) {
            bpmDefinition = this.bpmDefinitionManager.getById(processInstCmd.getProcDefId());
        } else if (StringUtils.isNotEmpty((String)processInstCmd.getFlowKey())) {
            bpmDefinition = this.bpmDefinitionManager.getMainByDefKey(processInstCmd.getFlowKey(), false);
        } else {
            String defId = this.bpmDefinitionManager.getDefIdByBpmnDefId(processInstCmd.getBpmnDefId());
            bpmDefinition = this.bpmDefinitionManager.getById(defId);
        }
        return bpmDefinition;
    }

    public Map saveDraft(ProcessInstCmd processInstCmd) throws Exception {
        ContextThreadUtil.setActionCmd((ActionCmd)processInstCmd);
        DefaultBpmProcessInstance instance = this.getProcessInst(processInstCmd, true);
        BpmStartModel startModel = new BpmStartModel((BpmProcessInstance)instance, (ActionCmd)processInstCmd, AopType.PREVIOUS);
        BpmStartEvent startEvent = new BpmStartEvent(startModel);
        AppUtil.publishEvent((ApplicationEvent)startEvent);
        String msg = "\u4fdd\u5b58\u8868\u5355\u4fe1\u606f\u6210\u529f";
        if (!processInstCmd.getApproval().booleanValue()) {
            if (StringUtil.isEmpty((String)processInstCmd.getInstId())) {
                IGroup org = ContextUtil.getCurrentGroup();
                if (BeanUtils.isNotEmpty((Object)org)) {
                    String orgPath = org.getPath();
                    instance.setCreateOrgPath(orgPath);
                    instance.setCreateOrgId(org.getGroupId());
                }
                this.bpmProcessInstanceManager.create((Model)instance);
                msg = "\u4fdd\u5b58\u8349\u7a3f\u6210\u529f";
            } else {
                this.bpmProcessInstanceManager.update((Model)instance);
            }
        }
        this.updSubject(instance, processInstCmd);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("instance", instance);
        map.put("msg", msg);
        return map;
    }

    public BpmProcessInstance startDraftProcessInstance(BpmProcessInstance processInstance) throws Exception {
        String instId = processInstance.getId();
        if (!ProcessInstanceStatus.STATUS_DRAFT.getKey().equals(processInstance.getStatus())) {
            throw new StartFlowException("\u542f\u52a8\u6d41\u7a0b\u5931\u8d25,\u6b64\u5b9e\u4f8b\u5df2\u7ecf\u542f\u52a8");
        }
        DefaultProcessInstCmd processInstCmd = new DefaultProcessInstCmd();
        processInstCmd.setInstId(instId);
        return this.startProcessInst((ProcessInstCmd)processInstCmd);
    }

    public BpmProcessInstance startDraftProcessInstance(BpmProcessInstance processInstance, Map<String, Object> variables) throws Exception {
        String instId = processInstance.getId();
        if (!ProcessInstanceStatus.STATUS_DRAFT.getKey().equals(processInstance.getStatus())) {
            throw new StartFlowException("\u542f\u52a8\u6d41\u7a0b\u5931\u8d25,\u6b64\u5b9e\u4f8b\u5df2\u7ecf\u542f\u52a8");
        }
        DefaultProcessInstCmd processInstCmd = new DefaultProcessInstCmd();
        processInstCmd.setInstId(instId);
        processInstCmd.setVariables(variables);
        return this.startProcessInst((ProcessInstCmd)processInstCmd);
    }

    public List<BpmProcessInstance> getProcessInstancesByUserId(String userId) {
        return (List)this.bpmProcessInstanceManager.getByUserId(userId);
    }

    public PageList<BpmProcessInstance> getProcessInstancesByUserId(String userId, PageBean page) {
        return (PageList)this.bpmProcessInstanceManager.getByUserId(userId, page);
    }

    public List<BpmProcessInstance> getProcessInstancesByUserId(String userId, QueryFilter queryFilter) {
        return (List)this.bpmProcessInstanceManager.getByUserId(userId, queryFilter);
    }

    public List<BpmProcessInstance> getAttendProcessInstancesByUserId(String userId) {
        return (List)this.bpmProcessInstanceManager.getByAttendUserId(userId);
    }

    public PageList<BpmProcessInstance> getAttendProcessInstancesByUserId(String userId, PageBean page) {
        return this.bpmProcessInstanceManager.getByAttendUserId(userId, page);
    }

    public List<BpmProcessInstance> getAttendProcessInstancesByUserId(String userId, QueryFilter queryFilter) {
        return (List)this.bpmProcessInstanceManager.getByAttendUserId(userId, queryFilter);
    }

    public List<BpmProcessInstance> getDraftsByUserId(String userId, QueryFilter queryFilter) {
        return (List)this.bpmProcessInstanceManager.getDraftsByUserId(userId, queryFilter);
    }

    public List<BpmProcessInstance> getAll(QueryFilter queryFilter) {
        return (List)this.bpmProcessInstanceManager.query(queryFilter);
    }

    public boolean removeProcessInstance(String processInstId) {
        this.bpmProcessInstanceManager.remove((Serializable)((Object)processInstId));
        return true;
    }

    public boolean suspendProcessInstance(String processInstId) {
        try {
            this.bpmProcessInstanceManager.updForbiddenByInstId(processInstId, BpmProcessInstance.FORBIDDEN_YES);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public boolean recoverProcessInstance(String processInstId) {
        try {
            this.bpmProcessInstanceManager.updForbiddenByInstId(processInstId, BpmProcessInstance.FORBIDDEN_NO);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public boolean endProcessInstance(String processInstId) {
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)processInstId));
        this.bpmProcessInstanceManager.updateStatusByInstanceId(processInstId, ProcessInstanceStatus.STATUS_END.getKey());
        this.natProInstanceService.endProcessInstance(instance.getBpmnInstId());
        return true;
    }

    public BpmProcessInstance getProcessInstance(String processInstId) {
        return (BpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)processInstId));
    }

    public List<BpmProcessInstance> getByTaskUserId(String userId) {
        IUser user = this.userServiceImpl.getUserById(userId);
        List groupList = this.defaultUserGroupService.getGroupsByUserIdOrAccount(user.getAccount());
        return (List)this.bpmProcessInstanceManager.getByUserIdGroupList(userId, groupList);
    }

    public PageList<BpmProcessInstance> getByTaskUserId(String userId, PageBean page) {
        IUser user = this.userServiceImpl.getUserById(userId);
        List groupList = this.defaultUserGroupService.getGroupsByUserIdOrAccount(user.getAccount());
        IPage list = this.bpmProcessInstanceManager.getByUserIdGroupList(userId, groupList, page);
        ArrayList<DefaultBpmProcessInstance> arys = new ArrayList<DefaultBpmProcessInstance>();
        for (DefaultBpmProcessInstance instance : list.getRecords()) {
            arys.add(instance);
        }
        return new PageList(arys);
    }

    public List<BpmProcessInstance> getByTaskUserId(String userId, QueryFilter queryFilter) {
        List groupList = this.defaultUserGroupService.getGroupsByUserIdOrAccount(userId);
        return (List)this.bpmProcessInstanceManager.getByUserIdGroupList(userId, groupList, queryFilter);
    }

    public BpmProcessInstance getProcessInstanceByBpmnInstId(String bpmnInstId) {
        return this.bpmProcessInstanceManager.getByBpmnInstId(bpmnInstId);
    }

    public void removeTestInstByDefKey(String defKey) {
        this.bpmProcessInstanceManager.removeTestInstByDefKey(defKey, Boolean.valueOf(false));
    }

    public void revokeInstance(String instanceId, String informType, String cause) throws Exception {
        this.bpmProcessInstanceManager.revokeInstance(instanceId, informType, cause);
    }

    public boolean isSuspendByInstId(String processInstId) {
        BpmProcessInstance instance = (BpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)processInstId));
        int forbindden = instance.getIsForbidden();
        if (BpmProcessInstance.FORBIDDEN_YES == forbindden) {
            return true;
        }
        DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getById(instance.getProcDefId());
        String status = bpmDefinition.getStatus();
        return "forbidden_instance".equals(status);
    }

    public List<UserTaskNodeDef> getApprovalNodes(String processInstId) throws Exception {
        List checkOpinions = this.bpmCheckOpinionManager.getByInstId(processInstId);
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)processInstId));
        String procDefId = instance.getProcDefId();
        List nodeDefs = this.bpmDefinitionAccessor.getNodesByType(procDefId, NodeType.USERTASK);
        ArrayList<UserTaskNodeDef> userTaskNodeDefs = new ArrayList<UserTaskNodeDef>();
        for (BpmNodeDef bpmNodeDef : nodeDefs) {
            for (DefaultBpmCheckOpinion opinion : checkOpinions) {
                String status = opinion.getStatus();
                if (OpinionStatus.AWAITING_CHECK.toString().equals(status) || OpinionStatus.REJECT.toString().equals(status) || OpinionStatus.BACK_TO_START.toString().equals(status) || !bpmNodeDef.getNodeId().equals(opinion.getTaskKey())) continue;
                userTaskNodeDefs.add((UserTaskNodeDef)bpmNodeDef);
            }
        }
        return userTaskNodeDefs;
    }

    private BPMNShap getByTaskKey(List<BPMNShap> shaps, String taskKey) {
        BPMNShap shap = null;
        if (StringUtil.isEmpty((String)taskKey) || BeanUtils.isEmpty(shaps)) {
            return shap;
        }
        for (BPMNShap bpmnShap : shaps) {
            if (!taskKey.equals(bpmnShap.getBpmnElement())) continue;
            shap = bpmnShap;
            break;
        }
        return shap;
    }

    private BPMNEdge getByEdgeId(List<BPMNEdge> edges, String edgeId) {
        BPMNEdge edge = null;
        if (StringUtil.isEmpty((String)edgeId) || BeanUtils.isEmpty(edges)) {
            return edge;
        }
        for (BPMNEdge bpmnEdge : edges) {
            if (!edgeId.equals(bpmnEdge.getId())) continue;
            edge = bpmnEdge;
            break;
        }
        return edge;
    }

    private List<BpmInstanceTrack> convertFromOpinions(List<DefaultBpmCheckOpinion> checkOpinions, List<BPMNShap> shaps) {
        ArrayList<BpmInstanceTrack> tracks = new ArrayList<BpmInstanceTrack>();
        int size = 0;
        LocalDateTime preTime = null;
        for (DefaultBpmCheckOpinion defaultBpmCheckOpinion : checkOpinions) {
            String status = defaultBpmCheckOpinion.getStatus();
            String taskKey = defaultBpmCheckOpinion.getTaskKey();
            LocalDateTime createTime = defaultBpmCheckOpinion.getCreateTime();
            BPMNShap bpmnshap = this.getByTaskKey(shaps, taskKey);
            if (bpmnshap == null) continue;
            if (preTime == null || preTime.compareTo(createTime) != 0) {
                ++size;
            }
            BpmInstanceTrack track = new BpmInstanceTrack();
            track.setDuration(defaultBpmCheckOpinion.getDurMs());
            track.setStatus(status);
            track.setTaskKey(taskKey);
            track.setSn(Integer.valueOf(size));
            if (OpinionStatus.START.getKey().equals(status) || OpinionStatus.END.getKey().equals(status)) {
                preTime = null;
                track.setType("event");
                track.setPoint(new BpmTrackPoint(Double.valueOf(bpmnshap.getX()), Double.valueOf(bpmnshap.getY())));
                track.setRadius(Double.valueOf(bpmnshap.getWidth() / 2.0));
            } else {
                preTime = createTime;
                if (OpinionStatus.SKIP.getKey().equals(status)) {
                    preTime = null;
                }
                track.setType("rect");
                track.setPoint(new BpmTrackPoint(Double.valueOf(bpmnshap.getX()), Double.valueOf(bpmnshap.getY())));
                track.setSize(new BpmTrackSize(Double.valueOf(bpmnshap.getWidth()), Double.valueOf(bpmnshap.getHeight())));
            }
            tracks.add(track);
        }
        return tracks;
    }

    private void interpolation(List<BpmInstanceTrack> tracks, List<BPMNEdge> edges, List<BPMNShap> shaps) {
        if (BeanUtils.isEmpty(tracks) || BeanUtils.isEmpty(edges)) {
            return;
        }
        int size = tracks.size();
        if (size < 2) {
            return;
        }
        HashMap<String, List<BpmInstanceTrack>> map = new HashMap<String, List<BpmInstanceTrack>>();
        int sn = 1;
        List<BpmInstanceTrack> twins = null;
        do {
            List<BpmInstanceTrack> preTracks = this.getBySn(tracks, sn);
            if (sn == 1 && preTracks.size() != 1) {
                throw new RuntimeException("\u8f68\u8ff9\u7684\u5f00\u59cb\u8282\u70b9\u8981\u6c42\u6709\u4e14\u4ec5\u6709\u4e00\u4e2a");
            }
            for (BpmInstanceTrack preTrack : preTracks) {
                twins = this.getTwins(tracks, sn, preTrack);
                if (twins == null) continue;
                List<BpmInstanceTrack> interpoles = this.getInterpoles(twins, edges, shaps);
                map.put(sn + "", interpoles);
            }
            ++sn;
        } while (BeanUtils.isNotEmpty(twins));
        this.mergeTracks(tracks, map, sn);
    }

    private void mergeTracks(List<BpmInstanceTrack> tracks, Map<String, List<BpmInstanceTrack>> map, int total) {
        ArrayList<BpmInstanceTrack> resultTracks = new ArrayList<BpmInstanceTrack>();
        int sn = 1;
        List<BpmInstanceTrack> orginTracks = null;
        HashMap<String, List<BpmInstanceTrack>> orginMap = new HashMap<String, List<BpmInstanceTrack>>();
        do {
            if (BeanUtils.isNotEmpty(orginTracks = this.getBySn(tracks, sn))) {
                orginMap.put(sn + "", orginTracks);
            }
            ++sn;
        } while (BeanUtils.isNotEmpty(orginTracks));
        int newSn = 1;
        for (int i = 1; i < total; ++i) {
            int addCount;
            List orgins = (List)orginMap.get(i + "");
            for (BpmInstanceTrack orgin : orgins) {
                orgin.setSn(Integer.valueOf(newSn));
                resultTracks.add(orgin);
            }
            ++newSn;
            List<BpmInstanceTrack> adds = map.get(i + "");
            if (adds == null || (addCount = adds.size()) == 0) continue;
            for (BpmInstanceTrack add : adds) {
                add.setSn(Integer.valueOf(newSn++));
                resultTracks.add(add);
            }
        }
        tracks.clear();
        tracks.addAll(resultTracks);
    }

    private List<BpmInstanceTrack> getInterpoles(List<BpmInstanceTrack> twins, List<BPMNEdge> edges, List<BPMNShap> shaps) {
        String afterTaskKey;
        ArrayList<BpmInstanceTrack> list = new ArrayList<BpmInstanceTrack>();
        BpmInstanceTrack preTrack = twins.get(0);
        BpmInstanceTrack afterTrack = twins.get(1);
        String preTaskKey = preTrack.getTaskKey();
        if (!preTaskKey.equals(afterTaskKey = afterTrack.getTaskKey())) {
            TrackNode finalNode = this.getPathNode(preTaskKey, afterTaskKey, edges);
            if (finalNode != null) {
                List<BpmInstanceTrack> trackByTrackNode = this.getTrackByTrackNode(finalNode, edges, shaps);
                list.addAll(trackByTrackNode);
            } else {
                BpmInstanceTrack flyLineBetweenTwins = this.getFlyLineBetweenTwins(preTrack, afterTrack);
                list.add(flyLineBetweenTwins);
            }
        }
        return list;
    }

    private List<BpmInstanceTrack> getTrackByTrackNode(TrackNode trackNode, List<BPMNEdge> edges, List<BPMNShap> shaps) {
        ArrayList<BpmInstanceTrack> tracks = new ArrayList<BpmInstanceTrack>();
        TrackNode preNode = trackNode;
        int size = trackNode.getDepth();
        int index = 0;
        do {
            BpmInstanceTrack track;
            preNode = preNode.getParent();
            if (++index >= size - 1) continue;
            if (preNode.isEdge().booleanValue()) {
                BPMNEdge edge = this.getByEdgeId(edges, preNode.getId());
                track = new BpmInstanceTrack();
                track.setType("line");
                List<Point2D.Double> points = edge.getPoints();
                ArrayList<BpmTrackPoint> lines = new ArrayList<BpmTrackPoint>();
                for (Point2D.Double double1 : points) {
                    lines.add(new BpmTrackPoint(Double.valueOf(double1.getX()), Double.valueOf(double1.getY())));
                }
                track.setPoints(lines);
                tracks.add(0, track);
                continue;
            }
            BPMNShap shap = this.getByTaskKey(shaps, preNode.getId());
            track = new BpmInstanceTrack();
            double width = shap.getWidth();
            double height = shap.getHeight();
            track.setPoint(new BpmTrackPoint(Double.valueOf(shap.getX()), Double.valueOf(shap.getY())));
            if (width == height) {
                track.setType("diamond");
                track.setLength(Double.valueOf(height));
            } else {
                track.setType("rect");
                track.setSize(new BpmTrackSize(Double.valueOf(width), Double.valueOf(height)));
            }
            tracks.add(0, track);
        } while (preNode != null);
        return tracks;
    }

    private BpmInstanceTrack getFlyLineBetweenTwins(BpmInstanceTrack preTrack, BpmInstanceTrack afterTrack) {
        Double startX = 0.0;
        Double startY = 0.0;
        Double endX = 0.0;
        Double endY = 0.0;
        switch (preTrack.getType()) {
            case "event": {
                startX = preTrack.getPoint().getX() + preTrack.getRadius() / 2.0;
                startY = preTrack.getPoint().getY();
                break;
            }
            case "rect": {
                startX = preTrack.getPoint().getX() + preTrack.getSize().getWidth() / 2.0;
                startY = preTrack.getPoint().getY();
                break;
            }
            case "diamond": {
                startX = preTrack.getPoint().getX() + preTrack.getLength() / 2.0;
                startY = preTrack.getPoint().getY();
            }
        }
        switch (afterTrack.getType()) {
            case "event": {
                endX = afterTrack.getPoint().getX() + afterTrack.getRadius() / 2.0;
                endY = afterTrack.getPoint().getY();
                break;
            }
            case "rect": {
                endX = afterTrack.getPoint().getX() + afterTrack.getSize().getWidth() / 2.0;
                endY = afterTrack.getPoint().getY();
                break;
            }
            case "diamond": {
                endX = afterTrack.getPoint().getX() + afterTrack.getLength() / 2.0;
                endY = afterTrack.getPoint().getY();
            }
        }
        BpmInstanceTrack track = new BpmInstanceTrack();
        track.setType("line");
        ArrayList<BpmTrackPoint> lines = new ArrayList<BpmTrackPoint>();
        lines.add(new BpmTrackPoint(startX, startY));
        lines.add(new BpmTrackPoint(startX, Double.valueOf(startY - 5.0)));
        lines.add(new BpmTrackPoint(endX, Double.valueOf(startY - 5.0)));
        lines.add(new BpmTrackPoint(endX, endY));
        track.setPoints(lines);
        return track;
    }

    private TrackNode getPathNode(String preTaskKey, String afterTaskKey, List<BPMNEdge> edges) {
        ArrayList<TrackNode> fromNodes = new ArrayList<TrackNode>();
        TrackNode root = new TrackNode(preTaskKey);
        fromNodes.add(root);
        return this.findPath(fromNodes, afterTaskKey, edges);
    }

    private TrackNode findPath(List<TrackNode> nodes, String afterTaskKey, List<BPMNEdge> edges) {
        ArrayList<TrackNode> fromNodes = new ArrayList<TrackNode>();
        for (TrackNode node : nodes) {
            List<BPMNEdge> forks = this.getForks(node.getId(), edges);
            for (BPMNEdge edge : forks) {
                String targetRef = edge.getTargetRef();
                TrackNode edgeNode = new TrackNode(edge.getId(), node);
                TrackNode targetNode = new TrackNode(targetRef, edgeNode);
                targetNode.setType("shap");
                if (targetRef.equals(afterTaskKey)) {
                    return targetNode;
                }
                fromNodes.add(targetNode);
            }
        }
        if (fromNodes.size() > 0) {
            if (((TrackNode)fromNodes.get(0)).getDepth() > 10) {
                return null;
            }
            return this.findPath(fromNodes, afterTaskKey, edges);
        }
        return null;
    }

    private List<BPMNEdge> getForks(String preTaskKey, List<BPMNEdge> edges) {
        ArrayList<BPMNEdge> forks = new ArrayList<BPMNEdge>();
        for (BPMNEdge bpmnEdge : edges) {
            if (preTaskKey.equals(bpmnEdge.getSourceRef())) {
                forks.add(bpmnEdge);
                continue;
            }
            if (!preTaskKey.equals(bpmnEdge.getTargetRef())) continue;
            forks.add(bpmnEdge);
        }
        return forks;
    }

    private List<BpmInstanceTrack> getBySn(List<BpmInstanceTrack> tracks, int sn) {
        ArrayList<BpmInstanceTrack> list = new ArrayList<BpmInstanceTrack>();
        for (BpmInstanceTrack track : tracks) {
            if (track.getSn() != sn) continue;
            list.add(track);
        }
        return list;
    }

    private List<BpmInstanceTrack> getTwins(List<BpmInstanceTrack> tracks, int sn, BpmInstanceTrack preTrack) {
        List<BpmInstanceTrack> afterTracks = this.getBySn(tracks, sn + 1);
        if (BeanUtils.isEmpty(afterTracks)) {
            return null;
        }
        ArrayList<BpmInstanceTrack> twins = new ArrayList<BpmInstanceTrack>();
        BpmInstanceTrack afterTrack = afterTracks.get(0);
        twins.add(preTrack);
        twins.add(afterTrack);
        return twins;
    }

    public List<BpmInstanceTrack> getTracksByInstId(String processInstId) {
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)processInstId));
        String defId = instance.getProcDefId();
        BpmDefinition bpmDefinition = this.bpmDefinitionService.getBpmDefinitionByDefId(defId);
        String bpmnXml = bpmDefinition.getBpmnXml();
        List checkOpinions = this.bpmCheckOpinionManager.getByInstId(processInstId);
        List<BPMNShap> shaps = ProcessDiagramGenerator.extractBPMNShap(bpmnXml);
        List<BPMNEdge> edges = ProcessDiagramGenerator.extractBPMNEdge(bpmnXml);
        List<BpmInstanceTrack> tracks = this.convertFromOpinions(checkOpinions, shaps);
        this.interpolation(tracks, edges, shaps);
        return tracks;
    }

    private Map<String, Object> getActVars(String defId, String nodeId) throws Exception {
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        ArrayList bpmVariableList = defExt.getVariableList();
        if (bpmVariableList == null) {
            bpmVariableList = new ArrayList();
        }
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        if (StringUtil.isNotEmpty((String)nodeId)) {
            bpmVariableList.addAll(defExt.getVariableList(nodeId));
        }
        for (BpmVariableDef var : bpmVariableList) {
            String varkey = var.getVarKey();
            Object rtnVal = DefaultBpmVariableDef.getValue((String)var.getDataType(), (String)String.valueOf(var.getDefaultVal()));
            rtnMap.put(varkey, rtnVal);
        }
        return rtnMap;
    }
}

