/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.api.context;

import com.artfess.base.util.ContextThread;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.model.process.task.BpmTask;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class ContextThreadUtil
implements ContextThread {
    private static ThreadLocal<ActionCmd> actionCmdLocal = new ThreadLocal();
    private static ThreadLocal<Map<String, Object>> commuVars = new ThreadLocal();
    private static ThreadLocal<Map<String, Set<BpmTask>>> tasksMap = new ThreadLocal();

    public static void setCommuVars(Map<String, Object> commuVars_) {
        commuVars.set(commuVars_);
    }

    public static Map<String, Object> getCommuVars() {
        if (commuVars.get() == null) {
            ContextThreadUtil.setCommuVars(new HashMap<String, Object>());
        }
        return commuVars.get();
    }

    public static Object getCommuVar(String key, Object defaultValue) {
        Map<String, Object> map;
        if (commuVars.get() == null) {
            ContextThreadUtil.setCommuVars(new HashMap<String, Object>());
        }
        if ((map = commuVars.get()).containsKey(key)) {
            return map.get(key);
        }
        return defaultValue;
    }

    public static void putCommonVars(String key, Object value) {
        Map<String, Object> vars = ContextThreadUtil.getCommuVars();
        vars.put(key, value);
    }

    public static void cleanCommuVars() {
        commuVars.remove();
    }

    public static void setActionCmd(ActionCmd cmd) {
        actionCmdLocal.set(cmd);
    }

    public static ActionCmd getActionCmd() {
        return actionCmdLocal.get();
    }

    public static void addTask(BpmTask task) {
        Map<String, Set<BpmTask>> map = tasksMap.get();
        if (map == null) {
            map = new HashMap<String, Set<BpmTask>>();
            HashSet<BpmTask> set = new HashSet<BpmTask>();
            set.add(task);
            map.put(task.getProcInstId(), set);
            tasksMap.set(map);
        } else if (map.containsKey(task.getProcInstId())) {
            Set<BpmTask> set = map.get(task.getProcInstId());
            if (set.contains(task)) {
                set.remove(task);
                set.add(task);
            } else {
                set.add(task);
            }
        } else {
            HashSet<BpmTask> set = new HashSet<BpmTask>();
            set.add(task);
            map.put(task.getProcInstId(), set);
        }
    }

    public static Set<BpmTask> getByInstId(String instId) {
        Map<String, Set<BpmTask>> map = tasksMap.get();
        if (map == null) {
            return null;
        }
        if (map.get(instId) == null) {
            return null;
        }
        return map.get(instId);
    }

    public static void clearTaskMap() {
        tasksMap.remove();
    }

    public static void clearTaskByInstId(String instId) {
        Map<String, Set<BpmTask>> map = tasksMap.get();
        if (map == null) {
            return;
        }
        map.remove(instId);
    }

    public void cleanAll() {
        actionCmdLocal.remove();
        commuVars.remove();
        tasksMap.remove();
    }
}

